/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.link.BBridgePriority;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BIsolatedLinkSettings;
import com.tridium.platform.tcpip.link.BLinkMode;
import com.tridium.platform.tcpip.link.BPortPriority;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import com.tridium.platform.ui.tcpip.BBridgePriorityFE;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.tcpip.BIpHostVectorFE;
import com.tridium.platform.ui.tcpip.BTcpIpAdapterEditor;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleHostFileContentChanged", flags=4), @NiagaraAction(name="setEnabledStates", flags=4)})
public class BTcpIpHostEditor
extends BWbComponentView {
    public static final Action handleHostFileContentChanged = BTcpIpHostEditor.newAction((int)4, null);
    public static final Action setEnabledStates = BTcpIpHostEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BTcpIpHostEditor.class);
    private BTextEditorPane hostsFilePane = null;
    private List<BTcpIpAdapterEditor> adapterEditors = null;
    private boolean hostFileDirty = false;
    private boolean isIPv6Readonly = true;
    private boolean usesAdapterLevelSettings = false;
    private BCheckBox niagaraUsesIpv6 = null;
    private BTextField hostNameTextField = null;
    private BTextField domainTextField = null;
    private BIpHostFE gatewayFE = null;
    private BIpHostVectorFE dnsHostEditor = null;
    private BIpHostFE ipv6DefaultGatewayFE = null;
    private BIpHostVectorFE ipv6DnsHostEditor = null;
    private boolean linkSettingsReadonly = true;
    private BLimitedFrozenEnumFE linkModeEnabledFE = null;
    private BBorderPane[] linkSettingsPanes = null;
    private boolean canUseStp = false;
    private BCheckBox stpEnabledCheckBox = null;
    private BBridgePriorityFE stpBridgePriorityFE = null;
    private BFrozenEnumFE stpPortPriority1FE = null;
    private BFrozenEnumFE stpPortPriority2FE = null;
    private BWbFieldEditor stpHelloTimeFE = null;
    private BWbFieldEditor stpForwardDelayTimeFE = null;
    private BWbFieldEditor stpMaxAgingTimeFE = null;

    public void handleHostFileContentChanged() {
        this.invoke(handleHostFileContentChanged, null, null);
    }

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    protected final void doLoadValue(BObject value, Context cx) throws Exception {
        boolean readonly;
        BTcpIpHostSettings hostSettings = (BTcpIpHostSettings)value;
        BGridPane pane = new BGridPane(2);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.setColumnAlign(BHalign.fill);
        pane.setStretchColumn(1);
        pane.setColumnGap(10.0);
        pane.setRowGap(6.0);
        pane.setColorRows(true);
        this.hostNameTextField = new BTextField(hostSettings.getHostName(), 32);
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.hostName"), (BWidget)this.left((BWidget)this.hostNameTextField));
        this.hostsFilePane = new BTextEditorPane(hostSettings.getHostFileContents(), 20, 80, true);
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.hostFile"), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.hostsFilePane));
        boolean foundIpv6Adapter = false;
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings settings = (BTcpIpAdapterSettings)c.get();
            if (!settings.getIsIpv6Supported()) continue;
            foundIpv6Adapter = true;
            break;
        }
        if (foundIpv6Adapter) {
            this.niagaraUsesIpv6 = new BCheckBox(this.getLexicon().getText("TcpIpHostEditor.niagaraUsesIpv6.value"));
            LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.niagaraUsesIpv6"), (BWidget)this.left((BWidget)this.niagaraUsesIpv6));
            this.niagaraUsesIpv6.setSelected(hostSettings.getNiagaraUsesIpv6());
            this.isIPv6Readonly = hostSettings.getIsIPv6Readonly();
        } else {
            this.niagaraUsesIpv6 = null;
            this.isIPv6Readonly = true;
        }
        this.usesAdapterLevelSettings = hostSettings.getUsesAdapterLevelSettings();
        if (this.usesAdapterLevelSettings) {
            this.domainTextField = null;
            this.gatewayFE = null;
            this.dnsHostEditor = null;
            this.ipv6DnsHostEditor = null;
            this.ipv6DefaultGatewayFE = null;
        } else {
            this.domainTextField = new BTextField(hostSettings.getDomain(), 32);
            LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.domain"), (BWidget)this.left((BWidget)this.domainTextField));
            this.gatewayFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.gateway"), (BWidget)this.left((BWidget)this.gatewayFE));
            this.gatewayFE.loadValue((BObject)BString.make((String)hostSettings.getDefaultGateway()), cx);
            this.dnsHostEditor = new BIpHostVectorFE();
            LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)this.dnsHostEditor);
            if (foundIpv6Adapter) {
                this.ipv6DefaultGatewayFE = new BIpHostFE(true);
                LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)this.left((BWidget)this.ipv6DefaultGatewayFE));
                this.ipv6DefaultGatewayFE.loadValue((BObject)BString.make((String)hostSettings.getIpv6DefaultGateway()), cx);
                this.ipv6DnsHostEditor = new BIpHostVectorFE(true);
                LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)this.ipv6DnsHostEditor);
            } else {
                this.ipv6DnsHostEditor = null;
                this.ipv6DefaultGatewayFE = null;
            }
            BasicContext feContext = new BasicContext(cx, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)hostSettings.getMaxDnsHosts())));
            this.dnsHostEditor.loadValue((BObject)hostSettings.getDnsHosts(), (Context)feContext);
            if (foundIpv6Adapter) {
                this.ipv6DnsHostEditor.loadValue((BObject)hostSettings.getIpv6DnsHosts(), (Context)feContext);
            }
            this.linkTo(null, (BComponent)this.domainTextField, (Slot)BTextField.textModified, (Slot)setModified);
            this.linkTo(null, (BComponent)this.gatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.linkTo(null, (BComponent)this.dnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
            if (foundIpv6Adapter) {
                this.linkTo(null, (BComponent)this.ipv6DnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
                this.linkTo(null, (BComponent)this.ipv6DefaultGatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            }
        }
        if (this.getSlot("lk0") != null) {
            this.remove("lk0");
        }
        if (this.getSlot("lk3") != null) {
            this.remove("lk3");
        }
        this.linkTo("lk0", (BComponent)this.hostNameTextField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.hostsFilePane.getEditor(), (Slot)BTextEditor.textModified, (Slot)handleHostFileContentChanged);
        if (foundIpv6Adapter) {
            this.linkTo(null, (BComponent)this.niagaraUsesIpv6, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        BVector linkModesSupported = (BVector)hostSettings.get("linkModesSupported");
        BTcpIpLinkSettings activeLinkSettings = (BTcpIpLinkSettings)hostSettings.get("linkModeSettings");
        if (linkModesSupported != null && activeLinkSettings != null) {
            BGridPane linkCfgPane = new BGridPane(1);
            linkCfgPane.setHalign(BHalign.left);
            linkCfgPane.setValign(BValign.top);
            linkCfgPane.setRowAlign(BValign.top);
            linkCfgPane.setColumnGap(10.0);
            linkCfgPane.setRowGap(0.0);
            linkCfgPane.setColorRows(false);
            this.linkLoadValue(linkCfgPane, linkModesSupported, activeLinkSettings, cx);
            boolean addLinkPane = true;
            if (linkModesSupported.getPropertyCount() == 1 && activeLinkSettings.getLinkMode().getOrdinal() == 0) {
                addLinkPane = false;
            }
            if (addLinkPane) {
                LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.activeLinkSettings"), (BWidget)this.left((BWidget)linkCfgPane));
            }
        }
        BGridPane adapterPane = new BGridPane(1);
        adapterPane.setHalign(BHalign.left);
        adapterPane.setColumnAlign(BHalign.fill);
        adapterPane.setStretchColumn(0);
        LabelUtil.addLabelWidgetPair((BPane)pane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.interfaceCategory"), (BWidget)adapterPane);
        this.adapterEditors = new ArrayList<BTcpIpAdapterEditor>();
        int adapterCount = 0;
        BExpandablePane firstExpandable = null;
        SlotCursor c2 = hostSettings.getAdapters().loadSlots().getProperties();
        while (c2.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c2.get();
            ++adapterCount;
            BTcpIpAdapterEditor editor = new BTcpIpAdapterEditor();
            editor.loadValue((BObject)adapter, cx);
            this.adapterEditors.add(editor);
            this.linkTo(null, (BComponent)editor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
            if (editor.adapterEnabledCheckBox != null) {
                this.linkTo(null, (BComponent)editor.adapterEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            }
            if (editor.dhcpEnabledCheckBox != null) {
                this.linkTo(null, (BComponent)editor.dhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            }
            if (editor.ipv6DhcpEnabledCheckBox != null) {
                this.linkTo(null, (BComponent)editor.ipv6DhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            }
            BExpandablePane expandable = new BExpandablePane((BWidget)new BLabel(this.getLexicon().getText("TcpIpHostEditor.interfacePrefix") + " " + adapterCount), (BWidget)new BBorderPane((BWidget)editor, BBorder.inset, BInsets.make((double)4.0)));
            if (firstExpandable == null) {
                firstExpandable = expandable;
            }
            adapterPane.add(null, (BValue)expandable, null);
        }
        if (adapterCount == 1) {
            firstExpandable.setExpanded(true);
        }
        boolean bl = readonly = this.isReadonly() || hostSettings.getIsReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
        this.setContent((BWidget)pane);
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BTcpIpLinkSettings currentLinkSettings;
        if (!this.isModified()) {
            return value;
        }
        if (this.isReadonly()) {
            return value;
        }
        BTcpIpHostSettings hostSettings = (BTcpIpHostSettings)value;
        int enabledAdapterCount = 0;
        boolean ipv6AdapterEnabled = false;
        for (BTcpIpAdapterEditor plugin : this.adapterEditors) {
            if (!plugin.isAdapterEnabledSelected()) continue;
            ++enabledAdapterCount;
            if (!plugin.isIpv6EnabledSelected()) continue;
            ipv6AdapterEnabled = true;
        }
        if (enabledAdapterCount == 0) {
            this.saveError("TcpIpHostEditor.noEnabledAdapters");
        }
        HashMap<String, BTcpIpAdapterSettings> networkPrefixes = new HashMap<String, BTcpIpAdapterSettings>();
        for (BTcpIpAdapterEditor plugin : this.adapterEditors) {
            BTcpIpAdapterSettings conflict;
            String network;
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)plugin.saveValue(cx);
            if (!adapter.getIsAdapterEnabled()) continue;
            try {
                network = IPAddressUtil.getIPv4NetworkPrefix((String)adapter.getIpAddress(), (String)adapter.getSubnetMask());
            }
            catch (Exception e) {
                network = null;
            }
            if (network == null || (conflict = networkPrefixes.put(network, adapter)) == null) continue;
            this.saveError("TcpIpHostEditor.duplicateNetworkPrefixes", new Object[]{conflict.getAdapterId(), adapter.getAdapterId(), network});
        }
        String hostName = this.hostNameTextField.getText();
        if (hostName.length() != 0 && !IPAddressUtil.isHostname((String)hostName)) {
            this.saveError("TcpIpHostEditor.invalidHostNameSyntax");
        }
        hostSettings.setHostName(hostName);
        hostSettings.setHostFileContents(this.hostsFilePane.getText());
        this.hostFileDirty = false;
        if (this.niagaraUsesIpv6 != null) {
            hostSettings.setNiagaraUsesIpv6(this.niagaraUsesIpv6.getSelected());
        }
        if (!this.usesAdapterLevelSettings) {
            if (this.gatewayFE != null) {
                hostSettings.setDefaultGateway(this.gatewayFE.saveValue(cx).toString().trim());
            }
            if (this.domainTextField != null) {
                hostSettings.setDomain(this.domainTextField.getText());
            }
            if (this.dnsHostEditor != null) {
                hostSettings.setDnsHosts((BVector)this.dnsHostEditor.saveValue(cx));
            }
            if (this.ipv6DefaultGatewayFE != null) {
                String ipv6DefaultGateway = this.ipv6DefaultGatewayFE.saveValue(cx).toString().trim();
                if (ipv6AdapterEnabled) {
                    hostSettings.setIpv6DefaultGateway(ipv6DefaultGateway);
                } else if (ipv6DefaultGateway.length() != 0) {
                    this.saveError("TcpIpHostEditor.nonEmptyIPv6Gateway");
                }
            }
            if (this.ipv6DnsHostEditor != null) {
                BVector ipv6DnsHosts = (BVector)this.ipv6DnsHostEditor.saveValue(cx);
                if (ipv6AdapterEnabled) {
                    hostSettings.setIpv6DnsHosts(ipv6DnsHosts);
                } else if (ipv6DnsHosts.getSlotCount() != 0) {
                    this.saveError("TcpIpHostEditor.nonEmptyIPv6DNSHosts");
                }
            }
        }
        if ((currentLinkSettings = (BTcpIpLinkSettings)hostSettings.get("linkModeSettings")) != null) {
            this.doSaveValueLink(hostSettings, cx);
        }
        return hostSettings;
    }

    protected void saveError(String lexiconKey) throws CannotSaveException {
        this.saveError(lexiconKey, null);
    }

    protected void saveError(String lexiconKey, Object[] lexiconArguments) throws CannotSaveException {
        BDialog.error((BWidget)this, (String)this.getLexicon().getText("TcpIpHostEditor.invalidDataTitle"), (Object)(lexiconArguments == null ? this.getLexicon().getText(lexiconKey) : this.getLexicon().getText(lexiconKey, lexiconArguments)));
        CannotSaveException cse = new CannotSaveException();
        cse.setSilent(true);
        throw cse;
    }

    public boolean isHostFileDirty() {
        return this.hostFileDirty;
    }

    private int enabledAdapterCount() {
        int enabledAdapterCount = 0;
        for (BTcpIpAdapterEditor plugin : this.adapterEditors) {
            if (!plugin.isAdapterEnabledSelected()) continue;
            ++enabledAdapterCount;
        }
        return enabledAdapterCount;
    }

    protected void doSetReadonly(boolean readonly) {
        this.doSetEnabledStates();
    }

    public final void doHandleHostFileContentChanged() {
        this.hostFileDirty = true;
        this.setModified();
    }

    public final void doSetEnabledStates() {
        boolean hostSettingsProvidedByDHCPv4 = false;
        boolean hostSettingsProvidedByAutoconfiguration = false;
        if (!this.usesAdapterLevelSettings) {
            for (BTcpIpAdapterEditor adapterEditor : this.adapterEditors) {
                if (!adapterEditor.isAdapterEnabledSelected() || !adapterEditor.isDhcpEnabledSelected()) continue;
                hostSettingsProvidedByDHCPv4 = true;
            }
        }
        if (this.hostNameTextField != null) {
            boolean enabled = !this.isReadonly();
            this.hostNameTextField.setEditable(enabled);
            this.hostNameTextField.setEnabled(enabled);
        }
        if (this.hostsFilePane != null) {
            boolean enabled = !this.isReadonly();
            this.hostsFilePane.getEditor().setEditable(enabled);
            this.hostsFilePane.getEditor().setEnabled(enabled);
        }
        if (this.domainTextField != null) {
            boolean enabled = !hostSettingsProvidedByDHCPv4 && !this.isReadonly();
            this.domainTextField.setEditable(enabled);
            this.domainTextField.setEnabled(enabled);
        }
        if (this.gatewayFE != null) {
            boolean enabled = !hostSettingsProvidedByDHCPv4 && !this.isReadonly();
            this.gatewayFE.setReadonly(!enabled);
            this.gatewayFE.setEnabled(enabled);
        }
        if (this.dnsHostEditor != null) {
            boolean enabled = !hostSettingsProvidedByDHCPv4 && !this.isReadonly();
            this.dnsHostEditor.setReadonly(!enabled);
            this.dnsHostEditor.setEnabled(enabled);
        }
        if (this.niagaraUsesIpv6 != null) {
            boolean enabled = !this.isReadonly();
            this.niagaraUsesIpv6.setEnabled(enabled);
        }
        if (this.ipv6DefaultGatewayFE != null) {
            boolean enabled = !hostSettingsProvidedByAutoconfiguration && !this.isReadonly() && !this.isIPv6Readonly;
            this.ipv6DefaultGatewayFE.setReadonly(!enabled);
            this.ipv6DefaultGatewayFE.setEnabled(enabled);
        }
        if (this.ipv6DnsHostEditor != null) {
            boolean enabled = !hostSettingsProvidedByAutoconfiguration && !this.isReadonly() && !this.isIPv6Readonly;
            this.ipv6DnsHostEditor.setReadonly(!enabled);
            this.ipv6DnsHostEditor.setEnabled(enabled);
        }
        if (this.adapterEditors != null) {
            int adapterCount = 0;
            for (BTcpIpAdapterEditor editor : this.adapterEditors) {
                boolean readonly;
                boolean bl = readonly = this.isReadonly() || editor.isAdapterReadonly;
                if (this.linkModeEnabledFE != null && adapterCount > 0) {
                    try {
                        if (this.linkModeEnabledFE.saveValue() == BLinkMode.daisyChain) {
                            editor.adapterEnabledCheckBox.setSelected(false);
                            readonly = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (editor.isReadonly() == readonly) {
                    editor.doSetReadonly(readonly);
                } else {
                    editor.setReadonly(readonly);
                }
                ++adapterCount;
            }
        }
        this.doSetLinkEnabledStates();
    }

    private void linkLoadValue(BGridPane parentPane, BVector supportedLinkModes, BTcpIpLinkSettings activeLinkModeSettings, Context cx) {
        int[] modeOrdinals;
        this.linkSettingsReadonly = activeLinkModeSettings.getIsReadOnly();
        this.canUseStp = false;
        this.stpEnabledCheckBox = null;
        this.stpBridgePriorityFE = null;
        this.stpPortPriority1FE = null;
        this.stpPortPriority2FE = null;
        this.stpHelloTimeFE = null;
        this.stpForwardDelayTimeFE = null;
        this.stpMaxAgingTimeFE = null;
        ArrayList<Integer> linkModeOrdinals = new ArrayList<Integer>();
        ArrayList<String> linkModeTags = new ArrayList<String>();
        boolean activeSettingsAreSupported = false;
        SlotCursor c = supportedLinkModes.getProperties();
        while (c.next(BLinkMode.class)) {
            BLinkMode supportedMode = (BLinkMode)c.get();
            linkModeOrdinals.add(supportedMode.getOrdinal());
            linkModeTags.add(SlotPath.escape((String)supportedMode.getDisplayTag(cx)));
            if (activeLinkModeSettings.getLinkMode().getOrdinal() != supportedMode.getOrdinal()) continue;
            activeSettingsAreSupported = true;
        }
        if (!activeSettingsAreSupported) {
            throw new BajaRuntimeException("Link configuration actively using settings for unsupported mode: " + activeLinkModeSettings.getLinkMode());
        }
        int[] linkModeOrdinalArray = linkModeOrdinals.stream().mapToInt(i -> i).toArray();
        String[] linkModeTagsArray = linkModeTags.toArray(new String[0]);
        BFacets linkModeRange = BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])linkModeOrdinalArray, (String[])linkModeTagsArray));
        BGridPane globalLinkOptions = new BGridPane(2);
        globalLinkOptions.setHalign(BHalign.left);
        globalLinkOptions.setValign(BValign.center);
        globalLinkOptions.setRowAlign(BValign.center);
        globalLinkOptions.setColumnGap(10.0);
        globalLinkOptions.setRowGap(6.0);
        globalLinkOptions.setColorRows(false);
        this.linkModeEnabledFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)globalLinkOptions, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.activeLinkMode"), (BWidget)this.left((BWidget)this.linkModeEnabledFE), (boolean)false);
        this.linkModeEnabledFE.loadValue((BObject)activeLinkModeSettings.getLinkMode(), (Context)linkModeRange);
        this.linkTo(null, (BComponent)this.linkModeEnabledFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.linkModeEnabledFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setEnabledStates);
        parentPane.add(null, (BValue)this.left((BWidget)globalLinkOptions));
        int maxLinkOrdinal = 0;
        for (int modeOrdinal : modeOrdinals = BLinkMode.DEFAULT.getRange().getOrdinals()) {
            if (modeOrdinal <= maxLinkOrdinal) continue;
            maxLinkOrdinal = modeOrdinal;
        }
        this.linkSettingsPanes = new BBorderPane[maxLinkOrdinal + 1];
        SlotCursor c2 = supportedLinkModes.getProperties();
        while (c2.next(BLinkMode.class)) {
            BLinkMode supportedMode = (BLinkMode)c2.get();
            BBorderPane linkConfigurationBorderPane = null;
            BGridPane linkConfigurationGridPane = new BGridPane(1);
            linkConfigurationGridPane.setHalign(BHalign.left);
            linkConfigurationGridPane.setValign(BValign.top);
            linkConfigurationGridPane.setRowAlign(BValign.top);
            linkConfigurationGridPane.setColumnGap(10.0);
            linkConfigurationGridPane.setRowGap(6.0);
            linkConfigurationGridPane.setColorRows(false);
            if (supportedMode.getOrdinal() == 1) {
                BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
                if (activeLinkModeSettings instanceof BDaisyChainSettings) {
                    daisyChainSettings = (BDaisyChainSettings)activeLinkModeSettings;
                }
                this.canUseStp = daisyChainSettings.getIsStpSupported();
                if (this.canUseStp) {
                    BGridPane spanningTreeCheckPane = new BGridPane(2);
                    spanningTreeCheckPane.setHalign(BHalign.left);
                    spanningTreeCheckPane.setValign(BValign.top);
                    spanningTreeCheckPane.setRowAlign(BValign.top);
                    spanningTreeCheckPane.setColumnGap(10.0);
                    spanningTreeCheckPane.setRowGap(6.0);
                    spanningTreeCheckPane.setColorRows(false);
                    this.stpEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpHostEditor.link.daisychain.stpEnabled"));
                    LabelUtil.addLabelWidgetPair((BPane)spanningTreeCheckPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpLabel"), (BWidget)this.left((BWidget)this.stpEnabledCheckBox), (boolean)false);
                    this.stpEnabledCheckBox.setSelected(daisyChainSettings.getIsStpEnabled());
                    this.linkTo(null, (BComponent)this.stpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                    this.linkTo(null, (BComponent)this.stpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
                    linkConfigurationGridPane.add(null, (BValue)this.left((BWidget)spanningTreeCheckPane));
                    BGridPane advancedSTPOptionsPane = new BGridPane(2);
                    advancedSTPOptionsPane.setHalign(BHalign.left);
                    advancedSTPOptionsPane.setValign(BValign.top);
                    advancedSTPOptionsPane.setRowAlign(BValign.top);
                    advancedSTPOptionsPane.setColumnGap(10.0);
                    advancedSTPOptionsPane.setRowGap(6.0);
                    advancedSTPOptionsPane.setColorRows(false);
                    this.stpBridgePriorityFE = new BBridgePriorityFE();
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpBridgePriority"), (BWidget)this.stpBridgePriorityFE, (boolean)false);
                    this.stpBridgePriorityFE.loadValue((BObject)daisyChainSettings.getBridgePriority(), cx);
                    this.linkTo(null, (BComponent)this.stpBridgePriorityFE, (Slot)BBridgePriorityFE.pluginModified, (Slot)setModified);
                    this.stpPortPriority1FE = new BFrozenEnumFE();
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpPortPriority1"), (BWidget)this.stpPortPriority1FE, (boolean)false);
                    this.stpPortPriority1FE.loadValue((BObject)daisyChainSettings.getPortPriority1(), cx);
                    this.linkTo(null, (BComponent)this.stpPortPriority1FE, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
                    this.stpPortPriority2FE = new BFrozenEnumFE();
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpPortPriority2"), (BWidget)this.stpPortPriority2FE, (boolean)false);
                    this.stpPortPriority2FE.loadValue((BObject)daisyChainSettings.getPortPriority2(), cx);
                    this.linkTo(null, (BComponent)this.stpPortPriority2FE, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
                    this.stpHelloTimeFE = BWbFieldEditor.makeFor((BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.helloTime.getFacets());
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpHelloTime"), (BWidget)this.stpHelloTimeFE, (boolean)false);
                    BasicContext context = new BasicContext(cx, BDaisyChainSettings.helloTime.getFacets());
                    this.stpHelloTimeFE.loadValue((BObject)daisyChainSettings.getHelloTime(), (Context)context);
                    this.linkTo(null, (BComponent)this.stpHelloTimeFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
                    this.stpForwardDelayTimeFE = BWbFieldEditor.makeFor((BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.forwardDelayTime.getFacets());
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpForwardDelayTime"), (BWidget)this.stpForwardDelayTimeFE, (boolean)false);
                    context = new BasicContext(cx, BDaisyChainSettings.forwardDelayTime.getFacets());
                    this.stpForwardDelayTimeFE.loadValue((BObject)daisyChainSettings.getForwardDelayTime(), (Context)context);
                    this.linkTo(null, (BComponent)this.stpForwardDelayTimeFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
                    this.stpMaxAgingTimeFE = BWbFieldEditor.makeFor((BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.maxAgingTime.getFacets());
                    LabelUtil.addLabelWidgetPair((BPane)advancedSTPOptionsPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpMaxAgingTime"), (BWidget)this.stpMaxAgingTimeFE, (boolean)false);
                    context = new BasicContext(cx, BDaisyChainSettings.maxAgingTime.getFacets());
                    this.stpMaxAgingTimeFE.loadValue((BObject)daisyChainSettings.getMaxAgingTime(), (Context)context);
                    this.linkTo(null, (BComponent)this.stpMaxAgingTimeFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
                    BExpandablePane advancedSTPSettingsExpansion = new BExpandablePane((BWidget)new BLabel(this.getLexicon().getText("TcpIpHostEditor.link.daisychain.advancedSTPSettings")), (BWidget)new BBorderPane((BWidget)advancedSTPOptionsPane, BBorder.inset, BInsets.make((double)6.0)));
                    linkConfigurationGridPane.add(null, (BValue)this.left((BWidget)advancedSTPSettingsExpansion));
                }
            } else if (supportedMode.getOrdinal() == 0) {
                BIsolatedLinkSettings isolatedSettings = new BIsolatedLinkSettings();
                if (activeLinkModeSettings instanceof BIsolatedLinkSettings) {
                    isolatedSettings = (BIsolatedLinkSettings)activeLinkModeSettings;
                }
            }
            linkConfigurationBorderPane = new BBorderPane((BWidget)linkConfigurationGridPane, BInsets.make((double)6.0, (double)0.0, (double)0.0, (double)0.0));
            linkConfigurationBorderPane.setVisible(false);
            this.linkSettingsPanes[supportedMode.getOrdinal()] = linkConfigurationBorderPane;
            parentPane.add(null, (BValue)linkConfigurationBorderPane);
        }
        this.linkSettingsPanes[activeLinkModeSettings.getLinkMode().getOrdinal()].setVisible(true);
    }

    protected void doSaveValueLink(BTcpIpHostSettings host, Context cx) throws Exception {
        if (host == null) {
            return;
        }
        if (this.isReadonly()) {
            return;
        }
        if (!this.isModified()) {
            return;
        }
        if (this.linkSettingsReadonly) {
            return;
        }
        if (this.linkModeEnabledFE == null) {
            return;
        }
        BVector linkModesSupported = (BVector)host.get("linkModesSupported");
        BTcpIpLinkSettings currentLinkSettings = (BTcpIpLinkSettings)host.get("linkModeSettings");
        if (linkModesSupported == null || currentLinkSettings == null) {
            return;
        }
        BIsolatedLinkSettings newSettings = null;
        BLinkMode linkModeSelected = (BLinkMode)this.linkModeEnabledFE.saveValue(cx);
        if (linkModeSelected == BLinkMode.daisyChain) {
            BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
            daisyChainSettings.setIsDaisyChainEnabled(true);
            daisyChainSettings.setIsStpSupported(this.canUseStp);
            if (daisyChainSettings.getIsStpSupported()) {
                if (this.stpEnabledCheckBox != null) {
                    daisyChainSettings.setIsStpEnabled(this.stpEnabledCheckBox.isSelected());
                }
                if (this.stpBridgePriorityFE != null) {
                    daisyChainSettings.setBridgePriority((BBridgePriority)this.stpBridgePriorityFE.saveValue(cx));
                }
                if (this.stpPortPriority1FE != null) {
                    daisyChainSettings.setPortPriority1((BPortPriority)this.stpPortPriority1FE.saveValue(cx));
                }
                if (this.stpPortPriority2FE != null) {
                    daisyChainSettings.setPortPriority2((BPortPriority)this.stpPortPriority2FE.saveValue(cx));
                }
                if (this.stpHelloTimeFE != null) {
                    daisyChainSettings.setHelloTime((BRelTime)this.stpHelloTimeFE.saveValue(cx));
                }
                if (this.stpForwardDelayTimeFE != null) {
                    daisyChainSettings.setForwardDelayTime((BRelTime)this.stpForwardDelayTimeFE.saveValue(cx));
                }
                if (this.stpMaxAgingTimeFE != null) {
                    daisyChainSettings.setMaxAgingTime((BRelTime)this.stpMaxAgingTimeFE.saveValue(cx));
                }
            }
            if (this.enabledAdapterCount() > 1) {
                this.saveError("TcpIpHostEditor.link.daisychainAndMoreThanOneInterface");
            }
            newSettings = daisyChainSettings;
        } else if (linkModeSelected == BLinkMode.isolated) {
            BIsolatedLinkSettings isolatedLinkSettings = new BIsolatedLinkSettings();
            isolatedLinkSettings.setIsIsolatedEnabled(true);
            newSettings = isolatedLinkSettings;
        }
        if (currentLinkSettings.getType() == newSettings.getType()) {
            currentLinkSettings.copyFrom(newSettings);
        } else {
            host.set("linkModeSettings", (BValue)newSettings);
        }
    }

    private void doSetLinkEnabledStates() {
        boolean stpSettingsEnabled;
        boolean stpCheckBoxEnabled;
        if (this.linkModeEnabledFE == null) {
            return;
        }
        boolean linkSettingsEnabled = !this.isReadonly() && !this.linkSettingsReadonly;
        BLinkMode linkModeSelected = null;
        if (this.linkModeEnabledFE != null) {
            this.linkModeEnabledFE.setEnabled(linkSettingsEnabled);
            try {
                linkModeSelected = (BLinkMode)this.linkModeEnabledFE.saveValue();
            }
            catch (Exception e) {
                return;
            }
        }
        boolean bl = stpCheckBoxEnabled = !this.isReadonly() && !this.linkSettingsReadonly && linkModeSelected == BLinkMode.daisyChain && this.canUseStp;
        if (this.stpEnabledCheckBox != null) {
            this.stpEnabledCheckBox.setEnabled(stpCheckBoxEnabled);
        }
        boolean bl2 = stpSettingsEnabled = stpCheckBoxEnabled && this.stpEnabledCheckBox != null && this.stpEnabledCheckBox.isSelected();
        if (this.stpBridgePriorityFE != null) {
            this.stpBridgePriorityFE.setReadonly(!stpSettingsEnabled);
            this.stpBridgePriorityFE.setEnabled(stpSettingsEnabled);
        }
        if (this.stpPortPriority1FE != null) {
            this.stpPortPriority1FE.setReadonly(!stpSettingsEnabled);
            this.stpPortPriority1FE.setEnabled(stpSettingsEnabled);
        }
        if (this.stpPortPriority2FE != null) {
            this.stpPortPriority2FE.setReadonly(!stpSettingsEnabled);
            this.stpPortPriority2FE.setEnabled(stpSettingsEnabled);
        }
        if (this.stpHelloTimeFE != null) {
            this.stpHelloTimeFE.setReadonly(!stpSettingsEnabled);
            this.stpHelloTimeFE.setEnabled(stpSettingsEnabled);
        }
        if (this.stpForwardDelayTimeFE != null) {
            this.stpForwardDelayTimeFE.setReadonly(!stpSettingsEnabled);
            this.stpForwardDelayTimeFE.setEnabled(stpSettingsEnabled);
        }
        if (this.stpMaxAgingTimeFE != null) {
            this.stpMaxAgingTimeFE.setReadonly(!stpSettingsEnabled);
            this.stpMaxAgingTimeFE.setEnabled(stpSettingsEnabled);
        }
        for (BBorderPane linkSettingsPane : this.linkSettingsPanes) {
            if (linkSettingsPane == null) continue;
            linkSettingsPane.setVisible(false);
        }
        this.linkSettingsPanes[linkModeSelected.getOrdinal()].setVisible(true);
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BTcpIpHostSettings) {
            WbViewEventWorker.getInstance().invokeLater(() -> {
                BTcpIpHostSettings hostSettings = (BTcpIpHostSettings)evt.getSourceComponent();
                Property property = evt.getSlot().asProperty();
                BValue propertyValue = hostSettings.get(property);
                if (property == BTcpIpHostSettings.niagaraUsesIpv6) {
                    if (this.niagaraUsesIpv6 != null) {
                        this.niagaraUsesIpv6.setSelected(((BBoolean)propertyValue).getBoolean());
                    }
                } else if (property == BTcpIpHostSettings.hostName) {
                    if (this.hostNameTextField != null) {
                        this.hostNameTextField.setText(propertyValue.toString().trim());
                    }
                } else if (property == BTcpIpHostSettings.hostFileContents) {
                    if (this.hostsFilePane != null) {
                        this.hostsFilePane.setText(propertyValue.toString().trim());
                    }
                } else if (!this.usesAdapterLevelSettings) {
                    if (property == BTcpIpHostSettings.defaultGateway) {
                        if (this.gatewayFE != null) {
                            this.gatewayFE.loadValue((BObject)((BString)propertyValue));
                        }
                    } else if (property == BTcpIpHostSettings.domain) {
                        if (this.domainTextField != null) {
                            this.domainTextField.setText(propertyValue.toString().trim());
                        }
                    } else if (property == BTcpIpHostSettings.dnsHosts) {
                        if (this.dnsHostEditor != null) {
                            this.dnsHostEditor.loadValue((BObject)((BVector)propertyValue));
                        }
                    } else {
                        boolean foundIpv6Adapter = false;
                        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
                        while (c.next()) {
                            BTcpIpAdapterSettings settings = (BTcpIpAdapterSettings)c.get();
                            if (!settings.getIsIpv6Supported()) continue;
                            foundIpv6Adapter = true;
                            break;
                        }
                        if (foundIpv6Adapter) {
                            if (property == BTcpIpHostSettings.ipv6DefaultGateway) {
                                if (this.ipv6DnsHostEditor != null) {
                                    this.ipv6DnsHostEditor.loadValue((BObject)((BVector)propertyValue));
                                }
                            } else if (property == BTcpIpHostSettings.ipv6DnsHosts && this.ipv6DefaultGatewayFE != null) {
                                this.ipv6DefaultGatewayFE.loadValue((BObject)((BString)propertyValue));
                            }
                        }
                    }
                }
            });
        } else if (evt.getSourceComponent() instanceof BTcpIpAdapterSettings || evt.getSourceComponent() instanceof BDhcpdAdapterSettings) {
            WbViewEventWorker.getInstance().invokeLater(() -> {
                Property property;
                BTcpIpAdapterSettings adapterSettings = null;
                adapterSettings = evt.getSourceComponent() instanceof BTcpIpAdapterSettings ? (BTcpIpAdapterSettings)evt.getSourceComponent() : (BTcpIpAdapterSettings)evt.getSourceComponent().getParent();
                if (this.adapterEditors != null) {
                    for (BTcpIpAdapterEditor adapterEditor : this.adapterEditors) {
                        if (adapterSettings != adapterEditor.getAdapter()) continue;
                        adapterEditor.processComponentEvent(evt);
                    }
                }
                if (!(this.usesAdapterLevelSettings || (property = evt.getSlot().asProperty()) != BTcpIpAdapterSettings.isAdapterEnabled && property != BTcpIpAdapterSettings.isDhcpEnabled)) {
                    this.doSetEnabledStates();
                }
            });
        } else if (evt.getSourceComponent() instanceof BTcpIpLinkSettings) {
            WbViewEventWorker.getInstance().invokeLater(() -> {
                BTcpIpLinkSettings linkSettings = (BTcpIpLinkSettings)evt.getSourceComponent();
                if (this.linkModeEnabledFE != null) {
                    BLinkMode activeLinkMode = (BLinkMode)this.linkModeEnabledFE.getCurrentValue();
                    if (activeLinkMode.getOrdinal() == 0 && linkSettings instanceof BIsolatedLinkSettings) {
                        BIsolatedLinkSettings isolatedLinkSettings = (BIsolatedLinkSettings)linkSettings;
                        Property property = evt.getSlot().asProperty();
                        BValue bValue = isolatedLinkSettings.get(property);
                    } else if (activeLinkMode.getOrdinal() == 1 && linkSettings instanceof BDaisyChainSettings) {
                        BDaisyChainSettings daisyChainSettings = (BDaisyChainSettings)linkSettings;
                        Property property = evt.getSlot().asProperty();
                        BValue propertyValue = daisyChainSettings.get(property);
                        if (property == BDaisyChainSettings.isStpEnabled) {
                            if (this.stpEnabledCheckBox != null) {
                                this.stpEnabledCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                            }
                        } else if (property == BDaisyChainSettings.bridgePriority) {
                            if (this.stpBridgePriorityFE != null) {
                                this.stpBridgePriorityFE.loadValue((BObject)((BBridgePriority)propertyValue));
                            }
                        } else if (property == BDaisyChainSettings.portPriority1) {
                            if (this.stpPortPriority1FE != null) {
                                this.stpPortPriority1FE.loadValue((BObject)((BPortPriority)propertyValue));
                            }
                        } else if (property == BDaisyChainSettings.portPriority2) {
                            if (this.stpPortPriority2FE != null) {
                                this.stpPortPriority2FE.loadValue((BObject)((BPortPriority)propertyValue));
                            }
                        } else if (property == BDaisyChainSettings.helloTime) {
                            if (this.stpHelloTimeFE != null) {
                                this.stpHelloTimeFE.loadValue((BObject)((BRelTime)propertyValue), (Context)BDaisyChainSettings.helloTime.getFacets());
                            }
                        } else if (property == BDaisyChainSettings.forwardDelayTime) {
                            if (this.stpForwardDelayTimeFE != null) {
                                this.stpForwardDelayTimeFE.loadValue((BObject)((BRelTime)propertyValue), (Context)BDaisyChainSettings.forwardDelayTime.getFacets());
                            }
                        } else if (property == BDaisyChainSettings.maxAgingTime && this.stpMaxAgingTimeFE != null) {
                            this.stpMaxAgingTimeFE.loadValue((BObject)((BRelTime)propertyValue), (Context)BDaisyChainSettings.maxAgingTime.getFacets());
                        }
                    }
                }
            });
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

