/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.ntp;

import com.tridium.platform.posix.BNtpModePosix;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.ui.ntp.BNtpServerFE;
import com.tridium.platform.ui.util.BCoordinatedGridPane;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.util.LexiconText;

public class BNtpServerQnxFE
extends BNtpServerFE {
    public static final Type TYPE = Sys.loadType(BNtpServerQnxFE.class);
    protected BBooleanFE preferredFe;
    protected BBooleanFE burstFe;
    protected BLimitedFrozenEnumFE peerModeFe;
    protected BIntegerFE minPollIntervalFe;
    protected BIntegerFE maxPollIntervalFe;
    protected String additionalArgs;
    protected final BFacets PEER_MODE_FACETS = BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])new int[]{2, 1}, (String[])new String[]{BNtpModePosix.server.getTag(), BNtpModePosix.peer.getTag()}));

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNtpServerQnxFE() {
        this.grid = new BCoordinatedGridPane(8);
        this.grid.setHalign(BHalign.left);
        this.grid.setColumnAlign(BHalign.center);
        this.addressFe = new BTextField("", 32);
        this.grid.add(null, (BValue)this.addressFe);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo((BComponent)this.addressFe, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.peerModeFe = new BLimitedFrozenEnumFE();
        this.grid.add(null, (BValue)this.peerModeFe);
        this.linkTo((BComponent)this.peerModeFe, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.peerModeFe, (Slot)BLimitedFrozenEnumFE.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.peerModeFe, (Slot)BLimitedFrozenEnumFE.mouseEvent, (Slot)propagateMouseEvent);
        this.burstFe = new BBooleanFE();
        this.grid.add(null, (BValue)this.burstFe);
        this.linkTo((BComponent)this.burstFe, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.burstFe, (Slot)BBooleanFE.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.burstFe, (Slot)BBooleanFE.mouseEvent, (Slot)propagateMouseEvent);
        this.linkTo((BComponent)this.burstFe, (Slot)BBooleanFE.actionPerformed, (Slot)actionPerformed);
        this.preferredFe = new BBooleanFE();
        this.grid.add(null, (BValue)this.preferredFe);
        this.linkTo((BComponent)this.preferredFe, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.preferredFe, (Slot)BBooleanFE.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.preferredFe, (Slot)BBooleanFE.mouseEvent, (Slot)propagateMouseEvent);
        this.linkTo((BComponent)this.preferredFe, (Slot)BBooleanFE.actionPerformed, (Slot)actionPerformed);
        this.minPollIntervalFe = new BIntegerFE();
        this.grid.add(null, (BValue)this.minPollIntervalFe);
        this.linkTo((BComponent)this.minPollIntervalFe, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.minPollIntervalFe, (Slot)BIntegerFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.minPollIntervalFe, (Slot)BIntegerFE.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.minPollIntervalFe, (Slot)BIntegerFE.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo((BComponent)this.minPollIntervalFe, (Slot)BIntegerFE.mouseEvent, (Slot)propagateMouseEvent);
        this.maxPollIntervalFe = new BIntegerFE();
        this.grid.add(null, (BValue)this.maxPollIntervalFe);
        this.linkTo((BComponent)this.maxPollIntervalFe, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.maxPollIntervalFe, (Slot)BIntegerFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.maxPollIntervalFe, (Slot)BIntegerFE.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo((BComponent)this.maxPollIntervalFe, (Slot)BIntegerFE.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo((BComponent)this.maxPollIntervalFe, (Slot)BIntegerFE.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.grid);
    }

    @Override
    public BWidget makeHeader() {
        BCoordinatedGridPane header = new BCoordinatedGridPane(8);
        header.setHalign(BHalign.left);
        header.setColumnAlign(BHalign.center);
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformService.address.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.peerMode.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.burst.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.prefer.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.minPollInterval.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.maxPollInterval.label"), (boolean)true));
        return header;
    }

    @Override
    public String getServerPropertyName(Context cx) throws Exception {
        BNtpServerQnx factory = (BNtpServerQnx)this.getCurrentValue();
        return factory.getPropertyName(factory.getServerString((BNtpModePosix)this.peerModeFe.saveValue(cx), this.addressFe.getText().trim(), ((BBoolean)this.burstFe.saveValue(cx)).getBoolean(), ((BBoolean)this.preferredFe.saveValue(cx)).getBoolean(), ((BInteger)this.minPollIntervalFe.saveValue(cx)).getInt(), ((BInteger)this.maxPollIntervalFe.saveValue(cx)).getInt(), this.additionalArgs));
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BComplex parent;
        BNtpServerQnx server = (BNtpServerQnx)value;
        if (!this.readonlyInitialized && (parent = server.getParent()) != null) {
            this.setReadonly((parent.loadSlots().getFlags((Slot)server.getPropertyInParent()) & 1) > 0);
        }
        this.peerModeFe.loadValue((BObject)server.getPeerMode(), (Context)this.PEER_MODE_FACETS);
        this.addressFe.setText(server.getAddress());
        this.burstFe.loadValue((BObject)BBoolean.make((boolean)server.getUseBurst()));
        this.preferredFe.loadValue((BObject)BBoolean.make((boolean)server.getServerPreferred()));
        BasicContext feContext = new BasicContext(cx, BNtpServerQnx.minPollInterval.getFacets());
        this.minPollIntervalFe.loadValue((BObject)BInteger.make((int)server.getMinPollInterval()), (Context)feContext);
        feContext = new BasicContext(cx, BNtpServerQnx.maxPollInterval.getFacets());
        this.maxPollIntervalFe.loadValue((BObject)BInteger.make((int)server.getMaxPollInterval()), (Context)feContext);
        this.additionalArgs = server.getAdditionalArgs();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BNtpServerQnx server = (BNtpServerQnx)value;
        server.setPeerMode((BNtpModePosix)this.peerModeFe.saveValue(cx));
        server.setAddress(this.addressFe.getText());
        server.setUseBurst(((BBoolean)this.burstFe.saveValue(cx)).getBoolean());
        server.setServerPreferred(((BBoolean)this.preferredFe.saveValue(cx)).getBoolean());
        server.setMinPollInterval(((BInteger)this.minPollIntervalFe.saveValue(cx)).getInt());
        server.setMaxPollInterval(((BInteger)this.maxPollIntervalFe.saveValue(cx)).getInt());
        server.setAdditionalArgs(this.additionalArgs);
        return server;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.burstFe.setEnabled(isEnabled);
        this.peerModeFe.setEnabled(isEnabled);
        this.preferredFe.setEnabled(isEnabled);
        this.minPollIntervalFe.setEnabled(isEnabled);
        this.maxPollIntervalFe.setEnabled(isEnabled);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.burstFe.setReadonly(readonly);
        this.peerModeFe.setReadonly(readonly);
        this.preferredFe.setReadonly(readonly);
        this.minPollIntervalFe.setReadonly(readonly);
        this.maxPollIntervalFe.setReadonly(readonly);
    }

    @Override
    public void doValidate(Context cx) throws Exception {
        super.doValidate(cx);
        int minPoll = ((BInteger)this.minPollIntervalFe.saveValue(cx)).getInt();
        int maxPoll = ((BInteger)this.maxPollIntervalFe.saveValue(cx)).getInt();
        if (minPoll < 4 || minPoll > 16) {
            throw new Exception("Invalid minPoll value for " + this.addressFe.getText() + ". Use (4-16)");
        }
        if (maxPoll < 5 || maxPoll > 17) {
            throw new Exception("Invalid maxPoll value for " + this.addressFe.getText() + ". Use (5-17)");
        }
        if (maxPoll < minPoll) {
            throw new Exception("Invalid configuration for " + this.addressFe.getText() + ": maxPoll < minPoll");
        }
    }
}

