/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.ntp;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.linux.BNtpPlatformServiceLinux;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ui.ntp.BNtpPlatformServiceEditor;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconText;

public class BNtpPlatformServiceEditorLinux
extends BNtpPlatformServiceEditor {
    public static final Type TYPE = Sys.loadType(BNtpPlatformServiceEditorLinux.class);
    protected BBooleanFE statsFe;
    protected BBooleanFE ntpFe;
    protected BBooleanFE localBackupFe;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNtpPlatformServiceEditorLinux() {
        this.autoRegisterForComponentEvents = false;
        this.ntpFe = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.ntp.label"), (BWidget)this.ntpFe);
        this.linkTo(null, (BComponent)this.ntpFe, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.localBackupFe = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.localBackup.label"), (BWidget)this.localBackupFe);
        this.linkTo(null, (BComponent)this.localBackupFe, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.statsFe = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.stats.label"), (BWidget)this.statsFe);
        this.linkTo(null, (BComponent)this.statsFe, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
    }

    @Override
    protected void doLoadValue(BObject value, Context contextIn) throws Exception {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BNtpPlatformServiceLinux ntpService = (BNtpPlatformServiceLinux)value;
        ntpService.lease(Integer.MAX_VALUE);
        ntpService.poll();
        super.doLoadValue(value, cx);
        BasicContext feContext = new BasicContext(cx, BNtpPlatformServiceLinux.ntp.getFacets());
        this.ntpFe.loadValue((BObject)BBoolean.make((boolean)ntpService.getNtp()), (Context)feContext);
        feContext = new BasicContext(cx, BNtpPlatformServiceLinux.localBackup.getFacets());
        this.localBackupFe.loadValue((BObject)BBoolean.make((boolean)ntpService.getLocalBackup()), (Context)feContext);
        feContext = new BasicContext(cx, BNtpPlatformServiceLinux.statistics.getFacets());
        this.statsFe.loadValue((BObject)BBoolean.make((boolean)ntpService.getStatistics()), (Context)feContext);
        BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)ntpService);
        sys.lease();
        this.setReadonly(sys.getIsServiceReadonly());
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BNtpPlatformServiceLinux ntpService = (BNtpPlatformServiceLinux)value;
        this.doValidate((BNtpPlatformService)ntpService, cx);
        ntpService.setNtp(((BBoolean)this.ntpFe.saveValue()).getBoolean());
        ntpService.setLocalBackup(((BBoolean)this.localBackupFe.saveValue()).getBoolean());
        ntpService.setStatistics(((BBoolean)this.statsFe.saveValue()).getBoolean());
        return super.doSaveValue(value, cx);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.ntpFe.setReadonly(readonly);
        this.localBackupFe.setReadonly(readonly);
        this.statsFe.setReadonly(readonly);
    }

    public BNtpPlatformServiceLinux service() {
        return (BNtpPlatformServiceLinux)this.getCurrentValue();
    }

    @Override
    public void doOnEnabledChanged(Context cx) throws Exception {
        boolean enabled = ((BBoolean)this.enabledFe.saveValue()).getBoolean() && !this.isReadonly();
        this.ntpFe.setEnabled(enabled);
        this.statsFe.setEnabled(enabled);
        this.serversFe.setEnabled(enabled);
    }
}

