/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.platform.hx.util.HxViewHelper;
import java.util.HashMap;
import java.util.Map;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class HxTimeZoneHelper
extends HxViewHelper {
    private BTimeZone[] zones;
    private Map<String, String> attrs;
    private static BTimeZone[] sortedTimeZones = null;

    protected HxTimeZoneHelper(String fieldName, Map<String, String> attrs, BTimeZone[] zones, BFacets facets) {
        super(fieldName, null, facets);
        this.zones = zones;
        this.attrs = attrs;
    }

    public static HxViewHelper makeFE(String fieldName, Map<String, String> attrs, Context cx) {
        return HxTimeZoneHelper.makeFE(fieldName, attrs, HxTimeZoneHelper.getSortedTimeZones(), cx);
    }

    public static HxViewHelper makeFE(String fieldName, Context cx) {
        return HxTimeZoneHelper.makeFE(fieldName, new HashMap<String, String>(), HxTimeZoneHelper.getSortedTimeZones(), cx);
    }

    public static HxViewHelper makeFE(String fieldName, BTimeZone[] zones, Context cx) {
        return HxTimeZoneHelper.makeFE(fieldName, new HashMap<String, String>(), zones, cx);
    }

    public static HxViewHelper makeFE(String fieldName, Map<String, String> attrs, BTimeZone[] zones, Context cx) {
        return new HxTimeZoneHelper(fieldName, attrs, zones, cx == null ? BFacets.NULL : cx.getFacets());
    }

    private static BTimeZone[] getSortedTimeZones() {
        if (sortedTimeZones == null) {
            Object[] unsorted = TimeZoneDatabase.get().getTimeZones();
            Array result = new Array(unsorted);
            result = result.sort(BTimeZone.OFFSET_COMPARATOR);
            sortedTimeZones = (BTimeZone[])result.trim();
        }
        return sortedTimeZones;
    }

    @Override
    public void write(BObject value, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<select name='").w((Object)op.scope(this.fieldName)).w((Object)"' ");
        if (this.isReadonly()) {
            out.w((Object)" disabled='disabled'");
        }
        for (String k : this.attrs.keySet()) {
            out.w((Object)" ").attr(k, this.attrs.get(k));
        }
        out.w((Object)"'>");
        for (BTimeZone zone : this.zones) {
            out.w((Object)"<option value='").w((Object)zone.getId()).w((Object)"'");
            if (value.equals((Object)zone)) {
                out.w((Object)" selected='selected'");
            }
            if (this.isReadonly() || !op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)">");
            out.safe((Object)zone);
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    @Override
    public BObject save(BObject value, HxOp op) throws Exception {
        String id = op.getUnsafeFormValue(this.fieldName);
        for (BTimeZone zone : this.zones) {
            if (!zone.getId().equals(id)) continue;
            return zone;
        }
        return null;
    }

    @Override
    public boolean isFormValueAvailable(HxOp op) {
        return !this.isReadonly() && op.make(this.fieldName, (OrdTarget)op).getFormValue("value") != null;
    }
}

