/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.LocalSessionUtil;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.ServletOutputStream;

public class BStationOutputServlet
extends BWebServlet {
    public static final Property servletName = BStationOutputServlet.newProperty((int)0, (String)"stationOutput", null);
    public static final Type TYPE = Sys.loadType(BStationOutputServlet.class);

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(WebOp op) throws Exception {
        BDaemonSession session = LocalSessionUtil.getLocalSession();
        op.setContentType("text/plain");
        if (session == null) {
            op.getWriter().println(this.getLexicon().getHtmlSafeText("StationOutputServlet.notAvailable"));
            return;
        }
        ServletOutputStream out = op.getResponse().getOutputStream();
        BStationSurrogate surrogate = BStationSurrogate.make((BDaemonSession)session, (String)Sys.getStation().getStationName());
        InputStream in = surrogate.getStationOutput(false, false);
        try {
            int len = 4096;
            byte[] buf = new byte[len];
            while (true) {
                try {
                    int n = in.read(buf, 0, len);
                    if (n < 0) {
                        return;
                    }
                }
                catch (InterruptedIOException n) {
                    continue;
                }
                catch (EOFException eofe) {
                    try {
                        in.close();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                {
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }
}

