/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.hx.BHxTcpIpAdapterEditor;
import com.tridium.platform.hx.util.HostNameValidator;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxStringHelper;
import com.tridium.platform.hx.util.HxStringListHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.hx.util.TcpIpAddressValidator;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.link.BBridgePriority;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BIsolatedLinkSettings;
import com.tridium.platform.tcpip.link.BLinkMode;
import com.tridium.platform.tcpip.link.BPortPriority;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BHxTcpIpHostEditor
extends BHxView {
    public static final BHxTcpIpHostEditor INSTANCE = new BHxTcpIpHostEditor();
    public static final Type TYPE = Sys.loadType(BHxTcpIpHostEditor.class);
    private HxViewHelper hostNameEditor = HxStringHelper.makeFE("hostName", HostNameValidator.INSTANCE, null);
    private HxViewHelper niagaraUsesIpv6Editor;
    private HxViewHelper domainEditor = HxStringHelper.makeFE("domain", null);
    private HxViewHelper gatewayEditor = HxStringHelper.makeFE("gateway", TcpIpAddressValidator.INSTANCE_PERMIT_NULL, null);
    private HxViewHelper dnsEditor = HxStringListHelper.makeFE("dnsHosts", TcpIpAddressValidator.INSTANCE_PERMIT_NULL, null);
    private HxViewHelper ipv6GatewayEditor = HxStringHelper.makeFE("ipv6Gateway", TcpIpAddressValidator.INSTANCEv6_PERMIT_NULL, null);
    private HxViewHelper ipv6DnsEditor = HxStringListHelper.makeFE("ipv6DnsHosts", TcpIpAddressValidator.INSTANCEv6_PERMIT_NULL, null);
    private HxViewHelper linkModeEnabledEditor;
    private boolean canUseStp;
    private HxViewHelper stpEnabledEditor;
    private HxViewHelper stpBridgePriorityEditor;
    private HxViewHelper stpPortPriority1Editor;
    private HxViewHelper stpPortPriority2Editor;
    private HxViewHelper stpHelloTimeEditor;
    private HxViewHelper stpForwardDelayTimeEditor;
    private HxViewHelper stpMaxAgingTimeEditor;

    public Type getType() {
        return TYPE;
    }

    protected BHxTcpIpHostEditor() {
        BFacets niagaraUsesIpv6Facets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpHostEditor.niagaraUsesIpv6.true)%"), BString.make((String)"%lexicon(platform:TcpIpHostEditor.niagaraUsesIpv6.false)%")});
        this.niagaraUsesIpv6Editor = HxBooleanHelper.makeFE("niagaraUsesIpv6", new HashMap(), (Context)niagaraUsesIpv6Facets);
        this.stpBridgePriorityEditor = HxViewHelper.makeFE("stpBridgePriority", (BObject)BBridgePriority.DEFAULT, (Context)BDaisyChainSettings.bridgePriority.getFacets());
        this.stpPortPriority1Editor = HxViewHelper.makeFE("stpPortPriority1", (BObject)BPortPriority.DEFAULT, (Context)BDaisyChainSettings.portPriority1.getFacets());
        this.stpPortPriority2Editor = HxViewHelper.makeFE("stpPortPriority2", (BObject)BPortPriority.DEFAULT, (Context)BDaisyChainSettings.portPriority2.getFacets());
        this.stpHelloTimeEditor = HxViewHelper.makeFE("stpHelloTime", (BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.helloTime.getFacets());
        this.stpForwardDelayTimeEditor = HxViewHelper.makeFE("stpForwardDelayTime", (BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.forwardDelayTime.getFacets());
        this.stpMaxAgingTimeEditor = HxViewHelper.makeFE("stpMaxAgingTime", (BObject)BRelTime.DEFAULT, (Context)BDaisyChainSettings.maxAgingTime.getFacets());
        BFacets stpEnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpHostEditor.link.daisychain.stpEnabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpHostEditor.link.daisychain.stpEnabled.false)%")});
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("onChange", "onLinkModeChanged(event)");
        this.linkModeEnabledEditor = HxViewHelper.makeFE("linkModeEnabled", (BObject)BLinkMode.isolated, null);
        attrs = new HashMap();
        attrs.put("onChange", "onStpEnabledChanged(event)");
        this.stpEnabledEditor = HxBooleanHelper.makeFE("stpEnabled", attrs, (Context)stpEnabledFacets);
    }

    public void write(HxOp op) throws Exception {
        BTcpIpHostSettings settings = (BTcpIpHostSettings)op.get();
        BOrd ord = BOrd.make((String)"module://platform/lib/BHxTcpIpHostEditor.js");
        op.addJavaScript(ord);
        settings.lease();
        boolean operatorCanWrite = op.canWrite();
        boolean isHostReadonly = settings.getIsReadonly();
        boolean foundIpv6Device = false;
        boolean hostSettingsProvidedByDHCPv4 = false;
        boolean hostSettingsProvidedByAutoconfiguration = false;
        SlotCursor c = settings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            if (!settings.getUsesAdapterLevelSettings() && adapter.getIsAdapterEnabled() && adapter.getIsDhcpEnabled()) {
                hostSettingsProvidedByDHCPv4 = true;
            }
            if (!adapter.getIsIpv6Supported()) continue;
            foundIpv6Device = true;
        }
        this.hostNameEditor.setReadonly(!operatorCanWrite || isHostReadonly);
        if (!settings.getUsesAdapterLevelSettings()) {
            this.domainEditor.setReadonly(!operatorCanWrite || isHostReadonly || hostSettingsProvidedByDHCPv4);
            this.gatewayEditor.setReadonly(!operatorCanWrite || isHostReadonly || hostSettingsProvidedByDHCPv4);
            this.dnsEditor.setReadonly(!operatorCanWrite || isHostReadonly || hostSettingsProvidedByDHCPv4);
        } else {
            this.domainEditor.setReadonly(true);
            this.gatewayEditor.setReadonly(true);
            this.dnsEditor.setReadonly(true);
        }
        boolean isIPv6Readonly = settings.getIsIPv6Readonly();
        if (foundIpv6Device && !settings.getUsesAdapterLevelSettings()) {
            this.ipv6GatewayEditor.setReadonly(!operatorCanWrite || isHostReadonly || isIPv6Readonly || hostSettingsProvidedByAutoconfiguration);
            this.ipv6DnsEditor.setReadonly(!operatorCanWrite || isHostReadonly || isIPv6Readonly || hostSettingsProvidedByAutoconfiguration);
            this.niagaraUsesIpv6Editor.setReadonly(!operatorCanWrite || isHostReadonly);
        } else {
            this.ipv6GatewayEditor.setReadonly(true);
            this.ipv6DnsEditor.setReadonly(true);
            this.niagaraUsesIpv6Editor.setReadonly(true);
        }
        boolean isLinkModeReadonly = true;
        boolean isStpEnabled = false;
        boolean addLinkEditors = true;
        BVector linkModesSupported = (BVector)settings.loadSlots().get("linkModesSupported");
        BTcpIpLinkSettings activeTcpIpLinkSettings = (BTcpIpLinkSettings)settings.loadSlots().get("linkModeSettings");
        if (linkModesSupported != null && activeTcpIpLinkSettings != null) {
            isLinkModeReadonly = isHostReadonly || activeTcpIpLinkSettings.getIsReadOnly();
            boolean activeSettingsAreSupported = false;
            SlotCursor c2 = linkModesSupported.getProperties();
            while (c2.next(BLinkMode.class)) {
                BLinkMode supportedMode = (BLinkMode)c2.get();
                if (supportedMode == BLinkMode.daisyChain) {
                    BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
                    if (activeTcpIpLinkSettings instanceof BDaisyChainSettings) {
                        daisyChainSettings = (BDaisyChainSettings)activeTcpIpLinkSettings;
                    }
                    this.canUseStp = daisyChainSettings.getIsStpSupported();
                    if (this.canUseStp) {
                        isStpEnabled = daisyChainSettings.getIsStpEnabled();
                    }
                }
                if (activeTcpIpLinkSettings.getLinkMode().getOrdinal() != supportedMode.getOrdinal()) continue;
                activeSettingsAreSupported = true;
            }
            if (!activeSettingsAreSupported) {
                throw new BajaRuntimeException("Link configuration actively using settings for unsupported mode: " + activeTcpIpLinkSettings.getLinkMode());
            }
            if (linkModesSupported.getPropertyCount() == 1 && activeTcpIpLinkSettings.getLinkMode().getOrdinal() == 0) {
                addLinkEditors = false;
            }
            boolean baseSettingsReadonly = isHostReadonly || !operatorCanWrite;
            this.linkModeEnabledEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly);
            this.stpEnabledEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp);
            this.stpBridgePriorityEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
            this.stpPortPriority1Editor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
            this.stpPortPriority2Editor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
            this.stpHelloTimeEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
            this.stpForwardDelayTimeEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
            this.stpMaxAgingTimeEditor.setReadonly(baseSettingsReadonly || isLinkModeReadonly || !this.canUseStp || !isStpEnabled);
        } else {
            this.linkModeEnabledEditor.setReadonly(true);
            this.stpEnabledEditor.setReadonly(true);
            this.stpBridgePriorityEditor.setReadonly(true);
            this.stpPortPriority1Editor.setReadonly(true);
            this.stpPortPriority2Editor.setReadonly(true);
            this.stpHelloTimeEditor.setReadonly(true);
            this.stpForwardDelayTimeEditor.setReadonly(true);
            this.stpMaxAgingTimeEditor.setReadonly(true);
        }
        HtmlWriter out = op.getHtmlWriter();
        out.println();
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("operatorCanWrite.hidden")).w((Object)("' value='" + operatorCanWrite)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("hostReadonly.hidden")).w((Object)("' value='" + isHostReadonly)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("usesAdapterLevelSettings.hidden")).w((Object)("' value='" + settings.getUsesAdapterLevelSettings())).println("'/>");
        String activeLinkModeValue = BLinkMode.isolated.getTag();
        if (activeTcpIpLinkSettings != null) {
            activeLinkModeValue = activeTcpIpLinkSettings.getLinkMode().getTag();
        }
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("linkSettingsReadonly.hidden")).w((Object)("' value='" + isLinkModeReadonly)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("linkModeEnabled.hidden")).w((Object)("' value='" + activeLinkModeValue)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canUseStp.hidden")).w((Object)("' value='" + this.canUseStp)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("stpEnabled.hidden")).w((Object)("' value='" + isStpEnabled)).println("'/>");
        out.println("<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.hostName").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.hostNameEditor.write((BObject)settings.get(BTcpIpHostSettings.hostName), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        if (foundIpv6Device) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.niagaraUsesIpv6").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.niagaraUsesIpv6Editor.write((BObject)settings.get(BTcpIpHostSettings.niagaraUsesIpv6), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        if (!settings.getUsesAdapterLevelSettings()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.domain").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.domainEditor.write((BObject)settings.get(BTcpIpHostSettings.domain), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.gateway").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.gatewayEditor.write((BObject)settings.get(BTcpIpHostSettings.defaultGateway), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.dnsHostsHx").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dnsEditor.write((BObject)settings.getDnsHosts(), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            if (foundIpv6Device) {
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.ipv6Gateway").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.ipv6GatewayEditor.write((BObject)settings.get(BTcpIpHostSettings.ipv6DefaultGateway), op);
                out.w((Object)"</td>");
                out.println("</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.ipv6DnsHostsHx").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.ipv6DnsEditor.write((BObject)settings.getIpv6DnsHosts(), op);
                out.w((Object)"</td>");
                out.println("</tr>");
            }
        }
        if (activeTcpIpLinkSettings != null && addLinkEditors) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.activeLinkMode").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.linkModeEnabledEditor.write((BObject)activeTcpIpLinkSettings.getLinkMode(), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            SlotCursor c3 = linkModesSupported.getProperties();
            while (c3.next(BLinkMode.class)) {
                BLinkMode supportedMode = (BLinkMode)c3.get();
                if (supportedMode == BLinkMode.daisyChain) {
                    BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
                    if (activeTcpIpLinkSettings instanceof BDaisyChainSettings) {
                        daisyChainSettings = (BDaisyChainSettings)activeTcpIpLinkSettings;
                    }
                    if (!daisyChainSettings.getIsStpSupported()) continue;
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpLabel").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpEnabledEditor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.isStpEnabled), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpBridgePriority").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpBridgePriorityEditor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.bridgePriority), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpPortPriority1").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpPortPriority1Editor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority1), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpPortPriority2").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpPortPriority2Editor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority2), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpHelloTime").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpHelloTimeEditor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.helloTime), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpForwardDelayTime").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpForwardDelayTimeEditor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.forwardDelayTime), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    out.w((Object)"<tr>");
                    out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.link.daisychain.stpMaxAgingTime").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                    out.w((Object)"<td>");
                    this.stpMaxAgingTimeEditor.write((BObject)daisyChainSettings.get(BDaisyChainSettings.maxAgingTime), op);
                    out.w((Object)"</td>");
                    out.println("</tr>");
                    continue;
                }
                if (supportedMode != BLinkMode.isolated) continue;
                BIsolatedLinkSettings isolatedLinkSettings = new BIsolatedLinkSettings();
                if (!(activeTcpIpLinkSettings instanceof BIsolatedLinkSettings)) continue;
                isolatedLinkSettings = (BIsolatedLinkSettings)activeTcpIpLinkSettings;
            }
        }
        String function = "executeHostOnLoad(\"" + op.getPath() + "\");";
        op.addOnload(function);
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.interfaceCategory").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        int adapterCount = 0;
        SlotCursor c4 = settings.getAdapters().loadSlots().getProperties();
        while (c4.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c4.get();
            if (activeTcpIpLinkSettings != null && addLinkEditors && adapterCount > 0) {
                try {
                    if (activeTcpIpLinkSettings.getLinkMode() == BLinkMode.daisyChain) {
                        adapter.setIsAdapterEnabled(false);
                        adapter.setIsAdapterReadonly(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HxOp adapterOp = op.make(((Property)c4.slot()).getName(), new OrdTarget((OrdTarget)op, (BObject)adapter));
            adapterOp.setReadonly(!op.canWrite() || settings.getIsReadonly());
            BHxTcpIpAdapterEditor.INSTANCE.write(adapterOp);
            out.println("<br/>");
            ++adapterCount;
        }
        out.w((Object)"</td>");
        out.println("</tr>");
        out.println("</table>");
    }

    public void validate(HxOp op) throws Exception {
        BTcpIpHostSettings settings = (BTcpIpHostSettings)op.get();
        if (settings.getIsReadonly()) {
            return;
        }
        boolean ipv6AdapterEnabled = false;
        int enabledAdapterCount = 0;
        HashMap<String, BTcpIpAdapterSettings> networkPrefixes = new HashMap<String, BTcpIpAdapterSettings>();
        SlotCursor c = settings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings conflict;
            String network;
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            HxOp adapterOp = op.make(((Property)c.slot()).getName(), new OrdTarget((OrdTarget)op, (BObject)adapter));
            BHxTcpIpAdapterEditor.INSTANCE.validate(adapterOp);
            if (!BHxTcpIpAdapterEditor.INSTANCE.isAdapterEnabledSelected(adapterOp)) continue;
            ++enabledAdapterCount;
            if (adapter.getIsIpv6Supported() && BHxTcpIpAdapterEditor.INSTANCE.isIpv6EnabledSelected(adapterOp)) {
                ipv6AdapterEnabled = true;
            }
            try {
                network = IPAddressUtil.getIPv4NetworkPrefix((String)BHxTcpIpAdapterEditor.INSTANCE.getAdapterIPValue(adapterOp), (String)BHxTcpIpAdapterEditor.INSTANCE.getAdapterSubnetMaskValue(adapterOp));
            }
            catch (Exception e) {
                network = null;
            }
            if (network == null || (conflict = networkPrefixes.put(network, adapter)) == null) continue;
            Object[] arguments = new Object[]{conflict.getAdapterId(), adapter.getAdapterId(), network};
            throw new LocalizableRuntimeException("platform", "TcpIpHostEditor.duplicateNetworkPrefixes", arguments);
        }
        if (enabledAdapterCount == 0) {
            throw new LocalizableRuntimeException("platform", "TcpIpHostEditor.noEnabledAdapters");
        }
        if (this.hostNameEditor.isFormValueAvailable(op)) {
            this.hostNameEditor.validate((BObject)settings.get(BTcpIpHostSettings.hostName), op);
        }
        if (this.niagaraUsesIpv6Editor != null && this.niagaraUsesIpv6Editor.isFormValueAvailable(op)) {
            this.niagaraUsesIpv6Editor.validate((BObject)settings.get(BTcpIpHostSettings.niagaraUsesIpv6), op);
        }
        if (!settings.getUsesAdapterLevelSettings()) {
            if (this.domainEditor.isFormValueAvailable(op)) {
                this.domainEditor.validate((BObject)settings.get(BTcpIpHostSettings.domain), op);
            }
            if (this.gatewayEditor.isFormValueAvailable(op)) {
                this.gatewayEditor.validate((BObject)settings.get(BTcpIpHostSettings.defaultGateway), op);
            }
            if (this.dnsEditor.isFormValueAvailable(op)) {
                this.dnsEditor.validate((BObject)settings.getDnsHosts(), op);
            }
            if (this.ipv6GatewayEditor != null && this.ipv6GatewayEditor.isFormValueAvailable(op)) {
                if (ipv6AdapterEnabled) {
                    this.ipv6GatewayEditor.validate((BObject)settings.get(BTcpIpHostSettings.ipv6DefaultGateway), op);
                } else {
                    String ipv6GatewayValue = "";
                    try {
                        ipv6GatewayValue = this.ipv6GatewayEditor.save((BObject)settings.get(BTcpIpHostSettings.ipv6DefaultGateway), op).toString();
                    }
                    catch (Exception adapterOp) {
                        // empty catch block
                    }
                    if (ipv6GatewayValue.length() != 0) {
                        throw new LocalizableRuntimeException("platform", "TcpIpHostEditor.nonEmptyIPv6Gateway");
                    }
                }
            }
            if (this.ipv6DnsEditor != null && this.ipv6DnsEditor.isFormValueAvailable(op)) {
                if (ipv6AdapterEnabled) {
                    this.ipv6DnsEditor.validate((BObject)settings.getIpv6DnsHosts(), op);
                } else {
                    BVector ipv6DnsHostsValue = null;
                    try {
                        ipv6DnsHostsValue = (BVector)this.ipv6DnsEditor.save((BObject)settings.getIpv6DnsHosts(), op);
                    }
                    catch (Exception adapterOp) {
                        // empty catch block
                    }
                    if (ipv6DnsHostsValue != null && ipv6DnsHostsValue.getSlotCount() != 0) {
                        throw new LocalizableRuntimeException("platform", "TcpIpHostEditor.nonEmptyIPv6DNSHosts");
                    }
                }
            }
        }
        BVector linkModesSupported = (BVector)settings.loadSlots().get("linkModesSupported");
        BTcpIpLinkSettings tcpIpLinkSettings = (BTcpIpLinkSettings)settings.loadSlots().get("linkModeSettings");
        if (linkModesSupported != null && tcpIpLinkSettings != null) {
            BLinkMode activeLinkMode = tcpIpLinkSettings.getLinkMode();
            if (!this.linkModeEnabledEditor.isReadonly()) {
                this.linkModeEnabledEditor.validate((BObject)activeLinkMode, op);
                activeLinkMode = (BLinkMode)this.linkModeEnabledEditor.save((BObject)activeLinkMode, op);
            }
            if (activeLinkMode.getOrdinal() == 1) {
                BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
                if (tcpIpLinkSettings instanceof BDaisyChainSettings) {
                    daisyChainSettings = (BDaisyChainSettings)tcpIpLinkSettings;
                }
                BBoolean stpEnabled = BBoolean.make((boolean)daisyChainSettings.getIsStpEnabled());
                if (this.stpEnabledEditor.isFormValueAvailable(op)) {
                    this.stpEnabledEditor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.isStpEnabled), op);
                    stpEnabled = (BBoolean)this.stpEnabledEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.isStpEnabled), op);
                }
                if (stpEnabled.getBoolean()) {
                    if (!this.stpBridgePriorityEditor.isReadonly()) {
                        this.stpBridgePriorityEditor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.bridgePriority), op);
                    }
                    if (!this.stpPortPriority1Editor.isReadonly()) {
                        this.stpPortPriority1Editor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority1), op);
                    }
                    if (!this.stpPortPriority2Editor.isReadonly()) {
                        this.stpPortPriority2Editor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority2), op);
                    }
                    if (!this.stpHelloTimeEditor.isReadonly()) {
                        this.stpHelloTimeEditor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.helloTime), op);
                    }
                    if (!this.stpForwardDelayTimeEditor.isReadonly()) {
                        this.stpForwardDelayTimeEditor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.forwardDelayTime), op);
                    }
                    if (!this.stpMaxAgingTimeEditor.isReadonly()) {
                        this.stpMaxAgingTimeEditor.validate((BObject)daisyChainSettings.get(BDaisyChainSettings.maxAgingTime), op);
                    }
                }
                if (enabledAdapterCount > 1) {
                    throw new LocalizableRuntimeException("platform", "TcpIpHostEditor.link.daisychainAndMoreThanOneInterface");
                }
            } else if (activeLinkMode.getOrdinal() == 0) {
                BIsolatedLinkSettings isolatedLinkSettings = new BIsolatedLinkSettings();
                if (tcpIpLinkSettings instanceof BIsolatedLinkSettings) {
                    isolatedLinkSettings = (BIsolatedLinkSettings)tcpIpLinkSettings;
                }
            }
        }
    }

    public BObject save(HxOp op) throws Exception {
        BTcpIpHostSettings settings = (BTcpIpHostSettings)op.get();
        if (settings.getIsReadonly()) {
            return settings;
        }
        this.validate(op);
        boolean foundIpv6Device = false;
        SlotCursor c = settings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            HxOp adapterOp = op.make(((Property)c.slot()).getName(), new OrdTarget((OrdTarget)op, (BObject)adapter));
            BHxTcpIpAdapterEditor.INSTANCE.save(adapterOp);
            if (!adapter.getIsIpv6Supported() || !adapter.getIsIpv6Enabled()) continue;
            foundIpv6Device = true;
        }
        if (this.hostNameEditor.isFormValueAvailable(op)) {
            settings.setHostName(this.hostNameEditor.save((BObject)settings.get(BTcpIpHostSettings.hostName), op).toString());
        }
        if (foundIpv6Device) {
            if (this.niagaraUsesIpv6Editor.isFormValueAvailable(op)) {
                settings.setNiagaraUsesIpv6(((BBoolean)this.niagaraUsesIpv6Editor.save((BObject)settings.get(BTcpIpHostSettings.niagaraUsesIpv6), op)).getBoolean());
            }
        } else {
            settings.setNiagaraUsesIpv6(false);
        }
        if (!settings.getUsesAdapterLevelSettings()) {
            if (this.domainEditor.isFormValueAvailable(op)) {
                settings.setDomain(this.domainEditor.save((BObject)settings.get(BTcpIpHostSettings.domain), op).toString());
            }
            if (this.gatewayEditor.isFormValueAvailable(op)) {
                settings.setDefaultGateway(this.gatewayEditor.save((BObject)settings.get(BTcpIpHostSettings.defaultGateway), op).toString());
            }
            if (this.dnsEditor.isFormValueAvailable(op)) {
                settings.setDnsHosts((BVector)this.dnsEditor.save((BObject)settings.getDnsHosts(), op));
            }
            if (foundIpv6Device) {
                if (this.ipv6GatewayEditor.isFormValueAvailable(op)) {
                    settings.setIpv6DefaultGateway(this.ipv6GatewayEditor.save((BObject)settings.get(BTcpIpHostSettings.ipv6DefaultGateway), op).toString());
                }
                if (this.ipv6DnsEditor.isFormValueAvailable(op)) {
                    settings.setIpv6DnsHosts((BVector)this.ipv6DnsEditor.save((BObject)settings.getIpv6DnsHosts(), op));
                }
            }
        }
        BVector supportedLinkModes = (BVector)settings.loadSlots().get("linkModesSupported");
        BTcpIpLinkSettings activeLinkSettings = (BTcpIpLinkSettings)settings.loadSlots().get("linkModeSettings");
        if (supportedLinkModes != null && activeLinkSettings != null) {
            BIsolatedLinkSettings newSettings = null;
            BLinkMode linkModeSelected = activeLinkSettings.getLinkMode();
            if (!this.linkModeEnabledEditor.isReadonly()) {
                linkModeSelected = (BLinkMode)this.linkModeEnabledEditor.save((BObject)activeLinkSettings.getLinkMode(), op);
            }
            if (linkModeSelected == BLinkMode.daisyChain) {
                BDaisyChainSettings daisyChainSettings = new BDaisyChainSettings();
                daisyChainSettings.setIsDaisyChainEnabled(true);
                daisyChainSettings.setIsStpSupported(this.canUseStp);
                if (daisyChainSettings.getIsStpSupported()) {
                    if (this.stpEnabledEditor.isFormValueAvailable(op)) {
                        daisyChainSettings.setIsStpEnabled(((BBoolean)this.stpEnabledEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.isStpEnabled), op)).getBoolean());
                    }
                    if (daisyChainSettings.getIsStpEnabled()) {
                        if (!this.stpBridgePriorityEditor.isReadonly()) {
                            daisyChainSettings.setBridgePriority((BBridgePriority)this.stpBridgePriorityEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.bridgePriority), op));
                        }
                        if (!this.stpPortPriority1Editor.isReadonly()) {
                            daisyChainSettings.setPortPriority1((BPortPriority)this.stpPortPriority1Editor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority1), op));
                        }
                        if (!this.stpPortPriority2Editor.isReadonly()) {
                            daisyChainSettings.setPortPriority2((BPortPriority)this.stpPortPriority2Editor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.portPriority2), op));
                        }
                        if (!this.stpHelloTimeEditor.isReadonly()) {
                            daisyChainSettings.setHelloTime((BRelTime)this.stpHelloTimeEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.helloTime), op));
                        }
                        if (!this.stpForwardDelayTimeEditor.isReadonly()) {
                            daisyChainSettings.setForwardDelayTime((BRelTime)this.stpForwardDelayTimeEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.forwardDelayTime), op));
                        }
                        if (!this.stpMaxAgingTimeEditor.isReadonly()) {
                            daisyChainSettings.setMaxAgingTime((BRelTime)this.stpMaxAgingTimeEditor.save((BObject)daisyChainSettings.get(BDaisyChainSettings.maxAgingTime), op));
                        }
                    }
                }
                newSettings = daisyChainSettings;
            } else if (linkModeSelected == BLinkMode.isolated) {
                BIsolatedLinkSettings isolatedLinkSettings = new BIsolatedLinkSettings();
                isolatedLinkSettings.setIsIsolatedEnabled(true);
                newSettings = isolatedLinkSettings;
            }
            if (activeLinkSettings.getType() == newSettings.getType()) {
                activeLinkSettings.copyFrom(newSettings);
            } else {
                settings.set("linkModeSettings", (BValue)newSettings);
            }
        }
        return settings;
    }
}

