/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration.converters;

import java.util.ArrayList;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BTypeNewNameConverter
extends BObject
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BTypeNewNameConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        if (!typespecName.equals("propMigration:TypeRenamed")) {
            return x;
        }
        log.finer("Migrate a TypeNameChange! typespecName=" + typespecName + ", xelem=" + x);
        String nam = x.get("n");
        log.info("Changing type of " + nam + " to propMigration:TypeNewName");
        x.setAttr("t", "propMigration:TypeNewName");
        XElem[] props = x.elems("p");
        for (int i = 0; i < props.length; ++i) {
            XElem p = props[i];
            String n = p.get("n", "-");
            if (!n.equals("propRename")) continue;
            log.info("Changing name of " + nam + ":propRename to propNewName");
            p.setAttr("n", "propNewName");
        }
        log.finer("migrated: new x is " + x);
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        log.finest("PropNameChangeConverter.newInstance is stubbed!");
        return (BValue)BTypeSpec.make((String)"propMigration:TypeNewName").getInstance();
    }

    public BOrd fixOrd(BOrd originalOrd) {
        String ordS = originalOrd.toString(null);
        if (!ordS.contains("propRename")) {
            return null;
        }
        ordS = ordS.replace("propRename", "propNewName");
        return BOrd.make((String)ordS);
    }

    static {
        convertTypes.add("propMigration:TypeRenamed");
        convertTypes.add("propMigration:TypeNewName");
    }
}

