/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration.converters;

import java.util.ArrayList;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BPropValueChangeConverter
extends BObject
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BPropValueChangeConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        XElem[] props;
        log.finer("Migrate a PropValueChange! typespecName=" + typespecName + ", xelem=" + x);
        for (XElem p : props = x.elems("p")) {
            String n = p.get("n", "-");
            if (n.equals("propValueChange")) {
                log.info("Changing value of propValueChange unconditionally");
                p.setAttr("v", "3.0");
                continue;
            }
            if (!n.equals("propValueChange2")) continue;
            log.finer("Found propValueChange2 - changing value ONLY if it is still default");
            String val = p.get("v", "5.0");
            if (!val.equals("5.0")) continue;
            log.info("Changing default value of propValueChange2 to 8.0");
            p.setAttr("v", "8.0");
        }
        log.finer("migrated: new x is " + x);
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        log.finest("PropValueChangeConverter.newInstance is stubbed!");
        return (BValue)BTypeSpec.make((String)(moduleName + ":" + typeName)).getInstance();
    }

    static {
        convertTypes.add("propMigration:PropValueChange");
    }
}

