/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.propMigration;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOrigSimple
extends BSimple {
    private String str;
    private boolean bool;
    private double dbl;
    public static final BOrigSimple DEFAULT = new BOrigSimple();
    public static final Type TYPE = Sys.loadType(BOrigSimple.class);

    public BOrigSimple() {
        this.str = "";
        this.bool = false;
        this.dbl = 0.0;
    }

    public BOrigSimple(String s, boolean b, double d) {
        this.str = s;
        this.bool = b;
        this.dbl = d;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BOrigSimple) {
            BOrigSimple sec = (BOrigSimple)((Object)obj);
            if (BDouble.equals((double)this.dbl, (double)sec.dbl) && this.bool == sec.bool) {
                if (this.str == null) {
                    return sec.str == null;
                }
                return this.str.equals(sec.str);
            }
            return false;
        }
        return false;
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeBoolean(this.bool);
        encoder.writeDouble(this.dbl);
        encoder.writeUTF(this.str);
    }

    public BObject decode(DataInput decoder) throws IOException {
        boolean b = decoder.readBoolean();
        double d = decoder.readDouble();
        String s = decoder.readUTF();
        return new BOrigSimple(s, b, d);
    }

    public String encodeToString() throws IOException {
        return this.bool + " " + this.dbl + " " + this.str;
    }

    public BObject decodeFromString(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, " ");
        boolean b = st.nextToken().equalsIgnoreCase("true");
        double d = Double.parseDouble(st.nextToken());
        String str = "";
        if (st.hasMoreTokens()) {
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken()).append(' ');
            }
            str = sb.substring(0, sb.length() - 1);
        }
        return new BOrigSimple(str, b, d);
    }

    public String prettyPrint() {
        return this.bool ? this.str : Double.toString(this.dbl);
    }

    public Type getType() {
        return TYPE;
    }
}

