/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.foxanalyzer.ui;

import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.foxanalyzer.BFoxFrameRecord;
import com.tridium.foxanalyzer.BFoxFrameRecordType;
import com.tridium.foxanalyzer.BIFoxAnalyzer;
import com.tridium.foxanalyzer.ui.BWbFoxAnalyzerToolOptions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.workbench.tool.BWbNavNodeTool;

public final class BWbFoxAnalyzerTool
extends BWbNavNodeTool
implements BIFoxAnalyzer {
    public static final Topic newFrame = BWbFoxAnalyzerTool.newTopic((int)264, null);
    public static final Type TYPE = Sys.loadType(BWbFoxAnalyzerTool.class);
    private Listener listener = new Listener();
    private Factory factory = new Factory();
    private PatternFilter channelFilter = new PatternFilter("*");
    private PatternFilter commandFilter = new PatternFilter("*");
    private PatternFilter stationNameFilter = new PatternFilter("*");
    private String id = "";
    private boolean showDebugFrames = true;
    private static Worker worker;
    private static final Queue queue;
    private int totalReg = 0;
    private static final BIcon icon;

    public void fireNewFrame(BFoxFrameRecord event) {
        this.fire(newFrame, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Topic getNewFrameTopic() {
        return newFrame;
    }

    public int getViewLogLimit() {
        return BWbFoxAnalyzerToolOptions.get().getViewLogLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        ++this.totalReg;
        BWbFoxAnalyzerToolOptions options = BWbFoxAnalyzerToolOptions.get();
        this.channelFilter = new PatternFilter(options.getChannelPattern());
        this.commandFilter = new PatternFilter(options.getCommandPattern());
        this.stationNameFilter = new PatternFilter(options.getStationNamePattern());
        this.id = options.getId();
        this.showDebugFrames = options.getShowDebugFrames();
        Class<BWbFoxAnalyzerTool> clazz = BWbFoxAnalyzerTool.class;
        synchronized (BWbFoxAnalyzerTool.class) {
            if (worker == null) {
                worker = new Worker((Worker.ITodo)queue);
                worker.start("wbFoxAnalyzerTool");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
            return;
        }
    }

    public void unregister() {
        --this.totalReg;
        if (this.totalReg <= 0) {
            FoxSession.unregisterListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
        }
    }

    private void post(Runnable runnable) {
        queue.enqueue((Object)runnable);
    }

    static {
        queue = new Queue();
        icon = BIcon.std((String)"magnifyingGlass.png");
    }

    private class Listener
    implements FoxSession.IFoxSessionListener {
        private Listener() {
        }

        public void connectionAborted(final String cause, final Throwable throwable) {
            BWbFoxAnalyzerTool.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make((BFoxFrameRecordType)BFoxFrameRecordType.connectionAborted, (String)cause, (Throwable)throwable);
                    BWbFoxAnalyzerTool.this.fireNewFrame(rec);
                }
            });
        }

        public void stateChanged(final FoxSession session, final String state, final Throwable throwable) {
            if (!this.validateSession(session)) {
                return;
            }
            BWbFoxAnalyzerTool.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make((BFoxFrameRecordType)BFoxFrameRecordType.stateChanged, (FoxSession)session, (String)state, (Throwable)throwable);
                    BWbFoxAnalyzerTool.this.fireNewFrame(rec);
                }
            });
        }

        public void readFrame(final FoxSession session, final FoxFrame frame) {
            if (!this.validateSession(session)) {
                return;
            }
            if (!this.validateFrame(frame)) {
                return;
            }
            BWbFoxAnalyzerTool.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make((BFoxFrameRecordType)BFoxFrameRecordType.readFrame, (FoxSession)session, (FoxFrame)frame, (boolean)BWbFoxAnalyzerTool.this.showDebugFrames);
                    BWbFoxAnalyzerTool.this.fireNewFrame(rec);
                }
            });
        }

        public void writeFrame(final FoxSession session, final FoxFrame frame) {
            if (!this.validateSession(session)) {
                return;
            }
            if (!this.validateFrame(frame)) {
                return;
            }
            BWbFoxAnalyzerTool.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make((BFoxFrameRecordType)BFoxFrameRecordType.writeFrame, (FoxSession)session, (FoxFrame)frame, (boolean)BWbFoxAnalyzerTool.this.showDebugFrames);
                    BWbFoxAnalyzerTool.this.fireNewFrame(rec);
                }
            });
        }

        private boolean validateFrame(FoxFrame frame) {
            return BWbFoxAnalyzerTool.this.channelFilter.accept(frame.channel) && BWbFoxAnalyzerTool.this.commandFilter.accept(frame.command);
        }

        private boolean validateSession(FoxSession session) {
            return session == null || BWbFoxAnalyzerTool.this.id.isEmpty() || !session.getId().equals(BWbFoxAnalyzerTool.this.id);
        }
    }

    private class Factory
    implements FoxSession.IFoxSessionListenerFactory {
        private Factory() {
        }

        public FoxSession.IFoxSessionListener make(FoxConnection conn) {
            if (!(conn instanceof BFoxClientConnection)) {
                return null;
            }
            BFoxSession fSes = ((BFoxClientConnection)conn).getFoxSession();
            if (fSes == null) {
                return null;
            }
            if (fSes.getStationName() == null) {
                return null;
            }
            if (!BWbFoxAnalyzerTool.this.stationNameFilter.accept(fSes.getStationName())) {
                return null;
            }
            return BWbFoxAnalyzerTool.this.listener;
        }
    }
}

