/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.util;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.text.DecimalFormat;

public final class JavaScriptMinifier {
    private static IMinificationEngine defaultEngine;
    private static final DecimalFormat DOUBLE_FORMAT;

    public static void minify(File inFile) throws Exception {
        JavaScriptMinifier.minify(inFile, JavaScriptMinifier.getDefaultEngine());
    }

    public static void minify(File inFile, IMinificationEngine engine) throws Exception {
        if (!inFile.exists()) {
            throw new IOException("Input file does not exist: " + inFile);
        }
        if (!inFile.isDirectory()) {
            if (inFile.getName().endsWith(".js") && !inFile.getName().endsWith(".min.js")) {
                File minDir = new File(inFile.getParentFile(), "min");
                if (!minDir.exists()) {
                    minDir.mkdirs();
                }
                File outFile = new File(minDir, inFile.getName().replaceAll(".js", ".min.js"));
                JavaScriptMinifier.minify(inFile, outFile, engine);
            }
        } else {
            File[] files = inFile.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    JavaScriptMinifier.minify(files[i], engine);
                }
            }
        }
    }

    public static void minify(File inFile, File outFile) throws Exception {
        JavaScriptMinifier.minify(new File[]{inFile}, outFile, JavaScriptMinifier.getDefaultEngine());
    }

    public static void minify(File inFile, File outFile, IMinificationEngine engine) throws Exception {
        JavaScriptMinifier.minify(new File[]{inFile}, outFile, engine);
    }

    public static void minify(File[] inFiles, File outFile) throws Exception {
        JavaScriptMinifier.minify(inFiles, outFile, JavaScriptMinifier.getDefaultEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void minify(File[] inFiles, File outFile, IMinificationEngine engine) throws Exception {
        if (inFiles.length == 0) {
            throw new IllegalArgumentException("Must specify JavaScript input files!");
        }
        System.out.println();
        for (int i = 0; i < inFiles.length; ++i) {
            System.out.println("Minifying: " + inFiles[i]);
            if (inFiles[i].exists()) continue;
            throw new IOException("Input file does not exist: " + inFiles[i]);
        }
        System.out.println("Output File: " + outFile);
        TraceInputStream in = null;
        TraceOutputStream out = null;
        try {
            File parent;
            in = new TraceInputStream(JavaScriptMinifier.createInputStream(inFiles));
            if (outFile.exists()) {
                outFile.delete();
            }
            if ((parent = outFile.getParentFile()) != null) {
                parent.mkdirs();
            }
            outFile.createNewFile();
            out = new TraceOutputStream(new FileOutputStream(outFile));
            engine.minify(in, out);
            out.flush();
            double sizeOfInput = in.getByteCount() / 1024.0;
            double sizeOfOutput = out.getByteCount() / 1024.0;
            double compression = 100.0 - out.getByteCount() / in.getByteCount() * 100.0;
            System.out.println("\nSize of input:  " + JavaScriptMinifier.formatDouble(sizeOfInput) + " kb");
            System.out.println("Size of output: " + JavaScriptMinifier.formatDouble(sizeOfOutput) + " kb");
            System.out.println("Compression: " + JavaScriptMinifier.formatDouble(compression) + " %\n");
            System.out.println("*** Minification Successfully Completed ***");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String formatDouble(double val) {
        return DOUBLE_FORMAT.format(val);
    }

    private static InputStream createInputStream(File[] files) throws Exception {
        InputStream result = new FileInputStream(files[0]);
        if (files.length > 1) {
            for (int i = 1; i < files.length; ++i) {
                result = new SequenceInputStream(result, new FileInputStream(files[i]));
            }
        }
        return result;
    }

    private static String post(URL url, String outStr) throws Exception {
        int length = outStr.getBytes().length;
        System.out.println("Sending number of bytes: " + length);
        System.out.println("Please wait while Web Service is invoked...");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(true);
        conn.addRequestProperty("content-type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("content-length", String.valueOf(length));
        conn.setRequestMethod("POST");
        OutputStream out = conn.getOutputStream();
        out.write(outStr.getBytes(), 0, length);
        out.flush();
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringWriter strWriter = new StringWriter();
        InputStream in = conn.getInputStream();
        try {
            int r = in.read();
            while (r > -1) {
                strWriter.write(r);
                r = in.read();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.out.println("responseCode=" + conn.getResponseCode());
            if (conn.getResponseCode() / 100 != 2) {
                throw new IOException(conn.getResponseMessage());
            }
            throw x;
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWriter.toString().trim();
    }

    public static synchronized IMinificationEngine getDefaultEngine() {
        if (defaultEngine == null) {
            defaultEngine = new GoogleClosure();
        }
        return defaultEngine;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Please specify a JS file or directory to start minification");
        }
        try {
            JavaScriptMinifier.minify(new File(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        DOUBLE_FORMAT = new DecimalFormat("0.00");
    }

    private static final class TraceOutputStream
    extends OutputStream {
        private double count = 0.0;
        private OutputStream out;

        private TraceOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.count += 1.0;
        }

        public double getByteCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }

    private static final class TraceInputStream
    extends InputStream {
        private double count = 0.0;
        private InputStream in;

        private TraceInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int val = this.in.read();
            if (val > -1) {
                this.count += 1.0;
            }
            return val;
        }

        public double getByteCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.in.close();
        }
    }

    public static final class GoogleClosureWebService
    implements IMinificationEngine {
        @Override
        public void minify(InputStream in, OutputStream out) throws Exception {
            System.out.println("*** Making Google Closure Web Service Call ***");
            StringBuilder js = new StringBuilder();
            int r = in.read();
            while (r > -1) {
                js.append((char)r);
                r = in.read();
            }
            StringBuilder args = new StringBuilder();
            args.append("js_code=");
            args.append(URLEncoder.encode(js.toString(), "UTF-8"));
            String compilationLevel = "SIMPLE_OPTIMIZATIONS";
            args.append("&compilation_level=").append(compilationLevel);
            args.append("&output_format=json");
            args.append("&output_info=compiled_code");
            args.append("&output_info=warnings");
            args.append("&output_info=errors");
            args.append("&output_info=statistics");
            String res = JavaScriptMinifier.post(new URL("http://closure-compiler.appspot.com/compile"), args.toString());
            System.out.println("Received number of bytes: " + res.length());
            JSONObject obj = new JSONObject(new JSONTokener(res));
            if (obj.has("errors")) {
                System.out.println("Detected Errors...");
                System.out.println(obj.getJSONArray("errors").toString(2));
            }
            if (obj.has("warnings")) {
                System.out.println("Detected Warnings...");
                System.out.println(obj.getJSONArray("warnings").toString(2));
            }
            if (obj.has("serverErrors")) {
                System.out.println("Detected Server Errors...");
                System.out.println(obj.getJSONArray("serverErrors").toString(2));
            }
            if (obj.has("statistics")) {
                System.out.println("Compilation Statistics");
                System.out.println(obj.getJSONObject("statistics").toString(2));
            }
            out.write(JSONUtil.getString((JSONObject)obj, (String)"compiledCode").getBytes("UTF-8"));
        }
    }

    public static final class GoogleClosure
    implements IMinificationEngine {
        private File bajaHome;
        private static URLClassLoader cachedGoogleClosureClassLoader;

        public GoogleClosure() {
            String bajaPath = System.getProperty("niagara.home");
            if (bajaPath == null) {
                throw new RuntimeException("Missing system property \"niagara.home\".  Has initEnv() been called?");
            }
            this.bajaHome = new File(bajaPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void minify(InputStream in, OutputStream out) throws Exception {
            System.out.println("*** Starting Google Closure Minification ***");
            String compilationLevel = "SIMPLE_OPTIMIZATIONS";
            Class<GoogleClosure> clazz = GoogleClosure.class;
            synchronized (GoogleClosure.class) {
                if (cachedGoogleClosureClassLoader == null) {
                    URL url = new File(this.bajaHome, "lib/gcCompiler.jar").toURI().toURL();
                    cachedGoogleClosureClassLoader = new URLClassLoader(new URL[]{url});
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                Class<?> compCls = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.Compiler");
                Object compiler = compCls.newInstance();
                Class<?> optionsCls = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.CompilerOptions");
                Object options = optionsCls.newInstance();
                Class<?> levelCls = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.CompilationLevel");
                Object optEnum = levelCls.getDeclaredField(compilationLevel).get(levelCls);
                Method optionsMeth = levelCls.getMethod("setOptionsForCompilationLevel", optionsCls);
                optionsMeth.invoke(optEnum, options);
                Class<?> fileCls = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.JSSourceFile");
                Method fromInputMethod = fileCls.getMethod("fromInputStream", String.class, InputStream.class);
                Object inJsFile = fromInputMethod.invoke(null, "newMinifiedCode.js", in);
                Method fromCode = fileCls.getMethod("fromCode", String.class, String.class);
                Object externJsFile = fromCode.invoke(null, "externs.js", "function alert(x) {}");
                try {
                    Method compileMethod = compCls.getMethod("compile", fileCls, fileCls, optionsCls);
                    compileMethod.invoke(compiler, externJsFile, inJsFile, options);
                    Method toSource = compCls.getMethod("toSource", new Class[0]);
                    String src = (String)toSource.invoke(compiler, new Object[0]);
                    byte[] bytes = src.getBytes("UTF-8");
                    for (int i = 0; i < bytes.length; ++i) {
                        out.write(bytes[i]);
                    }
                }
                finally {
                    try {
                        Method clearCachedSource = fileCls.getMethod("clearCachedSource", new Class[0]);
                        clearCachedSource.invoke(inJsFile, new Object[0]);
                        clearCachedSource.invoke(externJsFile, new Object[0]);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }
    }

    public static interface IMinificationEngine {
        public void minify(InputStream var1, OutputStream var2) throws Exception;
    }
}

