/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.datatypes;

import com.tridium.ndriver.datatypes.BAddress;
import java.net.InetAddress;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BIpAddress
extends BAddress {
    public static final int UNUSED_SESSION_ID = -1;
    public static final Property ipAddress = BIpAddress.newProperty((int)0, (String)"", null);
    public static final Property port = BIpAddress.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)65536), (BFacets)BFacets.make((String)"fieldEditor", (String)"ndriver:IpPortFE")));
    public static final Property sessionId = BIpAddress.newProperty((int)7, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BIpAddress.class);

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public int getSessionId() {
        return this.getInt(sessionId);
    }

    public void setSessionId(int v) {
        this.setInt(sessionId, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIpAddress() {
    }

    public BIpAddress(InetAddress iadr, int port) {
        this.setIpAddress(iadr.getHostAddress());
        this.setPort(port);
    }

    public BIpAddress(String ipAddress, int port) {
        this.setIpAddress(ipAddress);
        this.setPort(port);
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getAddress() {
        return this.getInetAddress();
    }

    @Override
    public boolean sameDevice(BAddress comp) {
        if (!(comp instanceof BIpAddress)) {
            return false;
        }
        return this.getInetAddress().equals(((BIpAddress)comp).getInetAddress());
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getIpAddress()).append(':').append(this.getPort());
        int sid = this.getSessionId();
        if (sid != -1) {
            sb.append("{").append(sid).append("}");
        }
        return sb.toString();
    }

    @Override
    public String toHashString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getInetAddress().getHostAddress()).append(':').append(this.getPort());
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.getIpAddress().length() > 0;
    }

    public boolean sameSessionId(BIpAddress comp) {
        return this.getSessionId() >= 0 && this.getSessionId() == comp.getSessionId();
    }
}

