/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.IFragmentable;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommTimer;
import com.tridium.ndriver.comm.NMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.spy.SpyWriter;

class FragmentManager {
    Hashtable<Object, IFragmentable> hash = new Hashtable(64);
    NCommTimer trnsMgr;
    NComm comm;

    FragmentManager(NComm comm, NCommTimer trnsMgr) {
        this.comm = comm;
        this.trnsMgr = trnsMgr;
    }

    NMessage mergeFragments(IFragmentable frag) throws Exception {
        boolean frgmt = !frag.isFinalFragment();
        Object h = frag.getHash();
        IFragmentable omsg = this.hash.get(h);
        if (omsg == null) {
            if (!frgmt) {
                return (NMessage)((Object)frag);
            }
            this.hash.put(h, frag);
            this.comm.log().fine("receive first fragment " + h);
            this.trnsMgr.startFragTimer(frag);
            return null;
        }
        omsg.merge(frag);
        if (!frgmt) {
            this.hash.remove(h);
            this.trnsMgr.closeFragTimer(frag);
            this.comm.log().fine("receive last fragment " + h);
            return (NMessage)((Object)omsg);
        }
        return null;
    }

    void fragTimeout(IFragmentable v) {
        this.hash.remove(v.getHash());
        this.trnsMgr.closeFragTimer(v);
        String trace = "";
        try {
            trace = ((NMessage)((Object)v)).toTraceString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.comm.log().fine("fragmented message Timeout " + trace);
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(true);
        out.trTitle((Object)"FragmentManager", 2);
        out.w((Object)"<tr>").th((Object)"hash").th((Object)"len").w((Object)"</tr>\n");
        Enumeration<IFragmentable> it = this.hash.elements();
        while (it.hasMoreElements()) {
            IFragmentable c = it.nextElement();
            out.tr(c.getHash(), (Object)Integer.toString(c.size()));
        }
        out.endTable();
    }
}

