/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver;

import com.tridium.ndriver.datatypes.BNWorker;
import com.tridium.ndriver.util.AgentInfoUtil;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

public abstract class BNNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property tuningPolicies = BNNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property async = BNNetwork.newProperty((int)4, (BValue)new BNWorker(), null);
    public static final Type TYPE = Sys.loadType(BNNetwork.class);
    private Logger log = null;
    public static final BFacets noWriteFacet = BFacets.make((String)"noWrite", (boolean)true);
    public static final BFacets groupFacet = BFacets.make((String)"group", (boolean)true);
    public static final Context noWrite = new BasicContext((Context)noWriteFacet){

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Context && ((Context)obj).getFacets().getb("noWrite", false);
        }

        public String toString() {
            return "NDriver.noWrite";
        }
    };
    public static final Context groupWrite = new BasicContext((Context)BFacets.make((BFacets)noWriteFacet, (BFacets)groupFacet)){

        public String toString() {
            return "NDriver.groupWrite";
        }
    };
    public static final Context groupWriteFinal = new BasicContext((Context)groupFacet){

        public String toString() {
            return "NDriver.groupWriteFinal";
        }
    };

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    public BNWorker getAsync() {
        return (BNWorker)this.get(async);
    }

    public void setAsync(BNWorker v) {
        this.set(async, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract String getNetworkName();

    public IFuture postAsync(Runnable r) {
        this.getAsync().post(r);
        return null;
    }

    public AgentList getAgents(Context cx) {
        return AgentInfoUtil.processDeviceManagerAgents(super.getAgents(cx), this.useAutoManager(), this.getType().getTypeInfo().getModuleName());
    }

    protected boolean useAutoManager() {
        return true;
    }

    public int getDeviceManagerSubscribeDepth() {
        return 1;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() throws Exception {
        this.updateStatus();
    }

    public void serviceStopped() throws Exception {
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        this.getAsync().spy(out);
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getNetworkName());
        }
        return this.log;
    }
}

