/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable.ui;

import com.tridium.query.BProjCol;
import com.tridium.query.expression.BField;
import com.tridium.queryTable.BQueryTable;
import com.tridium.queryTable.QueryUtil;
import com.tridium.queryTable.TypeSpecPath;
import com.tridium.queryTable.ui.BEqualPane;
import com.tridium.queryTable.ui.BQueryColumnTable;
import com.tridium.queryTable.ui.BQueryTableOptions;
import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BWbQueryConfig
extends BWbComponentView {
    public static final Action rowTypeChanged = BWbQueryConfig.newAction((int)4, null);
    public static final Action fromTypeChanged = BWbQueryConfig.newAction((int)4, null);
    public static final Action fromPropChanged = BWbQueryConfig.newAction((int)4, null);
    public static final Action linkedPropChanged = BWbQueryConfig.newAction((int)4, null);
    public static final Action handleSetModified = BWbQueryConfig.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BWbQueryConfig.class);
    public static final int PNAME = 0;
    public static final int ALIAS = 1;
    public static final int ON = 2;
    private boolean saveToOptions;
    private BSplitPane split;
    private BQueryColumnTable columnTable;
    private ColumnModel columnModel;
    private BWbFieldEditor rowTypeChoice;
    private BList fromList;
    private BList fromPropList;
    private BList linkedPropList;
    private BLink setModifiedLink;
    private Command addCmd;
    private Command defaultColumns;

    public void rowTypeChanged() {
        this.invoke(rowTypeChanged, null, null);
    }

    public void fromTypeChanged() {
        this.invoke(fromTypeChanged, null, null);
    }

    public void fromPropChanged() {
        this.invoke(fromPropChanged, null, null);
    }

    public void linkedPropChanged() {
        this.invoke(linkedPropChanged, null, null);
    }

    public void handleSetModified() {
        this.invoke(handleSetModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject o, Context cx) {
        BQueryTable queryTable = (BQueryTable)o;
        BQuery query = queryTable.getQuery();
        if (!query.hasExtent()) {
            query.from((BExtent)new BSingleExtent(BComponent.TYPE));
        }
        BQuery working = QueryUtil.getWorkingCopy(query, cx);
        this.split = new BSplitPane(BOrientation.vertical, 50.0);
        this.columnTable = this.makeColumnTable(working, cx);
        this.linkTo((BComponent)this.columnTable, (Slot)BTable.tableModified, (Slot)setModified);
        BTitlePane propertyPane = BTitlePane.makePane((String)"Columns", (BTable)this.columnTable, (String)"columns");
        this.split.setWidget1((BWidget)propertyPane);
        BEdgePane builder = new BEdgePane();
        BGridPane rowTypeHeader = new BGridPane(2);
        rowTypeHeader.setHalign(BHalign.left);
        rowTypeHeader.add("label", (BValue)new BLabel("Row Type"));
        this.rowTypeChoice = this.buildRowTypeChoice(working, cx);
        this.linkTo((BComponent)this.rowTypeChoice, (Slot)BWbFieldEditor.setModified, (Slot)rowTypeChanged);
        this.linkTo((BComponent)this.rowTypeChoice, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
        rowTypeHeader.add("choice", (BValue)this.rowTypeChoice);
        builder.setTop((BWidget)new BBorderPane((BWidget)rowTypeHeader, BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)2.0)));
        BEqualPane propQueryor = new BEqualPane();
        this.fromList = this.buildFromList();
        propQueryor.add("from", (BValue)new BTitlePane("From", (BWidget)this.fromList));
        this.linkTo((BComponent)this.fromList, (Slot)BList.selectionModified, (Slot)fromTypeChanged);
        this.fromPropList = this.buildFromPropList();
        propQueryor.add("fromProps", (BValue)new BTitlePane("Property", (BWidget)this.fromPropList));
        this.linkTo((BComponent)this.fromPropList, (Slot)BList.selectionModified, (Slot)fromPropChanged);
        this.linkedPropList = this.buildLinkedPropList();
        propQueryor.add("linkedProps", (BValue)new BTitlePane("Linked Property", (BWidget)this.linkedPropList));
        this.linkTo((BComponent)this.linkedPropList, (Slot)BList.selectionModified, (Slot)linkedPropChanged);
        this.setModifiedLink = this.linkTo((BComponent)this, (Slot)setModified, (Slot)handleSetModified);
        builder.setCenter((BWidget)propQueryor);
        BGridPane buttons = new BGridPane(2);
        this.addCmd = new AddColumn();
        BButton addButton = new BButton(this.addCmd, true, true);
        buttons.add("add", (BValue)addButton);
        this.defaultColumns = new DefaultColumnsCommand();
        BButton defaultColumnsButton = new BButton(this.defaultColumns, true, true);
        buttons.add("defaultColumns", (BValue)defaultColumnsButton);
        builder.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0)));
        this.split.setWidget2((BWidget)builder);
        this.setContent((BWidget)this.split);
        this.rowTypeChanged();
        BQueryTableOptions options = BQueryTableOptions.make();
        this.saveToOptions = options.getProjection(((BQueryTable)this.getCurrentValue()).getQuery(), this.getCurrentContext()) != null;
    }

    public BObject doSaveValue(BObject o, Context cx) throws Exception {
        Lexicon lex;
        int dialogResult;
        BQueryTable queryTable = (BQueryTable)o;
        BQuery result = queryTable.getQuery();
        result.lease(4);
        Context tx = cx;
        BTypeSpec typeSpec = (BTypeSpec)this.rowTypeChoice.saveValue();
        BSingleExtent extent = (BSingleExtent)result.getExtent();
        extent.setBaseExtent(typeSpec);
        BQuery copy = QueryUtil.makeQuery(typeSpec);
        BProjection projection = copy.getProjection();
        ArrayList<Property> toRemove = new ArrayList<Property>(16);
        SlotCursor c = projection.getProperties();
        while (c.next(BProjCol.class)) {
            toRemove.add(c.property());
        }
        for (Property prop : toRemove) {
            projection.remove(prop, tx);
        }
        BProjCol[] cols = this.columnModel.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            String escape = TextUtil.fromFriendly((String)cols[i].getAlias());
            projection.add(escape, cols[i].newCopy(true));
        }
        QueryUtil.addHiddenColumns(copy);
        BQueryTableOptions options = BQueryTableOptions.make();
        if (QueryUtil.isDefaultProjection(copy)) {
            options.removeProjection(copy);
            if (result.get("projection") != null) {
                result.remove("projection");
            }
            return result;
        }
        BProjectionColumn[] newColumns = (BProjectionColumn[])projection.getChildren(BProjectionColumn.class);
        if (this.saveToOptions && this.isSuperUser(this.getCurrentContext()) && (dialogResult = BDialog.confirm((BWidget)this, (String)"", (Object)new BLabel((lex = Lexicon.make(BWbQueryConfig.class)).getText("saveColumnsForAllUsersQuestion")), (int)12)) == 4) {
            this.saveToOptions = false;
        }
        if (this.saveToOptions) {
            if (newColumns.length > 0) {
                options.setProjection(copy, projection, this.getCurrentContext());
            } else {
                options.removeProjection(copy);
            }
        } else {
            options.removeProjection(result);
            result.select((BProjection)projection.newCopy(true));
        }
        return result;
    }

    public void doHandleSetModified(Context cx) {
        this.saveToOptions = true;
    }

    public boolean isSuperUser(Context cx) {
        if (cx == null) {
            return false;
        }
        BUser user = cx.getUser();
        if (user != null) {
            return user.getPermissions().isSuperUser();
        }
        if (cx instanceof BFacets) {
            BFacets facets = (BFacets)cx;
            String username = facets.gets("username", null);
            BISession isession = this.getCurrentValueSession();
            try {
                BUserService userService = (BUserService)BOrd.make((String)"station:|service:baja:UserService").get((BObject)isession);
                userService.loadSlots();
                user = userService.getUser(username);
                user.loadSlots();
                return user.getPermissions().isSuperUser();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void addColumn() {
        this.addCmd.invoke();
    }

    private BQueryColumnTable makeColumnTable(BQuery query, Context cx) {
        this.columnModel = new ColumnModel(query);
        query.getProjection().lease();
        SlotCursor c = query.getProjection().getProperties();
        while (c.next(BProjCol.class)) {
            BProjCol col = (BProjCol)c.get();
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)col.getPropertyInParent())) continue;
            this.columnModel.addColumn((BProjCol)col.newCopy(true));
        }
        BQueryColumnTable t = new BQueryColumnTable(this.columnModel);
        t.setSelection(new ColumnSelection());
        return t;
    }

    private BWbFieldEditor buildRowTypeChoice(BQuery query, Context cx) {
        BTypeSpec typeSpec = BTypeSpec.make((String)"baja:Component");
        BWbFieldEditor typeSpecEd = BWbFieldEditor.makeFor((BObject)BTypeSpec.DEFAULT);
        BExtent extent = query.getExtent();
        if (extent != null && Flags.isReadonly((BComplex)query, (Slot)extent.getPropertyInParent())) {
            typeSpecEd.setReadonly(true);
        }
        try {
            if (query.getExtent() != null) {
                query.getExtent().lease();
                typeSpec = ((BSingleExtent)query.getExtent()).getBaseExtent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        typeSpecEd.loadValue((BObject)typeSpec, (Context)BFacets.make((String)"showAbstract", (boolean)true));
        return typeSpecEd;
    }

    public void doRowTypeChanged() {
        try {
            this.updateFromList((BTypeSpec)this.rowTypeChoice.saveValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BList buildFromList() {
        BList fromList = new BList();
        fromList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                return super.getItemText(item);
            }
        });
        return fromList;
    }

    private void updateFromList(BTypeSpec typeSpec) {
        this.fromList.removeAllItems();
        this.fromList.getSelection().deselectAll();
        if (typeSpec == null) {
            return;
        }
        this.fromList.addItem((Object)typeSpec);
        this.fromList.addItem((Object)"columns");
    }

    public void doFromTypeChanged() {
        this.updateFromPropList(this.fromList.getSelectedItem());
    }

    private BList buildFromPropList() {
        BList fromPropList = new BList();
        fromPropList.setController((ListController)new LController());
        fromPropList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                return item.value.toString();
            }
        });
        return fromPropList;
    }

    private void updateFromPropList(Object queryion) {
        block5: {
            block4: {
                this.fromPropList.removeAllItems();
                this.fromPropList.getSelection().deselectAll();
                if (queryion == null) {
                    return;
                }
                if (!(queryion instanceof BTypeSpec)) break block4;
                BTypeSpec typeSpec = (BTypeSpec)queryion;
                if (typeSpec.getResolvedType().isAbstract()) {
                    return;
                }
                Property[] props = ((BComponent)typeSpec.getInstance()).getPropertiesArray();
                for (int i = 0; i < props.length; ++i) {
                    TypeSpecPath tsp = new TypeSpecPath(props[i].getType().getTypeSpec(), props[i].getName());
                    this.fromPropList.addItem((Object)tsp);
                }
                break block5;
            }
            if (!queryion.toString().equals("columns")) break block5;
            TypeSpecPath[] standard = QueryUtil.getStandardColumns();
            for (int i = 0; i < standard.length; ++i) {
                this.fromPropList.addItem((Object)standard[i]);
            }
        }
    }

    public void doFromPropChanged() {
        this.updateLinkedPropList(this.fromPropList.getSelectedItem());
    }

    private BList buildLinkedPropList() {
        BList linkedPropList = new BList();
        linkedPropList.setController((ListController)new LController());
        linkedPropList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                return item.value.toString();
            }
        });
        return linkedPropList;
    }

    private void updateLinkedPropList(Object fromPropType) {
        this.linkedPropList.removeAllItems();
        this.linkedPropList.getSelection().deselectAll();
        if (fromPropType == null) {
            return;
        }
        TypeSpecPath typeSpecPath = (TypeSpecPath)fromPropType;
        BObject o = typeSpecPath.typeSpec.getInstance();
        if (o instanceof BSimple) {
            return;
        }
        BComplex c = (BComplex)o;
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            TypeSpecPath tsp = new TypeSpecPath(props[i].getType().getTypeSpec(), typeSpecPath.path + "." + props[i].getName());
            this.linkedPropList.addItem((Object)tsp);
        }
    }

    public void doLinkedPropChanged() {
    }

    private class LController
    extends ListController {
        private LController() {
        }

        protected void itemDoubleClicked(BMouseEvent event, int index) {
            BWbQueryConfig.this.addColumn();
        }
    }

    private class ColumnSelection
    extends TableSelection {
        private ColumnSelection() {
        }

        public void updateTable() {
            this.getTable().setDeleteEnabled(!this.isEmpty());
            super.updateTable();
        }
    }

    class ColumnModel
    extends TableModel {
        private BQuery query;
        private List<BProjCol> visibleColumns = new ArrayList<BProjCol>();
        private List<BProjCol> allColumns = new ArrayList<BProjCol>();

        public ColumnModel(BQuery query) {
            this.query = query;
        }

        public void addColumn(BProjCol newColumn) {
            this.visibleColumns.add(newColumn);
            this.allColumns.add(newColumn);
            this.updateTable();
        }

        public BProjCol getExisting(BProjCol column) {
            for (int i = 0; i < this.allColumns.size(); ++i) {
                BProjCol existing = this.allColumns.get(i);
                if (!existing.equivalent((Object)column)) continue;
                return existing;
            }
            return null;
        }

        public boolean exists(BProjCol column) {
            return this.getExisting(column) != null;
        }

        public void defaultColumns() throws Exception {
            this.visibleColumns.clear();
            this.allColumns.clear();
            BTypeSpec typeSpec = (BTypeSpec)BWbQueryConfig.this.rowTypeChoice.saveValue();
            BQuery working = this.query;
            if (!QueryUtil.getRowType(working).equals((Object)typeSpec)) {
                working = (BQuery)this.query.newCopy(true);
                ((BSingleExtent)working.getExtent()).setBaseExtent(typeSpec);
            }
            TypeSpecPath[] columns = QueryUtil.getDefaultColumns(working);
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].path.equals("in")) continue;
                BProjCol projCol = QueryUtil.makeColumn(this.query, columns[i]);
                this.allColumns.add(projCol);
                this.visibleColumns.add(projCol);
            }
            this.updateTable();
        }

        public void deleteSelection() {
            int i;
            int[] queryion = this.getSelection().getRows();
            BProjCol[] toDelete = new BProjCol[queryion.length];
            for (i = 0; i < queryion.length; ++i) {
                toDelete[i] = (BProjCol)this.getSubject(queryion[i]);
            }
            for (i = 0; i < toDelete.length; ++i) {
                this.visibleColumns.remove(toDelete[i]);
                this.allColumns.remove(toDelete[i]);
                BWbQueryConfig.this.setModified();
            }
            this.getSelection().deselectAll();
        }

        public Object getSubject(int row) {
            return this.visibleColumns.get(row);
        }

        public BProjCol[] getColumns() {
            return this.allColumns.toArray(new BProjCol[this.allColumns.size()]);
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Display Name";
                }
                case 2: {
                    return "Column Type";
                }
            }
            return "Error-" + col;
        }

        public int getRowCount() {
            return this.visibleColumns.size();
        }

        public Object getValueAt(int row, int col) {
            BProjCol c = this.visibleColumns.get(row);
            switch (col) {
                case 0: {
                    return QueryUtil.getColumnName((BProjectionColumn)c);
                }
                case 1: {
                    return c.getAlias();
                }
                case 2: {
                    BTypeSpec typeSpec = (BTypeSpec)c.get("typeSpec");
                    if (typeSpec != null) {
                        return typeSpec;
                    }
                    return BTypeSpec.make((String)"baja:String");
                }
            }
            return "Error-" + row + "x" + col;
        }
    }

    private class AddColumn
    extends Command {
        public AddColumn() {
            super((BWidget)BWbQueryConfig.this, TYPE.getModule(), "command.addColumn");
        }

        public CommandArtifact doInvoke() {
            Object from = BWbQueryConfig.this.fromList.getSelectedItem();
            TypeSpecPath fromTypeProp = (TypeSpecPath)BWbQueryConfig.this.fromPropList.getSelectedItem();
            TypeSpecPath linkedProp = (TypeSpecPath)BWbQueryConfig.this.linkedPropList.getSelectedItem();
            if (from == null || fromTypeProp == null) {
                return null;
            }
            BTypeSpec typeSpec = fromTypeProp.typeSpec;
            String columnName = fromTypeProp.path;
            if (linkedProp != null) {
                columnName = linkedProp.path;
                typeSpec = linkedProp.typeSpec;
            }
            String displayName = TextUtil.toFriendly((String)columnName);
            BProjCol col = new BProjCol((BExpression)new BField(columnName));
            col.setAlias(displayName);
            col.add("typeSpec", (BValue)typeSpec);
            if (!BWbQueryConfig.this.columnModel.exists(col)) {
                BWbQueryConfig.this.columnModel.addColumn(col);
            }
            return null;
        }
    }

    private class DefaultColumnsCommand
    extends Command {
        public DefaultColumnsCommand() {
            super((BWidget)BWbQueryConfig.this, TYPE.getModule(), "command.defaultColumns");
        }

        public CommandArtifact doInvoke() throws Exception {
            BQueryTable queryTable = (BQueryTable)BWbQueryConfig.this.getCurrentValue();
            BQuery query = queryTable.getQuery();
            if (BWbQueryConfig.this.isSuperUser(BWbQueryConfig.this.getCurrentContext())) {
                BWbQueryConfig.this.columnModel.defaultColumns();
            } else {
                BQueryTableOptions options = BQueryTableOptions.make();
                options.removeProjection(query);
                BWbQueryConfig.this.loadValue((BObject)queryTable, BWbQueryConfig.this.getCurrentContext());
            }
            BWbQueryConfig.this.saveToOptions = false;
            ((BWbShell)this.getShell()).getSaveCommand().invoke();
            BWbQueryConfig.this.loadValue((BObject)queryTable, BWbQueryConfig.this.getCurrentContext());
            return null;
        }
    }
}

