/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.manifest;

import com.tridium.install.BDependency;
import com.tridium.template.BTemplateState;
import com.tridium.template.manifest.TemplateManifest;
import java.io.File;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaException;
import javax.baja.util.BUuid;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class ManifestXMLReader {
    XParser parser;
    BIFile file;
    TemplateManifest tplMnfst;

    public static TemplateManifest decode(BOrd ord) {
        return ManifestXMLReader.decode((BIFile)ord.resolve().get());
    }

    public static TemplateManifest decode(File file) {
        BOrd ord = BOrd.make((String)("file:/" + file.getAbsolutePath().replace('\\', '/')));
        try {
            return ManifestXMLReader.decode(ord);
        }
        catch (XException xe) {
            throw new XException("XML Parsing Error in Ord: " + ord + " - " + xe.toString());
        }
    }

    public static TemplateManifest decode(BIFile file) {
        try {
            InputStream ins = file.getInputStream();
            ManifestXMLReader rdr = new ManifestXMLReader(XParser.make((InputStream)ins), file);
            return rdr.decode();
        }
        catch (XException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot access " + file.getNavOrd().toString(null) + "\n" + e);
        }
    }

    private ManifestXMLReader(XParser p, BIFile file) {
        this.parser = p;
        this.file = file;
        this.tplMnfst = new TemplateManifest();
    }

    private TemplateManifest decode() throws Exception {
        XElem root = this.parser.parse();
        if (!root.name().equals("template")) {
            throw new BajaException("Root element must be <template>");
        }
        this.parseVersion(root);
        block24: for (int i = 0; i < root.contentSize(); ++i) {
            String name;
            XElem xelem = root.elem(i);
            switch (name = xelem.name()) {
                case "info": {
                    this.tplMnfst.info = xelem.get("i", "");
                    continue block24;
                }
                case "settings": {
                    this.getValues(this.tplMnfst.settings, xelem);
                    continue block24;
                }
                case "links": {
                    this.getValues(this.tplMnfst.links, xelem);
                    continue block24;
                }
                case "bindings": {
                    this.getValues(this.tplMnfst.bindings, xelem);
                    continue block24;
                }
                case "resources": {
                    this.getResources(xelem);
                    continue block24;
                }
                case "subtemplates": {
                    this.getSubtemplates(xelem);
                    continue block24;
                }
                case "tags": {
                    this.getTags(xelem);
                    continue block24;
                }
                case "dependencies": {
                    this.getDependencies(xelem);
                    continue block24;
                }
                case "revisions": {
                    this.getRevisions(xelem);
                    continue block24;
                }
                case "optionals": {
                    this.getOptionals(xelem);
                }
            }
        }
        this.parser.close();
        return this.tplMnfst;
    }

    private void parseVersion(XElem xelem) {
        try {
            this.tplMnfst.uID = BUuid.make((String)xelem.get("id"));
        }
        catch (XException xe) {
            this.tplMnfst.uID = BUuid.make();
        }
        this.tplMnfst.title = xelem.get("title", "");
        this.tplMnfst.version = xelem.get("version", "1.0");
        this.tplMnfst.vendor = xelem.get("vendor", "");
        this.tplMnfst.description = xelem.get("description", "");
        this.tplMnfst.info = xelem.get("info", "");
        this.tplMnfst.buildVersion = xelem.get("buildVersion", "");
        this.tplMnfst.bogSignature = xelem.get("signature", "0");
        this.tplMnfst.isApplication = xelem.getb("isApplication", false);
        this.tplMnfst.isStation = xelem.getb("isStation", false);
        try {
            this.tplMnfst.state = BTemplateState.make(xelem.geti("state"));
        }
        catch (XException e) {
            this.tplMnfst.state = BTemplateState.DEFAULT;
        }
    }

    private void getValues(Array<TemplateManifest.Value> a, XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            TemplateManifest.Value val = new TemplateManifest.Value();
            val.name = xelem.name();
            val.name = xelem.get("n", val.name);
            val.required = xelem.getb("req", false);
            val.type = xelem.get("typ", "num");
            val.slotPath = xelem.get("slotPath", "/" + val.name);
            String s = xelem.get("units", "");
            boolean bl = val.hasUnit = s.length() > 0;
            if (val.hasUnit) {
                val.unit = s;
            }
            boolean bl2 = val.hasMin = (s = xelem.get("min", "")).length() > 0;
            if (val.hasMin) {
                val.min = Float.valueOf(Float.parseFloat(s));
            }
            boolean bl3 = val.hasMax = (s = xelem.get("max", "")).length() > 0;
            if (val.hasMax) {
                val.max = Float.valueOf(Float.parseFloat(s));
            }
            a.add((Object)val);
        }
    }

    private void getResources(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            TemplateManifest.Resource res = new TemplateManifest.Resource();
            res.name = xelem.name();
            res.name = xelem.get("n", res.name);
            res.type = xelem.get("type", "");
            res.sourceOrd = xelem.get("sourceOrd", "");
            this.tplMnfst.resources.add((Object)res);
        }
    }

    private void getSubtemplates(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            TemplateManifest.Subtemplate st = new TemplateManifest.Subtemplate();
            st.name = xelem.name();
            st.name = xelem.get("n", st.name);
            st.vendor = xelem.get("vendor", "");
            st.version = xelem.get("version", "");
            st.locationOrd = xelem.get("locationOrd", "");
            st.ntplFileOrd = xelem.get("ntplFileOrd", "");
            this.tplMnfst.subtemplates.add((Object)st);
        }
    }

    private void getTags(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            TemplateManifest.Tag tag = new TemplateManifest.Tag();
            tag.name = xelem.name();
            tag.name = xelem.get("n", tag.name);
            this.tplMnfst.tags.add((Object)tag);
        }
    }

    private void getRevisions(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            TemplateManifest.Revision rev = new TemplateManifest.Revision();
            rev.version = xelem.get("v", "");
            rev.description = xelem.get("d", "");
            this.tplMnfst.revisionHistory.add((Object)rev);
        }
    }

    private void getOptionals(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            BOrd opt = BOrd.make((String)xelem.get("ord", ""));
            this.tplMnfst.optional.add((Object)opt);
        }
    }

    private void getDependencies(XElem xl) throws Exception {
        for (int i = 0; i < xl.contentSize(); ++i) {
            XElem xelem = xl.elem(i);
            BDependency dep = BDependency.make((XElem)xelem);
            this.tplMnfst.dependencies.add((Object)dep);
        }
    }

    XException err(String msg, Throwable cause) {
        return new XException(msg, this.parser, cause);
    }

    XException err(String msg) {
        return new XException(msg, this.parser);
    }
}

