/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.job;

import com.tridium.template.application.ApplicationTemplateInstaller;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.application.JobProgressTracker;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="templateFileOrd", type="baja:Ord", defaultValue="BOrd.DEFAULT", flags=1), @NiagaraProperty(name="componentsToBeRemoved", type="baja:OrdList", defaultValue="BOrdList.DEFAULT", flags=1), @NiagaraProperty(name="checkModulesBeforeInstall", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="upgradeMode", type="boolean", defaultValue="false", flags=1)})
public class BInstallApplicationTemplateJob
extends BSimpleJob {
    public static final Property templateFileOrd = BInstallApplicationTemplateJob.newProperty((int)1, (BValue)BOrd.DEFAULT, null);
    public static final Property componentsToBeRemoved = BInstallApplicationTemplateJob.newProperty((int)1, (BValue)BOrdList.DEFAULT, null);
    public static final Property checkModulesBeforeInstall = BInstallApplicationTemplateJob.newProperty((int)1, (boolean)false, null);
    public static final Property upgradeMode = BInstallApplicationTemplateJob.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BInstallApplicationTemplateJob.class);

    public BOrd getTemplateFileOrd() {
        return (BOrd)this.get(templateFileOrd);
    }

    public void setTemplateFileOrd(BOrd v) {
        this.set(templateFileOrd, (BValue)v, null);
    }

    public BOrdList getComponentsToBeRemoved() {
        return (BOrdList)this.get(componentsToBeRemoved);
    }

    public void setComponentsToBeRemoved(BOrdList v) {
        this.set(componentsToBeRemoved, (BValue)v, null);
    }

    public boolean getCheckModulesBeforeInstall() {
        return this.getBoolean(checkModulesBeforeInstall);
    }

    public void setCheckModulesBeforeInstall(boolean v) {
        this.setBoolean(checkModulesBeforeInstall, v, null);
    }

    public boolean getUpgradeMode() {
        return this.getBoolean(upgradeMode);
    }

    public void setUpgradeMode(boolean v) {
        this.setBoolean(upgradeMode, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context cx) throws Exception {
        if (!ApplicationTemplateUtil.isSuperUser(cx)) {
            throw new LocalizableRuntimeException(this.getType().getTypeInfo().getModuleName(), "installApplicationTemplateJob.notASuperUser");
        }
        if (this.getTemplateFileOrd().isNull()) {
            throw new IllegalStateException();
        }
        this.log().start(this.getType().getTypeInfo().getModuleName(), "installApplicationTemplateJob.start", null);
        try (ApplicationTemplateInstaller installer = new ApplicationTemplateInstaller(this.getTemplateFileOrd(), this.getComponentsToBeRemoved(), new JobProgressTracker((BJob)this));){
            if (this.getCheckModulesBeforeInstall() && !installer.checkForCompatibleModules()) {
                throw new LocalizableRuntimeException(this.getType().getTypeInfo().getModuleName(), "installApplicationTemplateJob.compatibility.failed");
            }
            if (this.getUpgradeMode()) {
                installer.upgrade(cx);
            } else {
                installer.install(cx);
            }
        }
        catch (Throwable e) {
            this.log().endFailed(e);
            throw e;
        }
    }
}

