/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.sys.module.BModuleFile;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.TemplateConst;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.NtplUtil;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class TemplateManager {
    private boolean isTemplateMapInitialized = false;
    protected BDirectory templateDir = null;
    BAbsTime tmplLastModified = BAbsTime.DEFAULT;
    protected BDirectory applicationDir = null;
    BAbsTime applLastModified = BAbsTime.DEFAULT;
    BDirectory modDir = null;
    BAbsTime modLastModified = BAbsTime.DEFAULT;
    Hashtable<FilePath, TemplateInfo> tInfo = null;
    Hashtable<FilePath, TemplateInfo> aInfo = null;
    Hashtable<FilePath, TemplateInfo> mInfo = null;
    public static TemplateManager INSTANCE = new TemplateManager();
    public static final Logger log = Logger.getLogger("ntpl");

    public TemplateInfo getTemplate(String templateName, String vendor) {
        this.updateTemplateMap(this.getTemplateDir());
        TemplateInfo thisInfo = this.findTemplate(this.tInfo, templateName, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        this.updateMods();
        thisInfo = this.findTemplate(this.mInfo, templateName, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        this.updateTemplateMap(this.getApplicationDir());
        thisInfo = this.findTemplate(this.aInfo, templateName, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        return null;
    }

    public TemplateInfo getTemplate(BNtplFile templateFile) {
        return templateFile == null ? null : new TemplateInfo(templateFile, templateFile.getLastModified());
    }

    public TemplateInfo getTemplate(BUuid uID, String vendor) {
        this.updateTemplateMap(this.getTemplateDir());
        TemplateInfo thisInfo = this.findTemplate(this.tInfo, uID, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        this.updateMods();
        thisInfo = this.findTemplate(this.mInfo, uID, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        this.updateTemplateMap(this.getApplicationDir());
        thisInfo = this.findTemplate(this.aInfo, uID, vendor);
        if (thisInfo != null) {
            return thisInfo;
        }
        return null;
    }

    public TemplateInfo[] getTemplatesForType(Type typ) {
        Array a = new Array(TemplateInfo.class);
        this.updateTemplateMap(this.getTemplateDir());
        if (this.tInfo != null) {
            this.addNtpls(typ, this.tInfo, (Array<TemplateInfo>)a);
        }
        this.updateMods();
        if (this.mInfo != null) {
            this.addNtpls(typ, this.mInfo, (Array<TemplateInfo>)a);
        }
        this.updateTemplateMap(this.getApplicationDir());
        if (this.aInfo != null) {
            this.addNtpls(typ, this.aInfo, (Array<TemplateInfo>)a);
        }
        return (TemplateInfo[])a.trim();
    }

    public void initTemplateMap() {
        this.updateTemplateMap(this.getTemplateDir());
        this.isTemplateMapInitialized = true;
    }

    private void updateTemplateMap(BDirectory templateDir) {
        if (this.isTemplateMapInitialized) {
            return;
        }
        try {
            this.updateTpls(templateDir);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot get template:" + e.getLocalizedMessage(), e);
        }
    }

    private TemplateInfo findTemplate(Hashtable<FilePath, TemplateInfo> infoTable, BUuid uID, String vendor) {
        if (infoTable != null) {
            Enumeration<TemplateInfo> templateInfos = infoTable.elements();
            while (templateInfos.hasMoreElements()) {
                TemplateInfo thisInfo = templateInfos.nextElement();
                if (!thisInfo.getUid().equals((Object)uID) || !thisInfo.getVendor().equals(vendor)) continue;
                return thisInfo;
            }
        }
        return null;
    }

    private TemplateInfo findTemplate(Hashtable<FilePath, TemplateInfo> infoTable, String templateName, String vendor) {
        if (infoTable != null) {
            Enumeration<TemplateInfo> templateInfos = infoTable.elements();
            while (templateInfos.hasMoreElements()) {
                TemplateInfo thisInfo = templateInfos.nextElement();
                if (!thisInfo.getName().equals(templateName) || !thisInfo.getVendor().equals(vendor)) continue;
                return thisInfo;
            }
        }
        return null;
    }

    private void addNtpls(Type typ, Hashtable<FilePath, TemplateInfo> ht, Array<TemplateInfo> a) {
        Iterator<FilePath> it = ht.keySet().iterator();
        while (it.hasNext()) {
            TemplateInfo ti = ht.get(it.next());
            if (!ti.rootType.is(typ)) continue;
            a.add((Object)ti);
        }
    }

    private void updateTpls(BDirectory tmplDir) {
        if (tmplDir == null) {
            this.tInfo = null;
            return;
        }
        BAbsTime tLstMod = tmplDir.getLastModified();
        Hashtable<FilePath, TemplateInfo> ht = new Hashtable<FilePath, TemplateInfo>();
        if (this.getApplicationDir().equals((Object)tmplDir)) {
            this.addNtpls(this.aInfo, ht, tmplDir.listFiles());
            this.aInfo = ht;
            this.applLastModified = tLstMod;
            return;
        }
        this.addNtpls(this.tInfo, ht, tmplDir.listFiles());
        this.tInfo = ht;
        this.tmplLastModified = tLstMod;
    }

    private void addNtpls(Hashtable<FilePath, TemplateInfo> origHt, Hashtable<FilePath, TemplateInfo> ht, BIFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            try {
                if (!(files[i] instanceof BNtplFile)) continue;
                BNtplFile f = (BNtplFile)files[i];
                TemplateInfo ti = null;
                FilePath fp = f.getFilePath();
                if (origHt != null) {
                    ti = origHt.get(fp);
                }
                BAbsTime lstMod = f.getLastModified();
                if (ti == null || ti.lastModified == null || ti.lastModified.isBefore(lstMod)) {
                    try {
                        ti = new TemplateInfo(f, lstMod);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Cannot load template " + f.getFileName() + ":" + e.getLocalizedMessage(), e);
                        if (!f.isOpen()) continue;
                        try {
                            f.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                ht.put(fp, ti);
                if (!f.isOpen()) continue;
                try {
                    f.close();
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error adding NTPL files:" + e.getLocalizedMessage(), e);
            }
        }
    }

    public void modsChanged() {
        this.modLastModified = BAbsTime.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMods() {
        BIFile[] mods;
        BDirectory mdDir = this.getModuleDir();
        if (mdDir == null) {
            return;
        }
        BAbsTime tLstMod = mdDir.getLastModified();
        if (!tLstMod.isAfter(this.modLastModified)) {
            return;
        }
        Hashtable<FilePath, TemplateInfo> ht = new Hashtable<FilePath, TemplateInfo>();
        for (BIFile mod : mods = mdDir.listFiles()) {
            if (!(mod instanceof BModuleFile)) continue;
            BModuleFile mf = (BModuleFile)mod;
            try {
                BSpace space = mf.open();
                try {
                    BIFile[] fa = ((BZipSpace)space).listFiles();
                    this.addNtpls(this.mInfo, ht, fa);
                }
                finally {
                    mf.close();
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error loading templates in module " + mf.getFileName(), e);
            }
        }
        this.mInfo = ht;
        this.modLastModified = tLstMod;
    }

    protected BDirectory getTemplateDir() {
        if (this.templateDir == null) {
            this.templateDir = AccessController.doPrivileged(() -> NtplUtil.getTemplateDirectory());
        }
        return this.templateDir;
    }

    private BDirectory getModuleDir() {
        if (this.modDir == null) {
            BOrd modOrd = BOrd.make((OrdQuery)TemplateConst.TEMPLATE_MODULE_DIR);
            try {
                this.modDir = (BDirectory)modOrd.resolve().get();
            }
            catch (Exception e) {
                this.modDir = null;
            }
        }
        return this.modDir;
    }

    protected BDirectory getApplicationDir() {
        if (this.applicationDir == null) {
            this.applicationDir = AccessController.doPrivileged(() -> NtplUtil.getApplicationDirectory());
        }
        return this.applicationDir;
    }

    public static class TemplateInfo {
        FilePath fp;
        BOrd ntpFileOrd;
        BAbsTime lastModified;
        BAbsTime versionDate;
        Type rootType;
        String name;
        String vendor;
        String version;
        BUuid uID;
        String description;

        public TemplateInfo(BNtplFile file, BAbsTime lastModified) {
            String[] names;
            OrdQuery q;
            BComponent base = file.getBaseComponent();
            BTemplateConfig config = BTemplateConfig.getConfigForRoot(base);
            this.setFilePath(file.getFilePath());
            this.setNtpFileOrd(file.getOrdInHost());
            this.setLastModified(config == null || BAbsTime.NULL.equals((Object)config.getVersionDate()) ? lastModified : config.getVersionDate());
            this.setRootType(base.getType());
            this.setVendor(file.getVendor());
            this.setVersion(file.getVersion());
            this.setDescription(file.getDescription());
            this.setUID(file.getUID());
            String pickName = file.getTitle();
            OrdQuery[] a = file.getOrdInSpace().parse();
            if (a.length > 1 && (q = a[a.length - 2]) instanceof FilePath && (names = ((FilePath)q).getNames()).length > 1 && names[0].equals("modules")) {
                String modNm = names[1];
                pickName = modNm.substring(0, modNm.indexOf(".")) + "/" + pickName;
            }
            this.setName(pickName);
        }

        public void setFilePath(FilePath fp) {
            this.fp = fp;
        }

        public void setNtpFileOrd(BOrd ntpFileOrd) {
            this.ntpFileOrd = ntpFileOrd;
        }

        public void setLastModified(BAbsTime lastModified) {
            this.lastModified = lastModified;
        }

        public void setVersionDate(BAbsTime versionDate) {
            this.versionDate = versionDate;
        }

        public void setRootType(Type rootType) {
            this.rootType = rootType;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUID(BUuid uID) {
            this.uID = uID;
        }

        public FilePath getFilePath() {
            return this.fp;
        }

        public BOrd getNtpFileOrd() {
            return this.ntpFileOrd;
        }

        public BAbsTime getLastModified() {
            return this.lastModified;
        }

        public BAbsTime getVersionDate() {
            return this.versionDate;
        }

        public Type getRootType() {
            return this.rootType;
        }

        public String getName() {
            return this.name;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public BUuid getUid() {
            return this.uID;
        }

        public BNtplFile getNtplFile() {
            return (BNtplFile)this.getNtpFileOrd().resolve().get();
        }
    }
}

