/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.template.file.MemoryPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMemoryFileSpace
extends BFileSpace {
    public static final Type TYPE = Sys.loadType(BMemoryFileSpace.class);
    public static final BMemoryFileSpace INSTANCE = new BMemoryFileSpace();
    private static HashMap<String, BMemoryFileStore> cache;
    int handle = 1;
    private static final MemoryMap map;
    private static final HashMap<String, String> aliasMap;
    static final Logger log;
    static ThreadLocal<Context> threadLocalContext;
    static BIFile MEM_NO_FILE;
    BOrd ABS_ORD = BOrd.make((String)"memory:");
    private BOrd ordInHost;

    public Type getType() {
        return TYPE;
    }

    public BMemoryFileStore makeMemoryStore(FilePath filePath) {
        return this.makeMemoryStore(filePath, null);
    }

    public BMemoryFileStore makeMemoryStore(FilePath filePath, FilePath aliasFilePath) {
        return this.makeMemoryStore(new MemoryPath(filePath), aliasFilePath == null ? null : new MemoryPath(aliasFilePath));
    }

    public BMemoryFileStore makeMemoryStore(MemoryPath memoryPath) {
        return this.makeMemoryStore(memoryPath, (MemoryPath)null);
    }

    public BMemoryFileStore makeMemoryStore(MemoryPath memoryPath, MemoryPath aliasMemoryPath) {
        return this.makeMemoryStore(memoryPath.getBody(), aliasMemoryPath == null ? null : aliasMemoryPath.getBody());
    }

    public BMemoryFileStore makeMemoryStore(String filePath) {
        return this.makeMemoryStore(filePath, null);
    }

    public BMemoryFileStore makeMemoryStore(String filePath, String aliasPath) {
        MemoryPath alias;
        String aliasKey;
        MemoryPath path = MemoryPath.make(filePath);
        BMemoryFileStore fs = new BMemoryFileStore((BFileSpace)this, (FilePath)path);
        String pathKey = path.getBody();
        map.put(pathKey, fs);
        if (aliasPath != null && !(aliasKey = (alias = MemoryPath.make(aliasPath)).getBody()).equals(pathKey)) {
            aliasMap.put(aliasKey, pathKey);
        }
        return fs;
    }

    private String getNextHandle() {
        return Integer.toString(this.handle++, 16);
    }

    public void delete(FilePath fp, Context cx) throws IOException {
        boolean aliasRemoved;
        if (!(fp instanceof MemoryPath)) {
            return;
        }
        String key = fp.getBody();
        map.remove(key);
        while (aliasRemoved = aliasMap.values().remove(key)) {
        }
    }

    public BIFile findFile(FilePath path) {
        if (!(path instanceof MemoryPath)) {
            return MEM_NO_FILE;
        }
        BMemoryFileStore store = (BMemoryFileStore)this.findStore(path);
        if (store == null) {
            return MEM_NO_FILE;
        }
        String extension = store.getExtension();
        if (extension != null && !extension.isEmpty()) {
            TypeInfo type = Sys.getRegistry().getFileTypeForExtension(extension);
            try {
                BIFile file = (BIFile)type.getInstance();
                file.setStore((BIFileStore)store);
                return file;
            }
            catch (Exception e) {
                return MEM_NO_FILE;
            }
        }
        return new BDataFile((BIFileStore)store);
    }

    private BMemoryFileSpace() {
        super("memory");
    }

    public BOrd getAbsoluteOrd() {
        return this.ABS_ORD;
    }

    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        return null;
    }

    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        return null;
    }

    public void move(FilePath from, FilePath to, Context cx) throws IOException {
    }

    public BIFile[] listFiles() {
        return null;
    }

    public FilePath localFileToPath(File file) {
        try {
            String path = file.getCanonicalPath();
            path = path.replace('\\', '/');
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return new FilePath(path);
        }
        catch (Exception e) {
            throw new UnresolvedException("Cannot map to path: " + file, (Throwable)e);
        }
    }

    public BIFileStore findStore(FilePath path) {
        String key = path.getBody();
        BIFileStore result = (BIFileStore)map.get(key);
        if (result == null) {
            result = (BIFileStore)map.get(aliasMap.get(key));
        }
        return result;
    }

    public BIFile getChild(BIFile dir, String name) {
        return null;
    }

    public BIFile[] getChildren(BIFile dir) {
        ArrayList v = new ArrayList(0);
        BIFile[] kids = v.toArray(new BIFile[v.size()]);
        return kids;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BOrd getOrdInHost() {
        return this.ABS_ORD;
    }

    public BOrd getOrdInSession() {
        return this.ABS_ORD;
    }

    public BHost getHost() {
        return BLocalHost.INSTANCE;
    }

    public BISession getSession() {
        return BLocalHost.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        try {
            Object[] keys;
            threadLocalContext.set(out.getContext());
            super.spy(out);
            out.startProps("BMemoryFileSpace");
            out.prop((Object)"ordInHost", (Object)this.ordInHost);
            out.endProps();
            out.startTable(true);
            out.trTitle((Object)"cache", 4);
            out.w((Object)"<tr>").th((Object)"key").th((Object)"name").th((Object)"modified").w((Object)"</tr>\n");
            for (Object key : keys = cache.keySet().toArray()) {
                BMemoryFileStore fs = cache.get(key);
                out.tr(key, (Object)fs.getFileName(), (Object)fs.getLastModified());
            }
            out.endTable();
        }
        finally {
            threadLocalContext.set(null);
        }
    }

    static {
        BLocalHost.INSTANCE.addNavChild((BINavNode)INSTANCE);
        cache = new HashMap();
        map = new MemoryMap();
        aliasMap = new HashMap();
        log = Logger.getLogger("sys.file");
        threadLocalContext = new ThreadLocal();
        MEM_NO_FILE = new BDataFile((BIFileStore)new BMemoryFileStore((BFileSpace)INSTANCE, new FilePath("")));
    }

    private static final class MemoryMap
    extends HashMap<String, BMemoryFileStore> {
        private MemoryMap() {
        }
    }
}

