/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.TemplateConst;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.api.TemplateSourceType;
import com.tridium.template.api.TemplateType;
import com.tridium.template.api.TemplateValueSource;
import com.tridium.template.api.impl.NewApplicationTemplateSource;
import com.tridium.template.api.impl.NewComponentTemplateSource;
import com.tridium.template.api.impl.NewDeviceTemplateSource;
import com.tridium.template.api.impl.NewStationTemplateSource;
import com.tridium.template.api.impl.TemplateSourceWithBase;
import com.tridium.template.file.DependencyUtil;
import com.tridium.template.manifest.ManifestXMLWriter;
import com.tridium.template.manifest.TemplateFileSpec;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.util.CompUtil;
import com.tridium.util.PasswordUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.driver.BDevice;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BPxFile;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

public abstract class NewTemplateSource
extends TemplateSourceWithBase {
    private boolean sourceOffline = true;
    private BComponent sourceRoot = null;
    private BIDirectory sourceHomeDir = null;
    private BIDirectory sourceProtectedHomeDir = null;
    private boolean sourceDirectoriesAreResolved = false;
    private BComponentSpace componentSpace = null;
    private BComponent deployRoot = null;
    private boolean useMinorVersionOnDeployment = true;
    protected static final Logger log = Logger.getLogger("template");

    public static NewTemplateSource create(BComponent sourceComponent, BIDirectory sourceHomeDir, BIDirectory sourceProtectedHomeDir, boolean createAsApplication) {
        Objects.requireNonNull(sourceComponent);
        NewTemplateSource result = null;
        if (sourceComponent instanceof BStation) {
            result = createAsApplication ? new NewApplicationTemplateSource() : new NewStationTemplateSource();
        } else if (sourceComponent instanceof BDevice) {
            result = new NewDeviceTemplateSource();
        } else if (sourceComponent.getPropertyInParent() == null || sourceComponent.getPropertyInParent().isDynamic()) {
            result = new NewComponentTemplateSource();
        }
        if (result != null) {
            result.sourceOffline = !sourceComponent.isRunning();
            result.sourceRoot = sourceComponent;
            result.sourceHomeDir = sourceHomeDir;
            result.sourceProtectedHomeDir = sourceProtectedHomeDir;
        }
        return result;
    }

    @Override
    protected TemplateValueSource getValueSource() {
        return TemplateValueSource.DEFAULT_VALUE;
    }

    @Override
    protected BComponent getBase() {
        return this.getDeployRoot();
    }

    @Override
    protected BValue getPropertyValue(int propertyKey) {
        return null;
    }

    @Override
    public void setUseMinorVersionOnDeployment(boolean useMinorVersionOnDeployment) {
        this.useMinorVersionOnDeployment = useMinorVersionOnDeployment;
    }

    @Override
    public boolean getUseMinorVersionOnDeployment() {
        return this.useMinorVersionOnDeployment;
    }

    @Override
    public void save(OutputStream out) throws IOException {
        long start = Clock.nanoTicks();
        log.fine(() -> String.format("Starting save to stream of %s template [%s].", new Object[]{this.getTemplateType(), this.getTitle()}));
        TemplateManifest manifest = new TemplateManifest();
        BTemplateConfig config = BTemplateConfig.getOrCreateConfigForRoot(this.getDeployRoot(), this.getTemplateType() == TemplateType.APPLICATION);
        this.collectTemplateInfo(manifest, config);
        Set<TemplateFileSpec> filesToStore = this.addFilesToManifest(manifest);
        this.addDependenciesToManifest(filesToStore, manifest);
        this.buildTemplateFile(out, manifest, filesToStore);
        log.fine(() -> String.format("Finished save to stream of %s template [%s].", new Object[]{this.getTemplateType(), this.getTitle()}));
        log.finest(() -> String.format("Template save to stream completed in %d ms.", TimeUnit.MILLISECONDS.convert(Clock.nanoTicks() - start, TimeUnit.NANOSECONDS)));
    }

    @Override
    public BOrd save() throws IOException {
        long start = Clock.nanoTicks();
        log.fine("Starting template save to default location.");
        FilePath targetDirPath = new FilePath((this.sourceOffline ? "~" : "^") + this.getDefaultStationDirectoryName());
        BDirectory targetDir = BFileSystem.INSTANCE.makeDir(targetDirPath);
        String filename = FileToFile.getUniqueFilename((BDirectory)targetDir, (String)(this.getTitle() + "." + this.getFileExtension()));
        BIFile file = BFileSystem.INSTANCE.makeFile(targetDirPath.merge(filename));
        try (OutputStream fileOut = file.getOutputStream();){
            this.save(fileOut);
        }
        BOrd fileOrd = file.getOrdInSession();
        log.fine(() -> String.format("Finished template save to default location: %s", fileOrd));
        log.finest(() -> String.format("Template save %d ms.", TimeUnit.MILLISECONDS.convert(Clock.nanoTicks() - start, TimeUnit.NANOSECONDS)));
        return fileOrd;
    }

    @Override
    public String getVendor() {
        return Sys.getBajaModule().getVendor(RuntimeProfile.rt);
    }

    @Override
    public BComponent getTemplateRoot() {
        if (this.componentSpace == null && this.sourceRoot != null) {
            this.createRootAndReleaseSource();
        }
        if (this.componentSpace == null) {
            return null;
        }
        return this.componentSpace.getRootComponent();
    }

    @Override
    public BComponent getDeployRoot() {
        if (this.deployRoot == null && this.sourceRoot != null) {
            this.createRootAndReleaseSource();
        }
        return this.deployRoot;
    }

    @Override
    public List<BComponent> getInstallRoots() {
        return Collections.singletonList(this.getDeployRoot());
    }

    @Override
    public TemplateSourceType getSourceType() {
        return TemplateSourceType.CREATE;
    }

    protected BComponent getTransferStrategyParams() {
        return null;
    }

    protected void doPostCopyCleanup(BComponent source, BComponent copy) {
    }

    protected abstract String getDefaultStationDirectoryName();

    protected SortedSet<TemplateFileSpec> getFilesToStore() {
        return Collections.emptySortedSet();
    }

    final BIDirectory getSourceHomeDir() {
        this.resolveSourceDirectories();
        return this.sourceHomeDir;
    }

    final BIDirectory getSourceProtectedHomeDir() {
        this.resolveSourceDirectories();
        return this.sourceProtectedHomeDir;
    }

    private void createRootAndReleaseSource() {
        TransferResult transferResult;
        Objects.requireNonNull(this.sourceRoot);
        log.finer("Copying template root component...");
        BComponentSpace space = new BComponentSpace(null, null, null);
        BUnrestrictedFolder templateRoot = new BUnrestrictedFolder();
        space.setRootComponent((BComponent)templateRoot);
        String name = this.sourceRoot instanceof BStation ? ((BStation)this.sourceRoot).getStationName() : this.sourceRoot.getName();
        Mark sourceMark = name == null || name.isEmpty() ? new Mark((BObject)this.sourceRoot) : new Mark((BObject)this.sourceRoot, name);
        TransferStrategy transferStrategy = TransferStrategy.make((int)16, (Mark)sourceMark, (BObject)templateRoot, (BComponent)this.getTransferStrategyParams(), null);
        if (transferStrategy == null) {
            log.severe("Failed to copy the source component into the template; failed to create component copier.");
            return;
        }
        try {
            transferResult = transferStrategy.transfer();
        }
        catch (Exception e) {
            log.severe(() -> String.format("Failed to copy the source component into the template; exception during transfer: %s", e));
            return;
        }
        if (transferResult == null) {
            log.severe("Failed to copy the source component into the template; transfer produced empty results.");
            return;
        }
        BComponent deployRoot = templateRoot.get(transferResult.getInsertNames()[0]).asComponent();
        log.finer("Clearing passwords from new template root...");
        PasswordUtil.forceClearReversiblePasswords((BComponent)templateRoot);
        this.doPostCopyCleanup(this.sourceRoot, deployRoot);
        this.componentSpace = space;
        this.deployRoot = deployRoot;
        this.resolveSourceDirectories();
        this.sourceRoot = null;
    }

    private void resolveSourceDirectories() {
        if (!this.sourceDirectoriesAreResolved) {
            BOrd ordInHost;
            if (this.sourceRoot != null && (this.sourceHomeDir == null || this.sourceProtectedHomeDir == null) && (ordInHost = this.sourceRoot.getOrdInHost()) != null) {
                if (this.sourceHomeDir == null) {
                    this.sourceHomeDir = NewTemplateSource.confirmAsDirectory(BOrd.make((String)(ordInHost.toString() + "|file:^")), (BObject)this.sourceRoot);
                }
                if (this.sourceProtectedHomeDir == null) {
                    this.sourceProtectedHomeDir = NewTemplateSource.confirmAsDirectory(BOrd.make((String)(ordInHost.toString() + "|file:^^")), (BObject)this.sourceRoot);
                }
            }
            this.sourceDirectoriesAreResolved = true;
        }
    }

    private static BIDirectory confirmAsDirectory(BOrd ord, BObject base) {
        try {
            return (BIDirectory)ord.resolve(base).get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getBuildVersion() {
        BModule module = Sys.getModuleForClass(NiagaraTemplate.class);
        if (module == null) {
            return "";
        }
        Version vendorVersion = module.getVendorVersion(RuntimeProfile.rt);
        if (vendorVersion == null) {
            return "";
        }
        return vendorVersion.toString();
    }

    private Set<TemplateFileSpec> addFilesToManifest(TemplateManifest manifest) {
        log.finer("Adding files to template manifest...");
        SortedSet<TemplateFileSpec> filesToStore = this.getFilesToStore();
        for (TemplateFileSpec fileSpec : filesToStore) {
            log.finest(() -> String.format("Adding file to template manifest: %s, %s, %s", fileSpec.getName(), fileSpec.getType(), fileSpec.getSourceOrd()));
            manifest.addResource(fileSpec.getName(), fileSpec.getType(), fileSpec.getSourceOrd());
        }
        return filesToStore;
    }

    private void buildTemplateFile(OutputStream out, TemplateManifest manifest, Set<TemplateFileSpec> filesToStore) throws IOException {
        log.finer("Zipping template files...");
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            log.finer("  Zipping the manifest file...");
            ZipEntry manifestEntry = new ZipEntry("template-manifest.xml");
            manifestEntry.setComment("Template Manifest");
            zipOut.putNextEntry(manifestEntry);
            ManifestXMLWriter manifestWriter = new ManifestXMLWriter(zipOut);
            manifestWriter.encode(manifest);
            zipOut.closeEntry();
            log.finer("  Zipping the BOG file...");
            ZipEntry bogEntry = new ZipEntry("template.bog");
            bogEntry.setComment("BOG snippet");
            zipOut.putNextEntry(bogEntry);
            ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)zipOut);
            encoder.encodeDocument((BValue)this.getTemplateRoot());
            zipOut.closeEntry();
            if (!filesToStore.isEmpty()) {
                log.finer("  Zipping the supporting files...");
            }
            for (TemplateFileSpec fileSpec : filesToStore) {
                log.finest(() -> String.format("    Zipping file %s...", fileSpec.getName()));
                ZipEntry fileEntry = new ZipEntry(fileSpec.getName());
                zipOut.putNextEntry(fileEntry);
                try (InputStream fileIn = fileSpec.getFile().getInputStream();){
                    BajaFileUtil.pipe((InputStream)fileIn, (OutputStream)zipOut);
                }
                zipOut.closeEntry();
            }
            zipOut.finish();
        }
    }

    private void addDependenciesToManifest(Set<TemplateFileSpec> filesToStore, TemplateManifest manifest) {
        Hashtable<String, BDependency> hashtable = new Hashtable<String, BDependency>();
        List<BComponent> installRoots = this.getInstallRoots();
        if (!installRoots.isEmpty()) {
            log.finer("Adding component dependencies to template manifest...");
        }
        for (BComponent root : this.getInstallRoots()) {
            log.finest(() -> String.format("Adding dependencies for root %s...", root.getSlotPath()));
            DependencyUtil.getBogComponentDependencies(root, hashtable, this.getUseMinorVersionOnDeployment());
        }
        if (!filesToStore.isEmpty()) {
            log.finer("Adding PX file dependencies to template manifest...");
        }
        for (TemplateFileSpec fileSpec : filesToStore) {
            if (!(fileSpec.getFile() instanceof BPxFile)) continue;
            log.finest(() -> String.format("Adding dependencies for px file %s...", fileSpec.getName()));
            DependencyUtil.getPxFileDependencies((BPxFile)fileSpec.getFile(), hashtable, this.getUseMinorVersionOnDeployment());
        }
        BDependency[] dependencies = new BDependency[hashtable.size()];
        manifest.addDependencies(hashtable.values().toArray(dependencies));
    }

    private void collectTemplateInfo(TemplateManifest manifest, BTemplateConfig config) {
        BComponent deployRoot = this.getDeployRoot();
        TemplateType templateType = this.getTemplateType();
        log.finer("Collecting template information...");
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.ROOT_TAG_NAME, (BValue)BMarker.MARKER, (int)16389, null, null);
        manifest.uID = BUuid.make();
        config.setUID(manifest.uID);
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.UID_TAG_NAME, (BValue)BString.make((String)manifest.uID.toString()), (int)16389, null, null);
        manifest.vendor = this.getVendor();
        BVersion version = new BVersion(manifest.vendor, manifest.version);
        version.setBajaVersionString(Sys.getBajaVersion().toString());
        config.setVersion(version);
        config.setVersionDate(BAbsTime.now());
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.VENDOR_TAG_NAME, (BValue)BString.make((String)manifest.vendor), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.VERSION_TAG_NAME, (BValue)BString.make((String)manifest.version), (int)16389, null, null);
        manifest.title = deployRoot.getName();
        config.setTemplateName(manifest.title);
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.TITLE_TAG_NAME, (BValue)BString.make((String)manifest.title), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.NTPL_FILE_TAG_NAME, (BValue)BString.make((String)(manifest.title + "." + this.getFileExtension())), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)deployRoot, (String)TemplateConst.INFO_TAG_NAME, (BValue)BString.make((String)manifest.description), (int)16389, null, null);
        manifest.buildVersion = NewTemplateSource.getBuildVersion();
        long signature = UpgradeUtil.getTemplateSignature(this.getTemplateRoot());
        manifest.bogSignature = Long.toHexString(signature);
        manifest.isApplication = templateType == TemplateType.APPLICATION;
        manifest.isStation = templateType == TemplateType.STATION;
    }
}

