/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api;

import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.api.TemplateProperty;
import com.tridium.template.api.TemplateValue;
import com.tridium.template.api.TemplateValueSource;
import com.tridium.template.api.impl.NiagaraTemplateUtils;
import java.util.Objects;

public class TemplateElement {
    private final NiagaraTemplate template;
    private final int propertyKey;
    private final int elementKey;
    private static final String NAME_SEPARATOR = ".";

    public NiagaraTemplate template() {
        return this.template;
    }

    public TemplateProperty property() {
        return this.template.getProperty(this.propertyKey);
    }

    public String getName() {
        String result = null;
        result = this.template.isPropertyPrimitive(this.propertyKey) ? this.template.getPropertyName(this.propertyKey) : this.template.getElementName(this.propertyKey, this.elementKey);
        return NiagaraTemplateUtils.replaceNull(result);
    }

    public String getFullName() {
        StringBuilder name = new StringBuilder(this.template.getPropertyName(this.propertyKey));
        if (!this.template.isPropertyPrimitive(this.propertyKey)) {
            name.append(NAME_SEPARATOR);
            name.append(this.template.getElementName(this.propertyKey, this.elementKey));
        }
        return name.toString();
    }

    public TemplateValue presentValue() {
        return this.template.getElementValue(this.propertyKey, this.elementKey, TemplateValueSource.PRESENT_VALUE);
    }

    public TemplateValue localValue() {
        return this.template.getElementValue(this.propertyKey, this.elementKey, TemplateValueSource.LOCAL_VALUE);
    }

    public TemplateValue defaultValue() {
        return this.template.getElementValue(this.propertyKey, this.elementKey, TemplateValueSource.DEFAULT_VALUE);
    }

    TemplateElement(NiagaraTemplate template, int propertyKey, int elementKey) {
        this.template = Objects.requireNonNull(template);
        this.propertyKey = propertyKey;
        this.elementKey = elementKey;
    }
}

