/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.device;

import com.tridium.template.BTemplateConfig;
import java.util.ArrayList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

public class DeviceTemplateEdit
extends MgrEdit {
    public DeviceTemplateEdit(BAbstractManager manager, String title) {
        super(manager, title);
    }

    public void checkTargetNames() {
        super.checkTargetNames();
        int depth = this.getManager().getModel().getSubscribeDepth();
        if (depth >= 2) {
            return;
        }
        MgrEditRow[] rows = this.getRows();
        if (rows.length == 0) {
            return;
        }
        BComponent[] tcs = new BComponent[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            tcs[i] = this.getTemplateConfig(rows[i].getTarget());
        }
        BComponent.lease((BComponent[])tcs, (int)1);
    }

    protected MgrColumn[] makeColumns() {
        BComponent target = this.getManager().getModel().getTable().getSelectedComponent();
        if (target != null) {
            return this.makeColumns(target);
        }
        return new MgrColumn[0];
    }

    public MgrColumn[] makeColumns(BComponent target) {
        ArrayList<Object> columns = new ArrayList<Object>();
        BTemplateConfig templateConfig = this.getTemplateConfig(target);
        if (templateConfig != null) {
            MgrColumn.Name colName = new MgrColumn.Name();
            colName.setFlags(4);
            columns.add(colName);
            Property propertyInParent = templateConfig.getPropertyInParent();
            for (Property property : templateConfig.getProperties()) {
                int flags = templateConfig.getFlags((Slot)property);
                if ((flags & 7) != 0) continue;
                columns.add((Object)new PropStringPath(new Property[]{propertyInParent, property}, 1));
            }
        }
        MgrColumn[] retColumns = new MgrColumn[columns.size()];
        return columns.toArray(retColumns);
    }

    private BTemplateConfig getTemplateConfig(BComponent target) {
        return BTemplateConfig.getConfigForRoot((BComponent)target);
    }

    public static class PropStringPath
    extends MgrColumn.PropPath {
        public PropStringPath(Property[] props, int flags) {
            super(props, flags);
        }

        public BValue load(MgrEditRow row) {
            BComplex val = this.getTargetBase(row);
            for (int i = 0; i < this.props.length; ++i) {
                val = val.get(this.props[i].getName());
            }
            return val.newCopy();
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComplex target = this.getTargetBase(row);
            int len = this.props.length;
            for (int i = 0; i < len - 1; ++i) {
                target = (BComplex)target.get(this.props[i].getName());
            }
            String prop = this.props[len - 1].getName();
            BValue old = target.get(prop);
            if (!old.equivalent((Object)value)) {
                target.set(prop, value.newCopy(), cx);
            }
        }

        public Object get(Object row) {
            BComplex val = this.getRowBase(row);
            for (int i = 0; i < this.props.length - 1; ++i) {
                val = (BComplex)val.get(this.props[i].getName());
            }
            String prop = this.props[this.props.length - 1].getName();
            return val.get(prop);
        }
    }
}

