/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.StringElement;

class CharacterSetElement
extends Element {
    public static final CharacterSetElement DOT = new CharacterSetElement(false){

        @Override
        protected boolean inSet(char value) {
            switch (value) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return ".";
        }
    };
    public static final CharacterSetElement DIGIT = new CharacterSetElement(false){

        @Override
        protected boolean inSet(char value) {
            return '0' <= value && value <= '9';
        }

        @Override
        public String toString() {
            return "\\d";
        }
    };
    public static final CharacterSetElement NON_DIGIT = new CharacterSetElement(true){

        @Override
        protected boolean inSet(char value) {
            return value < '0' || '9' < value;
        }

        @Override
        public String toString() {
            return "\\D";
        }
    };
    public static final CharacterSetElement WHITESPACE = new CharacterSetElement(false){

        @Override
        protected boolean inSet(char value) {
            switch (value) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return "\\s";
        }
    };
    public static final CharacterSetElement NON_WHITESPACE = new CharacterSetElement(true){

        @Override
        protected boolean inSet(char value) {
            switch (value) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return "\\S";
        }
    };
    public static final CharacterSetElement WORD = new CharacterSetElement(false){

        @Override
        protected boolean inSet(char value) {
            return 'a' <= value && value <= 'z' || 'A' <= value && value <= 'Z' || '0' <= value && value <= '9' || value == '_';
        }

        @Override
        public String toString() {
            return "\\w";
        }
    };
    public static final CharacterSetElement NON_WORD = new CharacterSetElement(true){

        @Override
        protected boolean inSet(char value) {
            boolean word = 'a' <= value && value <= 'z' || 'A' <= value && value <= 'Z' || '0' <= value && value <= '9' || value == '_';
            return !word;
        }

        @Override
        public String toString() {
            return "\\W";
        }
    };
    private boolean inverted;
    private Object[] contents = new Object[0];

    public CharacterSetElement(boolean inverted) {
        this.inverted = inverted;
    }

    public void addCharacter(char c) {
        this.addContent(new Character(c));
    }

    public void addCharacters(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.addCharacter(str.charAt(i));
        }
    }

    public void addCharacters(StringElement elem) {
        this.addCharacters(elem.getString());
    }

    public void addRange(char min, char max) {
        this.addContent(new Range(min, max));
    }

    public void addCharacterSet(CharacterSetElement elem) {
        this.addContent(elem);
    }

    private void addContent(Object obj) {
        Object[] temp = this.contents;
        this.contents = new Object[temp.length + 1];
        System.arraycopy(temp, 0, this.contents, 0, temp.length);
        this.contents[temp.length] = obj;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public int match(Matcher m, ReaderBuffer buffer, int start, int skip) throws IOException {
        if (skip != 0) {
            return -1;
        }
        int c = buffer.peek(start);
        if (c < 0) {
            m.setReadEndOfString();
            return -1;
        }
        if (m.isCaseInsensitive()) {
            c = Character.toLowerCase((char)c);
        }
        return this.inSet((char)c) ? 1 : -1;
    }

    protected boolean inSet(char value) {
        for (int i = 0; i < this.contents.length; ++i) {
            CharacterSetElement e;
            Range r;
            Character c;
            Object obj = this.contents[i];
            if (!(obj instanceof Character ? (c = (Character)obj).charValue() == value : (obj instanceof Range ? (r = (Range)obj).inside(value) : obj instanceof CharacterSetElement && (e = (CharacterSetElement)obj).inSet(value)))) continue;
            return !this.inverted;
        }
        return this.inverted;
    }

    @Override
    public void printTo(PrintWriter output, String indent) {
        output.println(indent + this.toString());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.inverted) {
            buffer.append("[^");
        } else {
            buffer.append("[");
        }
        for (int i = 0; i < this.contents.length; ++i) {
            buffer.append(this.contents[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private class Range {
        private char min;
        private char max;

        public Range(char min, char max) {
            this.min = min;
            this.max = max;
        }

        public boolean inside(char c) {
            return c >= this.min && c <= this.max;
        }

        public String toString() {
            return this.min + "-" + this.max;
        }
    }
}

