/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.TokenMatch;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.TokenRegExpParser;
import net.percederberg.grammatica.parser.re.RegExpException;

class TokenNFA {
    private State[] initialChar = new State[128];
    private State initial = new State();
    private StateQueue queue = new StateQueue();

    TokenNFA() {
    }

    public void addTextMatch(String str, boolean ignoreCase, TokenPattern value) {
        State state;
        char ch = str.charAt(0);
        if (ch < '\u0080' && !ignoreCase) {
            state = this.initialChar[ch];
            if (state == null) {
                state = this.initialChar[ch] = new State();
            }
        } else {
            state = this.initial.addOut(ch, ignoreCase, null);
        }
        for (int i = 1; i < str.length(); ++i) {
            state = state.addOut(str.charAt(i), ignoreCase, null);
        }
        state.value = value;
    }

    public void addRegExpMatch(String pattern, boolean ignoreCase, TokenPattern value) throws RegExpException {
        int i;
        TokenRegExpParser parser = new TokenRegExpParser(pattern, ignoreCase);
        String debug = "DFA regexp; " + parser.getDebugInfo();
        boolean isAscii = parser.start.isAsciiOutgoing();
        for (i = 0; isAscii && i < 128; ++i) {
            boolean match = false;
            for (int j = 0; j < parser.start.outgoing.length; ++j) {
                if (!parser.start.outgoing[j].match((char)i)) continue;
                if (match) {
                    isAscii = false;
                    break;
                }
                match = true;
            }
            if (!match || this.initialChar[i] == null) continue;
            isAscii = false;
        }
        if (parser.start.incoming.length > 0) {
            this.initial.addOut(new EpsilonTransition(parser.start));
            debug = debug + ", uses initial epsilon";
        } else if (isAscii && !ignoreCase) {
            for (i = 0; isAscii && i < 128; ++i) {
                for (int j = 0; j < parser.start.outgoing.length; ++j) {
                    if (!parser.start.outgoing[j].match((char)i)) continue;
                    this.initialChar[i] = parser.start.outgoing[j].state;
                }
            }
            debug = debug + ", uses ASCII lookup";
        } else {
            parser.start.mergeInto(this.initial);
            debug = debug + ", uses initial state";
        }
        parser.end.value = value;
        value.setDebugInfo(debug);
    }

    public int match(ReaderBuffer buffer, TokenMatch match) throws IOException {
        State state;
        int length = 0;
        int pos = 1;
        this.queue.clear();
        int peekChar = buffer.peek(0);
        if (0 <= peekChar && peekChar < 128 && (state = this.initialChar[peekChar]) != null) {
            this.queue.addLast(state);
        }
        if (peekChar >= 0) {
            this.initial.matchTransitions((char)peekChar, this.queue, true);
        }
        this.queue.markEnd();
        peekChar = buffer.peek(1);
        while (!this.queue.isEmpty()) {
            if (this.queue.isMarked()) {
                peekChar = buffer.peek(++pos);
                this.queue.markEnd();
            }
            state = this.queue.removeFirst();
            if (state.value != null) {
                match.update(pos, state.value);
            }
            if (peekChar < 0) continue;
            state.matchTransitions((char)peekChar, this.queue, false);
        }
        return length;
    }

    protected static class StateQueue {
        private State[] queue = new State[2048];
        private int first = 0;
        private int last = 0;
        private int mark = 0;

        protected StateQueue() {
        }

        public boolean isEmpty() {
            return this.last <= this.first;
        }

        public boolean isMarked() {
            return this.first == this.mark;
        }

        public void clear() {
            this.first = 0;
            this.last = 0;
            this.mark = 0;
        }

        public void markEnd() {
            this.mark = this.last;
        }

        public State removeFirst() {
            if (this.first < this.last) {
                ++this.first;
                return this.queue[this.first - 1];
            }
            return null;
        }

        public void addLast(State state) {
            if (this.last >= this.queue.length) {
                if (this.first <= 0) {
                    State[] temp = this.queue;
                    this.queue = new State[temp.length * 2];
                    System.arraycopy(temp, 0, this.queue, 0, temp.length);
                } else {
                    System.arraycopy(this.queue, this.first, this.queue, 0, this.last - this.first);
                    this.last -= this.first;
                    this.mark -= this.first;
                    this.first = 0;
                }
            }
            this.queue[this.last++] = state;
        }
    }

    protected static class NonWordTransition
    extends Transition {
        public NonWordTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return false;
        }

        @Override
        public boolean match(char ch) {
            boolean word = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_';
            return !word;
        }

        @Override
        public Transition copy(State state) {
            return new NonWordTransition(state);
        }
    }

    protected static class WordTransition
    extends Transition {
        public WordTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return true;
        }

        @Override
        public boolean match(char ch) {
            return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_';
        }

        @Override
        public Transition copy(State state) {
            return new WordTransition(state);
        }
    }

    protected static class NonWhitespaceTransition
    extends Transition {
        public NonWhitespaceTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return false;
        }

        @Override
        public boolean match(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Transition copy(State state) {
            return new NonWhitespaceTransition(state);
        }
    }

    protected static class WhitespaceTransition
    extends Transition {
        public WhitespaceTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return true;
        }

        @Override
        public boolean match(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Transition copy(State state) {
            return new WhitespaceTransition(state);
        }
    }

    protected static class NonDigitTransition
    extends Transition {
        public NonDigitTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return false;
        }

        @Override
        public boolean match(char ch) {
            return ch < '0' || '9' < ch;
        }

        @Override
        public Transition copy(State state) {
            return new NonDigitTransition(state);
        }
    }

    protected static class DigitTransition
    extends Transition {
        public DigitTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return true;
        }

        @Override
        public boolean match(char ch) {
            return '0' <= ch && ch <= '9';
        }

        @Override
        public Transition copy(State state) {
            return new DigitTransition(state);
        }
    }

    protected static class DotTransition
    extends Transition {
        public DotTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return false;
        }

        @Override
        public boolean match(char ch) {
            switch (ch) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Transition copy(State state) {
            return new DotTransition(state);
        }
    }

    protected static class CharRangeTransition
    extends Transition {
        protected boolean inverse;
        protected boolean ignoreCase;
        private Object[] contents = new Object[0];

        public CharRangeTransition(boolean inverse, boolean ignoreCase, State state) {
            super(state);
            this.inverse = inverse;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean isAscii() {
            if (this.inverse) {
                return false;
            }
            for (int i = 0; i < this.contents.length; ++i) {
                Character c;
                Object obj = this.contents[i];
                if (!(obj instanceof Character ? (c = (Character)obj).charValue() < '\u0000' || '\u0080' <= c.charValue() : obj instanceof Range && !((Range)obj).isAscii())) continue;
                return false;
            }
            return true;
        }

        public void addCharacter(char c) {
            if (this.ignoreCase) {
                c = Character.toLowerCase(c);
            }
            this.addContent(new Character(c));
        }

        public void addRange(char min, char max) {
            if (this.ignoreCase) {
                min = Character.toLowerCase(min);
                max = Character.toLowerCase(max);
            }
            this.addContent(new Range(min, max));
        }

        private void addContent(Object obj) {
            Object[] temp = this.contents;
            this.contents = new Object[temp.length + 1];
            System.arraycopy(temp, 0, this.contents, 0, temp.length);
            this.contents[temp.length] = obj;
        }

        @Override
        public boolean match(char ch) {
            if (this.ignoreCase) {
                ch = Character.toLowerCase(ch);
            }
            for (int i = 0; i < this.contents.length; ++i) {
                Range r;
                Character c;
                Object obj = this.contents[i];
                if (!(obj instanceof Character ? (c = (Character)obj).charValue() == ch : obj instanceof Range && (r = (Range)obj).inside(ch))) continue;
                return !this.inverse;
            }
            return this.inverse;
        }

        @Override
        public Transition copy(State state) {
            CharRangeTransition copy = new CharRangeTransition(this.inverse, this.ignoreCase, state);
            copy.contents = this.contents;
            return copy;
        }

        private class Range {
            private char min;
            private char max;

            public Range(char min, char max) {
                this.min = min;
                this.max = max;
            }

            public boolean isAscii() {
                return '\u0000' <= this.min && this.min < '\u0080' && '\u0000' <= this.max && this.max < '\u0080';
            }

            public boolean inside(char c) {
                return this.min <= c && c <= this.max;
            }
        }
    }

    protected static class CharTransition
    extends Transition {
        protected char match;

        public CharTransition(char match, State state) {
            super(state);
            this.match = match;
        }

        @Override
        public boolean isAscii() {
            return '\u0000' <= this.match && this.match < '\u0080';
        }

        @Override
        public boolean match(char ch) {
            return this.match == ch;
        }

        @Override
        public Transition copy(State state) {
            return new CharTransition(this.match, state);
        }
    }

    protected static class EpsilonTransition
    extends Transition {
        public EpsilonTransition(State state) {
            super(state);
        }

        @Override
        public boolean isAscii() {
            return false;
        }

        @Override
        public boolean match(char ch) {
            return false;
        }

        @Override
        public Transition copy(State state) {
            return new EpsilonTransition(state);
        }
    }

    protected static abstract class Transition {
        protected State state;

        public Transition(State state) {
            this.state = state;
            this.state.addIn(this);
        }

        public abstract boolean isAscii();

        public abstract boolean match(char var1);

        public abstract Transition copy(State var1);
    }

    protected static class State {
        protected TokenPattern value = null;
        protected Transition[] incoming = new Transition[0];
        protected Transition[] outgoing = new Transition[0];
        protected boolean epsilonOut = false;

        protected State() {
        }

        public boolean hasTransitions() {
            return this.incoming.length > 0 || this.outgoing.length > 0;
        }

        public boolean isAsciiOutgoing() {
            for (int i = 0; i < this.outgoing.length; ++i) {
                if (this.outgoing[i].isAscii()) continue;
                return false;
            }
            return true;
        }

        public void addIn(Transition trans) {
            Transition[] temp = this.incoming;
            this.incoming = new Transition[temp.length + 1];
            System.arraycopy(temp, 0, this.incoming, 0, temp.length);
            this.incoming[temp.length] = trans;
        }

        public State addOut(char ch, boolean ignoreCase, State state) {
            if (ignoreCase) {
                if (state == null) {
                    state = new State();
                }
                this.addOut(new CharTransition(Character.toLowerCase(ch), state));
                this.addOut(new CharTransition(Character.toUpperCase(ch), state));
                return state;
            }
            if (state == null) {
                state = this.findUniqueCharTransition(ch);
                if (state != null) {
                    return state;
                }
                state = new State();
            }
            return this.addOut(new CharTransition(ch, state));
        }

        public State addOut(Transition trans) {
            Transition[] temp = this.outgoing;
            this.outgoing = new Transition[temp.length + 1];
            System.arraycopy(temp, 0, this.outgoing, 0, temp.length);
            this.outgoing[temp.length] = trans;
            if (trans instanceof EpsilonTransition) {
                this.epsilonOut = true;
            }
            return trans.state;
        }

        public void mergeInto(State state) {
            int i;
            for (i = 0; i < this.incoming.length; ++i) {
                state.addIn(this.incoming[i]);
                this.incoming[i].state = state;
            }
            this.incoming = null;
            for (i = 0; i < this.outgoing.length; ++i) {
                state.addOut(this.outgoing[i]);
            }
            this.outgoing = null;
        }

        private State findUniqueCharTransition(char ch) {
            Transition trans;
            int i;
            Transition res = null;
            for (i = 0; i < this.outgoing.length; ++i) {
                trans = this.outgoing[i];
                if (!trans.match(ch) || !(trans instanceof CharTransition)) continue;
                if (res != null) {
                    return null;
                }
                res = trans;
            }
            for (i = 0; res != null && i < this.outgoing.length; ++i) {
                trans = this.outgoing[i];
                if (trans == res || trans.state != res.state) continue;
                return null;
            }
            return res == null ? null : res.state;
        }

        public void matchTransitions(char ch, StateQueue queue, boolean initial) {
            for (int i = 0; i < this.outgoing.length; ++i) {
                Transition trans = this.outgoing[i];
                State target = trans.state;
                if (initial && trans instanceof EpsilonTransition) {
                    target.matchTransitions(ch, queue, true);
                    continue;
                }
                if (!trans.match(ch)) continue;
                queue.addLast(target);
                if (!target.epsilonOut) continue;
                target.matchEmpty(queue);
            }
        }

        public void matchEmpty(StateQueue queue) {
            for (int i = 0; i < this.outgoing.length; ++i) {
                Transition trans = this.outgoing[i];
                if (!(trans instanceof EpsilonTransition)) continue;
                State target = trans.state;
                queue.addLast(target);
                if (!target.epsilonOut) continue;
                target.matchEmpty(queue);
            }
        }
    }
}

