/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BCreateMibParameters;
import com.tridium.snmp.datatypes.BSnmpVersions;
import com.tridium.snmp.ui.BSnmpAutoMibOptions;
import com.tridium.snmp.util.SnmpUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.nav.BComponentMenuAgent;
import java.io.PrintWriter;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;

public class BSnmpLocalDeviceMenuAgent
extends BComponentMenuAgent {
    public static final BSnmpLocalDeviceMenuAgent INSTANCE = new BSnmpLocalDeviceMenuAgent();
    public static final Type TYPE = Sys.loadType(BSnmpLocalDeviceMenuAgent.class);
    public static BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static Lexicon lex = Lexicon.make((String)"snmp");
    BTextField fileNameTF;

    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (!((BComponent)target).isMounted()) {
            return menu;
        }
        if (((BComponent)target).getComponentSpace() != null) {
            CreateMipCommand ecmd = new CreateMipCommand(owner, target);
            menu.add("CreateMib", (Command)ecmd);
            menu.add(null, (BValue)new BSeparator());
            Property[] a = menu.getDynamicPropertiesArray();
            for (int i = 0; i < a.length - 3; ++i) {
                if (!a[i].getType().is(BActionMenuItem.TYPE)) continue;
                Property p = a[a.length - 3];
                Property p1 = a[a.length - 2];
                Property p2 = a[a.length - 1];
                System.arraycopy(a, i, a, i + 3, a.length - i - 3);
                a[i] = p;
                a[i + 1] = p1;
                a[i + 2] = p2;
                break;
            }
            menu.reorder(a);
        }
        return menu;
    }

    boolean verifyFileExists(String fname) {
        try {
            BOrd o = SnmpUtil.absolutePathToDirOrd((String)fname);
            BDirectory d = (BDirectory)o.resolve().get();
            String filename = fname.substring(fname.lastIndexOf(92) + 1);
            FilePath fp = new FilePath(d.getFilePath().getBody() + "/" + filename);
            d.getFileSpace().makeFile(fp);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    class Browse
    extends Command {
        public boolean fileSetFromBrowser;

        public Browse(BWidget owner) {
            super(owner, "");
            this.fileSetFromBrowser = false;
        }

        public CommandArtifact doInvoke() {
            BOrd ord;
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getShell());
            String fname = BSnmpLocalDeviceMenuAgent.this.fileNameTF.getText();
            if (fname.lastIndexOf(92) > 0) {
                chooser.setCurrentDirectory(SnmpUtil.absolutePathToDirOrd((String)fname));
            }
            if ((ord = chooser.show()) != null) {
                BSnmpLocalDeviceMenuAgent.this.fileNameTF.setText(SnmpUtil.ordToAbsolutePath((BOrd)ord));
                this.fileSetFromBrowser = true;
            }
            return null;
        }

        public BImage getIcon() {
            return browseIcon;
        }
    }

    public class CreateMipCommand
    extends Command {
        BSnmpAgent dev;

        public CreateMipCommand(BWidget owner, BObject target) {
            super(owner, BSnmpNetwork.TYPE.getModule().getLexicon(), "createMib");
            this.dev = (BSnmpAgent)target;
        }

        public CommandArtifact doInvoke() {
            BSnmpAutoMibOptions opts = BSnmpAutoMibOptions.getDefault();
            try {
                BSnmpLocalDeviceMenuAgent.this.fileNameTF = new BTextField("", 60);
                BSnmpLocalDeviceMenuAgent.this.fileNameTF.setText(opts.getLocalMibFile());
                Browse b = new Browse(this.getOwner());
                BButton button = new BButton((Command)b);
                button.setButtonStyle(BButtonStyle.toolBar);
                BGridPane filePane = new BGridPane(2);
                filePane.add(null, (BValue)BSnmpLocalDeviceMenuAgent.this.fileNameTF);
                filePane.add(null, (BValue)button);
                BSnmpVersions snmpVer = BSnmpVersions.v1;
                BFrozenEnumFE versionDropDown = new BFrozenEnumFE();
                versionDropDown.loadValue((BObject)snmpVer);
                BGridPane versionPane = new BGridPane(1);
                versionPane.add(null, (BValue)versionDropDown);
                BGridPane pane = new BGridPane(2);
                pane.add(null, (BValue)new BLabel(lex.getText("createMib.mibFile")));
                pane.add(null, (BValue)filePane);
                pane.add(null, (BValue)new BLabel(lex.getText("createMib.snmpVersion")));
                pane.add(null, (BValue)versionPane);
                int tries = 0;
                BSnmpVersions snmpVersion = BSnmpVersions.v1;
                String fileName = "";
                boolean found = false;
                do {
                    int retVal;
                    if ((retVal = BDialog.open((BWidget)this.getOwner(), (String)lex.getText("createMib.title"), (Object)pane, (int)3)) == 2) {
                        return null;
                    }
                    fileName = BSnmpLocalDeviceMenuAgent.this.fileNameTF.getText();
                    BListDropDown versionEnumDropDown = (BListDropDown)versionDropDown.getContent();
                    int snmpVersionOrdinal = snmpVersion.getRange().getOrdinals()[versionEnumDropDown.getSelectedIndex()];
                    snmpVersion = BSnmpVersions.make((int)snmpVersionOrdinal);
                    if (!BSnmpLocalDeviceMenuAgent.this.verifyFileExists(fileName)) {
                        if (tries > 0) {
                            BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("createMib.error"));
                            return null;
                        }
                        BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("createMib.dirError"));
                        ++tries;
                        continue;
                    }
                    found = true;
                } while (!found);
                opts.setLocalMibFile(fileName);
                opts.save();
                BCreateMibParameters arg = new BCreateMibParameters();
                arg.setFileName(fileName.substring(fileName.lastIndexOf("\\") + 1));
                arg.setVersion(snmpVersion);
                BString bstr = this.dev.createMib(arg);
                String s = bstr.getString();
                BTextEditor textArea = new BTextEditor();
                textArea.setEditable(true);
                textArea.setText(s);
                BBorderPane textPane = new BBorderPane((BWidget)textArea, BBorder.solid, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
                textPane.setFill(Theme.widget().getWindowBackground());
                textPane = new BBorderPane((BWidget)textPane, BBorder.inset, BInsets.DEFAULT);
                BScrollPane sp = new BScrollPane((BWidget)textPane);
                int retVal = BDialog.open((BWidget)this.getOwner(), (String)fileName, (Object)sp, (int)3);
                if (retVal == 2) {
                    return null;
                }
                s = textArea.getText();
                this.saveToFile(fileName, s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private void saveToFile(String fname, String s) {
            try {
                BOrd fOrd = SnmpUtil.absolutePathToOrd((String)fname);
                BIFile f = (BIFile)fOrd.resolve().get();
                PrintWriter out = new PrintWriter(f.getOutputStream());
                out.println(s);
                out.close();
            }
            catch (Throwable e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }
}

