/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.report;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.report.BReport;
import javax.baja.report.BReportRecipient;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BReportFileRecipient
extends BReportRecipient {
    public static final Property ord = BReportFileRecipient.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:DirectoryOrdFE")));
    public static final Property includeTimestamp = BReportFileRecipient.newProperty((int)0, (boolean)true, null);
    public static final Property timestampFormat = BReportFileRecipient.newProperty((int)0, (String)"yyyyMMdd_HHmm", null);
    public static final Type TYPE = Sys.loadType(BReportFileRecipient.class);
    private static final BIcon icon = BIcon.std((String)"file.png");

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public boolean getIncludeTimestamp() {
        return this.getBoolean(includeTimestamp);
    }

    public void setIncludeTimestamp(boolean v) {
        this.setBoolean(includeTimestamp, v, null);
    }

    public String getTimestampFormat() {
        return this.getString(timestampFormat);
    }

    public void setTimestampFormat(String v) {
        this.setString(timestampFormat, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleRoute(BReport breport) throws Exception {
        String filename = breport.getFileName();
        if (this.getIncludeTimestamp()) {
            int i = filename.lastIndexOf(".");
            filename = filename.substring(0, i) + new SimpleDateFormat(this.getTimestampFormat().trim()).format(new Date()) + filename.substring(i);
        }
        BIFile bifile = (BIFile)this.getOrd().resolve().get();
        BDirectory bdirectory = bifile.getFileSpace().makeDir(bifile.getFilePath(), null);
        FilePath filepath = bdirectory.getFilePath().merge(filename);
        BIFile bifile1 = bifile.getFileSpace().makeFile(filepath, null);
        OutputStream outputstream = bifile1.getOutputStream();
        byte[] abyte0 = breport.getContent();
        outputstream.write(abyte0, 0, abyte0.length);
        outputstream.flush();
        outputstream.close();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == ord) {
            BOrd ord = (BOrd)this.get(property);
            if (ord.equals((Object)BOrd.NULL) || ord.equals((Object)BOrd.DEFAULT)) {
                return;
            }
            BObject object = ord.get();
            if (object instanceof BIFile) {
                BIFile file = (BIFile)object;
                if (!file.isDirectory()) {
                    this.setOrd(BOrd.DEFAULT);
                    throw new BajaRuntimeException("Invalid ORD: " + ord.encodeToString() + ". ORD must resolve to a File Directory.");
                }
            } else {
                this.setOrd(BOrd.DEFAULT);
                throw new BajaRuntimeException("Invalid ORD: " + ord.encodeToString() + ". ORD must resolve to a File Directory.");
            }
        }
        super.changed(property, context);
    }

    public BIcon getIcon() {
        return icon;
    }
}

