/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BWeeklyScheduleRelation
extends BRelationInfo {
    public static final Type TYPE = Sys.loadType(BWeeklyScheduleRelation.class);

    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity entity) {
        if (entity instanceof BWeeklySchedule) {
            BWeeklySchedule schedule = (BWeeklySchedule)entity;
            ArrayList<BControlPoint> points = new ArrayList<BControlPoint>();
            this.findPoints((BComponent)schedule, null, points);
            if (!points.isEmpty()) {
                return Optional.of(new BasicRelation(this.getRelationId(), (Entity)points.get(0), false));
            }
        }
        if (entity instanceof BControlPoint) {
            BControlPoint point = (BControlPoint)entity;
            ArrayList<BWeeklySchedule> schedules = new ArrayList<BWeeklySchedule>();
            this.findSchedules((BComponent)point, schedules);
            if (!schedules.isEmpty()) {
                return Optional.of(new BasicRelation(this.getRelationId(), (Entity)schedules.get(0), true));
            }
        }
        return Optional.empty();
    }

    public void addRelations(Entity entity, Collection<Relation> relations) {
        if (entity instanceof BWeeklySchedule) {
            BWeeklySchedule schedule = (BWeeklySchedule)entity;
            ArrayList<BControlPoint> points = new ArrayList<BControlPoint>();
            this.findPoints((BComponent)schedule, null, points);
            for (BControlPoint point : points) {
                relations.add((Relation)new BasicRelation(this.getRelationId(), (Entity)point, false));
            }
        }
        if (entity instanceof BControlPoint) {
            BControlPoint point = (BControlPoint)entity;
            ArrayList<BWeeklySchedule> schedules = new ArrayList<BWeeklySchedule>();
            this.findSchedules((BComponent)point, schedules);
            for (BWeeklySchedule schedule : schedules) {
                relations.add((Relation)new BasicRelation(this.getRelationId(), (Entity)schedule, true));
            }
        }
    }

    private void findSchedules(BComponent target, List<BWeeklySchedule> schedules) {
        for (BLink link : target.getLinks()) {
            BComponent source = link.getSourceComponent();
            if (source == null) continue;
            if (source instanceof BWeeklySchedule && link.getSourceSlotName().equals("out")) {
                if (schedules.contains((BWeeklySchedule)source)) continue;
                schedules.add((BWeeklySchedule)source);
                continue;
            }
            this.findSchedules(source, schedules);
        }
    }

    private void findPoints(BComponent source, BComponent lastSource, List<BControlPoint> points) {
        for (Knob knob : source.get("out") != null ? source.getKnobs(source.getSlot("out")) : source.getKnobs()) {
            BComponent target = knob.getTargetComponent();
            if (target == null) continue;
            Slot sourceSlot = knob.getSourceSlot();
            boolean composite = false;
            boolean linked = false;
            if ((source.getFlags(sourceSlot) & 0x1000) > 0 && lastSource != null) {
                composite = true;
                for (BLink link : source.getLinks(sourceSlot)) {
                    BComponent prevSource = link.getSourceComponent();
                    if (prevSource == null || !prevSource.equals((Object)lastSource)) continue;
                    linked = true;
                }
            }
            if (composite && !linked) continue;
            this.findPoints(target, source, points);
            if (!(target instanceof BControlPoint) || points.contains((BControlPoint)target)) continue;
            points.add((BControlPoint)target);
        }
    }
}

