/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.point;

import com.tridium.history.audit.BAuditRecord;
import javax.baja.control.BPointExtension;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraProperties(value={@NiagaraProperty(name="user", type="String", defaultValue="", flags=65), @NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="adminUser", type="String", defaultValue="", flags=69), @NiagaraProperty(name="adminTimestamp", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=69), @NiagaraProperty(name="operatorUser", type="String", defaultValue="", flags=69), @NiagaraProperty(name="operatorTimestamp", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=69)})
public class BAuditExt
extends BPointExtension {
    public static final Property user = BAuditExt.newProperty((int)65, (String)"", null);
    public static final Property timestamp = BAuditExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property adminUser = BAuditExt.newProperty((int)69, (String)"", null);
    public static final Property adminTimestamp = BAuditExt.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Property operatorUser = BAuditExt.newProperty((int)69, (String)"", null);
    public static final Property operatorTimestamp = BAuditExt.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAuditExt.class);

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String v) {
        this.setString(user, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public String getAdminUser() {
        return this.getString(adminUser);
    }

    public void setAdminUser(String v) {
        this.setString(adminUser, v, null);
    }

    public BAbsTime getAdminTimestamp() {
        return (BAbsTime)this.get(adminTimestamp);
    }

    public void setAdminTimestamp(BAbsTime v) {
        this.set(adminTimestamp, (BValue)v, null);
    }

    public String getOperatorUser() {
        return this.getString(operatorUser);
    }

    public void setOperatorUser(String v) {
        this.setString(operatorUser, v, null);
    }

    public BAbsTime getOperatorTimestamp() {
        return (BAbsTime)this.get(operatorTimestamp);
    }

    public void setOperatorTimestamp(BAbsTime v) {
        this.set(operatorTimestamp, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void onExecute(BStatusValue out, Context context) {
        this.checkLevel(out.getStatus());
    }

    private void checkLevel(BStatus status) {
        if (status.isOverridden()) {
            String level = status.getFacets().get("activeLevel").toString();
            if (level.length() > 0) {
                if (level.equals("1")) {
                    this.setUser(this.getAdminUser());
                    this.setTimestamp(this.getAdminTimestamp());
                } else if (level.equals("8")) {
                    this.setUser(this.getOperatorUser());
                    this.setTimestamp(this.getOperatorTimestamp());
                } else {
                    this.setUser("");
                    this.setTimestamp(BAbsTime.DEFAULT);
                }
            }
        } else {
            this.setUser("");
            this.setTimestamp(BAbsTime.DEFAULT);
        }
    }

    public void checkRecord(BAuditRecord rec) {
        if (rec.getSlotName().equals("override") || rec.getSlotName().equals("active") || rec.getSlotName().equals("inactive")) {
            this.setOperatorUser(rec.getUserName());
            this.setOperatorTimestamp(rec.getTimestamp());
        } else if (rec.getSlotName().equals("emergencyOverride") || rec.getSlotName().equals("emergencyActive") || rec.getSlotName().equals("emergencyInactive")) {
            this.setAdminUser(rec.getUserName());
            this.setAdminTimestamp(rec.getTimestamp());
        } else if (rec.getSlotName().equals("auto")) {
            this.setOperatorUser("");
            this.setOperatorTimestamp(BAbsTime.DEFAULT);
        } else if (rec.getSlotName().equals("emergencyAuto")) {
            this.setAdminUser("");
            this.setAdminTimestamp(BAbsTime.DEFAULT);
        }
        this.checkLevel(this.getParentPoint().getStatus());
    }
}

