/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BSequencerModeEnum;
import com.vykon.vykonPro.enums.BSequencerOutputEnum;
import com.vykon.vykonPro.hvac.BManualSequencerCmd;
import com.vykon.vykonPro.hvac.BRotationOrder;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRotationalLoadSequencerV1
extends BComponent {
    public static final Property status = BRotationalLoadSequencerV1.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BRotationalLoadSequencerV1.newProperty((int)65, (String)"", null);
    public static final Property facets = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property schedule = BRotationalLoadSequencerV1.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BRotationalLoadSequencerV1.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property stopFailedLoad = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)new BStatusBoolean(false), null);
    public static final Property numberOutputs = BRotationalLoadSequencerV1.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BRotationalLoadSequencerV1.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property rotationOrder = BRotationalLoadSequencerV1.newProperty((int)257, (BValue)new BRotationOrder(), null);
    public static final Property rotateMode = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerModeEnum.TYPE)), null);
    public static final Property rotateInterval = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)BRelTime.makeHours((int)168), null);
    public static final Property feedbackDelay = BRotationalLoadSequencerV1.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property lastRotateTime = BRotationalLoadSequencerV1.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property runtimeRemainingUntilShift = BRotationalLoadSequencerV1.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property leadLoad = BRotationalLoadSequencerV1.newProperty((int)5, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property leadLoadEnum = BRotationalLoadSequencerV1.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE))), null);
    public static final Property leadRuntimeAtStart = BRotationalLoadSequencerV1.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property nextLeadLoad = BRotationalLoadSequencerV1.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE))), null);
    public static final Property outA = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property runtimeA = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeB = BRotationalLoadSequencerV1.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeC = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeD = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeE = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeF = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeG = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeH = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeI = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeJ = BRotationalLoadSequencerV1.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property disabledLoads = BRotationalLoadSequencerV1.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Property debug = BRotationalLoadSequencerV1.newProperty((int)4, (boolean)false, null);
    public static final Action startupTimerExpired = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action rotateTimerExpired = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredA = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredB = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredC = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredD = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredE = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredF = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredG = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredH = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredI = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action feedbackTimerExpiredJ = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action runtimeTimerExpired = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action countdownTimerExpired = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action checkNext = BRotationalLoadSequencerV1.newAction((int)4, null);
    public static final Action disableOutput = BRotationalLoadSequencerV1.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BRotationalLoadSequencerV1.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BRotationalLoadSequencerV1.newAction((int)0, (BValue)new BManualSequencerCmd(), null);
    public static final Action manualRotate = BRotationalLoadSequencerV1.newAction((int)0, null);
    public static final Action resetFailedLoad = BRotationalLoadSequencerV1.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Type TYPE = Sys.loadType(BRotationalLoadSequencerV1.class);
    private static final BIcon icon = BIcon.std((String)"reorder.png");
    int numOutputs;
    int startedLoads;
    boolean feedbackTimerActiveA = false;
    boolean feedbackTimerActiveB = false;
    boolean feedbackTimerActiveC = false;
    boolean feedbackTimerActiveD = false;
    boolean feedbackTimerActiveE = false;
    boolean feedbackTimerActiveF = false;
    boolean feedbackTimerActiveG = false;
    boolean feedbackTimerActiveH = false;
    boolean feedbackTimerActiveI = false;
    boolean feedbackTimerActiveJ = false;
    boolean currentIn;
    boolean wasOn = false;
    boolean isFirst = false;
    Clock.Ticket feedbackTicketA;
    Clock.Ticket feedbackTicketB;
    Clock.Ticket feedbackTicketC;
    Clock.Ticket feedbackTicketD;
    Clock.Ticket feedbackTicketE;
    Clock.Ticket feedbackTicketF;
    Clock.Ticket feedbackTicketG;
    Clock.Ticket feedbackTicketH;
    Clock.Ticket feedbackTicketI;
    Clock.Ticket feedbackTicketJ;
    Clock.Ticket rotateTicket;
    Clock.Ticket startupTicket;
    Clock.Ticket runtimeTicket;
    Clock.Ticket countdownTicket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets v) {
        this.set(actionFacets, (BValue)v, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean v) {
        this.set(schedule, (BValue)v, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean v) {
        this.set(loadFailed, (BValue)v, null);
    }

    public BStatusBoolean getStopFailedLoad() {
        return (BStatusBoolean)this.get(stopFailedLoad);
    }

    public void setStopFailedLoad(BStatusBoolean v) {
        this.set(stopFailedLoad, (BValue)v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int v) {
        this.setInt(requiredLoads, v, null);
    }

    public BRotationOrder getRotationOrder() {
        return (BRotationOrder)this.get(rotationOrder);
    }

    public void setRotationOrder(BRotationOrder v) {
        this.set(rotationOrder, (BValue)v, null);
    }

    public BEnum getRotateMode() {
        return (BEnum)this.get(rotateMode);
    }

    public void setRotateMode(BEnum v) {
        this.set(rotateMode, (BValue)v, null);
    }

    public BRelTime getRotateInterval() {
        return (BRelTime)this.get(rotateInterval);
    }

    public void setRotateInterval(BRelTime v) {
        this.set(rotateInterval, (BValue)v, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    public BAbsTime getLastRotateTime() {
        return (BAbsTime)this.get(lastRotateTime);
    }

    public void setLastRotateTime(BAbsTime v) {
        this.set(lastRotateTime, (BValue)v, null);
    }

    public BRelTime getRuntimeRemainingUntilShift() {
        return (BRelTime)this.get(runtimeRemainingUntilShift);
    }

    public void setRuntimeRemainingUntilShift(BRelTime v) {
        this.set(runtimeRemainingUntilShift, (BValue)v, null);
    }

    public BEnum getLeadLoad() {
        return (BEnum)this.get(leadLoad);
    }

    public void setLeadLoad(BEnum v) {
        this.set(leadLoad, (BValue)v, null);
    }

    public BStatusEnum getLeadLoadEnum() {
        return (BStatusEnum)this.get(leadLoadEnum);
    }

    public void setLeadLoadEnum(BStatusEnum v) {
        this.set(leadLoadEnum, (BValue)v, null);
    }

    public BRelTime getLeadRuntimeAtStart() {
        return (BRelTime)this.get(leadRuntimeAtStart);
    }

    public void setLeadRuntimeAtStart(BRelTime v) {
        this.set(leadRuntimeAtStart, (BValue)v, null);
    }

    public BStatusEnum getNextLeadLoad() {
        return (BStatusEnum)this.get(nextLeadLoad);
    }

    public void setNextLeadLoad(BStatusEnum v) {
        this.set(nextLeadLoad, (BValue)v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean v) {
        this.set(feedbackA, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean v) {
        this.set(feedbackB, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean v) {
        this.set(feedbackC, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean v) {
        this.set(feedbackD, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean v) {
        this.set(feedbackE, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean v) {
        this.set(feedbackF, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean v) {
        this.set(feedbackG, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean v) {
        this.set(feedbackH, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean v) {
        this.set(feedbackI, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean v) {
        this.set(feedbackJ, (BValue)v, null);
    }

    public BRelTime getRuntimeA() {
        return (BRelTime)this.get(runtimeA);
    }

    public void setRuntimeA(BRelTime v) {
        this.set(runtimeA, (BValue)v, null);
    }

    public BRelTime getRuntimeB() {
        return (BRelTime)this.get(runtimeB);
    }

    public void setRuntimeB(BRelTime v) {
        this.set(runtimeB, (BValue)v, null);
    }

    public BRelTime getRuntimeC() {
        return (BRelTime)this.get(runtimeC);
    }

    public void setRuntimeC(BRelTime v) {
        this.set(runtimeC, (BValue)v, null);
    }

    public BRelTime getRuntimeD() {
        return (BRelTime)this.get(runtimeD);
    }

    public void setRuntimeD(BRelTime v) {
        this.set(runtimeD, (BValue)v, null);
    }

    public BRelTime getRuntimeE() {
        return (BRelTime)this.get(runtimeE);
    }

    public void setRuntimeE(BRelTime v) {
        this.set(runtimeE, (BValue)v, null);
    }

    public BRelTime getRuntimeF() {
        return (BRelTime)this.get(runtimeF);
    }

    public void setRuntimeF(BRelTime v) {
        this.set(runtimeF, (BValue)v, null);
    }

    public BRelTime getRuntimeG() {
        return (BRelTime)this.get(runtimeG);
    }

    public void setRuntimeG(BRelTime v) {
        this.set(runtimeG, (BValue)v, null);
    }

    public BRelTime getRuntimeH() {
        return (BRelTime)this.get(runtimeH);
    }

    public void setRuntimeH(BRelTime v) {
        this.set(runtimeH, (BValue)v, null);
    }

    public BRelTime getRuntimeI() {
        return (BRelTime)this.get(runtimeI);
    }

    public void setRuntimeI(BRelTime v) {
        this.set(runtimeI, (BValue)v, null);
    }

    public BRelTime getRuntimeJ() {
        return (BRelTime)this.get(runtimeJ);
    }

    public void setRuntimeJ(BRelTime v) {
        this.set(runtimeJ, (BValue)v, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString v) {
        this.set(disabledLoads, (BValue)v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void feedbackTimerExpiredA() {
        this.invoke(feedbackTimerExpiredA, null, null);
    }

    public void feedbackTimerExpiredB() {
        this.invoke(feedbackTimerExpiredB, null, null);
    }

    public void feedbackTimerExpiredC() {
        this.invoke(feedbackTimerExpiredC, null, null);
    }

    public void feedbackTimerExpiredD() {
        this.invoke(feedbackTimerExpiredD, null, null);
    }

    public void feedbackTimerExpiredE() {
        this.invoke(feedbackTimerExpiredE, null, null);
    }

    public void feedbackTimerExpiredF() {
        this.invoke(feedbackTimerExpiredF, null, null);
    }

    public void feedbackTimerExpiredG() {
        this.invoke(feedbackTimerExpiredG, null, null);
    }

    public void feedbackTimerExpiredH() {
        this.invoke(feedbackTimerExpiredH, null, null);
    }

    public void feedbackTimerExpiredI() {
        this.invoke(feedbackTimerExpiredI, null, null);
    }

    public void feedbackTimerExpiredJ() {
        this.invoke(feedbackTimerExpiredJ, null, null);
    }

    public void runtimeTimerExpired() {
        this.invoke(runtimeTimerExpired, null, null);
    }

    public void countdownTimerExpired() {
        this.invoke(countdownTimerExpired, null, null);
    }

    public void checkNext() {
        this.invoke(checkNext, null, null);
    }

    public void disableOutput(BEnum output) {
        this.invoke(disableOutput, (BValue)output, null);
    }

    public void enableOutput(BEnum output) {
        this.invoke(enableOutput, (BValue)output, null);
    }

    public void manualCmd(BManualSequencerCmd manCmd) {
        this.invoke(manualCmd, (BValue)manCmd, null);
    }

    public void manualRotate() {
        this.invoke(manualRotate, null, null);
    }

    public void resetFailedLoad(BEnum output) {
        this.invoke(resetFailedLoad, (BValue)output, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
        this.numOutputs = this.getNumberOutputs();
        this.initNumberOutputs();
    }

    public void stopped() {
        this.cancelFeedbackTickets();
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
    }

    private void cancelFeedbackTickets() {
        if (this.feedbackTicketA != null) {
            this.feedbackTicketA.cancel();
        }
        if (this.feedbackTicketB != null) {
            this.feedbackTicketB.cancel();
        }
        if (this.feedbackTicketC != null) {
            this.feedbackTicketC.cancel();
        }
        if (this.feedbackTicketD != null) {
            this.feedbackTicketD.cancel();
        }
        if (this.feedbackTicketE != null) {
            this.feedbackTicketE.cancel();
        }
        if (this.feedbackTicketF != null) {
            this.feedbackTicketF.cancel();
        }
        if (this.feedbackTicketG != null) {
            this.feedbackTicketG.cancel();
        }
        if (this.feedbackTicketH != null) {
            this.feedbackTicketH.cancel();
        }
        if (this.feedbackTicketI != null) {
            this.feedbackTicketI.cancel();
        }
        if (this.feedbackTicketJ != null) {
            this.feedbackTicketJ.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (p == numberOutputs) {
            this.initNumberOutputs();
        } else if (p == schedule) {
            this.calculate();
        } else if (p == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.startOutput();
            }
        } else if (p == feedbackA || p == feedbackB || p == feedbackC || p == feedbackD || p == feedbackE || p == feedbackF || p == feedbackG || p == feedbackH || p == feedbackI || p == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            this.checkRunningStatus();
        } else if (p == rotateMode) {
            int mode = this.getRotateMode().getOrdinal();
            switch (mode) {
                case 2: {
                    BRelTime currentRT = BRelTime.make((long)this.getRuntime(this.getLeadLoad().getEnum().getOrdinal()));
                    this.setLeadRuntimeAtStart(currentRT);
                    this.setRuntimeRemainingUntilShift(this.getRotateInterval());
                    this.startRuntimeTimer();
                    if (this.rotateTicket == null) break;
                    this.rotateTicket.cancel();
                    break;
                }
                case 1: {
                    this.startRotateTimer();
                    if (this.runtimeTicket == null) break;
                    this.runtimeTicket.cancel();
                    break;
                }
                case 0: {
                    this.startCountdownTimer();
                    if (this.rotateTicket != null) {
                        this.rotateTicket.cancel();
                    }
                    if (this.runtimeTicket == null) break;
                    this.runtimeTicket.cancel();
                }
            }
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        boolean used = false;
        for (int i = 0; i < 10; ++i) {
            int setFlags;
            if (i >= this.numOutputs) {
                setFlags = 6;
                used = false;
            } else {
                setFlags = 10;
                used = true;
            }
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    this.initSlot("runtimeA", setFlags);
                    this.initSlot("feedbackA", setFlags);
                    this.initLoads("outA", used, 1);
                    break;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    this.initSlot("runtimeB", setFlags);
                    this.initSlot("feedbackB", setFlags);
                    this.initLoads("outB", used, 2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    this.initSlot("runtimeC", setFlags);
                    this.initSlot("feedbackC", setFlags);
                    this.initLoads("outC", used, 3);
                    break;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    this.initSlot("runtimeD", setFlags);
                    this.initSlot("feedbackD", setFlags);
                    this.initLoads("outD", used, 4);
                    break;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    this.initSlot("runtimeE", setFlags);
                    this.initSlot("feedbackE", setFlags);
                    this.initLoads("outE", used, 5);
                    break;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    this.initSlot("runtimeF", setFlags);
                    this.initSlot("feedbackF", setFlags);
                    this.initLoads("outF", used, 6);
                    break;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    this.initSlot("runtimeG", setFlags);
                    this.initSlot("feedbackG", setFlags);
                    this.initLoads("outG", used, 7);
                    break;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    this.initSlot("runtimeH", setFlags);
                    this.initSlot("feedbackH", setFlags);
                    this.initLoads("outH", used, 8);
                    break;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    this.initSlot("runtimeI", setFlags);
                    this.initSlot("feedbackI", setFlags);
                    this.initLoads("outI", used, 9);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                    this.initSlot("runtimeJ", setFlags);
                    this.initSlot("feedbackJ", setFlags);
                    this.initLoads("outJ", used, 10);
                }
            }
            int[] disabledLoads = this.getDisabledLoads().getOrdinals();
            for (int k = 0; k < disabledLoads.length; ++k) {
                if (!this.getDisabledLoads().getBit(disabledLoads[k])) continue;
                String loadName = this.getDisabledLoads().getTag(disabledLoads[k]);
                ((BStatusBoolean)this.get(loadName)).setStatusDisabled(true);
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initLoads(String name, boolean used, int value) {
        int setFlags = 5;
        BRotationOrder ro = this.getRotationOrder();
        if (used) {
            if (ro.get(name) == null) {
                ro.add(name, (BValue)BInteger.make((int)value));
                ro.setFlags(ro.getSlot(name), setFlags);
            }
        } else if (ro.get(name) != null) {
            ro.remove(name);
        }
    }

    public void doStartupTimerExpired() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.calculate();
    }

    public void doCountdownTimerExpired() {
        BAbsTime nextTime;
        BAbsTime currentTime = Clock.time();
        BRelTime timeLeft = currentTime.delta(nextTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (timeLeft.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(timeLeft);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
        }
    }

    public void doRotateTimerExpired() {
        BAbsTime nextTime;
        BAbsTime currentTime = Clock.time();
        BRelTime timeLeft = currentTime.delta(nextTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (timeLeft.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(timeLeft);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
            this.rotateLead();
            this.startOutput();
        }
    }

    public void doFeedbackTimerExpiredA() {
        this.feedbackTimerActiveA = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredB() {
        this.feedbackTimerActiveB = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredC() {
        this.feedbackTimerActiveC = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredD() {
        this.feedbackTimerActiveD = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredE() {
        this.feedbackTimerActiveE = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredF() {
        this.feedbackTimerActiveF = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredG() {
        this.feedbackTimerActiveG = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredH() {
        this.feedbackTimerActiveH = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredI() {
        this.feedbackTimerActiveI = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doFeedbackTimerExpiredJ() {
        this.feedbackTimerActiveJ = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doRuntimeTimerExpired() {
        long startRT;
        long currentRT = this.getRuntime(this.getLeadLoad().getEnum().getOrdinal());
        long actualRT = currentRT - (startRT = this.getLeadRuntimeAtStart().getMillis());
        if (actualRT > 0L) {
            long timeLeft = this.getRotateInterval().getMillis() - actualRT;
            if (timeLeft > 1000L) {
                this.setRuntimeRemainingUntilShift(BRelTime.make((long)timeLeft));
            } else {
                this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
                this.rotateLead();
                this.startOutput();
            }
        }
    }

    public void doManualRotate() {
        this.rotateLead();
        if (this.currentIn) {
            this.startOutput();
        } else {
            this.checkNext();
        }
    }

    public void doDisableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        this.getStatusOutput(outNmbr).setStatusDisabled(true);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
        this.startOutput();
    }

    public void doEnableOutput(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        this.getStatusOutput(outNmbr).setStatusDisabled(false);
        int loadBit = this.getLoadBit(outNmbr);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
        this.startOutput();
    }

    public void doResetFailedLoad(BEnum output) {
        int outNmbr = output.getEnum().getOrdinal();
        this.getStatusOutput(outNmbr).setStatusInAlarm(false);
        if (this.checkFailed() == 0) {
            this.getLoadFailed().setValue(false);
        }
        this.startOutput();
    }

    public void doManualCmd(BManualSequencerCmd manCmd) {
        int outNmbr = manCmd.getOutput().getOrdinal();
        if (manCmd.getCommand()) {
            this.getStatusOutput(outNmbr).setStatusDisabled(true);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | loadBit));
        } else {
            this.getStatusOutput(outNmbr).setStatusDisabled(false);
            int loadBit = this.getLoadBit(outNmbr);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~loadBit));
        }
        this.startOutput();
    }

    public void doCheckNext() {
        this.checkNextLoad();
    }

    void calculate() {
        this.currentIn = this.getSchedule().getValue();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                if (this.getRotateMode().getOrdinal() == 1) {
                    this.startRotateTimer();
                } else if (this.getRotateMode().getOrdinal() == 2) {
                    this.startRuntimeTimer();
                } else {
                    this.startCountdownTimer();
                }
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.countdownTicket != null) {
                    this.countdownTicket.cancel();
                }
                if (this.runtimeTicket != null) {
                    this.runtimeTicket.cancel();
                }
                this.cancelFeedbackTickets();
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    private void rotateLead() {
        int p;
        BRotationOrder ro = this.getRotationOrder();
        String lead1 = this.getLeadLoad().getTag();
        lead1 = lead1.substring(lead1.length() - 1);
        String current = ro.getOrder();
        String[] loads = TextUtil.splitAndTrim((String)current, (char)',');
        boolean shifted = false;
        boolean next = false;
        for (int b = 0; b < loads.length; ++b) {
            if (next && this.getOutStatus(p = ((BInteger)ro.get("out" + loads[b])).getInt())) {
                this.setLeadLoad((BEnum)BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                this.getLeadLoadEnum().setValue(BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                shifted = true;
                break;
            }
            if (!lead1.equals(loads[b])) continue;
            next = true;
        }
        if (!shifted && next) {
            for (int c = 0; c < loads.length && !lead1.equals(loads[c]); ++c) {
                p = ((BInteger)ro.get("out" + loads[c])).getInt();
                if (!this.getOutStatus(p)) continue;
                this.setLeadLoad((BEnum)BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                this.getLeadLoadEnum().setValue(BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                shifted = true;
                break;
            }
        }
        if (shifted) {
            this.startOutput();
            this.setLastRotateTime(Clock.time());
            BRelTime currentRT = BRelTime.make((long)this.getRuntime(this.getLeadLoad().getEnum().getOrdinal()));
            this.setLeadRuntimeAtStart(currentRT);
            this.setRuntimeRemainingUntilShift(this.getRotateInterval());
            if (this.getStatus().isFault()) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)false));
                this.setFaultCause("");
            }
        } else {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)true));
            this.setFaultCause("There are no loads available to rotate the lead load at - " + Clock.time());
        }
    }

    private void checkNextLoad() {
        int p;
        boolean nextAvail = false;
        boolean next = false;
        BRotationOrder ro = this.getRotationOrder();
        String lead1 = this.getLeadLoad().getTag();
        lead1 = lead1.substring(lead1.length() - 1);
        String current = ro.getOrder();
        String[] loads = TextUtil.splitAndTrim((String)current, (char)',');
        for (int b = 0; b < loads.length; ++b) {
            if (next && this.getOutStatus(p = ((BInteger)ro.get("out" + loads[b])).getInt())) {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                nextAvail = true;
                break;
            }
            if (!lead1.equals(loads[b])) continue;
            next = true;
        }
        if (!nextAvail && next) {
            for (int c = 0; c < loads.length && !lead1.equals(loads[c]); ++c) {
                p = ((BInteger)ro.get("out" + loads[c])).getInt();
                if (!this.getOutStatus(p)) continue;
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)p, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                nextAvail = true;
                break;
            }
        }
    }

    long getRuntime(int index) {
        switch (index) {
            case 1: {
                return this.getRuntimeA().getMillis();
            }
            case 2: {
                return this.getRuntimeB().getMillis();
            }
            case 3: {
                return this.getRuntimeC().getMillis();
            }
            case 4: {
                return this.getRuntimeD().getMillis();
            }
            case 5: {
                return this.getRuntimeE().getMillis();
            }
            case 6: {
                return this.getRuntimeF().getMillis();
            }
            case 7: {
                return this.getRuntimeG().getMillis();
            }
            case 8: {
                return this.getRuntimeH().getMillis();
            }
            case 9: {
                return this.getRuntimeI().getMillis();
            }
            case 10: {
                return this.getRuntimeJ().getMillis();
            }
        }
        return Long.MAX_VALUE;
    }

    boolean getOutValue(int index) {
        switch (index) {
            case 1: {
                return this.getOutA().getValue();
            }
            case 2: {
                return this.getOutB().getValue();
            }
            case 3: {
                return this.getOutC().getValue();
            }
            case 4: {
                return this.getOutD().getValue();
            }
            case 5: {
                return this.getOutE().getValue();
            }
            case 6: {
                return this.getOutF().getValue();
            }
            case 7: {
                return this.getOutG().getValue();
            }
            case 8: {
                return this.getOutH().getValue();
            }
            case 9: {
                return this.getOutI().getValue();
            }
            case 10: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getOutStatus(int index) {
        switch (index) {
            case 1: {
                return this.getOutA().getStatus().isOk();
            }
            case 2: {
                return this.getOutB().getStatus().isOk();
            }
            case 3: {
                return this.getOutC().getStatus().isOk();
            }
            case 4: {
                return this.getOutD().getStatus().isOk();
            }
            case 5: {
                return this.getOutE().getStatus().isOk();
            }
            case 6: {
                return this.getOutF().getStatus().isOk();
            }
            case 7: {
                return this.getOutG().getStatus().isOk();
            }
            case 8: {
                return this.getOutH().getStatus().isOk();
            }
            case 9: {
                return this.getOutI().getStatus().isOk();
            }
            case 10: {
                return this.getOutJ().getStatus().isOk();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int index) {
        switch (index) {
            case 1: {
                return this.getFeedbackA().getValue();
            }
            case 2: {
                return this.getFeedbackB().getValue();
            }
            case 3: {
                return this.getFeedbackC().getValue();
            }
            case 4: {
                return this.getFeedbackD().getValue();
            }
            case 5: {
                return this.getFeedbackE().getValue();
            }
            case 6: {
                return this.getFeedbackF().getValue();
            }
            case 7: {
                return this.getFeedbackG().getValue();
            }
            case 8: {
                return this.getFeedbackH().getValue();
            }
            case 9: {
                return this.getFeedbackI().getValue();
            }
            case 10: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    void startOutput() {
        int id;
        int k;
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + " - running start output");
        }
        if (!this.getSchedule().getValue()) {
            return;
        }
        int lead = this.getLeadLoad().getEnum().getOrdinal();
        int req = this.getRequiredLoads();
        int started = 0;
        BRotationOrder ro = this.getRotationOrder();
        String current = ro.getOrder();
        String[] loads = TextUtil.splitAndTrim((String)current, (char)',');
        boolean leadStarted = false;
        if (this.getDebug()) {
            System.out.println("lead load is " + lead + " , required loads " + req);
        }
        for (k = 0; k < loads.length; ++k) {
            if (ro.get("out" + loads[k]) == null) continue;
            id = ((BInteger)ro.get("out" + loads[k])).getInt();
            if (id == lead) {
                leadStarted = true;
                if (started < req && this.getStatusOutput(lead).getStatus().isOk()) {
                    if (!this.getStatusOutput(lead).getValue()) {
                        this.getStatusOutput(lead).setValue(true);
                        this.startFeedbackTimer(lead);
                    }
                    ++started;
                    if (!this.getDebug()) continue;
                    System.out.println("checked lead load, started " + started);
                    continue;
                }
                if (this.getRequiredLoads() == 0) {
                    this.getStatusOutput(lead).setValue(false);
                }
                if (!this.getDebug()) continue;
                System.out.println("checking " + loads[k] + " , enough loads already started");
                continue;
            }
            if (id != lead && leadStarted && started < req) {
                if (!this.getStatusOutput(id).getStatus().isOk()) continue;
                if (!this.getStatusOutput(id).getValue()) {
                    this.getStatusOutput(id).setValue(true);
                    this.startFeedbackTimer(id);
                }
                ++started;
                if (!this.getDebug()) continue;
                System.out.println("checked lead load, started " + started);
                continue;
            }
            if (started != req) continue;
            this.getStatusOutput(id).setValue(false);
            if (!this.getDebug()) continue;
            System.out.println("checking " + loads[k] + " , enough loads already started");
        }
        for (k = 0; k < loads.length; ++k) {
            if (ro.get("out" + loads[k]) == null) continue;
            id = ((BInteger)ro.get("out" + loads[k])).getInt();
            if (id == lead) break;
            if (started < req) {
                if (!this.getStatusOutput(id).getStatus().isOk()) continue;
                if (!this.getStatusOutput(id).getValue()) {
                    this.getStatusOutput(id).setValue(true);
                    this.startFeedbackTimer(id);
                }
                ++started;
                if (!this.getDebug()) continue;
                System.out.println("checked lead load, started " + started);
                continue;
            }
            if (started != req) continue;
            this.getStatusOutput(id).setValue(false);
            if (!this.getDebug()) continue;
            System.out.println("checking " + loads[k] + " , enough loads already started");
        }
        if (started < req) {
            if (this.getDebug()) {
                System.out.println("didn't start the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)true));
            this.setFaultCause("Not enough loads available to start the required number!");
        } else {
            if (this.getDebug()) {
                System.out.println("started the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
            if (!this.getStatus().isFault()) {
                this.setFaultCause("");
            }
        }
        this.checkNextLoad();
    }

    BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 1: {
                return this.getOutA();
            }
            case 2: {
                return this.getOutB();
            }
            case 3: {
                return this.getOutC();
            }
            case 4: {
                return this.getOutD();
            }
            case 5: {
                return this.getOutE();
            }
            case 6: {
                return this.getOutF();
            }
            case 7: {
                return this.getOutG();
            }
            case 8: {
                return this.getOutH();
            }
            case 9: {
                return this.getOutI();
            }
            case 10: {
                return this.getOutJ();
            }
        }
        if (index < 1) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    private int checkFailed() {
        int failed = 0;
        for (int i = 1; i <= this.getNumberOutputs(); ++i) {
            BStatusBoolean out = this.getStatusOutput(i);
            if (!out.getStatus().isAlarm()) continue;
            ++failed;
        }
        return failed;
    }

    void stopOutput() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + " stopping outputs");
        }
        for (int i = 1; i <= this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
        }
        this.checkRunningStatus();
    }

    void startCountdownTimer() {
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.countdownTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)countdownTimerExpired, null);
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer(int timer) {
        switch (timer) {
            case 1: {
                if (this.feedbackTicketA != null) {
                    this.feedbackTicketA.cancel();
                }
                this.feedbackTimerActiveA = true;
                this.feedbackTicketA = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredA, null);
            }
            case 2: {
                if (this.feedbackTicketB != null) {
                    this.feedbackTicketB.cancel();
                }
                this.feedbackTimerActiveB = true;
                this.feedbackTicketB = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredB, null);
            }
            case 3: {
                if (this.feedbackTicketC != null) {
                    this.feedbackTicketC.cancel();
                }
                this.feedbackTimerActiveC = true;
                this.feedbackTicketC = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredC, null);
            }
            case 4: {
                if (this.feedbackTicketD != null) {
                    this.feedbackTicketD.cancel();
                }
                this.feedbackTimerActiveD = true;
                this.feedbackTicketD = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredD, null);
            }
            case 5: {
                if (this.feedbackTicketE != null) {
                    this.feedbackTicketE.cancel();
                }
                this.feedbackTimerActiveE = true;
                this.feedbackTicketE = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredE, null);
            }
            case 6: {
                if (this.feedbackTicketF != null) {
                    this.feedbackTicketF.cancel();
                }
                this.feedbackTimerActiveF = true;
                this.feedbackTicketF = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredF, null);
            }
            case 7: {
                if (this.feedbackTicketG != null) {
                    this.feedbackTicketG.cancel();
                }
                this.feedbackTimerActiveG = true;
                this.feedbackTicketG = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredG, null);
            }
            case 8: {
                if (this.feedbackTicketH != null) {
                    this.feedbackTicketH.cancel();
                }
                this.feedbackTimerActiveH = true;
                this.feedbackTicketH = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredH, null);
            }
            case 9: {
                if (this.feedbackTicketI != null) {
                    this.feedbackTicketI.cancel();
                }
                this.feedbackTimerActiveI = true;
                this.feedbackTicketI = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredI, null);
            }
            case 10: {
                if (this.feedbackTicketJ != null) {
                    this.feedbackTicketJ.cancel();
                }
                this.feedbackTimerActiveJ = true;
                this.feedbackTicketJ = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpiredJ, null);
            }
        }
    }

    void startRuntimeTimer() {
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
        this.runtimeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)runtimeTimerExpired, null);
    }

    void checkRunningStatus() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + "checking running status");
        }
        this.startedLoads = 0;
        boolean isFailed = false;
        for (int i = 1; i <= this.numOutputs; ++i) {
            BStatusBoolean out = this.getStatusOutput(i);
            boolean feedback = this.getFeedbackValue(i);
            if (this.getDebug()) {
                System.out.println("load " + i + " out - " + out.getValue() + " | feedback - " + feedback);
            }
            if (this.getFeedbackTimer(i) || out.getStatus().isAlarm()) continue;
            if (out.getValue() && !feedback) {
                out.setStatusInAlarm(true);
                isFailed = true;
                ++this.startedLoads;
                if (!this.getStopFailedLoad().getValue()) continue;
                out.setValue(false);
                continue;
            }
            if (!out.getValue() || !feedback) continue;
            ++this.startedLoads;
        }
        if (isFailed) {
            this.getLoadFailed().setValue(true);
        }
        if (isFailed || this.startedLoads > this.getRequiredLoads()) {
            if (this.getDebug()) {
                System.out.println(this.startedLoads + " loads started, " + this.getRequiredLoads() + " loads required, or a load is failed");
            }
            this.startOutput();
        }
    }

    private boolean getFeedbackTimer(int ordinal) {
        switch (ordinal) {
            case 1: {
                return this.feedbackTimerActiveA;
            }
            case 2: {
                return this.feedbackTimerActiveB;
            }
            case 3: {
                return this.feedbackTimerActiveC;
            }
            case 4: {
                return this.feedbackTimerActiveD;
            }
            case 5: {
                return this.feedbackTimerActiveE;
            }
            case 6: {
                return this.feedbackTimerActiveF;
            }
            case 7: {
                return this.feedbackTimerActiveG;
            }
            case 8: {
                return this.feedbackTimerActiveH;
            }
            case 9: {
                return this.feedbackTimerActiveI;
            }
            case 10: {
                return this.feedbackTimerActiveJ;
            }
        }
        return false;
    }

    private int getLoadBit(int ordinal) {
        int loadBit = 0;
        switch (ordinal) {
            case 1: {
                loadBit = 1;
                break;
            }
            case 2: {
                loadBit = 2;
                break;
            }
            case 3: {
                loadBit = 4;
                break;
            }
            case 4: {
                loadBit = 8;
                break;
            }
            case 5: {
                loadBit = 16;
                break;
            }
            case 6: {
                loadBit = 32;
                break;
            }
            case 7: {
                loadBit = 48;
                break;
            }
            case 8: {
                loadBit = 64;
                break;
            }
            case 9: {
                loadBit = 128;
                break;
            }
            case 10: {
                loadBit = 512;
            }
        }
        return loadBit;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput" || slot.getName() == "resetFailedLoad") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

