/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.hvac.BMinMaxAvgBql;
import com.vykon.vykonPro.hvac.BZoneInfo;
import com.vykon.vykonPro.hvac.BZoneListExt;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMinMaxAvgBqlWithLimits
extends BMinMaxAvgBql {
    public static final Property upperLimit = BMinMaxAvgBqlWithLimits.newProperty((int)256, (BValue)new BStatusNumeric(80.0), null);
    public static final Property lowerLimit = BMinMaxAvgBqlWithLimits.newProperty((int)256, (BValue)new BStatusNumeric(60.0), null);
    public static final Property excludeValues = BMinMaxAvgBqlWithLimits.newProperty((int)256, (boolean)false, (BFacets)BFacets.makeBoolean((String)"exclude values", (String)"include values"));
    public static final Property outOfRangeZones = BMinMaxAvgBqlWithLimits.newProperty((int)1, (BValue)new BZoneListExt(), null);
    public static final Type TYPE = Sys.loadType(BMinMaxAvgBqlWithLimits.class);
    BComponent zoneExt = null;
    BMinMaxAvgBql.MySub sub = null;

    public BStatusNumeric getUpperLimit() {
        return (BStatusNumeric)this.get(upperLimit);
    }

    public void setUpperLimit(BStatusNumeric v) {
        this.set(upperLimit, (BValue)v, null);
    }

    public BStatusNumeric getLowerLimit() {
        return (BStatusNumeric)this.get(lowerLimit);
    }

    public void setLowerLimit(BStatusNumeric v) {
        this.set(lowerLimit, (BValue)v, null);
    }

    public boolean getExcludeValues() {
        return this.getBoolean(excludeValues);
    }

    public void setExcludeValues(boolean v) {
        this.setBoolean(excludeValues, v, null);
    }

    public BZoneListExt getOutOfRangeZones() {
        return (BZoneListExt)this.get(outOfRangeZones);
    }

    public void setOutOfRangeZones(BZoneListExt v) {
        this.set(outOfRangeZones, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        this.zoneExt = this.getOutOfRangeZones();
        this.sub = new BMinMaxAvgBql.MySub(this);
        super.started();
    }

    @Override
    public void stopped() {
        super.stopped();
        if (this.sub != null) {
            this.sub.unsubscribeAll();
            this.sub = null;
        }
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)upperLimit) || slot.equals((Object)lowerLimit)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            BAbsTime current = Clock.time();
            if (this.ticket == null || this.getNextRefreshTime().isBefore(current)) {
                this.refreshQuery();
                this.initClockTicket();
            }
            return;
        }
        int num = 0;
        double avg = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        String minZ = "";
        String maxZ = "";
        int validCount = 0;
        int oorCount = 0;
        double upper = this.getUpperLimit().getValue();
        double lower = this.getLowerLimit().getValue();
        BOrd hypOrd = ((BZoneListExt)this.zoneExt).getHyperlink();
        this.initCalcTicket();
        for (int i = 0; i < this.myComps.size(); ++i) {
            BStatusNumeric n;
            BComponent comp = (BComponent)this.myComps.get(i);
            if (comp.get("out") == null || !comp.get("out").getType().is(BStatusNumeric.TYPE)) continue;
            if (!comp.isSubscribed()) {
                this.sub.subscribe(comp);
            }
            if (!(n = (BStatusNumeric)comp.get("out")).getStatus().isValid() || BDouble.make((double)n.getValue()) == BDouble.NaN) continue;
            double nValue = n.getValue();
            ++validCount;
            String name = this.getZoneIdentifierFormat().format((Object)comp);
            String compName = SlotPath.escape((String)(name + "_" + comp.getName()));
            if (nValue < lower || nValue > upper) {
                ++oorCount;
                if (this.zoneExt.get(compName) == null) {
                    BOrd nord = BOrd.make((String)("station:|" + comp.getSlotPathOrd()));
                    if (hypOrd != BOrd.NULL && hypOrd != BOrd.DEFAULT) {
                        nord = BOrd.make((BOrd)nord, (BOrd)hypOrd).normalize();
                    }
                    BZoneInfo zi = new BZoneInfo(name, (BStatusNumeric)n.newCopy(), nord, this.getFacets());
                    this.zoneExt.add(compName, (BValue)zi, 2);
                } else {
                    BZoneInfo zi = (BZoneInfo)this.zoneExt.get(compName);
                    zi.setOut((BStatusNumeric)n.newCopy());
                }
            } else if (this.zoneExt.get(compName) != null) {
                this.zoneExt.remove(compName);
            }
            if (this.getExcludeValues() && (nValue < lower || nValue > upper)) continue;
            if (nValue < min) {
                min = nValue;
                minZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            if (nValue > max) {
                max = nValue;
                maxZ = this.getZoneIdentifierFormat().format((Object)comp);
            }
            avg += nValue;
            ++num;
        }
        this.getMinZoneIdentifier().setValue(minZ);
        this.getMaxZoneIdentifier().setValue(maxZ);
        if (min == Double.POSITIVE_INFINITY) {
            min = Double.NaN;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            min = Double.NaN;
        }
        if (num != 0) {
            this.getSum().setValue(avg);
            this.getAvg().setValue(avg / (double)num);
            if (this.getAvg().getStatus().isNull()) {
                this.getAvg().setStatus(BStatus.ok);
            }
            if (this.getSum().getStatus().isNull()) {
                this.getSum().setStatus(BStatus.ok);
            }
        } else {
            this.getSum().setStatus(64);
            this.getAvg().setStatus(64);
        }
        this.setCount(num);
        this.getMin().setValue(min);
        this.getMax().setValue(max);
        String s = oorCount + " of " + validCount + " zones out of range";
        this.zoneExt.set(this.zoneExt.getProperty("out"), (BValue)BString.make((String)s));
    }

    @Override
    public void doRefreshQuery() {
        this.result = (BITable)this.getPointQuery().resolve((BObject)this).get();
        this.myComps = new ArrayList();
        this.zoneExt.removeAll();
        this.setNextRefreshTime(this.getNextRefreshTime().add(this.getRefreshQueryInterval()));
        int count = 0;
        try (TableCursor c = this.result.cursor();){
            while (c.next()) {
                ++count;
                this.myComps.add((BComponent)c.get());
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " - error trying to refresh the query");
            System.out.println(e);
        }
        this.setNumberOfPoints(count);
    }
}

