/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.tridium.history.BNumeric64BitTrendRecord;
import java.io.IOException;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.BTrendRecord;
import javax.baja.history.ext.BNumericIntervalHistoryExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericIntervalDeltaHistoryExt
extends BNumericIntervalHistoryExt {
    public static final Property deltaLogging = BNumericIntervalDeltaHistoryExt.newProperty((int)256, (boolean)false, null);
    public static final Property useRollover = BNumericIntervalDeltaHistoryExt.newProperty((int)256, (boolean)true, null);
    public static final Property initialized = BNumericIntervalDeltaHistoryExt.newProperty((int)69, (boolean)false, null);
    public static final Property lastCurrent = BNumericIntervalDeltaHistoryExt.newProperty((int)69, (int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericIntervalDeltaHistoryExt.class);
    private BNumericTrendRecord rec;

    public boolean getDeltaLogging() {
        return this.getBoolean(deltaLogging);
    }

    public void setDeltaLogging(boolean v) {
        this.setBoolean(deltaLogging, v, null);
    }

    public boolean getUseRollover() {
        return this.getBoolean(useRollover);
    }

    public void setUseRollover(boolean v) {
        this.setBoolean(useRollover, v, null);
    }

    public boolean getInitialized() {
        return this.getBoolean(initialized);
    }

    public void setInitialized(boolean v) {
        this.setBoolean(initialized, v, null);
    }

    public double getLastCurrent() {
        return this.getDouble(lastCurrent);
    }

    public void setLastCurrent(double v) {
        this.setDouble(lastCurrent, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        double current;
        super.started();
        this.rec = this.getPrecision() == 64 ? new BNumeric64BitTrendRecord() : new BNumericTrendRecord();
        if (!(this.getInitialized() || Double.isInfinite(current = ((BStatusNumeric)this.getParentPoint().getStatusValue()).getValue()) || Double.isNaN(current))) {
            this.setLastCurrent(((BStatusNumeric)this.getParentPoint().getStatusValue()).getValue());
            this.setInitialized(true);
        }
    }

    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        double current = ((BStatusNumeric)out).getValue();
        if (this.getDeltaLogging()) {
            if (!Double.isInfinite(current) && !Double.isNaN(current)) {
                double delta = current - this.getLastCurrent();
                if (this.getUseRollover()) {
                    BRolloverValue maxrv = this.getMaxRolloverValue();
                    BRolloverValue minrv = this.getMinRolloverValue();
                    if (!maxrv.getUnspecified()) {
                        double minValue = 0.0;
                        if (!minrv.getUnspecified()) {
                            minValue = minrv.getValue();
                        }
                        if (current < this.getLastCurrent()) {
                            delta = maxrv.getValue() - this.getLastCurrent() + (current - minValue) + 1.0;
                        }
                    }
                }
                this.setLastCurrent(current);
                this.append((BTrendRecord)this.rec.set(timestamp, delta, ((BStatusNumeric)out).getStatus()));
            }
        } else {
            if (!Double.isInfinite(current) && !Double.isNaN(current)) {
                this.setLastCurrent(current);
            }
            this.append((BTrendRecord)this.rec.set(timestamp, ((BStatusNumeric)out).getValue(), ((BStatusNumeric)out).getStatus()));
        }
    }
}

