/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.enums.BDateModeEnum;
import com.vykon.vykonPro.util.BVykonProService;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendFlags;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BNumericHistoryAnalysis
extends BComponent {
    public static final Property status = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNumericHistoryAnalysis.newProperty((int)65, (String)"", null);
    public static final Property historyName = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%/%parent.name%"), null);
    public static final Property historyOrd = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BOrd.DEFAULT, null);
    public static final Property historyInterval = BNumericHistoryAnalysis.newProperty((int)69, (BValue)BRelTime.DEFAULT, null);
    public static final Property facets = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property deltaLogged = BNumericHistoryAnalysis.newProperty((int)0, (boolean)false, null);
    public static final Property excludeInvalidValues = BNumericHistoryAnalysis.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property excludeHiddenValues = BNumericHistoryAnalysis.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property dateMode = BNumericHistoryAnalysis.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BDateModeEnum.TYPE)), null);
    public static final Property billingCycleStartDay = BNumericHistoryAnalysis.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)28));
    public static final Property executePeriod = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property calculating = BNumericHistoryAnalysis.newProperty((int)67, (boolean)false, null);
    public static final Property nextUpdateTime = BNumericHistoryAnalysis.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property lastUpdateTime = BNumericHistoryAnalysis.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property currentHourTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property debug = BNumericHistoryAnalysis.newProperty((int)68, (boolean)false, null);
    public static final Action calculate = BNumericHistoryAnalysis.newAction((int)0, null);
    public static final Action reset = BNumericHistoryAnalysis.newAction((int)0, null);
    public static final Action query = BNumericHistoryAnalysis.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNumericHistoryAnalysis.class);
    private static final BIcon icon = BIcon.std((String)"historyDatabase.png");
    private boolean serviceFound = false;
    private String serviceFault = "vykonPro service fault";
    private boolean ordOkay = false;
    private String ordFault = "historyOrd fault";
    Clock.Ticket ticket = null;
    BAbsTime now = null;
    BAbsTime firstOfMonth = null;
    BAbsTime firstOfYear = null;
    BOrd lastOrd = null;
    double min = 0.0;
    double max = 0.0;
    double total = 0.0;
    double records = 0.0;
    double avg = 0.0;
    int day = 0;
    int currentHour = 0;
    int lastHour = 0;
    int currentDay = 0;
    int lastDay = 0;
    int month = 0;
    int previousMonth = 0;
    int year = 0;
    int previousYear = 0;
    int billDay = 0;
    BWeekday resetDay = BWeekday.make((String)"sunday");
    String deviceName;
    boolean latch = false;
    boolean billingLatch = false;
    boolean resetLatch = true;
    boolean serviceExists = false;
    String deltaSyntax = "";
    boolean ch = false;
    private boolean lastHourQuery = false;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat v) {
        this.set(historyName, (BValue)v, null);
    }

    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    public void setHistoryOrd(BOrd v) {
        this.set(historyOrd, (BValue)v, null);
    }

    public BRelTime getHistoryInterval() {
        return (BRelTime)this.get(historyInterval);
    }

    public void setHistoryInterval(BRelTime v) {
        this.set(historyInterval, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public boolean getDeltaLogged() {
        return this.getBoolean(deltaLogged);
    }

    public void setDeltaLogged(boolean v) {
        this.setBoolean(deltaLogged, v, null);
    }

    public boolean getExcludeInvalidValues() {
        return this.getBoolean(excludeInvalidValues);
    }

    public void setExcludeInvalidValues(boolean v) {
        this.setBoolean(excludeInvalidValues, v, null);
    }

    public boolean getExcludeHiddenValues() {
        return this.getBoolean(excludeHiddenValues);
    }

    public void setExcludeHiddenValues(boolean v) {
        this.setBoolean(excludeHiddenValues, v, null);
    }

    public BEnum getDateMode() {
        return (BEnum)this.get(dateMode);
    }

    public void setDateMode(BEnum v) {
        this.set(dateMode, (BValue)v, null);
    }

    public int getBillingCycleStartDay() {
        return this.getInt(billingCycleStartDay);
    }

    public void setBillingCycleStartDay(int v) {
        this.setInt(billingCycleStartDay, v, null);
    }

    public BRelTime getExecutePeriod() {
        return (BRelTime)this.get(executePeriod);
    }

    public void setExecutePeriod(BRelTime v) {
        this.set(executePeriod, (BValue)v, null);
    }

    public boolean getCalculating() {
        return this.getBoolean(calculating);
    }

    public void setCalculating(boolean v) {
        this.setBoolean(calculating, v, null);
    }

    public BAbsTime getNextUpdateTime() {
        return (BAbsTime)this.get(nextUpdateTime);
    }

    public void setNextUpdateTime(BAbsTime v) {
        this.set(nextUpdateTime, (BValue)v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public BStatusNumeric getCurrentHourTotal() {
        return (BStatusNumeric)this.get(currentHourTotal);
    }

    public void setCurrentHourTotal(BStatusNumeric v) {
        this.set(currentHourTotal, (BValue)v, null);
    }

    public BStatusNumeric getCurrentHourAvg() {
        return (BStatusNumeric)this.get(currentHourAvg);
    }

    public void setCurrentHourAvg(BStatusNumeric v) {
        this.set(currentHourAvg, (BValue)v, null);
    }

    public BStatusNumeric getCurrentHourMin() {
        return (BStatusNumeric)this.get(currentHourMin);
    }

    public void setCurrentHourMin(BStatusNumeric v) {
        this.set(currentHourMin, (BValue)v, null);
    }

    public BStatusNumeric getCurrentHourMax() {
        return (BStatusNumeric)this.get(currentHourMax);
    }

    public void setCurrentHourMax(BStatusNumeric v) {
        this.set(currentHourMax, (BValue)v, null);
    }

    public BStatusNumeric getLastHourTotal() {
        return (BStatusNumeric)this.get(lastHourTotal);
    }

    public void setLastHourTotal(BStatusNumeric v) {
        this.set(lastHourTotal, (BValue)v, null);
    }

    public BStatusNumeric getLastHourAvg() {
        return (BStatusNumeric)this.get(lastHourAvg);
    }

    public void setLastHourAvg(BStatusNumeric v) {
        this.set(lastHourAvg, (BValue)v, null);
    }

    public BStatusNumeric getLastHourMin() {
        return (BStatusNumeric)this.get(lastHourMin);
    }

    public void setLastHourMin(BStatusNumeric v) {
        this.set(lastHourMin, (BValue)v, null);
    }

    public BStatusNumeric getLastHourMax() {
        return (BStatusNumeric)this.get(lastHourMax);
    }

    public void setLastHourMax(BStatusNumeric v) {
        this.set(lastHourMax, (BValue)v, null);
    }

    public BStatusNumeric getCurrentDayTotal() {
        return (BStatusNumeric)this.get(currentDayTotal);
    }

    public void setCurrentDayTotal(BStatusNumeric v) {
        this.set(currentDayTotal, (BValue)v, null);
    }

    public BStatusNumeric getCurrentDayAvg() {
        return (BStatusNumeric)this.get(currentDayAvg);
    }

    public void setCurrentDayAvg(BStatusNumeric v) {
        this.set(currentDayAvg, (BValue)v, null);
    }

    public BStatusNumeric getCurrentDayMin() {
        return (BStatusNumeric)this.get(currentDayMin);
    }

    public void setCurrentDayMin(BStatusNumeric v) {
        this.set(currentDayMin, (BValue)v, null);
    }

    public BStatusNumeric getCurrentDayMax() {
        return (BStatusNumeric)this.get(currentDayMax);
    }

    public void setCurrentDayMax(BStatusNumeric v) {
        this.set(currentDayMax, (BValue)v, null);
    }

    public BStatusNumeric getYesterdayTotal() {
        return (BStatusNumeric)this.get(yesterdayTotal);
    }

    public void setYesterdayTotal(BStatusNumeric v) {
        this.set(yesterdayTotal, (BValue)v, null);
    }

    public BStatusNumeric getYesterdayAvg() {
        return (BStatusNumeric)this.get(yesterdayAvg);
    }

    public void setYesterdayAvg(BStatusNumeric v) {
        this.set(yesterdayAvg, (BValue)v, null);
    }

    public BStatusNumeric getYesterdayMin() {
        return (BStatusNumeric)this.get(yesterdayMin);
    }

    public void setYesterdayMin(BStatusNumeric v) {
        this.set(yesterdayMin, (BValue)v, null);
    }

    public BStatusNumeric getYesterdayMax() {
        return (BStatusNumeric)this.get(yesterdayMax);
    }

    public void setYesterdayMax(BStatusNumeric v) {
        this.set(yesterdayMax, (BValue)v, null);
    }

    public BStatusNumeric getCurrentWeekTotal() {
        return (BStatusNumeric)this.get(currentWeekTotal);
    }

    public void setCurrentWeekTotal(BStatusNumeric v) {
        this.set(currentWeekTotal, (BValue)v, null);
    }

    public BStatusNumeric getCurrentWeekAvg() {
        return (BStatusNumeric)this.get(currentWeekAvg);
    }

    public void setCurrentWeekAvg(BStatusNumeric v) {
        this.set(currentWeekAvg, (BValue)v, null);
    }

    public BStatusNumeric getCurrentWeekMin() {
        return (BStatusNumeric)this.get(currentWeekMin);
    }

    public void setCurrentWeekMin(BStatusNumeric v) {
        this.set(currentWeekMin, (BValue)v, null);
    }

    public BStatusNumeric getCurrentWeekMax() {
        return (BStatusNumeric)this.get(currentWeekMax);
    }

    public void setCurrentWeekMax(BStatusNumeric v) {
        this.set(currentWeekMax, (BValue)v, null);
    }

    public BStatusNumeric getLastWeekTotal() {
        return (BStatusNumeric)this.get(lastWeekTotal);
    }

    public void setLastWeekTotal(BStatusNumeric v) {
        this.set(lastWeekTotal, (BValue)v, null);
    }

    public BStatusNumeric getLastWeekAvg() {
        return (BStatusNumeric)this.get(lastWeekAvg);
    }

    public void setLastWeekAvg(BStatusNumeric v) {
        this.set(lastWeekAvg, (BValue)v, null);
    }

    public BStatusNumeric getLastWeekMin() {
        return (BStatusNumeric)this.get(lastWeekMin);
    }

    public void setLastWeekMin(BStatusNumeric v) {
        this.set(lastWeekMin, (BValue)v, null);
    }

    public BStatusNumeric getLastWeekMax() {
        return (BStatusNumeric)this.get(lastWeekMax);
    }

    public void setLastWeekMax(BStatusNumeric v) {
        this.set(lastWeekMax, (BValue)v, null);
    }

    public BStatusNumeric getCurrentMonthTotal() {
        return (BStatusNumeric)this.get(currentMonthTotal);
    }

    public void setCurrentMonthTotal(BStatusNumeric v) {
        this.set(currentMonthTotal, (BValue)v, null);
    }

    public BStatusNumeric getCurrentMonthAvg() {
        return (BStatusNumeric)this.get(currentMonthAvg);
    }

    public void setCurrentMonthAvg(BStatusNumeric v) {
        this.set(currentMonthAvg, (BValue)v, null);
    }

    public BStatusNumeric getCurrentMonthMin() {
        return (BStatusNumeric)this.get(currentMonthMin);
    }

    public void setCurrentMonthMin(BStatusNumeric v) {
        this.set(currentMonthMin, (BValue)v, null);
    }

    public BStatusNumeric getCurrentMonthMax() {
        return (BStatusNumeric)this.get(currentMonthMax);
    }

    public void setCurrentMonthMax(BStatusNumeric v) {
        this.set(currentMonthMax, (BValue)v, null);
    }

    public BStatusNumeric getLastMonthTotal() {
        return (BStatusNumeric)this.get(lastMonthTotal);
    }

    public void setLastMonthTotal(BStatusNumeric v) {
        this.set(lastMonthTotal, (BValue)v, null);
    }

    public BStatusNumeric getLastMonthAvg() {
        return (BStatusNumeric)this.get(lastMonthAvg);
    }

    public void setLastMonthAvg(BStatusNumeric v) {
        this.set(lastMonthAvg, (BValue)v, null);
    }

    public BStatusNumeric getLastMonthMin() {
        return (BStatusNumeric)this.get(lastMonthMin);
    }

    public void setLastMonthMin(BStatusNumeric v) {
        this.set(lastMonthMin, (BValue)v, null);
    }

    public BStatusNumeric getLastMonthMax() {
        return (BStatusNumeric)this.get(lastMonthMax);
    }

    public void setLastMonthMax(BStatusNumeric v) {
        this.set(lastMonthMax, (BValue)v, null);
    }

    public BStatusNumeric getCurrentYearTotal() {
        return (BStatusNumeric)this.get(currentYearTotal);
    }

    public void setCurrentYearTotal(BStatusNumeric v) {
        this.set(currentYearTotal, (BValue)v, null);
    }

    public BStatusNumeric getCurrentYearAvg() {
        return (BStatusNumeric)this.get(currentYearAvg);
    }

    public void setCurrentYearAvg(BStatusNumeric v) {
        this.set(currentYearAvg, (BValue)v, null);
    }

    public BStatusNumeric getCurrentYearMin() {
        return (BStatusNumeric)this.get(currentYearMin);
    }

    public void setCurrentYearMin(BStatusNumeric v) {
        this.set(currentYearMin, (BValue)v, null);
    }

    public BStatusNumeric getCurrentYearMax() {
        return (BStatusNumeric)this.get(currentYearMax);
    }

    public void setCurrentYearMax(BStatusNumeric v) {
        this.set(currentYearMax, (BValue)v, null);
    }

    public BStatusNumeric getLastYearTotal() {
        return (BStatusNumeric)this.get(lastYearTotal);
    }

    public void setLastYearTotal(BStatusNumeric v) {
        this.set(lastYearTotal, (BValue)v, null);
    }

    public BStatusNumeric getLastYearAvg() {
        return (BStatusNumeric)this.get(lastYearAvg);
    }

    public void setLastYearAvg(BStatusNumeric v) {
        this.set(lastYearAvg, (BValue)v, null);
    }

    public BStatusNumeric getLastYearMin() {
        return (BStatusNumeric)this.get(lastYearMin);
    }

    public void setLastYearMin(BStatusNumeric v) {
        this.set(lastYearMin, (BValue)v, null);
    }

    public BStatusNumeric getLastYearMax() {
        return (BStatusNumeric)this.get(lastYearMax);
    }

    public void setLastYearMax(BStatusNumeric v) {
        this.set(lastYearMax, (BValue)v, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.billDay = this.getBillingCycleStartDay();
        this.lastOrd = this.getHistoryOrd();
        if (!this.isRunning()) {
            return;
        }
        this.checkForService();
        this.updateHistory();
        this.initClockTicket();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void atSteadyState() {
        this.calculate();
    }

    private final void checkForService() {
        this.serviceFound = false;
        if (BVykonProService.getInstance() == null) {
            this.serviceFault = "This component requires the VykonPro service in the station";
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.serviceFault = "The vykonPro service is disabled";
        } else {
            this.serviceFound = true;
            this.serviceFault = "";
        }
        this.updateStatus();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("current") || slot.getName().startsWith("last") || slot.getName().startsWith("yesterday")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime value) {
        this.initClockTicket();
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime now = Clock.time();
        BAbsTime startTime = BAbsTime.make((BAbsTime)now, (BTime)BTime.make((int)0, (int)0, (int)0));
        BRelTime period = this.getExecutePeriod();
        if (period.getMillis() < 60000L) {
            period = BRelTime.MINUTE;
        }
        while (!startTime.isAfter(now)) {
            startTime = startTime.add(period);
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)startTime, (BRelTime)period, (Action)calculate, null);
        this.setNextUpdateTime(startTime.add(period));
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(executePeriod)) {
            this.calculate();
        } else if (property.equals(historyName)) {
            this.updateHistory();
        } else if (property.equals(billingCycleStartDay)) {
            this.billDay = this.getBillingCycleStartDay();
        }
    }

    private String resolveHistoryName() {
        BFormat pattern = this.getHistoryName();
        try {
            String p = pattern.encodeToString();
            if (p.indexOf("/") > -1) {
                int firstSlash = p.indexOf("/");
                BFormat station = BFormat.make((String)p.substring(0, firstSlash));
                BFormat history = BFormat.make((String)p.substring(firstSlash + 1));
                String s = SlotPath.escape((String)SlotPath.unescape((String)station.format((Object)this)));
                String h = SlotPath.escape((String)SlotPath.unescape((String)history.format((Object)this)));
                return s + "/" + h;
            }
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "couldn't resolve the historyName";
        }
    }

    private void updateHistory() {
        block8: {
            this.ordOkay = false;
            String hname = this.resolveHistoryName();
            if (hname.length() > 0) {
                BOrd hord = BOrd.make((String)("history:/" + hname));
                try {
                    if (hord.resolve((BObject)this).get() != null) {
                        BHistoryConfig config;
                        BCollectionInterval interval;
                        this.ordOkay = true;
                        this.ordFault = "";
                        this.setHistoryOrd(hord);
                        if (!this.getHistoryOrd().equals((Object)this.lastOrd)) {
                            this.lastOrd = BOrd.make((String)this.getHistoryOrd().toString());
                            this.reset();
                        }
                        if ((interval = (config = ((BIHistory)hord.resolve((BObject)this).get()).getConfig()).getInterval()).isIrregular()) {
                            this.setHistoryInterval(BRelTime.DEFAULT);
                        } else {
                            this.setHistoryInterval(interval.getInterval());
                        }
                        break block8;
                    }
                    this.ordFault = "history:/" + hname + " | History Ord does not resolve to an actual history";
                }
                catch (Exception e) {
                    System.out.println(this.getSlotPath() + " - exception resolving history");
                    System.out.println(e);
                    this.ordFault = "history:/" + hname + " | History Ord does not resolve to an actual history";
                }
            } else {
                this.ordFault = "History Name was blank";
            }
        }
        this.updateStatus();
    }

    private void updateStatus() {
        if (this.serviceFound && this.ordOkay) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        } else {
            this.setStatus(BStatus.fault);
            if (!this.serviceFound) {
                this.setFaultCause(this.serviceFault);
            } else if (!this.ordOkay) {
                this.setFaultCause(this.ordFault);
            } else {
                this.setFaultCause("unknown fault");
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == query) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public void doCalculate() throws Exception {
        this.setNextUpdateTime(Clock.time().add(this.getExecutePeriod()));
        if (this.getHistoryOrd().equals((Object)BOrd.NULL)) {
            this.updateHistory();
        } else if (!BOrd.make((String)("history:/" + this.resolveHistoryName())).equals((Object)this.getHistoryOrd())) {
            this.updateHistory();
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                this.updateHistory();
                if (!this.getStatus().isOk()) {
                    return;
                }
            }
        }
        this.query();
    }

    public void doQuery() throws Exception {
        if (!this.getStatus().isOk()) {
            return;
        }
        this.setCalculating(true);
        this.now = Clock.time();
        this.currentHour = this.now.getHour();
        this.day = this.now.getDayOfYear();
        this.currentDay = this.now.getDay();
        this.month = this.now.getMonth().getMonthOfYear();
        this.year = this.now.getYear();
        if (this.getDateMode().getOrdinal() == 1) {
            this.firstOfMonth = BAbsTime.make((int)this.year, (BMonth)this.now.getMonth(), (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)0, (int)0);
            this.firstOfYear = BAbsTime.make((int)this.year, (BMonth)BMonth.make((int)0), (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)0, (int)0);
            if (this.currentDay < this.billDay) {
                this.firstOfMonth = this.firstOfMonth.prevMonth();
            }
        }
        this.deltaSyntax = this.getDeltaLogged() ? ";delta=false" : ";delta=true";
        this.currentHourQuery();
        this.currentDayQuery();
        this.currentWeekQuery();
        this.currentMonthQuery();
        this.currentYearQuery();
        if (this.currentHour != this.lastHour) {
            this.lastHourQuery();
            this.lastHour = this.currentHour;
        } else if (this.getDebug()) {
            this.writeDebug("lastHour = " + this.lastHour + " | currentHour = " + this.currentHour);
        }
        if (this.day != this.lastDay) {
            this.yesterdayQuery();
            this.lastDay = this.day;
            this.billingLatch = false;
        }
        if (this.resetLatch || this.now.getWeekday().equals((Object)this.resetDay) && !this.latch) {
            this.lastWeekQuery();
            this.latch = true;
        }
        if (!this.now.getWeekday().equals((Object)this.resetDay)) {
            this.latch = false;
        }
        if (this.now.getMonth().getMonthOfYear() != this.previousMonth && this.getDateMode().getOrdinal() == 0) {
            this.lastMonthQuery();
            this.previousMonth = this.month;
        } else if (this.getDateMode().getOrdinal() == 1 && (this.currentDay == this.billDay && !this.billingLatch || this.resetLatch)) {
            this.lastMonthQuery();
            this.previousMonth = this.month;
            this.billingLatch = true;
        }
        if (this.now.getYear() != this.previousYear) {
            this.lastYearQuery();
            this.previousYear = this.year;
        }
        this.setCalculating(false);
        this.setLastUpdateTime(Clock.time());
        this.resetLatch = false;
    }

    public void doReset() throws Exception {
        this.getCurrentHourTotal().setValue(0.0);
        this.getCurrentHourAvg().setValue(0.0);
        this.getCurrentHourMin().setValue(0.0);
        this.getCurrentHourMax().setValue(0.0);
        this.getLastHourTotal().setValue(0.0);
        this.getLastHourAvg().setValue(0.0);
        this.getLastHourMin().setValue(0.0);
        this.getLastHourMax().setValue(0.0);
        this.lastHour = 0;
        this.getCurrentDayTotal().setValue(0.0);
        this.getCurrentDayAvg().setValue(0.0);
        this.getCurrentDayMin().setValue(0.0);
        this.getCurrentDayMax().setValue(0.0);
        this.getYesterdayTotal().setValue(0.0);
        this.getYesterdayAvg().setValue(0.0);
        this.getYesterdayMin().setValue(0.0);
        this.getYesterdayMax().setValue(0.0);
        this.lastDay = 0;
        this.getCurrentWeekTotal().setValue(0.0);
        this.getCurrentWeekAvg().setValue(0.0);
        this.getCurrentWeekMin().setValue(0.0);
        this.getCurrentWeekMax().setValue(0.0);
        this.getLastWeekTotal().setValue(0.0);
        this.getLastWeekAvg().setValue(0.0);
        this.getLastWeekMin().setValue(0.0);
        this.getLastWeekMax().setValue(0.0);
        this.getCurrentMonthTotal().setValue(0.0);
        this.getCurrentMonthAvg().setValue(0.0);
        this.getCurrentMonthMin().setValue(0.0);
        this.getCurrentMonthMax().setValue(0.0);
        this.getLastMonthTotal().setValue(0.0);
        this.getLastMonthAvg().setValue(0.0);
        this.getLastMonthMin().setValue(0.0);
        this.getLastMonthMax().setValue(0.0);
        this.previousMonth = 0;
        this.getCurrentYearTotal().setValue(0.0);
        this.getCurrentYearAvg().setValue(0.0);
        this.getCurrentYearMin().setValue(0.0);
        this.getCurrentYearMax().setValue(0.0);
        this.getLastYearTotal().setValue(0.0);
        this.getLastYearAvg().setValue(0.0);
        this.getLastYearMin().setValue(0.0);
        this.getLastYearMax().setValue(0.0);
        this.previousYear = 0;
        this.resetLatch = true;
        this.calculate();
    }

    public void currentHourQuery() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("?period=timeRange;start=");
        BAbsTime current = Clock.time();
        BAbsTime start = null;
        start = BAbsTime.make((BAbsTime)current, (BTime)BTime.make((int)current.getHour(), (int)0, (int)0));
        if (!this.getDeltaLogged() && this.getHistoryInterval().getMinutes() <= 60) {
            start = start.subtract(this.getHistoryInterval());
            this.ch = true;
        }
        sb.append(start.encodeToString());
        sb.append(";end=");
        sb.append(current.encodeToString());
        this.runQuery(sb.toString());
        this.getCurrentHourTotal().setValue(this.total);
        this.getCurrentHourMin().setValue(this.min);
        this.getCurrentHourMax().setValue(this.max);
        this.getCurrentHourAvg().setValue(this.avg);
    }

    public void lastHourQuery() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("?period=timeRange;start=");
        BAbsTime current = Clock.time();
        BAbsTime start = null;
        BAbsTime stop = null;
        stop = BAbsTime.make((BAbsTime)current, (BTime)BTime.make((int)current.getHour(), (int)0, (int)0));
        start = stop.subtract(BRelTime.makeHours((int)1));
        stop = stop.subtract(BRelTime.makeSeconds((int)1));
        if (!this.getDeltaLogged() && this.getHistoryInterval().getMinutes() <= 60) {
            start = start.subtract(this.getHistoryInterval());
            this.ch = true;
        }
        sb.append(start.encodeToString());
        sb.append(";end=");
        sb.append(stop.encodeToString());
        if (this.getDebug()) {
            this.writeDebug("running lastHour query - " + sb.toString());
            this.lastHourQuery = true;
        }
        this.runQuery(sb.toString());
        if (this.lastHourQuery) {
            this.writeDebug("records = " + this.records + " | min = " + this.min + " | max = " + this.max + " | total = " + this.total);
            this.lastHourQuery = false;
        }
        this.getLastHourTotal().setValue(this.total);
        this.getLastHourMin().setValue(this.min);
        this.getLastHourMax().setValue(this.max);
        this.getLastHourAvg().setValue(this.avg);
    }

    public void currentDayQuery() throws Exception {
        this.runQuery("?period=today");
        this.getCurrentDayTotal().setValue(this.total);
        this.getCurrentDayMin().setValue(this.min);
        this.getCurrentDayMax().setValue(this.max);
        this.getCurrentDayAvg().setValue(this.avg);
    }

    public void yesterdayQuery() throws Exception {
        this.runQuery("?period=yesterday");
        this.getYesterdayTotal().setValue(this.total);
        this.getYesterdayMin().setValue(this.min);
        this.getYesterdayMax().setValue(this.max);
        this.getYesterdayAvg().setValue(this.avg);
    }

    public void currentWeekQuery() throws Exception {
        this.runQuery("?period=weekToDate");
        this.getCurrentWeekTotal().setValue(this.total);
        this.getCurrentWeekMin().setValue(this.min);
        this.getCurrentWeekMax().setValue(this.max);
        this.getCurrentWeekAvg().setValue(this.avg);
    }

    public void lastWeekQuery() throws Exception {
        this.runQuery("?period=lastWeek");
        this.getLastWeekTotal().setValue(this.total);
        this.getLastWeekMin().setValue(this.min);
        this.getLastWeekMax().setValue(this.max);
        this.getLastWeekAvg().setValue(this.avg);
    }

    public void currentMonthQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=monthToDate");
        } else {
            String p = "?period=timeRange;start=" + this.firstOfMonth.encodeToString();
            this.runQuery(p);
        }
        this.getCurrentMonthTotal().setValue(this.total);
        this.getCurrentMonthMin().setValue(this.min);
        this.getCurrentMonthMax().setValue(this.max);
        this.getCurrentMonthAvg().setValue(this.avg);
    }

    public void lastMonthQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=lastMonth");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("?period=timeRange;start=");
            sb.append(this.firstOfMonth.prevMonth().encodeToString());
            sb.append(";end=");
            sb.append(this.firstOfMonth.encodeToString());
            this.runQuery(sb.toString());
        }
        this.getLastMonthTotal().setValue(this.total);
        this.getLastMonthMin().setValue(this.min);
        this.getLastMonthMax().setValue(this.max);
        this.getLastMonthAvg().setValue(this.avg);
    }

    public void currentYearQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=yearToDate");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("?period=timeRange;start=");
            sb.append(this.firstOfYear.encodeToString());
            this.runQuery(sb.toString());
        }
        this.getCurrentYearTotal().setValue(this.total);
        this.getCurrentYearMin().setValue(this.min);
        this.getCurrentYearMax().setValue(this.max);
        this.getCurrentYearAvg().setValue(this.avg);
    }

    public void lastYearQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=lastYear");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("?period=timeRange;start=");
            sb.append(this.firstOfYear.prevYear().encodeToString());
            sb.append(";end=");
            sb.append(this.firstOfYear.encodeToString());
            this.runQuery(sb.toString());
        }
        this.getLastYearTotal().setValue(this.total);
        this.getLastYearMin().setValue(this.min);
        this.getLastYearMax().setValue(this.max);
        this.getLastYearAvg().setValue(this.avg);
    }

    private void runQuery(String period) {
        BOrd qord = BOrd.make((String)(this.getHistoryOrd().toString() + period + this.deltaSyntax + "|bql:select timestamp, trendFlags, status, value"));
        BITable result = (BITable)qord.resolve().get();
        ColumnList columns = result.getColumns();
        Column valueColumn = columns.get(3);
        Column statusColumn = columns.get(2);
        Column trendColumn = columns.get(1);
        this.total = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.records = 0.0;
        this.avg = 0.0;
        boolean first = true;
        boolean excInvalid = this.getExcludeInvalidValues();
        boolean excHidden = this.getExcludeHiddenValues();
        double value = 0.0;
        BStatus status = BStatus.nullStatus;
        BTrendFlags flags = null;
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BDouble checkValue;
                value = ((BINumeric)c.cell(valueColumn)).getNumeric();
                status = ((BStatus)c.cell(statusColumn)).getStatus();
                flags = (BTrendFlags)c.cell(trendColumn);
                if (excInvalid & !status.isValid() || excHidden & flags.getBit("hidden") || (checkValue = BDouble.make((double)value)) == BDouble.NaN || checkValue == BDouble.NEGATIVE_INFINITY || checkValue == BDouble.POSITIVE_INFINITY) continue;
                if (!this.ch) {
                    this.records += 1.0;
                }
                if (first) {
                    this.min = value;
                    this.max = value;
                    this.total = value;
                    if (!this.ch) {
                        first = false;
                        continue;
                    }
                    this.ch = false;
                    continue;
                }
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
                this.total += value;
            }
        }
        if (this.lastHourQuery) {
            this.writeDebug("runQuery records = " + this.records + " | min = " + this.min + " | max = " + this.max + " | total = " + this.total);
        }
        if (this.records > 0.0) {
            this.avg = this.total / this.records;
        }
    }

    private void writeDebug(String msg) {
        System.out.println("########## " + Clock.time() + " - " + this.getSlotPath());
        System.out.println("########## " + msg);
    }

    public BIcon getIcon() {
        return icon;
    }
}

