/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.tridium.history.BNumeric64BitTrendRecord;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.BTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BManualNumericHistoryExt
extends BHistoryExt {
    public static final Property interval = BManualNumericHistoryExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property precision = BManualNumericHistoryExt.newProperty((int)0, (int)32, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE")));
    public static final Property minRolloverValue = BManualNumericHistoryExt.newProperty((int)0, (BValue)new BRolloverValue(), null);
    public static final Property maxRolloverValue = BManualNumericHistoryExt.newProperty((int)0, (BValue)new BRolloverValue(), null);
    public static final Action manualCollect = BManualNumericHistoryExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BManualNumericHistoryExt.class);
    private BNumericTrendRecord rec;

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    public int getPrecision() {
        return this.getInt(precision);
    }

    public void setPrecision(int v) {
        this.setInt(precision, v, null);
    }

    public BRolloverValue getMinRolloverValue() {
        return (BRolloverValue)this.get(minRolloverValue);
    }

    public void setMinRolloverValue(BRolloverValue v) {
        this.set(minRolloverValue, (BValue)v, null);
    }

    public BRolloverValue getMaxRolloverValue() {
        return (BRolloverValue)this.get(maxRolloverValue);
    }

    public void setMaxRolloverValue(BRolloverValue v) {
        this.set(maxRolloverValue, (BValue)v, null);
    }

    public void manualCollect() {
        this.invoke(manualCollect, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    public void started() throws Exception {
        super.started();
        if (this.isValidInterval(this.getInterval())) {
            BCollectionInterval collectionInterval = BCollectionInterval.make((BRelTime)this.getInterval());
            if (!this.getHistoryConfig().getInterval().equals((Object)collectionInterval)) {
                this.getHistoryConfig().setInterval(collectionInterval);
            }
        }
        this.rec = this.getPrecision() == 64 ? new BNumeric64BitTrendRecord() : new BNumericTrendRecord();
        this.syncProperties();
    }

    public void activated(BAbsTime startTime, BAbsTime currentTime, BStatusValue value) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            String s = this.getSlotPath() + ": activated (start=" + startTime.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ", current=" + currentTime.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ")";
            log.fine(s);
        }
    }

    public void deactivated(BAbsTime currentTime, BStatusValue value) {
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (cx == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(interval)) {
            if (!this.isValidInterval(this.getInterval())) {
                return;
            }
            this.getHistoryConfig().setInterval(BCollectionInterval.make((BRelTime)this.getInterval()));
        } else if (p.equals(minRolloverValue)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(minRolloverValue.getName());
            if (prop == null) {
                config.add(minRolloverValue.getName(), this.getMinRolloverValue().newCopy(), 1);
            } else {
                config.set(prop, this.getMinRolloverValue().newCopy());
            }
        } else if (p.equals(maxRolloverValue)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(maxRolloverValue.getName());
            if (prop == null) {
                config.add(maxRolloverValue.getName(), this.getMaxRolloverValue().newCopy(), 1);
            } else {
                config.set(prop, this.getMaxRolloverValue().newCopy());
            }
        } else if (p.equals(precision)) {
            BHistoryConfig config = this.getHistoryConfig();
            Property prop = config.loadSlots().getProperty(precision.getName());
            if (prop == null) {
                config.add(precision.getName(), (BValue)BInteger.make((int)this.getPrecision()), 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE")), null);
            } else {
                config.set(prop, (BValue)BInteger.make((int)this.getPrecision()));
            }
            this.rec = this.getPrecision() == 64 ? new BNumeric64BitTrendRecord() : new BNumericTrendRecord();
            if (!config.getRecordType().equals((Object)this.getRecordType().getTypeSpec())) {
                config.setRecordType(this.getRecordType().getTypeSpec());
            }
        }
    }

    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        this.append((BTrendRecord)this.rec.set(timestamp, ((BStatusNumeric)out).getValue(), ((BStatusNumeric)out).getStatus()));
    }

    public void updateStatus() {
        super.updateStatus();
        if (this.getStatus().isFault()) {
            return;
        }
        if (!this.isValidInterval(this.getInterval())) {
            BStatus newStatus = BStatus.makeFault((BStatus)this.getStatus(), (boolean)true);
            if (!this.getStatus().equals((Object)newStatus)) {
                this.setStatus(newStatus);
                this.setFaultCause("Invalid interval: " + this.getInterval().toString());
            }
        } else {
            this.setFaultCause("");
        }
    }

    private boolean isValidInterval(BRelTime interval) {
        return interval.getMillis() > 0L;
    }

    private void syncProperties() {
        BHistoryConfig config = this.getHistoryConfig();
        Property prop = config.loadSlots().getProperty(minRolloverValue.getName());
        if (prop == null) {
            config.add(minRolloverValue.getName(), this.getMinRolloverValue().newCopy(), 1);
        } else {
            BRolloverValue configMin = (BRolloverValue)config.get(prop);
            if (!configMin.equivalent((Object)this.getMinRolloverValue())) {
                config.set(prop, this.getMinRolloverValue().newCopy());
            }
        }
        prop = config.loadSlots().getProperty(maxRolloverValue.getName());
        if (prop == null) {
            config.add(maxRolloverValue.getName(), this.getMaxRolloverValue().newCopy(), 1);
        } else {
            BRolloverValue configMax = (BRolloverValue)config.get(prop);
            if (!configMax.equivalent((Object)this.getMaxRolloverValue())) {
                config.set(prop, this.getMaxRolloverValue().newCopy());
            }
        }
        prop = config.loadSlots().getProperty(precision.getName());
        if (prop == null) {
            config.add(precision.getName(), (BValue)BInteger.make((int)this.getPrecision()), 1, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"history:PrecisionFE")), null);
        } else {
            BInteger configPrecision = (BInteger)config.get(prop);
            if (configPrecision.getInt() != this.getPrecision()) {
                config.set(prop, (BValue)BInteger.make((int)this.getPrecision()));
            }
        }
    }

    public Type getRecordType() {
        if (this.getPrecision() == 64) {
            return BNumeric64BitTrendRecord.TYPE;
        }
        return BNumericTrendRecord.TYPE;
    }

    public void pointChanged(BAbsTime arg0, BStatusValue arg1) throws Exception {
    }

    public void doManualCollect() {
        BControlPoint point = this.getParentPoint();
        BStatusValue val = (BStatusValue)point.getOutStatusValue().newCopy(true);
        try {
            this.writeRecord(Clock.time(), val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

