/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.alarm;

import java.util.HashMap;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="numberOfItems", type="int", defaultValue="0", flags=256, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=1), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=1)})
public class BRelatedMetadata
extends BComponent {
    public static final Property numberOfItems = BRelatedMetadata.newProperty((int)256, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property status = BRelatedMetadata.newProperty((int)1, (BValue)BStatus.DEFAULT, null);
    public static final Property faultCause = BRelatedMetadata.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BRelatedMetadata.class);
    MySubscriber subscriber;
    private static String SLOT_NAME = "relatedPoint";
    private static String CAUSE = " must be mapped to a valid Control Point ord in the station";
    private BAlarmSourceExt ase;
    private HashMap<String, String> keys = new HashMap();

    public int getNumberOfItems() {
        return this.getInt(numberOfItems);
    }

    public void setNumberOfItems(int v) {
        this.setInt(numberOfItems, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.subscriber = new MySubscriber();
        if (Sys.atSteadyState()) {
            this.subscribeItems();
        }
        BComponent parent = this.getParent().getParentComponent();
        this.ase = (BAlarmSourceExt)parent;
        if (this.ase != null) {
            Slot s = parent.getSlot("metaData");
            parent.setFlags(s, parent.getFlags(s) | 0x10000);
        }
    }

    public void stopped() {
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
    }

    public void stationStarted() {
        this.subscribeItems();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(numberOfItems)) {
            this.initSlots();
        } else if (prop.getName().startsWith(SLOT_NAME)) {
            this.validateOrd(prop.getName());
        }
        super.changed(prop, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmSourceExt;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        BOrd compOrd;
        if (property.getName().startsWith(SLOT_NAME) && (compOrd = (BOrd)oldValue) != BOrd.DEFAULT) {
            BComponent comp = (BComponent)compOrd.resolve((BObject)this).get();
            if (this.ase != null) {
                this.ase.setMetaData(BFacets.makeRemove((BFacets)this.ase.getMetaData(), (String)comp.getName()));
            }
        }
        int numSlots = ((BOrd[])this.getChildren(BOrd.class)).length;
        if (this.getNumberOfItems() != numSlots) {
            this.setNumberOfItems(numSlots);
        }
        this.subscribeItems();
        super.removed(property, oldValue, context);
    }

    private void initSlots() {
        int numSlots;
        int numOrds = this.getNumberOfItems();
        if (numOrds > (numSlots = ((BOrd[])this.getChildren(BOrd.class)).length)) {
            for (int i = numSlots + 1; i <= numOrds; ++i) {
                this.add(SLOT_NAME + i, (BValue)BOrd.DEFAULT, 256);
            }
        } else if (numOrds < numSlots) {
            for (int i = numOrds + 1; i <= numSlots; ++i) {
                this.removeMetadata(SLOT_NAME + i);
                this.remove(SLOT_NAME + i);
            }
        }
        this.subscribeItems();
    }

    private void removeMetadata(String slot) {
        BComponent comp;
        BOrd compOrd = (BOrd)this.get(slot);
        if (compOrd != BOrd.DEFAULT && (comp = (BComponent)compOrd.resolve((BObject)this).get()) != null && this.ase != null) {
            this.ase.setMetaData(BFacets.makeRemove((BFacets)this.ase.getMetaData(), (String)comp.getName()));
        }
    }

    private void subscribeItems() {
        this.subscriber.unsubscribeAll();
        BFacets facets = BFacets.DEFAULT;
        for (int i = 1; i <= this.getNumberOfItems(); ++i) {
            String slotName = SLOT_NAME + i;
            BOrd objOrd = (BOrd)this.get(slotName);
            if (objOrd == BOrd.DEFAULT) continue;
            try {
                BObject object = objOrd.resolve((BObject)this).get();
                if (object == null || !(object instanceof BControlPoint)) continue;
                BControlPoint point = (BControlPoint)object;
                this.subscriber.subscribe((BComponent)point);
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)point.getName(), (String)point.getValueWithFacets((Context)point.getFacets())));
                this.keys.put(slotName, point.getName());
                continue;
            }
            catch (Exception e) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(slotName + CAUSE);
                System.out.println(this.getSlotPath());
                e.printStackTrace();
            }
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        if (facets != BFacets.DEFAULT && this.ase != null) {
            this.ase.setMetaData(BFacets.make((BFacets)this.ase.getMetaData(), (BFacets)facets));
        }
    }

    private void updateMetadata(BComponent source) {
        if (!(source instanceof BControlPoint)) {
            return;
        }
        BControlPoint point = (BControlPoint)source;
        BFacets facet = BFacets.make((String)point.getName(), (String)point.getValueWithFacets((Context)point.getFacets()));
        if (this.ase != null) {
            this.ase.setMetaData(BFacets.make((BFacets)this.ase.getMetaData(), (BFacets)facet));
        }
    }

    private void validateOrd(String slot) {
        boolean fault = false;
        BOrd checkOrd = (BOrd)this.get(slot);
        if (checkOrd == BOrd.DEFAULT) {
            fault = true;
        }
        try {
            BObject obj = checkOrd.resolve((BObject)this).get();
            if (obj != null && obj instanceof BControlPoint) {
                BControlPoint point = (BControlPoint)obj;
                this.keys.forEach((k, v) -> {
                    if (this.keys.get(slot) != null && !this.keys.get(slot).equals(point.getName())) {
                        if (this.ase != null) {
                            this.ase.setMetaData(BFacets.makeRemove((BFacets)this.ase.getMetaData(), (String)this.keys.get(slot)));
                        }
                        this.keys.put(slot, point.getName());
                    }
                });
                this.subscriber.subscribe((BComponent)point);
                this.updateMetadata((BComponent)point);
            } else {
                fault = true;
            }
            if (fault) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(slot + CAUSE);
            } else {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            }
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(slot + CAUSE);
            System.out.println(this.getSlotPath());
            e.printStackTrace();
        }
    }

    public class MySubscriber
    extends Subscriber {
        public void event(BComponentEvent event) {
            if (event.getId() == 0 && event.getSlotName().equals("out")) {
                try {
                    BRelatedMetadata.this.updateMetadata(event.getSourceComponent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

