/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.alarm;

import com.vykon.vykonPro.hvac.BRollingAvg;
import com.vykon.vykonPro.hvac.BRollingAvgMaster;
import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BTwoStateAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviationLimit", type="double", defaultValue="0"), @NiagaraProperty(name="deadband", type="double", defaultValue="0")})
public class BMaxDeviationAlgorithm
extends BTwoStateAlgorithm {
    public static final Property deviationLimit = BMaxDeviationAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BMaxDeviationAlgorithm.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BMaxDeviationAlgorithm.class);

    public double getDeviationLimit() {
        return this.getDouble(deviationLimit);
    }

    public void setDeviationLimit(double v) {
        this.setDouble(deviationLimit, v, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BRollingAvg || grandparent instanceof BRollingAvgMaster;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == deadband || slot == deviationLimit) {
            BControlPoint point = this.getParentPoint();
            if (point != null) {
                return (BFacets)point.get("deviationFacets");
            }
            return BFacets.DEFAULT;
        }
        return super.getSlotFacets(slot);
    }

    protected boolean isNormal(BStatusValue bStatusValue) {
        BControlPoint point = this.getParentPoint();
        double error = ((BStatusNumeric)point.get("maximumDeviation")).getValue();
        if (Double.isNaN(error)) {
            return true;
        }
        if (this.isCurrentOffnormal()) {
            return error < this.getDeviationLimit() - this.getDeadband();
        }
        return error < this.getDeviationLimit();
    }

    public void writeAlarmData(BStatusValue out, Map map) {
        BControlPoint point = this.getParentPoint();
        BAlarmSourceExt ext = this.getParentExt();
        BStatusNumeric maximumDeviation = (BStatusNumeric)point.get("maximumDeviation");
        BFacets deviationFacets = (BFacets)point.get("deviationFacets");
        String maximumDeviationInput = "";
        boolean master = false;
        if (point instanceof BRollingAvgMaster) {
            master = true;
            maximumDeviationInput = ((BRollingAvgMaster)point).getMaximumDeviationInput();
        }
        if (!ext.getAlarmState().isInAlarm()) {
            map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)deviationFacets)));
            map.put("errorLimit", BString.make((String)BDouble.toString((double)this.getDeviationLimit(), (Context)deviationFacets)));
            map.put("offnormalValue", BString.make((String)maximumDeviation.valueToString((Context)deviationFacets)));
            map.put("alarmValue", (BIDataValue)maximumDeviation.getValueValue());
            map.put("presentValue", BString.make((String)maximumDeviation.valueToString((Context)deviationFacets)));
            map.put("status", BString.make((String)out.getStatus().toString(null)));
            if (master) {
                map.put("deviationInput", BString.make((String)maximumDeviationInput));
            }
        } else {
            map.put("presentValue", BString.make((String)maximumDeviation.valueToString((Context)deviationFacets)));
        }
    }
}

