/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetMigrator;

import com.tridium.bacnetAws.BBacnetAwsDevice;
import com.tridium.bacnetAws.BBacnetAwsDeviceFolder;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.BLocalBacnetAwsDevice;
import com.tridium.bacnetAws.ui.device.BBacnetAwsDeviceManager;
import com.tridium.migrator.MigrationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BBacnetWsToAwsConverter
extends BObject
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BBacnetWsToAwsConverter.class);
    private static final List<String> convertTypes;
    private static final Map<String, String> newTypeSpecMap;
    private static final int MODULE_NDX = 0;
    private static final int TYPE_NDX = 1;
    private static final String MODULE_BACNETWS = "bacnetws";
    private static final String MODULE_BACNET = "bacnet";
    private static final String MODULE_DEF_AWS = "bacAws=bacnetAws";
    private static final String MODULE_DEF_BAC = "bac=bacnet";

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typespecName, Version sourceVersion) {
        String[] moduleAndType = typespecName.split(":");
        String moduleStr = moduleAndType[0];
        String typeStr = moduleAndType[1];
        if (moduleStr.equals(MODULE_BACNETWS)) {
            switch (typeStr) {
                case "BacnetWsNetwork": {
                    this.migrateType(x, MODULE_DEF_AWS, "bacAws:BacnetAwsNetwork");
                    break;
                }
                case "BacnetWsDevice": {
                    this.migrateType(x, MODULE_DEF_AWS, "bacAws:BacnetAwsDevice");
                    break;
                }
                case "BacnetWsDeviceFolder": {
                    this.migrateType(x, MODULE_DEF_AWS, "bacAws:BacnetAwsDeviceFolder");
                    break;
                }
                case "BacnetWsDeviceManager": {
                    this.migrateType(x, MODULE_DEF_AWS, "bacAws:BacnetAwsDeviceManager");
                    break;
                }
                case "LocalBacnetWsDevice": {
                    this.migrateType(x, MODULE_DEF_AWS, "bacAws:LocalBacnetAwsDevice");
                    break;
                }
                case "BacnetWsStack": {
                    this.migrateType(x, MODULE_DEF_BAC, "bac:BacnetStack");
                    break;
                }
                case "BacnetWsClientLayer": {
                    this.migrateType(x, MODULE_DEF_BAC, "bac:BacnetClientLayer");
                }
            }
        } else if (moduleStr.equals(MODULE_BACNET)) {
            switch (typeStr) {
                case "BacnetDevice": {
                    this.migrateIfContainedBy(x, MODULE_DEF_AWS, "bacAws:BacnetAwsDevice", "bacAws:BacnetAwsNetwork");
                    this.migrateIfContainedBy(x, MODULE_DEF_AWS, "bacAws:BacnetAwsDevice", "bacAws:BacnetAwsDeviceFolder");
                    break;
                }
                case "BacnetHistoryDeviceExt": {
                    this.migrateIfContainedBy(x, MODULE_DEF_AWS, "bacAws:BacnetAwsHistoryDeviceExt", "bacAws:BacnetAwsDevice");
                    break;
                }
                case "BacnetConfigDeviceExt": {
                    this.migrateIfContainedBy(x, MODULE_DEF_AWS, "bacAws:BacnetAwsConfigDeviceExt", "bacAws:BacnetAwsDevice");
                }
            }
        }
        return x;
    }

    public BValue newInstance(String moduleName, String typeName) {
        BValue inst = null;
        if (moduleName.equals(MODULE_BACNETWS)) {
            switch (typeName) {
                case "BacnetWsNetwork": {
                    inst = BBacnetAwsNetwork.TYPE.getInstance().asValue();
                    break;
                }
                case "LocalBacnetWsDevice": {
                    inst = BLocalBacnetAwsDevice.TYPE.getInstance().asValue();
                    break;
                }
                case "BacnetWsDevice": {
                    inst = BBacnetAwsDevice.TYPE.getInstance().asValue();
                    break;
                }
                case "BacnetWsDeviceFolder": {
                    inst = BBacnetAwsDeviceFolder.TYPE.getInstance().asValue();
                    break;
                }
                case "BacnetWsDeviceManager": {
                    inst = BBacnetAwsDeviceManager.TYPE.getInstance().asValue();
                    break;
                }
                default: {
                    log.config("BacnetWsToAwsConverter:couldn't match typeName '" + typeName + "'");
                    break;
                }
            }
        } else {
            log.config("BacnetWsToAwsConverter:couldn't match moduleName '" + moduleName + "'");
        }
        return inst;
    }

    public String newTypeSpec(String typeSpecName) {
        String newTypeSpecName = newTypeSpecMap.get(typeSpecName);
        return newTypeSpecName == null ? typeSpecName : newTypeSpecName;
    }

    private void migrateType(XElem elem, String moduleStr, String typeStr) {
        MigrationUtils.logInfoByModule((String)"bacnetMigrator", (String)"wsToAws.convert", (Object[])new Object[]{elem.get("n", "unnamedObject"), elem.get("t", "unknown"), moduleStr, typeStr});
        if (log.isLoggable(Level.FINER)) {
            log.finer("Migrating " + elem.get("n", "unnamedObject") + " of type " + elem.get("t", "unknown") + " to " + moduleStr + ":" + typeStr);
        }
        elem.setAttr("m", moduleStr);
        elem.setAttr("t", typeStr);
    }

    private void migrateIfContainedBy(XElem elem, String moduleStr, String typeStr, String parentTypeStr) {
        boolean parentMatch = false;
        for (XElem x = elem.parent(); x != null; x = x.parent()) {
            if (!x.get("t", "").equals(parentTypeStr)) continue;
            parentMatch = true;
            break;
        }
        if (parentMatch) {
            elem.setAttr("t", typeStr);
        }
    }

    public String toString(Context c) {
        return "BacnetWsToAwsConverter";
    }

    static {
        ArrayList<String> mutableConvertTypes = new ArrayList<String>();
        mutableConvertTypes.add("bacnetws:BacnetWsNetwork");
        mutableConvertTypes.add("bacnetws:BacnetWsDeviceFolder");
        mutableConvertTypes.add("bacnetws:BacnetWsDeviceManager");
        mutableConvertTypes.add("bacnetws:BacnetWsDevice");
        mutableConvertTypes.add("bacnetws:LocalBacnetWsDevice");
        mutableConvertTypes.add("bacnetws:BacnetWsStack");
        mutableConvertTypes.add("bacnetws:BacnetWsClientLayer");
        mutableConvertTypes.add("bacnet:BacnetDevice");
        mutableConvertTypes.add("bacnet:BacnetHistoryDeviceExt");
        mutableConvertTypes.add("bacnet:BacnetConfigDeviceExt");
        convertTypes = Collections.unmodifiableList(mutableConvertTypes);
        newTypeSpecMap = new HashMap<String, String>();
        newTypeSpecMap.put("bacnetws:BacnetWsNetwork", "bacnetAws:BacnetAwsNetwork");
        newTypeSpecMap.put("bacnetws:BacnetWsDeviceFolder", "bacnetAws:BacnetAwsDeviceFolder");
        newTypeSpecMap.put("bacnetws:BacnetWsDevice", "bacnetAws:BacnetAwsDevice");
        newTypeSpecMap.put("bacnetws:LocalBacnetWsDevice", "bacnetAws:LocalBacnetAwsDevice");
        newTypeSpecMap.put("bacnetws:BacnetWsStack", "bacnet:BacnetStack");
        newTypeSpecMap.put("bacnetws:BacnetWsClientLayer", "bacnet:BacnetClientLayer");
    }
}

