/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.ui.fe;

import com.tridium.ui.UiEnv;
import com.tridium.util.ObjectUtil;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaBoundQueryResult;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BQueryResultWriter;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.QueryStyleManager;
import com.tridiumx.jsonToolkit.util.JsonStringUtil;
import java.util.List;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="mouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public class BQueryStylePickerFE
extends BWbFieldEditor {
    public static final Action mouseEvent = BQueryStylePickerFE.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BQueryStylePickerFE.class);
    private final List<BQueryResultWriter> agents = QueryStyleManager.getInstance().getQueryStyles();
    private final BListDropDown queryStylePicker = new BListDropDown();

    public void mouseEvent(BMouseEvent parameter) {
        this.invoke(mouseEvent, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BQueryStylePickerFE() {
        BFlowPane panel = new BFlowPane();
        panel.add("child?", (BValue)this.queryStylePicker);
        BHyperlinkLabel previewLabel = new BHyperlinkLabel(JsonStringUtil.lexicon.get("preview"), ObjectUtil.getGuideHelpOrd((TypeInfo)BJsonSchemaBoundQueryResult.TYPE.getTypeInfo()));
        panel.add("child?", (BValue)previewLabel);
        this.setContent((BWidget)panel);
        this.linkTo("lk?", (BComponent)this.queryStylePicker, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk?", (BComponent)this.queryStylePicker, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk?", (BComponent)previewLabel, (Slot)BWidget.mouseEvent, (Slot)mouseEvent);
    }

    protected void doSetReadonly(boolean readonly) {
        this.queryStylePicker.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject existingValue, Context cx) {
        BTypeSpec val = (BTypeSpec)existingValue.as(BTypeSpec.class);
        int selectedIndex = -1;
        this.queryStylePicker.getList().removeAllItems();
        for (int i = 0; i < this.agents.size(); ++i) {
            BQueryResultWriter writer = this.agents.get(i);
            this.queryStylePicker.getList().addItem((Object)writer.getType().getDisplayName(cx));
            if (!writer.getType().getTypeSpec().equals((Object)val)) continue;
            selectedIndex = i;
        }
        this.queryStylePicker.setSelectedIndex(selectedIndex);
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        int selected = this.queryStylePicker.getSelectedIndex();
        return this.agents.get(selected).getType().getTypeSpec();
    }

    public void doMouseEvent(BMouseEvent event) {
        if (event.getId() == 512) {
            int selected = this.queryStylePicker.getSelectedIndex();
            String preview = this.agents.get(selected).previewText().getString();
            UiEnv.get().openBubbleHelp((BWidget)this, event.getX(), event.getY(), preview);
        } else if (event.getId() == 505) {
            UiEnv.get().closeBubbleHelp();
        }
    }
}

