/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.ui;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BSchemaHistoryDebug;
import com.tridiumx.jsonToolkit.ui.FormattedJsonParser;
import com.tridiumx.jsonToolkit.ui.JsonWbStringUtil;
import com.tridiumx.jsonToolkit.util.JsonStringUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BJsonOutputWidget
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BJsonOutputWidget.class);
    private String originalJson;
    private String indentedJson;
    private boolean inPrettyMode = true;
    private ToggleTextField textField;
    private BToggleButton viewToggle;
    private static final int VISIBLE_ROWS = 14;
    private static final int VISIBLE_COLUMNS = 100;
    private static final int MAX_GENERATE_WAIT_MS = 30000;
    private static final BBrush BG = BBrush.makeSolid((BColor)BColor.make((String)"#2B2B2B"));
    private static final BBrush FG = BBrush.makeSolid((BColor)BColor.make((String)"#A9B7C6"));
    private static final BBrush BRACKET = BBrush.makeSolid((BColor)BColor.make((String)"#A5C25C"));
    private static final BBrush KEYWORD = BBrush.makeSolid((BColor)BColor.make((String)"#FFC66D"));
    private static final BImage COPY_ICON = BImage.make((BIcon)BIcon.std((String)"export.png"));
    private static final BImage GENERATE_ICON = BImage.make((BIcon)BIcon.std((String)"running.png"));
    private static final BImage CLEAR_ICON = BImage.make((BIcon)BIcon.std((String)"eraser.png"));
    private static final BImage HISTORY_ICON = BImage.make((BIcon)BIcon.std((String)"detailsView.png"));
    private static final BImage METRICS_ICON = BImage.make((BIcon)BIcon.std((String)"diagnostics.png"));
    private static final BImage PRETTY_BRACES_ICON = BImage.make((String)"module://jsonToolkit/icons/prettyBraces.png");
    private static final BImage BRACES_ICON = BImage.make((BIcon)BIcon.std((String)"braces.png"));

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context context) {
        this.originalJson = ((BString)value).getString();
        this.indentedJson = null;
        BGridPane outerPane = new BGridPane(2);
        outerPane.setRowAlign(BValign.top);
        BTextEditorPane textPane = new BTextEditorPane(14, 100);
        this.textField = new ToggleTextField();
        textPane.setContent((BWidget)this.textField);
        this.textField.setEditable(false);
        this.updateTextField();
        outerPane.add("textPane", (BValue)textPane);
        BGridPane settingsPane = new BGridPane(1);
        settingsPane.setRowAlign(BValign.top);
        BButton generate = new BButton((Command)new GenerateJson());
        generate.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("generate", (BValue)generate);
        BButton copyToClipBoard = new BButton((Command)new ClipboardCopy());
        copyToClipBoard.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("copyToClipBoard", (BValue)copyToClipBoard);
        BButton clear = new BButton((Command)new Clear());
        clear.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("clear", (BValue)clear);
        BButton history = new BButton((Command)new History());
        history.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("history", (BValue)history);
        BButton metrics = new BButton((Command)new Metrics());
        metrics.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("metrics", (BValue)metrics);
        this.viewToggle = new BToggleButton((Command)new ViewToggle());
        this.viewToggle.setButtonStyle(BButtonStyle.toolBar);
        settingsPane.add("viewToggle", (BValue)this.viewToggle);
        outerPane.add("options", (BValue)settingsPane);
        this.setContent((BWidget)outerPane);
    }

    private void toggleView() {
        this.inPrettyMode = !this.inPrettyMode;
        this.updateTextField();
        this.viewToggle.setImage(this.inPrettyMode ? PRETTY_BRACES_ICON : BRACES_ICON);
        this.viewToggle.setText(this.inPrettyMode ? JsonStringUtil.lexicon.get("viewToggleBtn.label") : JsonStringUtil.lexicon.get("viewToggleBtn.label.raw"));
    }

    private void updateTextField() {
        String formatted = this.inPrettyMode ? this.getIndented() : this.originalJson;
        this.textField.setParser(this.inPrettyMode ? new FormattedJsonParser() : new TextParser());
        this.textField.setRenderer(this.inPrettyMode ? new JsonRenderer() : new TextRenderer());
        this.textField.setText(formatted == null ? "" : formatted);
    }

    private String getIndented() {
        if (this.indentedJson == null) {
            this.indentedJson = JsonWbStringUtil.indent(this.originalJson);
        }
        return this.indentedJson;
    }

    private BJsonSchema getSchema() {
        return this.getSchema(null);
    }

    private BJsonSchema getSchema(BComplex complex) {
        if (complex == null) {
            complex = this.getParent();
        }
        if (complex instanceof BPropertyEntry) {
            BObject target = ((BPropertyEntry)complex.as(BPropertyEntry.class)).getTarget();
            if (target instanceof BJsonSchema) {
                return (BJsonSchema)target.as(BJsonSchema.class);
            }
        } else if (complex.getParent() == null) {
            throw new BajaRuntimeException("Unable to find json schema for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        return this.getSchema(complex.getParent());
    }

    protected class ViewToggle
    extends ToggleCommand {
        ViewToggle() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "viewToggleBtn");
        }

        public BImage getIcon() {
            return BJsonOutputWidget.this.inPrettyMode ? PRETTY_BRACES_ICON : BRACES_ICON;
        }

        public synchronized boolean isSelected() {
            return BJsonOutputWidget.this.inPrettyMode;
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BJsonOutputWidget.this.toggleView();
        }
    }

    protected class Metrics
    extends Command {
        Metrics() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "metricsBtn");
        }

        public CommandArtifact doInvoke() {
            String debugNavPath = BJsonOutputWidget.this.getSchema().getConfig().getDebug().getNavOrd().toString();
            BOrd metricsNavOrd = BOrd.make((String)(debugNavPath + "/metrics"));
            BJsonOutputWidget.this.getWbShell().hyperlink(new HyperlinkInfo(metricsNavOrd, BHyperlinkMode.newTab));
            return null;
        }
    }

    protected class History
    extends Command {
        History() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "historyBtn");
        }

        public CommandArtifact doInvoke() {
            BJsonSchema schema = BJsonOutputWidget.this.getSchema();
            schema.getConfig().getDebug().lease();
            BSchemaHistoryDebug historyDebug = schema.getConfig().getDebug().getSchemaOutputHistoryDebug();
            BOrd spyOrd = ObjectUtil.toSpyRemote((BObject)historyDebug);
            BJsonOutputWidget.this.getWbShell().hyperlink(new HyperlinkInfo(spyOrd, BHyperlinkMode.newTab));
            return null;
        }
    }

    protected class Clear
    extends Command {
        Clear() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "clearBtn");
        }

        public CommandArtifact doInvoke() {
            BJsonOutputWidget.this.getSchema().clearOutput();
            return null;
        }
    }

    protected class ClipboardCopy
    extends Command {
        ClipboardCopy() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "clipboardCopyBtn");
        }

        public CommandArtifact doInvoke() {
            Clipboard sysClipboard = Clipboard.getDefault();
            String toCopy = BJsonOutputWidget.this.textField.getText();
            String selectedText = BJsonOutputWidget.this.textField.getModel().getSelectedText();
            if (selectedText != null && !selectedText.isEmpty()) {
                toCopy = selectedText;
            } else {
                BJsonOutputWidget.this.textField.getSelection().selectAll();
            }
            sysClipboard.setContents(TransferEnvelope.make((String)toCopy));
            return null;
        }
    }

    protected class GenerateJson
    extends Command {
        GenerateJson() {
            super((BWidget)BJsonOutputWidget.this, JsonStringUtil.lexicon.module, "generateJsonBtn");
        }

        public CommandArtifact doInvoke() {
            BProgressDialog.openIndeterminate((BWidget)BJsonOutputWidget.this, (String)JsonStringUtil.lexicon.get("generating"), dialog -> {
                BJsonSchema schema = BJsonOutputWidget.this.getSchema();
                schema.lease(30000);
                long outputSetsBefore = schema.getMetrics().getSchemaGenerations();
                schema.forceGenerateJson();
                long start = System.currentTimeMillis();
                while (outputSetsBefore == schema.getMetrics().getSchemaGenerations() && System.currentTimeMillis() - start < 30000L) {
                    if (System.currentTimeMillis() - start > 25000L) {
                        dialog.setTitle(JsonStringUtil.lexicon.get("generateJsonBtn.still.waiting"));
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            });
            return null;
        }
    }

    static class JsonRenderer
    extends TextRenderer {
        JsonRenderer() {
        }

        public BBrush getBackground() {
            return BG;
        }

        public BBrush getForeground(Segment seg) {
            if (seg.type == 8) {
                return BRACKET;
            }
            if (seg.type == 6) {
                return KEYWORD;
            }
            return FG;
        }
    }

    class ToggleTextField
    extends BTextEditor {
        ToggleTextField() {
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            if (event.getClickCount() == 3) {
                BJsonOutputWidget.this.toggleView();
            }
        }
    }
}

