/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.BVideoPlaybackChooser;
import com.tridium.videoDriver.ui.camera.BVideoCameraPickerFE;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.workbench.view.BWbComponentView;

public class BVideoPlaybackChooserView
extends BWbComponentView {
    public static final Action changeCameraSelection = BVideoPlaybackChooserView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoPlaybackChooserView.class);
    protected BVideoCameraPickerFE cameraPicker;
    protected BEdgePane content;
    protected boolean viewLoaded;
    protected BVideoPlaybackChooser videoPlaybackChooser;
    protected BVideoPlayback videoPlayback;
    public static final Logger log = Logger.getLogger("videoDriver.playbackChooserView");

    public void changeCameraSelection() {
        this.invoke(changeCameraSelection, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BIVideoCamera getVideoCameraForInitialLoad() {
        BIVideoCamera videoCamera = this.resolveVideoCameraForInitialLoad();
        if (videoCamera != null && videoCamera instanceof BComponent) {
            try {
                BComponent cameraComponent = (BComponent)videoCamera;
                cameraComponent.lease(0, 10000L);
                cameraComponent.getComponentSpace().sync();
            }
            catch (Exception e) {
                System.out.println("Unable to sync camera: " + videoCamera);
            }
        }
        return videoCamera;
    }

    private BIVideoCamera resolveVideoCameraForInitialLoad() {
        BOrd recentVideoCameraOrd = this.videoPlaybackChooser.getMostRecentCameraViewed();
        if (recentVideoCameraOrd == null || recentVideoCameraOrd.isNull()) {
            return null;
        }
        try {
            BObject resolvedCameraObject = recentVideoCameraOrd.get((BObject)this.videoPlaybackChooser);
            if (resolvedCameraObject != null && resolvedCameraObject instanceof BIVideoCamera) {
                return (BIVideoCamera)resolvedCameraObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void doChangeCameraSelection() {
        String slotPath = this.cameraPicker.saveSlotPath();
        String slotPathOrd = "station:|" + slotPath;
        BOrd cameraOrd = BOrd.make((String)slotPathOrd);
        BObject cameraObject = cameraOrd.get((BObject)this.videoPlaybackChooser);
        if (cameraObject != null && cameraObject instanceof BIVideoCamera && cameraObject instanceof BObject) {
            if (!this.videoPlaybackChooser.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
                FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackChooser, (String)"setMostRecentViewedRpc", (Object[])new Object[]{cameraOrd});
            } else {
                this.videoPlaybackChooser.setMostRecentCameraViewed(cameraOrd);
            }
            if (cameraObject instanceof BComponent) {
                try {
                    BComponent cameraComponent = (BComponent)cameraObject;
                    cameraComponent.lease(0, 10000L);
                    cameraComponent.getComponentSpace().sync();
                }
                catch (Exception e) {
                    System.out.println("Unable to sync camera: " + cameraObject);
                }
            }
            this.videoPlayback.loadValue(cameraObject);
        }
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.videoPlaybackChooser = (BVideoPlaybackChooser)value;
        this.cameraPicker = new BVideoCameraPickerFE((BWidget)this, this.videoPlaybackChooser);
        BEdgePane cameraPickerPane = new BEdgePane();
        cameraPickerPane.setLeft((BWidget)this.cameraPicker);
        BEdgePane content = new BEdgePane();
        content.setTop((BWidget)cameraPickerPane);
        this.videoPlayback = new BVideoPlayback(this.cameraPicker, cameraPickerPane);
        this.videoPlayback.loadValue(null);
        content.setCenter((BWidget)this.videoPlayback);
        this.setContent((BWidget)content);
        this.loadViewAsync();
    }

    public void handleComponentEvent(BComponentEvent event) {
        this.videoPlayback.handleComponentEvent(event);
        super.handleComponentEvent(event);
    }

    public void tryLoadViewAsync() {
        if (this.videoPlaybackChooser.getMostRecentCameraViewed().isNull()) {
            this.cameraPicker.loadValue((BObject)BString.make((String)VideoDriverLexicon.LEX.getText("VideoPlaybackChooserView.ChooseCameraBox.ChooseCamera")));
        } else {
            String ord = this.videoPlaybackChooser.getMostRecentCameraViewed().toString();
            if (ord.startsWith("station:|slot:")) {
                ord = ord.substring(9);
            }
            this.cameraPicker.loadValue((BObject)BString.make((String)ord));
        }
        this.linkTo((BComponent)this.cameraPicker, (Slot)BVideoCameraPickerFE.listActionPerformed, (Slot)changeCameraSelection);
        BIVideoCamera videoCamera = this.getVideoCameraForInitialLoad();
        this.videoPlayback.loadValue((BObject)videoCamera);
    }

    protected void loadViewAsync() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("loadViewAsync");
        }
        new Thread("VideoPlayback.UpdateView"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("VideoPlayback.UpdateView - Thread running. isRunning()=" + BVideoPlaybackChooserView.this.isRunning());
                }
                BVideoPlaybackChooserView.this.viewLoaded = false;
                if (!BVideoPlaybackChooserView.this.isRunning()) {
                    BVideoPlaybackChooserView.this.start();
                }
                while (BVideoPlaybackChooserView.this.isRunning() && !BVideoPlaybackChooserView.this.viewLoaded) {
                    long startOfWhileLoopTicks = Clock.ticks();
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to hook up the view.");
                        }
                        BVideoPlaybackChooserView.this.tryLoadViewAsync();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("View is loaded.");
                        }
                        BVideoPlaybackChooserView.this.viewLoaded = true;
                    }
                    catch (UnresolvedException ue) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Unable to resolve video camera at this time");
                        }
                        BVideoPlaybackChooserView.this.viewLoaded = false;
                        try {
                            long nowTicks = Clock.ticks();
                            long elapsedTimeUntilException = nowTicks - startOfWhileLoopTicks;
                            if (elapsedTimeUntilException < 15000L) {
                                long sleepTime = 16000L - elapsedTimeUntilException;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Will sleep for " + sleepTime + " millis and then retry");
                                }
                                Thread.sleep(sleepTime);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("Will retry immediately");
                        }
                        catch (InterruptedException ie) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("LiveVideo.UpdateView - Thread Interrupted");
                            }
                            return;
                        }
                    }
                    finally {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("LiveVideo.UpdateView - Thread finished");
                    }
                }
            }
        }.start();
    }
}

