/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BLiveVideo
extends BWbView {
    public static final Type TYPE = Sys.loadType(BLiveVideo.class);
    Thread loadViewAsyncThread;
    private static final BIcon icon = BIcon.std((String)"video.png");
    protected BIVideoCamera videoCamera;
    protected boolean viewLoaded = false;
    protected BLabel loadingLabel;
    protected BVideoPtzDialogPane videoPtzPane;
    protected static final boolean DEFAULT_LAYOUT = true;
    protected static final boolean FULLY_RESOLVED_LAYOUT = false;
    public static final Lexicon LEX = Lexicon.make(BLiveVideo.class);
    public static final Logger log = Logger.getLogger("videoDriver.liveVideoView");

    public Type getType() {
        return TYPE;
    }

    protected void loadViewAsync() {
        if (this.loadViewAsyncThread != null && this.loadViewAsyncThread.isAlive()) {
            block4: {
                try {
                    this.loadViewAsyncThread.join(5000L);
                }
                catch (InterruptedException e) {
                    if (!log.isLoggable(Level.FINE)) break block4;
                    log.log(Level.FINE, "LiveVideo.UpdateView - Thread interrupted.", e);
                }
            }
            if (this.loadViewAsyncThread.isAlive()) {
                this.loadViewAsyncThread.interrupt();
            }
        }
        this.loadViewAsyncThread = new Thread("LiveVideo.UpdateView"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("LiveVideo.UpdateView - Thread running.");
                }
                BLiveVideo.this.viewLoaded = false;
                if (!BLiveVideo.this.isRunning()) {
                    BLiveVideo.this.start();
                }
                while (BLiveVideo.this.isRunning() && !BLiveVideo.this.viewLoaded) {
                    long startOfWhileLoopTicks = Clock.ticks();
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to re-draw the view.");
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to hook up the view.");
                        }
                        BLiveVideo.this.tryLoadViewAsync();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("View is loaded.");
                        }
                        BLiveVideo.this.hideLoadingLabel();
                        BLiveVideo.this.viewLoaded = true;
                    }
                    catch (UnresolvedException ue) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Unable to resolve video camera at this time", ue);
                        }
                        BLiveVideo.this.viewLoaded = false;
                        try {
                            long nowTicks = Clock.ticks();
                            long elapsedTimeUntilException = nowTicks - startOfWhileLoopTicks;
                            if (elapsedTimeUntilException < 15000L) {
                                long sleepTime = 16000L - elapsedTimeUntilException;
                                if (!BLiveVideo.this.isRunning()) continue;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Will sleep for " + sleepTime + " millis and then retry");
                                }
                                Thread.sleep(sleepTime);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("Will retry immediately");
                        }
                        catch (InterruptedException ie) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("LiveVideo.UpdateView - Thread Interrupted");
                            }
                            return;
                        }
                    }
                    finally {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("LiveVideo.UpdateView - Thread Finished");
                    }
                }
            }
        };
        this.loadViewAsyncThread.start();
    }

    protected void tryLoadViewAsync() {
        block2: {
            try {
                this.drawView(false);
                this.viewLoaded = true;
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "LiveVideo.UpdateView - Exception calling tryLoadViewAsync", e);
            }
        }
    }

    protected void drawView(boolean def) {
        BVideoLayerPane content = new BVideoLayerPane();
        if (def) {
            BVideoPlayer p = new BVideoPlayer();
            BBorderPane bp = new BBorderPane((BWidget)p, BBorder.inset, BInsets.NULL);
            content.add("borderPane", (BValue)bp);
        } else {
            this.videoPtzPane = new BVideoPtzDialogPane(this.videoCamera, (BWidget)this, this.getPanTiltKeepDownInterval(this.videoCamera), this.getZoomKeepDownInterval(this.videoCamera));
            content.add("videoPtzPane", (BValue)this.videoPtzPane);
        }
        BEdgePane loadingPane = new BEdgePane();
        this.loadingLabel = new BLabel(BImage.make((String)LEX.getText("VideoMultistreamViewer.Loading.Icon")), LEX.getText("VideoMultistreamViewer.Loading.Label"));
        this.loadingLabel.setFont(Theme.label().getLargeBoldFont());
        loadingPane.setCenter((BWidget)this.loadingLabel);
        content.add("loadingPane", (BValue)loadingPane);
        this.setContent((BWidget)content);
    }

    private BRelTime getPanTiltKeepDownInterval(BIVideoCamera videoCamera) {
        try {
            BRelTime interval;
            BComponent videoCameraComponent;
            BStruct controlTiming;
            if (videoCamera != null && videoCamera instanceof BComponent && (controlTiming = (BStruct)(videoCameraComponent = (BComponent)videoCamera).get("controlTiming")) != null && (interval = (BRelTime)controlTiming.get("moveInterval")) != null) {
                return interval;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BRelTime.makeSeconds((int)1);
    }

    private BRelTime getZoomKeepDownInterval(BIVideoCamera videoCamera) {
        try {
            BRelTime interval;
            BComponent videoCameraComponent;
            BStruct controlTiming;
            if (videoCamera != null && videoCamera instanceof BComponent && (controlTiming = (BStruct)(videoCameraComponent = (BComponent)videoCamera).get("controlTiming")) != null && (interval = (BRelTime)controlTiming.get("zoomInterval")) != null) {
                return interval;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BRelTime.makeSeconds((int)1);
    }

    protected void hideLoadingLabel() {
        block2: {
            try {
                this.loadingLabel.setVisible(false);
                ((BWidget)this.loadingLabel.getParent()).setVisible(false);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "LiveVideo.UpdateView - Exception calling hideLoadingLabel()", e);
            }
        }
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (value instanceof BIVideoCamera) {
            this.videoCamera = BVideoPlayback.getVideoSource((BIVideoCamera)value);
            this.drawView(true);
            this.loadViewAsync();
        }
    }

    public void stopped() throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stopped");
        }
        super.stopped();
        if (this.loadViewAsyncThread != null && this.loadViewAsyncThread.isAlive()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Stopping async load thread");
            }
            this.loadViewAsyncThread.interrupt();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

