/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.multistream;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.gx.awt.ImageManager;
import com.tridium.nd.BNiagaraStation;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.BVideoPlaybackMultistream;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoMultistreamAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoMultistreamLayoutTypesEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.multistream.BNoCamera;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamCameraChooserList;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamCameraDropPane;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamDragAndDropCamera;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamGrid2x2Pane;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamGrid3x3Pane;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamLayoutTypesEnumFE;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPictureInPictureLowerLeftPane;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamTwoSmallOneLargePane;
import com.tridium.videoDriver.ui.multistream.BVideoSplitPaneSizerPane;
import com.tridium.videoDriver.ui.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

public class BVideoMultistreamViewer
extends BWbComponentView {
    public static final Action switchVideoLayout = BVideoMultistreamViewer.newAction((int)0, null);
    public static final Action enableSave = BVideoMultistreamViewer.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoMultistreamViewer.class);
    ListPopulatorThreadGroup listPopulatorThreads = new ListPopulatorThreadGroup();
    protected BIVideoCamera NO_CAMERA = new BNoCamera();
    protected BEdgePane mainLeftPane;
    protected SaveCommand save;
    protected RefreshCommand refresh;
    public static final Logger log = Logger.getLogger("videoDriver.multistreamViewer");
    protected static final Lexicon LEX = Lexicon.make(BVideoMultistreamViewer.class);
    protected static final BImage DEFAULT_CAMERA_IMAGE = BImage.make((String)"module://videoDriver/icons/camera.png");
    protected BOrd[] multistreamViewerCameraOrds = new BOrd[16];
    protected Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToMultistreamBindings;
    protected Array<BVideoMultistreamCameraDropPane> dropPanesInUse;
    protected BPane layoutChooserPane;
    protected BPane cameraChooserPane;
    protected BEdgePane viewingPane;
    protected BFrozenEnumFE aspectRatioFE;
    protected BFrozenEnumFE frameRateFE;
    protected BFrozenEnumFE resolutionFE;
    protected BFrozenEnumFE compressionFE;
    protected BVideoPlaybackMultistream videoPlaybackMultistream;
    public final Object switcherSynchronizer = new Object();
    protected BGridPane cameraStackerGrid;
    protected BVideoMultistreamCameraChooserList videoCameraMultistreamChooserList;
    protected BWbFieldEditor videoLayoutChooserFE;
    protected BVideoSplitPaneSizerPane cameraChooserAndMain;
    public static final String MULTISTREAM_VIDEO_BINDING_PROP = "multistreamVideoBinding";
    public static final BImage SMALL_LOADING_ICON = BImage.make((String)LEX.getText("MultistreamViewer.CameraList.CameraDescription.Loading.Icon"));

    public void switchVideoLayout() {
        this.invoke(switchVideoLayout, null, null);
    }

    public void enableSave() {
        this.invoke(enableSave, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoMultistreamViewer() {
        this.linkTo((BComponent)this, (Slot)pluginModified, (Slot)enableSave);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Do load value");
        }
        super.doLoadValue(value, context);
        this.videoPlaybackMultistream = (BVideoPlaybackMultistream)value;
        this.drawView();
        this.loadViewAsync();
    }

    private void drawView() {
        this.drawMultistreamViewer();
        this.setContent((BWidget)this.cameraChooserAndMain);
    }

    private void loadViewAsync() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("loadViewAsync");
        }
        new Thread("VideoMultistreamViewer.UpdateView"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("VideoPlayback.UpdateView - Thread running. isRunning()=" + BVideoMultistreamViewer.this.isRunning());
                }
                boolean viewLoaded = false;
                if (!BVideoMultistreamViewer.this.isRunning()) {
                    BVideoMultistreamViewer.this.start();
                }
                while (BVideoMultistreamViewer.this.isRunning() && !viewLoaded) {
                    long startOfWhileLoopTicks = Clock.ticks();
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to hook up the view.");
                        }
                        BVideoMultistreamViewer.this.tryLoadViewAsync();
                        BVideoMultistreamViewer.this.fillCameraChooserPane();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("View is loaded.");
                        }
                        viewLoaded = true;
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Unable to resolve video camera at this time");
                        }
                        viewLoaded = false;
                        try {
                            long nowTicks = Clock.ticks();
                            long elapsedTimeUntilException = nowTicks - startOfWhileLoopTicks;
                            if (elapsedTimeUntilException < 15000L) {
                                long sleepTime = 16000L - elapsedTimeUntilException;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Will sleep for " + sleepTime + " millis and then retry");
                                }
                                Thread.sleep(sleepTime);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("Will retry immediately");
                        }
                        catch (InterruptedException ie) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("LiveVideo.UpdateView - Thread Interrupted");
                            }
                            return;
                        }
                    }
                    finally {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("LiveVideo.UpdateView - Thread finished");
                    }
                }
            }
        }.start();
    }

    private void tryLoadViewAsync() {
        this.linkTo((BComponent)this.aspectRatioFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.frameRateFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.resolutionFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.compressionFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.videoLayoutChooserFE, (Slot)BVideoMultistreamLayoutTypesEnumFE.pluginModified, (Slot)switchVideoLayout);
        try {
            this.lockModifiedState();
            this.doSwitchVideoLayout();
        }
        finally {
            this.unlockModifiedState();
        }
    }

    public void loadCamerOrds() {
        this.multistreamViewerCameraOrds[0] = this.videoPlaybackMultistream.getCamera1();
        this.multistreamViewerCameraOrds[1] = this.videoPlaybackMultistream.getCamera2();
        this.multistreamViewerCameraOrds[2] = this.videoPlaybackMultistream.getCamera3();
        this.multistreamViewerCameraOrds[3] = this.videoPlaybackMultistream.getCamera4();
        this.multistreamViewerCameraOrds[4] = this.videoPlaybackMultistream.getCamera5();
        this.multistreamViewerCameraOrds[5] = this.videoPlaybackMultistream.getCamera6();
        this.multistreamViewerCameraOrds[6] = this.videoPlaybackMultistream.getCamera7();
        this.multistreamViewerCameraOrds[7] = this.videoPlaybackMultistream.getCamera8();
        this.multistreamViewerCameraOrds[8] = this.videoPlaybackMultistream.getCamera9();
        this.multistreamViewerCameraOrds[9] = this.videoPlaybackMultistream.getCamera10();
        this.multistreamViewerCameraOrds[10] = this.videoPlaybackMultistream.getCamera11();
        this.multistreamViewerCameraOrds[11] = this.videoPlaybackMultistream.getCamera12();
        this.multistreamViewerCameraOrds[12] = this.videoPlaybackMultistream.getCamera13();
        this.multistreamViewerCameraOrds[13] = this.videoPlaybackMultistream.getCamera14();
        this.multistreamViewerCameraOrds[14] = this.videoPlaybackMultistream.getCamera15();
        this.multistreamViewerCameraOrds[15] = this.videoPlaybackMultistream.getCamera16();
    }

    public void drawMultistreamViewer() {
        this.loadCamerOrds();
        this.drawCameraChooserPane();
        this.drawLayoutChooserPane();
        this.mainLeftPane = new BEdgePane();
        this.mainLeftPane.setCenter((BWidget)this.cameraChooserPane);
        this.mainLeftPane.setBottom((BWidget)this.layoutChooserPane);
        this.cameraChooserAndMain = new BVideoSplitPaneSizerPane(BOrientation.horizontal);
        this.cameraChooserAndMain.setWidget1((BWidget)this.mainLeftPane);
        this.viewingPane = new BEdgePane();
        this.viewingPane.setCenter((BWidget)this.getDefaultLayoutPane());
        this.cameraChooserAndMain.setWidget2((BWidget)this.viewingPane);
        this.linkTo((BComponent)this.frameRateFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.resolutionFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.compressionFE, (Slot)BFrozenEnumFE.setModified, (Slot)switchVideoLayout);
        this.linkTo((BComponent)this.videoLayoutChooserFE, (Slot)BVideoMultistreamLayoutTypesEnumFE.pluginModified, (Slot)switchVideoLayout);
    }

    protected BObject doSaveValue(BObject value, Context context) throws CannotSaveException, Exception {
        this.videoPlaybackMultistream.setLayout((BFrozenEnum)this.videoLayoutChooserFE.saveValue());
        this.videoPlaybackMultistream.setAspectRatio((BVideoMultistreamAspectRatioEnum)this.aspectRatioFE.saveValue());
        this.videoPlaybackMultistream.setFrameRate((BVideoFrameRateEnum)this.frameRateFE.saveValue());
        this.videoPlaybackMultistream.setResolution((BVideoResolutionEnum)this.resolutionFE.saveValue());
        this.videoPlaybackMultistream.setCompression((BVideoCompressionEnum)this.compressionFE.saveValue());
        this.videoPlaybackMultistream.setCamera1(this.multistreamViewerCameraOrds[0]);
        this.videoPlaybackMultistream.setCamera2(this.multistreamViewerCameraOrds[1]);
        this.videoPlaybackMultistream.setCamera3(this.multistreamViewerCameraOrds[2]);
        this.videoPlaybackMultistream.setCamera4(this.multistreamViewerCameraOrds[3]);
        this.videoPlaybackMultistream.setCamera5(this.multistreamViewerCameraOrds[4]);
        this.videoPlaybackMultistream.setCamera6(this.multistreamViewerCameraOrds[5]);
        this.videoPlaybackMultistream.setCamera7(this.multistreamViewerCameraOrds[6]);
        this.videoPlaybackMultistream.setCamera8(this.multistreamViewerCameraOrds[7]);
        this.videoPlaybackMultistream.setCamera9(this.multistreamViewerCameraOrds[8]);
        this.videoPlaybackMultistream.setCamera10(this.multistreamViewerCameraOrds[9]);
        this.videoPlaybackMultistream.setCamera11(this.multistreamViewerCameraOrds[10]);
        this.videoPlaybackMultistream.setCamera12(this.multistreamViewerCameraOrds[11]);
        this.videoPlaybackMultistream.setCamera13(this.multistreamViewerCameraOrds[12]);
        this.videoPlaybackMultistream.setCamera14(this.multistreamViewerCameraOrds[13]);
        this.videoPlaybackMultistream.setCamera15(this.multistreamViewerCameraOrds[14]);
        this.videoPlaybackMultistream.setCamera16(this.multistreamViewerCameraOrds[15]);
        return super.doSaveValue(value, context);
    }

    public void updateCameraOrd(int multistreamViewerId, BOrd newViewerOrd) {
        this.doSetModified();
        this.multistreamViewerCameraOrds[multistreamViewerId] = newViewerOrd;
    }

    protected BWbFieldEditor getLayoutChooserFE() {
        return new BVideoMultistreamLayoutTypesEnumFE();
    }

    protected void drawLayoutChooserPane() {
        this.videoLayoutChooserFE = this.getLayoutChooserFE();
        this.aspectRatioFE = new BFrozenEnumFE();
        this.frameRateFE = new BFrozenEnumFE();
        this.resolutionFE = new BFrozenEnumFE();
        this.compressionFE = new BFrozenEnumFE();
        this.save = new SaveCommand();
        this.refresh = new RefreshCommand();
        BGridPane layoutChooserGrid = new BGridPane(2);
        layoutChooserGrid.setColumnAlign(BHalign.left);
        layoutChooserGrid.setHalign(BHalign.left);
        if (!this.videoPlaybackMultistream.getHideAspectRatio()) {
            layoutChooserGrid.add("chooseAspectRatio", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseAspectRatio")));
            layoutChooserGrid.add("aspectRatioChoice", (BValue)this.aspectRatioFE);
        }
        if (!this.videoPlaybackMultistream.getHideFrameRate()) {
            layoutChooserGrid.add("chooseFrameRate", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseFrameRate")));
            layoutChooserGrid.add("frameRateChoice", (BValue)this.frameRateFE);
        }
        if (!this.videoPlaybackMultistream.getHideResolution()) {
            layoutChooserGrid.add("chooseResolution", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseResolution")));
            layoutChooserGrid.add("resolutionChoice", (BValue)this.resolutionFE);
        }
        if (!this.videoPlaybackMultistream.getHideCompression()) {
            layoutChooserGrid.add("chooseCompression", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseCompression")));
            layoutChooserGrid.add("compressionChoice", (BValue)this.compressionFE);
        }
        if (!this.videoPlaybackMultistream.getHideLayout()) {
            layoutChooserGrid.add("chooseLayout", (BValue)new BLabel(LEX.getText("VideoMultistreamViewer.ChooseLayout")));
            layoutChooserGrid.add("layoutChoice", (BValue)this.videoLayoutChooserFE);
        }
        layoutChooserGrid.add("empty1", (BValue)new BNullWidget());
        layoutChooserGrid.add("empty2", (BValue)new BNullWidget());
        this.save.setEnabled(false);
        layoutChooserGrid.add("saveButton", (BValue)new BBorderPane((BWidget)new BButton((Command)this.save), BInsets.make((double)15.0, (double)0.0, (double)0.0, (double)0.0)));
        layoutChooserGrid.add("refreshButton", (BValue)new BBorderPane((BWidget)new BButton((Command)this.refresh), BInsets.make((double)15.0, (double)0.0, (double)0.0, (double)0.0)));
        this.videoLayoutChooserFE.loadValue((BObject)this.videoPlaybackMultistream.getLayout());
        this.aspectRatioFE.loadValue((BObject)this.videoPlaybackMultistream.getAspectRatio());
        this.frameRateFE.loadValue((BObject)this.videoPlaybackMultistream.getFrameRate());
        this.resolutionFE.loadValue((BObject)this.videoPlaybackMultistream.getResolution());
        this.compressionFE.loadValue((BObject)this.videoPlaybackMultistream.getCompression());
        if (!this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
            this.videoLayoutChooserFE.setEnabled(false);
            this.aspectRatioFE.setEnabled(false);
            this.frameRateFE.setEnabled(false);
            this.resolutionFE.setEnabled(false);
            this.compressionFE.setEnabled(false);
        }
        this.layoutChooserPane = new BBorderPane((BWidget)layoutChooserGrid);
    }

    protected void populateList(BOrdList camerasInStation, BGridPane cameraStackerGrid) throws InterruptedException {
        this.listPopulatorThreads.stopAll();
        for (int i = 0; i < camerasInStation.size(); ++i) {
            BOrd cameraOrd = camerasInStation.get(i);
            BObject cameraObject = cameraOrd.get((BObject)this.videoPlaybackMultistream);
            BVideoMultistreamDragAndDropCamera cameraDragAndDropWidget = new BVideoMultistreamDragAndDropCamera(!this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite());
            cameraDragAndDropWidget.setVideoCameraChooserList(this.videoCameraMultistreamChooserList);
            cameraDragAndDropWidget.setCameraOrd(cameraOrd);
            cameraDragAndDropWidget.setImage(SMALL_LOADING_ICON);
            cameraDragAndDropWidget.setText(BVideoMultistreamViewer.getDefaultCameraDragAndDropDescription(cameraObject, true));
            cameraStackerGrid.add("camera" + i, (BValue)cameraDragAndDropWidget);
            RetrieveListItemThread r = new RetrieveListItemThread(cameraOrd, cameraDragAndDropWidget);
            r.start();
        }
    }

    protected void drawCameraChooserPane() {
        this.videoCameraMultistreamChooserList = new BVideoMultistreamCameraChooserList();
        this.cameraStackerGrid = new BGridPane(1);
        this.cameraStackerGrid.setValign(BValign.top);
        this.cameraStackerGrid.setHalign(BHalign.left);
        BFont labelFont = Theme.label().getBoldText();
        labelFont = BFont.make((String)labelFont.getName(), (double)labelFont.getSize(), (int)5);
        BLabel label = new BLabel(VideoDriverLexicon.LEX.getText("VideoMultistreamViewer.DraggableCameras"));
        label.setFont(labelFont);
        this.cameraStackerGrid.add("heading", (BValue)label);
        this.videoCameraMultistreamChooserList.setContent((BWidget)this.cameraStackerGrid);
        BBorderPane cameraStackerBorderPane = new BBorderPane((BWidget)this.videoCameraMultistreamChooserList);
        BScrollPane cameraStackerScrollPane = new BScrollPane((BWidget)cameraStackerBorderPane);
        this.cameraChooserPane = cameraStackerScrollPane;
    }

    protected void fillCameraChooserPane() {
        try {
            if (!this.videoPlaybackMultistream.getPermissions(this.getCurrentContext()).hasAdminWrite()) {
                BOrdList camerasInStation = (BOrdList)FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackMultistream, (String)"getAllCamerasUsingCacheRPC", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC failed for VideoPlaybackMultistream#getAllCamerasUsingCacheRPC"));
                this.populateList(camerasInStation, this.cameraStackerGrid);
            } else {
                BOrdList camerasInStation = this.videoPlaybackMultistream.getAllCamerasUsingCache();
                this.populateList(camerasInStation, this.cameraStackerGrid);
            }
        }
        catch (InterruptedException ie) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Interrupted while populating list");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "ERROR in reading the list of cameras, ", e);
        }
    }

    public static String getDefaultCameraDragAndDropDescription(Object cameraObject, boolean loadingOrResolving) {
        if (cameraObject instanceof BIRemoteVideoCamera) {
            BComponent cameraComponent = (BComponent)cameraObject;
            try {
                cameraComponent.lease(Integer.MAX_VALUE, 10000L);
                cameraComponent.getComponentSpace().sync();
            }
            catch (Exception e) {
                System.out.println("Unable to sync camera: " + cameraObject);
            }
            BIRemoteVideoCamera remoteVideoCamera = (BIRemoteVideoCamera)cameraObject;
            BNiagaraStation niagaraStation = remoteVideoCamera.getNiagaraStation();
            if (niagaraStation != null) {
                String lexKey = loadingOrResolving ? "MultistreamViewer.CameraList.RemoteCamera.Loading" : "MultistreamViewer.CameraList.RemoteCamera.Offline";
                return LEX.getText(lexKey, new Object[]{niagaraStation.getStationName(), cameraComponent.getDisplayName(null)});
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unable to resolve the BNiagaraStation for the BNiagaraCameraPoint");
            }
        }
        Object arg0 = cameraObject;
        if (cameraObject instanceof BComponent) {
            BComponent cameraComponent = (BComponent)cameraObject;
            arg0 = cameraComponent.getName();
        }
        String lexKey = loadingOrResolving ? "MultistreamViewer.CameraList.CameraDescription.Loading.Label" : "MultistreamViewer.CameraList.CameraDescription.Unavailable.Label";
        return VideoDriverLexicon.getLexString((String)lexKey, (Object)arg0);
    }

    public static String getCameraDragAndDropDescription(BObject cameraObject) {
        if (cameraObject instanceof BIVideoCamera) {
            if (cameraObject instanceof BComponent) {
                BComponent cameraComponent = (BComponent)cameraObject;
                try {
                    cameraComponent.lease(Integer.MAX_VALUE, 10000L);
                    cameraComponent.getComponentSpace().sync();
                }
                catch (Exception e) {
                    System.out.println("Unable to sync camera: " + cameraObject);
                }
            }
            BIVideoCamera videoCamera = (BIVideoCamera)cameraObject;
            return videoCamera.getCameraDescription();
        }
        throw new IllegalStateException("Unrecognized cameraObject: " + cameraObject + ". Expected it to be an instance of BIVideoCamera.");
    }

    public static BImage getCameraDragAndDropImage(BObject cameraObject) {
        BImage cameraDragAndDropImage;
        if (cameraObject instanceof BComponent) {
            BComponent cameraComponent = (BComponent)cameraObject;
            cameraDragAndDropImage = BImage.make((BIcon)cameraComponent.getIcon());
        } else {
            cameraDragAndDropImage = DEFAULT_CAMERA_IMAGE;
        }
        return cameraDragAndDropImage;
    }

    public static ComponentAndSlotPath resolveAncestorComponent(ComponentAndSlotPath compInfo, Class<?> ancestorClass) {
        if (compInfo == null) {
            return null;
        }
        if (ancestorClass.isAssignableFrom(compInfo.c.getClass())) {
            return compInfo;
        }
        ComponentAndSlotPath parentInfo = BVideoMultistreamViewer.resolveParentComponent(compInfo);
        return BVideoMultistreamViewer.resolveAncestorComponent(parentInfo, ancestorClass);
    }

    public static ComponentAndSlotPath resolveAncestorComponent(ComponentAndSlotPath compInfo, String ancestorClassName) {
        if (compInfo == null) {
            return null;
        }
        if (ancestorClassName.equals(compInfo.c.getClass().getName())) {
            return compInfo;
        }
        ComponentAndSlotPath parentInfo = BVideoMultistreamViewer.resolveParentComponent(compInfo);
        return BVideoMultistreamViewer.resolveAncestorComponent(parentInfo, ancestorClassName);
    }

    private static SlotPath resolveSlotPath(BComponent root, BOrd rootSlotPathOrd) {
        OrdTarget target = rootSlotPathOrd.resolve((BObject)root);
        OrdQuery[] queries = target.getOrdQueries();
        String slotPathStr = null;
        for (int i = 0; i < queries.length && slotPathStr == null; ++i) {
            if (!queries[i].getScheme().equals("slot")) continue;
            slotPathStr = queries[i].getBody();
        }
        return new SlotPath(slotPathStr);
    }

    protected static ComponentAndSlotPath resolveParentComponent(ComponentAndSlotPath rootInfo) {
        OrdTarget target = rootInfo.spOrd.resolve((BObject)rootInfo.c);
        OrdQuery[] queries = target.getOrdQueries();
        String slotPathStr = null;
        for (int i = 0; i < queries.length && slotPathStr == null; ++i) {
            if (!queries[i].getScheme().equals("slot")) continue;
            slotPathStr = queries[i].getBody();
        }
        if (slotPathStr != null) {
            while (true) {
                SlotPath slotPath;
                SlotPath parentSlotPath;
                if ((parentSlotPath = (slotPath = new SlotPath(slotPathStr)).getParent()) == null) {
                    return null;
                }
                BOrd parentSlotPathOrd = BOrd.make((String)("station:|" + parentSlotPath));
                BComplex parent = (BComplex)parentSlotPathOrd.get((BObject)rootInfo.c);
                if (parent == null) {
                    return null;
                }
                if (parent instanceof BComponent) {
                    return new ComponentAndSlotPath((BComponent)parent, parentSlotPath, parentSlotPathOrd);
                }
                slotPathStr = parentSlotPath.toString();
            }
        }
        return null;
    }

    protected void indexMultistreamDvrsToCameras(Hashtable<BIVideoDvr, Array<BIVideoCamera>> multistreamDvrsToCameras, Hashtable<BIVideoCamera, BIVideoDvr> camerasToMultistreamDvrs, Array<BIVideoCamera> allCameras, BOrd[] cameraOrds) {
        for (int i = 0; i < cameraOrds.length; ++i) {
            BIVideoCamera videoCamera = this.resolveVideoCameraOrd(cameraOrds[i]);
            if (videoCamera == null) {
                allCameras.add((Object)this.NO_CAMERA);
                continue;
            }
            allCameras.add((Object)videoCamera);
            ComponentAndSlotPath cameraInfo = new ComponentAndSlotPath((BComponent)videoCamera, cameraOrds[i]);
            ComponentAndSlotPath videoDvrInfo = BVideoMultistreamViewer.resolveAncestorComponent(cameraInfo, BIVideoDvr.class);
            BIVideoDvr videoDvr = videoDvrInfo == null ? null : (BIVideoDvr)videoDvrInfo.c;
            ComponentAndSlotPath dvrNetInfo = BVideoMultistreamViewer.resolveAncestorComponent(videoDvrInfo == null ? cameraInfo : videoDvrInfo, BDeviceNetwork.class);
            ComponentAndSlotPath remoteVideoSourceInfo = BVideoMultistreamViewer.resolveAncestorComponent(dvrNetInfo, "com.tridium.remoteVideo.BRemoteVideoSource");
            if (remoteVideoSourceInfo != null || videoDvr == null || !videoDvr.supportsMultistream()) continue;
            Array camerasForThisDvr = multistreamDvrsToCameras.get(videoDvr);
            camerasToMultistreamDvrs.put(videoCamera, videoDvr);
            if (camerasForThisDvr == null) {
                camerasForThisDvr = new Array(BIVideoCamera.class);
                camerasForThisDvr.add((Object)videoCamera);
                multistreamDvrsToCameras.put(videoDvr, (Array<BIVideoCamera>)camerasForThisDvr);
                continue;
            }
            camerasForThisDvr.add((Object)videoCamera);
        }
    }

    protected BVideoMultistreamCameraDropPane makeEmptyDropPane(int multistreamViewerId) {
        BVideoPlayer emptyVideoPlayer = new BVideoPlayer();
        BVideoMultistreamCameraDropPane dropPaneForNoCamera = new BVideoMultistreamCameraDropPane(multistreamViewerId);
        emptyVideoPlayer.setHostTransferWidget(dropPaneForNoCamera);
        BBorderPane insetPane = new BBorderPane((BWidget)emptyVideoPlayer, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForNoCamera.setContent((BWidget)insetPane);
        emptyVideoPlayer.add("cameraBinding", (BValue)new BVideoStreamBinding());
        return dropPaneForNoCamera;
    }

    private static BVideoAspectRatioEnum mapMultistreamAspectRatioToAspectRatio(BVideoMultistreamAspectRatioEnum multistreamAspectRatio) {
        return BVideoAspectRatioEnum.make((int)(multistreamAspectRatio.getOrdinal() - 1));
    }

    void configureVideoPlayerFromVideoSource(BVideoPlayer videoPlayer, BIVideoSource videoSource) throws CannotSaveException, Exception {
        BVideoMultistreamAspectRatioEnum aspectRatio = (BVideoMultistreamAspectRatioEnum)this.aspectRatioFE.saveValue();
        if (aspectRatio.equals((Object)BVideoMultistreamAspectRatioEnum.inherit_from_camera)) {
            videoPlayer.setAspectRatio(videoSource.getPreferredAspectRatio());
        } else {
            videoPlayer.setAspectRatio(BVideoMultistreamViewer.mapMultistreamAspectRatioToAspectRatio(aspectRatio));
        }
        videoPlayer.setBackgroundColor(BColor.black);
        videoPlayer.setCompression((BVideoCompressionEnum)this.compressionFE.saveValue());
        videoPlayer.setFrameRate((BVideoFrameRateEnum)this.frameRateFE.saveValue());
        videoPlayer.setResolution((BVideoResolutionEnum)this.resolutionFE.saveValue());
        videoPlayer.setVideoStreamFox(this.videoPlaybackMultistream.getVideoStreamFox());
        videoPlayer.setShowTimeIndex(videoSource.isTimestampPreferred());
    }

    protected BVideoMultistreamCameraDropPane makeVideoCameraDropPaneForStandAloneCamera(BIVideoCamera standAloneCamera, int multistreamViewerId) {
        BVideoPlayer videoPlayerForStandAloneCamera = new BVideoPlayer();
        videoPlayerForStandAloneCamera.setCameraDescription(BVideoMultistreamViewer.getDefaultCameraDragAndDropDescription(standAloneCamera, true));
        try {
            this.configureVideoPlayerFromVideoSource(videoPlayerForStandAloneCamera, (BIVideoSource)standAloneCamera);
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BVideoMultistreamCameraDropPane dropPaneForCamera = new BVideoMultistreamCameraDropPane(multistreamViewerId);
        videoPlayerForStandAloneCamera.setHostTransferWidget(dropPaneForCamera);
        BBorderPane insetPane = new BBorderPane((BWidget)videoPlayerForStandAloneCamera, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForCamera.setContent((BWidget)insetPane);
        this.addVideoStreamBinding(videoPlayerForStandAloneCamera, standAloneCamera);
        return dropPaneForCamera;
    }

    protected void maybeMakeMultistreamPane(Hashtable<BIVideoDvr, BVideoMultistreamPaneForView> multistreamDvrsToMultistreamPanes, Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToMultistreamBindings, BIVideoDvr multistreamVideoDvr) {
        BVideoMultistreamPaneForView multistreamPaneForDvr = multistreamDvrsToMultistreamPanes.get(multistreamVideoDvr);
        if (multistreamPaneForDvr == null) {
            BVideoMultistreamBinding msBinding = new BVideoMultistreamBinding();
            msBinding.setOrd(((BComponent)multistreamVideoDvr).getSlotPathOrd());
            multistreamPaneForDvr = this.makeMultistreamPane(multistreamVideoDvr);
            multistreamPanesToMultistreamBindings.put(multistreamPaneForDvr, msBinding);
            multistreamDvrsToMultistreamPanes.put(multistreamVideoDvr, multistreamPaneForDvr);
        }
    }

    BVideoMultistreamPaneForView makeMultistreamPane(BIVideoDvr multistreamVideoDvr) {
        BVideoMultistreamPaneForView multistreamPaneForDvr = new BVideoMultistreamPaneForView();
        try {
            multistreamPaneForDvr.setCompression((BVideoCompressionEnum)this.compressionFE.saveValue());
            multistreamPaneForDvr.setFrameRate((BVideoFrameRateEnum)this.frameRateFE.saveValue());
            multistreamPaneForDvr.setResolution((BVideoResolutionEnum)this.resolutionFE.saveValue());
            multistreamPaneForDvr.setVideoStreamFox(this.videoPlaybackMultistream.getVideoStreamFox());
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        multistreamPaneForDvr.setVisible(false);
        return multistreamPaneForDvr;
    }

    protected BVideoMultistreamCameraDropPane makeVideoCameraDropPaneForMultistreamStreamCamera(Hashtable<BIVideoDvr, BVideoMultistreamPaneForView> dvrToPaneHash, Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>> panToPlayHash, BIVideoDvr multistreamDvr, BIVideoCamera nextCamera, int multistreamViewerId) {
        BVideoPlayer videoPlayer = new BVideoPlayer();
        videoPlayer.setCameraDescription(nextCamera.getCameraDescription());
        try {
            this.configureVideoPlayerFromVideoSource(videoPlayer, (BIVideoSource)nextCamera);
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BVideoMultistreamPaneForView multistreamPane = dvrToPaneHash.get(multistreamDvr);
        Array videoPlayersForMultistreamPane = panToPlayHash.get((Object)multistreamPane);
        if (videoPlayersForMultistreamPane == null) {
            videoPlayersForMultistreamPane = new Array(BVideoPlayer.class);
            panToPlayHash.put(multistreamPane, (Array<BVideoPlayer>)videoPlayersForMultistreamPane);
        }
        videoPlayersForMultistreamPane.add((Object)videoPlayer);
        videoPlayer.setMultistreamPaneForView(multistreamPane);
        BVideoMultistreamCameraDropPane dropPaneForCamera = new BVideoMultistreamCameraDropPane(multistreamViewerId);
        videoPlayer.setHostTransferWidget(dropPaneForCamera);
        BVideoStreamBinding videoPlayerBinding = new BVideoStreamBinding();
        videoPlayerBinding.setOrd(((BComponent)nextCamera).getSlotPathOrd());
        videoPlayer.add("cameraBinding", (BValue)videoPlayerBinding);
        BBorderPane insetPane = new BBorderPane((BWidget)videoPlayer, BBorder.inset, BInsets.make((double)0.0));
        dropPaneForCamera.setContent((BWidget)insetPane);
        return dropPaneForCamera;
    }

    protected boolean isStandAloneCamera(Hashtable<BIVideoDvr, Array<BIVideoCamera>> multistreamDvrsToCameras, BIVideoCamera nextCamera, BIVideoDvr multistreamDvr) {
        if (multistreamDvr == null) {
            return true;
        }
        Array<BIVideoCamera> camerasForMultistreamDvr = multistreamDvrsToCameras.get(multistreamDvr);
        return camerasForMultistreamDvr.size() < 2;
    }

    protected BIVideoPlayer[] getVideoPlayersToMultistreamPane(BVideoMultistreamPaneForView multistreamPane, Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>> multistreamPanesToVideoPlayers) {
        BVideoPlayer[] videoPlayersForMultistreamPane = (BVideoPlayer[])multistreamPanesToVideoPlayers.get((Object)multistreamPane).trim();
        BIVideoPlayer[] biVideoPlayers = new BIVideoPlayer[videoPlayersForMultistreamPane.length];
        System.arraycopy(videoPlayersForMultistreamPane, 0, biVideoPlayers, 0, videoPlayersForMultistreamPane.length);
        return biVideoPlayers;
    }

    protected Array<?> makeVideoPlayerDropPanes(BOrd[] cameraOrds) {
        Hashtable<BIVideoDvr, Array<BIVideoCamera>> multistreamDvrsToCameras = new Hashtable<BIVideoDvr, Array<BIVideoCamera>>(cameraOrds.length);
        Hashtable<BIVideoCamera, BIVideoDvr> camerasToMultistreamDvrs = new Hashtable<BIVideoCamera, BIVideoDvr>(cameraOrds.length);
        Array allCameras = new Array(BIVideoCamera.class);
        this.indexMultistreamDvrsToCameras(multistreamDvrsToCameras, camerasToMultistreamDvrs, (Array<BIVideoCamera>)allCameras, cameraOrds);
        Array videoPlayerDropPanes = new Array(BVideoMultistreamCameraDropPane.class);
        Hashtable<BIVideoDvr, BVideoMultistreamPaneForView> multistreamDvrsToMultistreamPanes = new Hashtable<BIVideoDvr, BVideoMultistreamPaneForView>(multistreamDvrsToCameras.size());
        Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>> multistreamPanesToVideoPlayers = new Hashtable<BVideoMultistreamPaneForView, Array<BVideoPlayer>>();
        Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToMultistreamBindings = new Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding>();
        ListIterator iterateAllCameras = allCameras.iterator();
        int multistreamViewerId = 0;
        while (iterateAllCameras.hasNext()) {
            BVideoMultistreamCameraDropPane dropPaneForCamera;
            BIVideoCamera nextCamera = (BIVideoCamera)iterateAllCameras.next();
            if (nextCamera == this.NO_CAMERA) {
                dropPaneForCamera = this.makeEmptyDropPane(multistreamViewerId++);
            } else {
                BIVideoDvr multistreamDvr = camerasToMultistreamDvrs.get(nextCamera);
                boolean isStandAloneCamera = this.isStandAloneCamera(multistreamDvrsToCameras, nextCamera, multistreamDvr);
                if (isStandAloneCamera) {
                    dropPaneForCamera = this.makeVideoCameraDropPaneForStandAloneCamera(nextCamera, multistreamViewerId++);
                } else {
                    this.maybeMakeMultistreamPane(multistreamDvrsToMultistreamPanes, multistreamPanesToMultistreamBindings, multistreamDvr);
                    dropPaneForCamera = this.makeVideoCameraDropPaneForMultistreamStreamCamera(multistreamDvrsToMultistreamPanes, multistreamPanesToVideoPlayers, multistreamDvr, nextCamera, multistreamViewerId++);
                }
            }
            videoPlayerDropPanes.add((Object)dropPaneForCamera);
        }
        Array retVal = new Array(Object.class);
        Enumeration multistreamPanes = multistreamPanesToVideoPlayers.keys();
        while (multistreamPanes.hasMoreElements()) {
            BVideoMultistreamPaneForView multistreamPane = (BVideoMultistreamPaneForView)((Object)multistreamPanes.nextElement());
            BIVideoPlayer[] biVideoPlayers = this.getVideoPlayersToMultistreamPane(multistreamPane, multistreamPanesToVideoPlayers);
            multistreamPane.setVideoPlayersForView(biVideoPlayers);
            retVal.add((Object)multistreamPane);
        }
        retVal.addAll(videoPlayerDropPanes);
        retVal.add(multistreamPanesToMultistreamBindings);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> getMultistreamPanesAndTheirBindings() {
        Object object = this.switcherSynchronizer;
        synchronized (object) {
            return this.multistreamPanesToMultistreamBindings;
        }
    }

    public BVideoMultistreamDragAndDropCamera[] getDragAndDropItems() {
        return (BVideoMultistreamDragAndDropCamera[])this.cameraStackerGrid.getChildren(BVideoMultistreamDragAndDropCamera.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array<BVideoMultistreamCameraDropPane> getDropPanesInUse() {
        Object object = this.switcherSynchronizer;
        synchronized (object) {
            return this.dropPanesInUse;
        }
    }

    public void doSwitchVideoLayout() {
        try {
            BVideoMultistreamLayoutTypesEnum multistreamLayout = (BVideoMultistreamLayoutTypesEnum)this.videoLayoutChooserFE.saveValue();
            BPane newLayoutPane = this.getNewVideoMultistreamPaneForLayout(multistreamLayout);
            BOrd[] newCameraOrds = this.getNewVideoCameraOrdsForLayout(multistreamLayout);
            Property[] newLayoutPaneProperties = this.getNewVideoMultistreamPanePropertiesLayout(multistreamLayout);
            this.switchVideoLayout(newLayoutPane, newCameraOrds, newLayoutPaneProperties);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to switch layout: " + e);
        }
    }

    public BPane getDefaultLayoutPane() {
        try {
            BVideoMultistreamLayoutTypesEnum multistreamLayout = (BVideoMultistreamLayoutTypesEnum)this.videoLayoutChooserFE.saveValue();
            BPane layoutPane = this.getNewVideoMultistreamPaneForLayout(multistreamLayout);
            Property[] videoPlayerProperties = this.getNewVideoMultistreamPanePropertiesLayout(multistreamLayout);
            for (int i = 0; i < videoPlayerProperties.length; ++i) {
                BVideoLayerPane layerPane = new BVideoLayerPane();
                layerPane.add("dummyVideoPlayer", (BValue)new BBorderPane((BWidget)new BVideoPlayer(), BBorder.inset, BInsets.NULL));
                BEdgePane loadingPane = new BEdgePane();
                BLabel loadingLabel = new BLabel(BImage.make((String)LEX.getText("VideoMultistreamViewer.Loading.Icon")), LEX.getText("VideoMultistreamViewer.Loading.Label"));
                loadingLabel.setFont(Theme.label().getLargeBoldFont());
                loadingPane.setCenter((BWidget)loadingLabel);
                layerPane.add("loadingPane", (BValue)loadingPane);
                layoutPane.set(videoPlayerProperties[i], (BValue)layerPane);
            }
            return layoutPane;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to switch layout: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchVideoLayout(BPane layoutPane, BOrd[] cameraOrds, Property[] paneWidgetProperties) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("switchVideoLayout");
        }
        Object object = this.switcherSynchronizer;
        synchronized (object) {
            this.doSetModified();
            BWidget[] childWidgets = this.getChildWidgets();
            for (int i = 0; i < childWidgets.length; ++i) {
                if (!(childWidgets[i] instanceof BVideoMultistreamPaneForView) || !childWidgets[i].getPropertyInParent().isDynamic()) continue;
                this.remove((BComplex)childWidgets[i]);
            }
            Array<?> miscellaneousObjects = this.makeVideoPlayerDropPanes(cameraOrds);
            this.multistreamPanesToMultistreamBindings = (Hashtable)miscellaneousObjects.pop();
            this.dropPanesInUse = new Array(BVideoMultistreamCameraDropPane.class);
            ListIterator i = miscellaneousObjects.iterator();
            int playerIndex = 0;
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof BVideoMultistreamCameraDropPane) {
                    if (playerIndex < paneWidgetProperties.length) {
                        BVideoMultistreamCameraDropPane nextDropPane = (BVideoMultistreamCameraDropPane)((Object)next);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Adding drop pane: " + nextDropPane.hashCode());
                        }
                        this.dropPanesInUse.add((Object)nextDropPane);
                        layoutPane.set(paneWidgetProperties[playerIndex], (BValue)nextDropPane);
                        ++playerIndex;
                        continue;
                    }
                    throw new IllegalStateException("Too many drop panes for video layout.");
                }
                if (next instanceof BVideoMultistreamPaneForView) {
                    this.add("multistreamPaneForView?", (BValue)((BVideoMultistreamPaneForView)((Object)next)));
                    continue;
                }
                throw new IllegalStateException("Unsupported array object class: " + next.getClass());
            }
            this.viewingPane.setCenter((BWidget)layoutPane);
            Enumeration<BVideoMultistreamPaneForView> multistreamPanes = this.multistreamPanesToMultistreamBindings.keys();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Initiate video streams");
            }
            while (multistreamPanes.hasMoreElements()) {
                BVideoMultistreamPaneForView pane = multistreamPanes.nextElement();
                BVideoMultistreamBinding msBinding = this.multistreamPanesToMultistreamBindings.get((Object)pane);
                pane.add(MULTISTREAM_VIDEO_BINDING_PROP, (BValue)msBinding);
            }
            this.updateVideoPaneStatusBarDescriptions();
        }
    }

    protected BPane getNewVideoMultistreamPaneForLayout(BVideoMultistreamLayoutTypesEnum multistreamLayout) {
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.oneVideoPlayer) {
            return new BEdgePane();
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.twoSmallOneLarge) {
            return new BVideoMultistreamTwoSmallOneLargePane();
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.pictureInPictureLowerLeft) {
            return new BVideoMultistreamPictureInPictureLowerLeftPane();
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid2x2) {
            return new BVideoMultistreamGrid2x2Pane();
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid3x3) {
            return new BVideoMultistreamGrid3x3Pane();
        }
        throw new BajaRuntimeException("Unsupported Layout: " + multistreamLayout);
    }

    protected BOrd[] getNewVideoCameraOrdsForLayout(BVideoMultistreamLayoutTypesEnum multistreamLayout) {
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.oneVideoPlayer) {
            return new BOrd[]{this.multistreamViewerCameraOrds[0]};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.twoSmallOneLarge) {
            return new BOrd[]{this.multistreamViewerCameraOrds[0], this.multistreamViewerCameraOrds[1], this.multistreamViewerCameraOrds[2]};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.pictureInPictureLowerLeft) {
            return new BOrd[]{this.multistreamViewerCameraOrds[0], this.multistreamViewerCameraOrds[1]};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid2x2) {
            return new BOrd[]{this.multistreamViewerCameraOrds[0], this.multistreamViewerCameraOrds[1], this.multistreamViewerCameraOrds[2], this.multistreamViewerCameraOrds[3]};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid3x3) {
            return new BOrd[]{this.multistreamViewerCameraOrds[0], this.multistreamViewerCameraOrds[1], this.multistreamViewerCameraOrds[2], this.multistreamViewerCameraOrds[3], this.multistreamViewerCameraOrds[4], this.multistreamViewerCameraOrds[5], this.multistreamViewerCameraOrds[6], this.multistreamViewerCameraOrds[7], this.multistreamViewerCameraOrds[8]};
        }
        throw new BajaRuntimeException("Unsupported Layout: " + multistreamLayout);
    }

    protected Property[] getNewVideoMultistreamPanePropertiesLayout(BVideoMultistreamLayoutTypesEnum multistreamLayout) {
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.oneVideoPlayer) {
            return new Property[]{BEdgePane.center};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.twoSmallOneLarge) {
            return new Property[]{BVideoMultistreamTwoSmallOneLargePane.bigOne, BVideoMultistreamTwoSmallOneLargePane.topLeft, BVideoMultistreamTwoSmallOneLargePane.topRight};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.pictureInPictureLowerLeft) {
            return new Property[]{BVideoMultistreamPictureInPictureLowerLeftPane.bigOne, BVideoMultistreamPictureInPictureLowerLeftPane.littleOne};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid2x2) {
            return new Property[]{BVideoMultistreamGrid2x2Pane.row1Col1, BVideoMultistreamGrid2x2Pane.row1Col2, BVideoMultistreamGrid2x2Pane.row2Col1, BVideoMultistreamGrid2x2Pane.row2Col2};
        }
        if (multistreamLayout == BVideoMultistreamLayoutTypesEnum.grid3x3) {
            return new Property[]{BVideoMultistreamGrid3x3Pane.row1Col1, BVideoMultistreamGrid3x3Pane.row1Col2, BVideoMultistreamGrid3x3Pane.row1Col3, BVideoMultistreamGrid3x3Pane.row2Col1, BVideoMultistreamGrid3x3Pane.row2Col2, BVideoMultistreamGrid3x3Pane.row2Col3, BVideoMultistreamGrid3x3Pane.row3Col1, BVideoMultistreamGrid3x3Pane.row3Col2, BVideoMultistreamGrid3x3Pane.row3Col3};
        }
        throw new BajaRuntimeException("Unsupported Layout: " + multistreamLayout);
    }

    private BIVideoCamera resolveVideoCameraOrd(BOrd videoCameraStationOrd) {
        BIVideoCamera videoCamera;
        if (!videoCameraStationOrd.toString().startsWith("station:|")) {
            videoCameraStationOrd = BOrd.make((String)("station:|" + videoCameraStationOrd.toString()));
        }
        try {
            videoCamera = (BIVideoCamera)videoCameraStationOrd.get((BObject)this.videoPlaybackMultistream);
        }
        catch (Exception e) {
            videoCamera = null;
        }
        return videoCamera;
    }

    protected void addVideoStreamBinding(BVideoPlayer videoPlayer, BIVideoCamera videoCamera) {
        BComponent videoCameraComponent = (BComponent)videoCamera;
        BVideoStreamBinding videoStreamBinding = new BVideoStreamBinding();
        BOrd videoCameraStationOrd = videoCameraComponent.getSlotPathOrd();
        if (!videoCameraStationOrd.toString().startsWith("station:|")) {
            videoCameraStationOrd = BOrd.make((String)("station:|" + videoCameraStationOrd.toString()));
        }
        videoStreamBinding.setOrd(videoCameraStationOrd);
        videoPlayer.add("cameraBinding", (BValue)videoStreamBinding);
        OrdTarget bindingTarget = videoCameraStationOrd.resolve((BObject)videoCameraComponent);
        videoStreamBinding.fw(303, bindingTarget, null, null, null);
    }

    public BVideoPlaybackMultistream getVideoPlaybackMultistream() {
        return this.videoPlaybackMultistream;
    }

    public void updateVideoPaneStatusBarDescriptions() {
        BVideoMultistreamDragAndDropCamera[] dragDropItems = this.getDragAndDropItems();
        for (int i = 0; i < dragDropItems.length; ++i) {
            this.updateDescriptionCorrespondingViewPane(dragDropItems[i]);
        }
    }

    public void updateDescriptionCorrespondingViewPane(BVideoMultistreamDragAndDropCamera dragDropItem) {
        String dragDropCameraDescription = dragDropItem.getText();
        BOrd cameraOrd = dragDropItem.getCameraOrd();
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":Updating corresponding view pane description (if camera being viewed)");
        }
        BOrd stationCameraOrd = BOrd.make((String)("station:|" + cameraOrd));
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + cameraOrd);
        }
        Array<BVideoMultistreamCameraDropPane> dropPanesInUse = this.getDropPanesInUse();
        BVideoMultistreamCameraDropPane dropPane2 = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("UD:" + dragDropCameraDescription + ":Preparing to iterate over drop panes in use.");
        }
        for (BVideoMultistreamCameraDropPane dropPane2 : dropPanesInUse) {
            BOrd bindingOrd;
            BVideoStreamBinding binding;
            if (dropPane2 == null || (binding = dropPane2.findVideoPlayerBinding()) == null || ((bindingOrd = binding.getOrd()) == null || !bindingOrd.equals((Object)cameraOrd)) && !bindingOrd.equals((Object)stationCameraOrd)) continue;
            BVideoPlayer videoPlayer = dropPane2.findVideoPlayer();
            videoPlayer.setCameraDescription(dragDropCameraDescription);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("UD:" + dragDropCameraDescription + ":Updated description");
        }
    }

    public void doEnableSave() {
        this.save.setEnabled(true);
    }

    public class RefreshCommand
    extends Command {
        RefreshCommand() {
            super((BWidget)BVideoMultistreamViewer.this, UiLexicon.bajaui().module, "commands.refresh");
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            BNiagaraWbShell niagaraWbShell = (BNiagaraWbShell)BVideoMultistreamViewer.this.getWbShell();
            if (event.isControlDown()) {
                ImageManager.trimAll();
            }
            niagaraWbShell.hyperlink((HyperlinkInfo)new NHyperlinkInfo(niagaraWbShell.getActiveOrd(), BHyperlinkMode.replace, false));
            return null;
        }
    }

    public class SaveCommand
    extends Command {
        SaveCommand() {
            super((BWidget)BVideoMultistreamViewer.this, UiLexicon.bajaui().module, "commands.save");
        }

        public CommandArtifact doInvoke() {
            BNiagaraWbShell niagaraWbShell = (BNiagaraWbShell)BVideoMultistreamViewer.this.getWbShell();
            niagaraWbShell.save((BWbView)BVideoMultistreamViewer.this);
            BVideoMultistreamViewer.this.save.setEnabled(false);
            return null;
        }
    }

    static class ComponentAndSlotPath {
        BComponent c;
        SlotPath sp;
        BOrd spOrd;

        ComponentAndSlotPath(BComponent c, SlotPath sp, BOrd spOrd) {
            this.c = c;
            this.sp = sp;
            this.spOrd = spOrd;
            if (sp == null) {
                this.sp = BVideoMultistreamViewer.resolveSlotPath(c, spOrd);
            }
        }

        ComponentAndSlotPath(BComponent c, BOrd spOrd) {
            this(c, BVideoMultistreamViewer.resolveSlotPath(c, spOrd), spOrd);
        }
    }

    public class RetrieveListItemThread
    extends Thread {
        BOrd cameraOrd;
        BVideoMultistreamDragAndDropCamera cameraDragAndDropWidget;
        boolean running;

        public RetrieveListItemThread(BOrd cameraOrd, BVideoMultistreamDragAndDropCamera cameraDragAndDropWidget) {
            super("MultistreamViewer.RetrieveListItem");
            this.cameraOrd = cameraOrd;
            this.cameraDragAndDropWidget = cameraDragAndDropWidget;
            this.running = true;
            BVideoMultistreamViewer.this.listPopulatorThreads.add(this);
        }

        public void pleaseStop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (BVideoMultistreamViewer.this.isRunning() && this.running) {
                    BObject cameraObject = this.cameraOrd.get((BObject)BVideoMultistreamViewer.this.videoPlaybackMultistream);
                    try {
                        String dragDropCameraDescription = BVideoMultistreamViewer.getCameraDragAndDropDescription(cameraObject);
                        this.cameraDragAndDropWidget.setText(dragDropCameraDescription);
                        this.cameraDragAndDropWidget.setImage(BVideoMultistreamViewer.getCameraDragAndDropImage(cameraObject));
                        if (!BVideoMultistreamViewer.this.isRunning() || !this.running) continue;
                        this.running = false;
                        Object object = BVideoMultistreamViewer.this.switcherSynchronizer;
                        synchronized (object) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":Entered synchronized(switcherSynhronizer) block");
                            }
                            BOrd stationCameraOrd = BOrd.make((String)("station:|" + this.cameraOrd));
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":stationCameraOrd=" + stationCameraOrd + " cameraOrd=" + this.cameraOrd);
                            }
                            Array<BVideoMultistreamCameraDropPane> dropPanesInUse = BVideoMultistreamViewer.this.getDropPanesInUse();
                            BVideoMultistreamCameraDropPane dropPane2 = null;
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(dragDropCameraDescription + ":Preparing to iterate over drop panes in use.");
                            }
                            for (BVideoMultistreamCameraDropPane dropPane2 : dropPanesInUse) {
                                BOrd bindingOrd;
                                BVideoStreamBinding binding;
                                if (dropPane2 == null || (binding = dropPane2.findVideoPlayerBinding()) == null || ((bindingOrd = binding.getOrd()) == null || !bindingOrd.equals((Object)this.cameraOrd)) && !bindingOrd.equals((Object)stationCameraOrd)) continue;
                                BVideoPlayer videoPlayer = dropPane2.findVideoPlayer();
                                videoPlayer.setCameraDescription(dragDropCameraDescription);
                            }
                        }
                    }
                    catch (RuntimeException rte) {
                        this.cameraDragAndDropWidget.setImage(BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/error.png"))));
                        this.cameraDragAndDropWidget.setText(BVideoMultistreamViewer.getDefaultCameraDragAndDropDescription(cameraObject, false));
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Exception setting text of a list item.\n>> Ord = " + this.cameraOrd + "\n>> Exception = " + rte, rte);
                    }
                    finally {
                        this.running = false;
                    }
                }
            }
            finally {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("List populator thread stopped. Ord = " + this.cameraOrd);
                }
            }
        }
    }

    public class ListPopulatorThreadGroup {
        LinkedList<RetrieveListItemThread> threads = new LinkedList();

        public synchronized void add(RetrieveListItemThread r) {
            this.threads.add(r);
        }

        public synchronized void stopAll() throws InterruptedException {
            LinkedList<RetrieveListItemThread> itemsToRemove = new LinkedList<RetrieveListItemThread>();
            RetrieveListItemThread r2 = null;
            for (RetrieveListItemThread r2 : this.threads) {
                if (r2 == null || !r2.isAlive()) continue;
                r2.pleaseStop();
                r2.join(100L);
                if (r2.isAlive()) continue;
                itemsToRemove.add(r2);
            }
            this.threads.removeAll(itemsToRemove);
        }
    }
}

