/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.multistream;

import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamViewer;
import com.tridium.videoDriver.ui.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;

public class BVideoMultistreamCameraDropPane
extends BTransferWidget {
    public static final Property content = BVideoMultistreamCameraDropPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Type TYPE = Sys.loadType(BVideoMultistreamCameraDropPane.class);
    protected boolean draggingOver = false;
    protected int multistreamViewerId;
    public static BBrush HALF_TRANSPARENT_GREEN = BBrush.makeSolid((BColor)BColor.make((int)BColor.limeGreen.getRed(), (int)BColor.limeGreen.getGreen(), (int)BColor.limeGreen.getBlue(), (int)128));

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoMultistreamCameraDropPane() {
    }

    public BVideoMultistreamCameraDropPane(int multistreamViewerId) {
        this.multistreamViewerId = multistreamViewerId;
    }

    public BVideoMultistreamViewer findVideoMultistreamViewer() {
        BWidget p = this.getParentWidget();
        while (!(p instanceof BVideoMultistreamViewer)) {
            p = p.getParentWidget();
        }
        return (BVideoMultistreamViewer)p;
    }

    public void doLayout(BWidget[] layout) {
        BWidget w = this.getContent();
        w.computePreferredSize();
        w.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public Point translateToChild(BWidget child, Point pt) {
        return super.translateToChild(child, pt);
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean isDraggingSpecialMultistreamCameraWidget(TransferContext cx) {
        TransferEnvelope transferEnvelop = cx.getEnvelope();
        try {
            String transferString = (String)transferEnvelop.getData(TransferFormat.string);
            return transferString.startsWith("dragFromChooserList:");
        }
        catch (UnsupportedFormatException ufe) {
            return false;
        }
    }

    public int dragOver(TransferContext cx) {
        if (this.isDraggingSpecialMultistreamCameraWidget(cx)) {
            return 16;
        }
        return 0;
    }

    public void dragEnter(TransferContext cx) {
        if (this.isDraggingSpecialMultistreamCameraWidget(cx)) {
            this.draggingOver = true;
            this.repaint();
        }
        super.dragEnter(cx);
    }

    public void dragExit(TransferContext cx) {
        if (this.isDraggingSpecialMultistreamCameraWidget(cx)) {
            this.draggingOver = false;
            this.repaint();
        }
        super.dragExit(cx);
    }

    public BOrd getCameraOrd(TransferContext cx) {
        TransferEnvelope transferEnvelop = cx.getEnvelope();
        try {
            String transferString = (String)transferEnvelop.getData(TransferFormat.string);
            if (transferString.startsWith("dragFromChooserList:")) {
                String ordString = transferString.substring("dragFromChooserList:".length());
                if (!ordString.startsWith("station:|")) {
                    ordString = "station:|" + ordString;
                }
                return BOrd.make((String)ordString);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.isDraggingSpecialMultistreamCameraWidget(cx)) {
            BOrd videoCameraStationOrd = this.getCameraOrd(cx);
            DropProcessor dropProcessor = new DropProcessor(videoCameraStationOrd);
            dropProcessor.start();
            this.draggingOver = false;
            this.repaint();
        }
        return super.drop(cx);
    }

    protected void maybeChangeCursorToHand(BMouseEvent event) {
        BVideoStreamBinding videoPlayerBinding = this.findVideoPlayerBinding();
        if (videoPlayerBinding != null && videoPlayerBinding.getOrd() != null && !videoPlayerBinding.getOrd().equals((Object)BOrd.NULL)) {
            this.setMouseCursor(MouseCursor.hand);
            this.findVideoPlayer().setMouseCursor(MouseCursor.hand);
        }
    }

    public void mouseEntered(BMouseEvent event) {
        this.maybeChangeCursorToHand(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.setMouseCursor(MouseCursor.normal);
        this.findVideoPlayer().setMouseCursor(MouseCursor.normal);
    }

    public void mouseReleased(BMouseEvent event) {
        BWbShell wbShell;
        BOrd videoCameraOrd;
        BVideoStreamBinding videoPlayerBinding;
        if (event.isButton1Down() && event.getClickCount() == 1 && (videoPlayerBinding = this.findVideoPlayerBinding()) != null && (videoCameraOrd = videoPlayerBinding.getOrd()) != null && !videoCameraOrd.equals((Object)BOrd.NULL) && (wbShell = BWbShell.getWbShell((BWidget)this)) != null) {
            wbShell.hyperlink(new HyperlinkInfo(videoCameraOrd, (BInputEvent)event));
        }
    }

    public BVideoPlayer findVideoPlayer() {
        return BVideoMultistreamCameraDropPane.findVideoPlayer((BWidget)this);
    }

    public BVideoStreamBinding findVideoPlayerBinding() {
        BVideoPlayer videoPlayer = this.findVideoPlayer();
        if (videoPlayer == null) {
            return null;
        }
        BBinding[] videoPlayerBindings = videoPlayer.getBindings();
        if (videoPlayerBindings == null) {
            return null;
        }
        for (int i = 0; i < videoPlayerBindings.length; ++i) {
            if (videoPlayerBindings[i] == null || !(videoPlayerBindings[i] instanceof BVideoStreamBinding)) continue;
            return (BVideoStreamBinding)videoPlayerBindings[i];
        }
        return null;
    }

    public BDeviceNetwork findNetwork(BComplex root) {
        if (root == null) {
            return null;
        }
        if (root instanceof BDeviceNetwork) {
            return (BDeviceNetwork)root;
        }
        return this.findNetwork(root.getParent());
    }

    public static BVideoPlayer findVideoPlayer(BWidget root) {
        if (root == null) {
            return null;
        }
        if (root instanceof BVideoPlayer) {
            return (BVideoPlayer)root;
        }
        BWidget[] childWidgets = root.getChildWidgets();
        for (int i = 0; i < childWidgets.length; ++i) {
            BVideoPlayer videoPlayer = BVideoMultistreamCameraDropPane.findVideoPlayer(childWidgets[i]);
            if (videoPlayer == null) continue;
            return videoPlayer;
        }
        return null;
    }

    protected BIVideoCamera getVideoCamera(BVideoPlayer videoPlayer) {
        if (videoPlayer == null) {
            return null;
        }
        BVideoStreamBinding videoStreamBinding = (BVideoStreamBinding)videoPlayer.get("cameraBinding");
        if (videoStreamBinding == null) {
            return null;
        }
        BOrd videoCameraOrd = videoStreamBinding.getOrd();
        if (videoCameraOrd.equals((Object)BOrd.NULL)) {
            return null;
        }
        BObject oldVideoCameraObject = videoCameraOrd.get((BObject)this.findVideoMultistreamViewer().getVideoPlaybackMultistream());
        if (oldVideoCameraObject != null && oldVideoCameraObject instanceof BIVideoCamera) {
            return (BIVideoCamera)oldVideoCameraObject;
        }
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.draggingOver) {
            g.setBrush(HALF_TRANSPARENT_GREEN);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public class DropProcessor
    extends Thread {
        BVideoMultistreamViewer.ComponentAndSlotPath newCameraInfo;
        BVideoMultistreamViewer.ComponentAndSlotPath oldCameraInfo;
        BOrd newVideoCameraStationOrd;
        BVideoPlayer videoPlayer;
        BVideoStreamBinding oldVideoStreamBinding;
        BOrd oldVideoCameraOrd;
        BIVideoCamera oldVideoCamera;
        BIVideoCamera newVideoCamera;
        BObject objectMountedInStation;
        BVideoMultistreamViewer multistreamViewer;

        public DropProcessor(BOrd videoCameraStationOrd) {
            super("MultistreamViewer.DropProcessor");
            this.newVideoCameraStationOrd = videoCameraStationOrd;
        }

        public void prepareForRun() {
            this.multistreamViewer = BVideoMultistreamCameraDropPane.this.findVideoMultistreamViewer();
            if (this.multistreamViewer == null) {
                throw new IllegalStateException("Expected for this BVideoCameraDropPane to be a descendant widget of a BVideoMultistreamViewer.");
            }
            this.objectMountedInStation = BVideoMultistreamCameraDropPane.this.findVideoMultistreamViewer().getVideoPlaybackMultistream();
            if (this.objectMountedInStation == null) {
                throw new IllegalStateException("Expected for this BVideoCameraDropPane's parent BVidoeMultistreamViewer's video playback multistream component to not be null.");
            }
            BObject newVideoCameraObject = this.newVideoCameraStationOrd.get(this.objectMountedInStation);
            if (newVideoCameraObject == null || !(newVideoCameraObject instanceof BIVideoCamera)) {
                throw new IllegalArgumentException("This given 'videoCameraStationOrd' does not resolve to a BIVideoCamera.");
            }
            this.newVideoCamera = (BIVideoCamera)newVideoCameraObject;
            this.newCameraInfo = new BVideoMultistreamViewer.ComponentAndSlotPath((BComponent)newVideoCameraObject, this.newVideoCameraStationOrd);
            this.videoPlayer = BVideoMultistreamCameraDropPane.this.findVideoPlayer();
            if (this.videoPlayer == null) {
                throw new IllegalStateException("Unable to find video player for BVideoCameraDropPane.");
            }
            this.oldVideoStreamBinding = (BVideoStreamBinding)this.videoPlayer.get("cameraBinding");
            if (this.oldVideoStreamBinding == null) {
                throw new IllegalStateException("Unable to find 'cameraBinding' for the videoPlayer.");
            }
            this.oldVideoCameraOrd = this.oldVideoStreamBinding.getOrd();
            if (!this.oldVideoCameraOrd.equals((Object)BOrd.NULL)) {
                BObject oldVideoCameraObject = this.oldVideoCameraOrd.get(this.objectMountedInStation);
                if (oldVideoCameraObject != null && oldVideoCameraObject instanceof BIVideoCamera) {
                    this.oldVideoCamera = (BIVideoCamera)oldVideoCameraObject;
                    this.oldCameraInfo = new BVideoMultistreamViewer.ComponentAndSlotPath((BComponent)oldVideoCameraObject, this.oldVideoCameraOrd);
                } else {
                    throw new IllegalStateException("The video camera that is bound to the video player does not resolve to a BIVideoCamera.");
                }
            }
        }

        public boolean isNewCameraMultistream() {
            BVideoMultistreamViewer.ComponentAndSlotPath dvrInfo = BVideoMultistreamViewer.resolveAncestorComponent(this.newCameraInfo, BIVideoDvr.class);
            return this.isMultistreamDvr(dvrInfo);
        }

        public boolean isOldCameraMultistream() {
            if (this.oldVideoCamera == null) {
                return false;
            }
            BVideoMultistreamViewer.ComponentAndSlotPath oldDvrInfo = BVideoMultistreamViewer.resolveAncestorComponent(this.oldCameraInfo, BIVideoDvr.class);
            return this.isMultistreamDvr(oldDvrInfo) && this.videoPlayer.getMultistreamPaneForView() != null;
        }

        protected boolean isMultistreamDvr(BVideoMultistreamViewer.ComponentAndSlotPath dvrInfo) {
            if (dvrInfo == null) {
                return false;
            }
            if (dvrInfo.c == null) {
                return false;
            }
            if (dvrInfo.c instanceof BIVideoDvr) {
                BVideoMultistreamViewer.ComponentAndSlotPath remoteVideoSourceInfo = BVideoMultistreamViewer.resolveAncestorComponent(dvrInfo, "com.tridium.remoteVideo.BRemoteVideoSource");
                if (remoteVideoSourceInfo != null) {
                    return false;
                }
                return ((BIVideoDvr)dvrInfo.c).supportsMultistream();
            }
            return false;
        }

        public void multistreamCameraWithExistingMultistreamableCameraThatIsCurrentlyNotMultistreamed(BVideoMultistreamCameraDropPane multistreamableCameraDropPane) {
            BVideoMultistreamPaneForView newMultistreamPane = this.multistreamViewer.makeMultistreamPane(this.newVideoCamera.getDvr());
            BVideoMultistreamBinding bindCamerasToOneStream = new BVideoMultistreamBinding();
            bindCamerasToOneStream.setOrd(((BComponent)this.newVideoCamera.getDvr()).getSlotPathOrd());
            BVideoPlayer otherCameraVideoPlayer = multistreamableCameraDropPane.findVideoPlayer();
            newMultistreamPane.setVideoPlayersForView(new BIVideoPlayer[]{otherCameraVideoPlayer, this.videoPlayer});
            BVideoStreamBinding otherCameraOldBinding = (BVideoStreamBinding)otherCameraVideoPlayer.get("cameraBinding");
            if (otherCameraOldBinding == null) {
                throw new IllegalStateException("Unable to find 'cameraBinding' for the other videoPlayer.");
            }
            this.stopBinding(otherCameraOldBinding);
            otherCameraVideoPlayer.remove((BComplex)otherCameraOldBinding);
            otherCameraVideoPlayer.resetImage();
            new BNullWidget().add("pawnBinding", (BValue)otherCameraOldBinding);
            BVideoStreamBinding otherCameraNewBinding = (BVideoStreamBinding)otherCameraOldBinding.newCopy();
            otherCameraVideoPlayer.setMultistreamPaneForView(newMultistreamPane);
            otherCameraVideoPlayer.add("cameraBinding", (BValue)otherCameraNewBinding);
            this.videoPlayer.setMultistreamPaneForView(newMultistreamPane);
            BVideoStreamBinding newBindingForThisPlayer = new BVideoStreamBinding();
            newBindingForThisPlayer.setOrd(this.newVideoCameraStationOrd);
            this.videoPlayer.add("cameraBinding", (BValue)newBindingForThisPlayer);
            this.multistreamViewer.getMultistreamPanesAndTheirBindings().put(newMultistreamPane, bindCamerasToOneStream);
            this.multistreamViewer.add("multistreamPaneForView?", (BValue)newMultistreamPane);
            newMultistreamPane.add("multistreamVideoBinding", (BValue)bindCamerasToOneStream);
        }

        protected void removeCameraFromMultistreamPane(BVideoMultistreamPaneForView oldMultistreamPane) {
            BVideoMultistreamBinding oldMultistreamBinding = (BVideoMultistreamBinding)oldMultistreamPane.get("multistreamVideoBinding");
            this.stopBinding(oldMultistreamBinding);
            oldMultistreamPane.remove((BComplex)oldMultistreamBinding);
            oldMultistreamPane.resetImage();
            new BNullWidget().add("pawnBinding", (BValue)oldMultistreamBinding);
            Array oldMultistreamPaneVideoPlayers = new Array((Object[])oldMultistreamPane.getVideoPlayers());
            oldMultistreamPaneVideoPlayers.remove((Object)this.videoPlayer);
            if (oldMultistreamPaneVideoPlayers.size() > 1) {
                oldMultistreamPane.setVideoPlayersForView((BIVideoPlayer[])oldMultistreamPaneVideoPlayers.trim());
                BVideoMultistreamBinding newMultistreamBinding = (BVideoMultistreamBinding)oldMultistreamBinding.newCopy();
                oldMultistreamPane.add("multistreamVideoBinding", (BValue)newMultistreamBinding);
                this.multistreamViewer.getMultistreamPanesAndTheirBindings().put(oldMultistreamPane, newMultistreamBinding);
            } else if (oldMultistreamPaneVideoPlayers.size() == 1) {
                BVideoPlayer otherVideoPlayer = (BVideoPlayer)((Object)oldMultistreamPaneVideoPlayers.pop());
                BVideoStreamBinding otherVideoPlayerBinding = (BVideoStreamBinding)otherVideoPlayer.get("cameraBinding");
                this.stopBinding(otherVideoPlayerBinding);
                otherVideoPlayer.remove((BComplex)otherVideoPlayerBinding);
                otherVideoPlayer.setMultistreamPaneForView(null);
                otherVideoPlayer.add("cameraBinding", otherVideoPlayerBinding.newCopy());
                this.multistreamViewer.getMultistreamPanesAndTheirBindings().remove((Object)oldMultistreamPane);
                this.multistreamViewer.remove((BComplex)oldMultistreamPane);
            } else {
                throw new IllegalStateException("Empty multistream pane! Empty multistream panes should not have happened in the first place!");
            }
        }

        public void changeCameraFromMultistreamToNonMultistream() {
            BVideoMultistreamPaneForView oldMultistreamPane = this.videoPlayer.getMultistreamPaneForView();
            this.removeCameraFromMultistreamPane(oldMultistreamPane);
            this.changeCameraFromNonMultistreamToNonMultistream();
        }

        public void changeCameraFromMultistreamToMultistream() {
            this.stopBinding(this.oldVideoStreamBinding);
            this.videoPlayer.remove((BComplex)this.oldVideoStreamBinding);
            this.videoPlayer.resetImage();
            new BNullWidget().add("pawnBinding", (BValue)this.oldVideoStreamBinding);
            BVideoMultistreamPaneForView oldMultistreamPane = this.videoPlayer.getMultistreamPaneForView();
            Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToBindings = this.multistreamViewer.getMultistreamPanesAndTheirBindings();
            BVideoMultistreamPaneForView newMultistreamPane = this.getMultistreamPaneForNewCamera(multistreamPanesToBindings);
            if (newMultistreamPane == oldMultistreamPane) {
                BVideoMultistreamBinding multistreamBinding = (BVideoMultistreamBinding)oldMultistreamPane.get("multistreamVideoBinding");
                this.stopBinding(multistreamBinding);
                oldMultistreamPane.remove((BComplex)multistreamBinding);
                this.oldVideoStreamBinding.setOrd(this.newVideoCameraStationOrd);
                this.videoPlayer.add("cameraBinding", this.oldVideoStreamBinding.newCopy());
                BVideoMultistreamBinding newMultistreamBinding = (BVideoMultistreamBinding)multistreamBinding.newCopy();
                oldMultistreamPane.add("multistreamVideoBinding", (BValue)newMultistreamBinding);
                this.multistreamViewer.getMultistreamPanesAndTheirBindings().put(oldMultistreamPane, newMultistreamBinding);
            } else {
                this.removeCameraFromMultistreamPane(oldMultistreamPane);
                if (newMultistreamPane == null) {
                    this.changeCameraFromNonMultistreamToMultistream();
                } else {
                    this.multistreamCameraWithExistingMultistreamPane(newMultistreamPane);
                }
            }
        }

        public void stopBinding(BVideoStreamBinding videoStreamBinding) {
            videoStreamBinding.stop();
        }

        public void changeCameraFromNonMultistreamToMultistream() {
            Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToBindings;
            BVideoMultistreamPaneForView existingMultistreamPaneToReuseForNewCamera;
            if (!(this.oldVideoStreamBinding.getParent() instanceof BNullWidget)) {
                this.stopBinding(this.oldVideoStreamBinding);
                this.videoPlayer.remove((BComplex)this.oldVideoStreamBinding);
                this.videoPlayer.resetImage();
                new BNullWidget().add("pawnBinding", (BValue)this.oldVideoStreamBinding);
            }
            if ((existingMultistreamPaneToReuseForNewCamera = this.getMultistreamPaneForNewCamera(multistreamPanesToBindings = this.multistreamViewer.getMultistreamPanesAndTheirBindings())) == null) {
                BVideoMultistreamCameraDropPane multistreamableCameraDropPane = this.getMultistreamableCameraForSameDvrThatIsNotUnderMultistreamPane();
                if (multistreamableCameraDropPane == null) {
                    this.changeCameraFromNonMultistreamToNonMultistream();
                } else {
                    this.multistreamCameraWithExistingMultistreamableCameraThatIsCurrentlyNotMultistreamed(multistreamableCameraDropPane);
                }
            } else {
                this.multistreamCameraWithExistingMultistreamPane(existingMultistreamPaneToReuseForNewCamera);
            }
        }

        protected void multistreamCameraWithExistingMultistreamPane(BVideoMultistreamPaneForView existingMultistreamPaneToReuseForNewCamera) {
            BVideoMultistreamBinding existingMultistreamBinding = (BVideoMultistreamBinding)existingMultistreamPaneToReuseForNewCamera.get("multistreamVideoBinding");
            this.stopBinding(existingMultistreamBinding);
            existingMultistreamPaneToReuseForNewCamera.remove((BComplex)existingMultistreamBinding);
            existingMultistreamPaneToReuseForNewCamera.resetImage();
            new BNullWidget().add("pawnBinding", (BValue)existingMultistreamBinding);
            BIVideoPlayer[] priorPlayersForMultistreamPane = existingMultistreamPaneToReuseForNewCamera.getVideoPlayers();
            BIVideoPlayer[] updatedPlayersForMultistreamPane = new BIVideoPlayer[priorPlayersForMultistreamPane.length + 1];
            System.arraycopy(priorPlayersForMultistreamPane, 0, updatedPlayersForMultistreamPane, 0, priorPlayersForMultistreamPane.length);
            updatedPlayersForMultistreamPane[updatedPlayersForMultistreamPane.length - 1] = this.videoPlayer;
            existingMultistreamPaneToReuseForNewCamera.setVideoPlayersForView(updatedPlayersForMultistreamPane);
            this.videoPlayer.setMultistreamPaneForView(existingMultistreamPaneToReuseForNewCamera);
            BVideoStreamBinding newVideoStreamBinding = new BVideoStreamBinding();
            newVideoStreamBinding.setOrd(this.newVideoCameraStationOrd);
            this.videoPlayer.add("cameraBinding", (BValue)newVideoStreamBinding);
            BVideoMultistreamBinding newMultistreamBinding = (BVideoMultistreamBinding)existingMultistreamBinding.newCopy();
            existingMultistreamPaneToReuseForNewCamera.add("multistreamVideoBinding", (BValue)newMultistreamBinding);
            this.multistreamViewer.getMultistreamPanesAndTheirBindings().put(existingMultistreamPaneToReuseForNewCamera, newMultistreamBinding);
        }

        protected BVideoMultistreamCameraDropPane getMultistreamableCameraForSameDvrThatIsNotUnderMultistreamPane() {
            BIVideoDvr newCameraDvr = this.newVideoCamera.getDvr();
            if (!(newCameraDvr instanceof BComponent)) {
                throw new IllegalStateException("Expected for the new camera's dvr to be a BComponent.");
            }
            BComponent newCameraDvrComponent = (BComponent)newCameraDvr;
            Array<BVideoMultistreamCameraDropPane> dropPanesInUse = this.multistreamViewer.getDropPanesInUse();
            for (BVideoMultistreamCameraDropPane dropPaneInUse : dropPanesInUse) {
                BIVideoDvr otherVideoDvr;
                BIVideoCamera otherVideoCamera;
                BVideoPlayer otherVideoPlayer;
                if (dropPaneInUse == BVideoMultistreamCameraDropPane.this || (otherVideoPlayer = dropPaneInUse.findVideoPlayer()).getMultistreamPaneForView() != null || (otherVideoCamera = BVideoMultistreamCameraDropPane.this.getVideoCamera(otherVideoPlayer)) == null || (otherVideoDvr = otherVideoCamera.getDvr()) == null || !otherVideoDvr.supportsMultistream() || !(otherVideoDvr instanceof BComponent) || !((BComponent)otherVideoDvr).getSlotPathOrd().equals((Object)newCameraDvrComponent.getSlotPathOrd())) continue;
                return dropPaneInUse;
            }
            return null;
        }

        protected BVideoMultistreamPaneForView getMultistreamPaneForNewCamera(Hashtable<BVideoMultistreamPaneForView, BVideoMultistreamBinding> multistreamPanesToBindings) {
            BOrd newCameraMultistreamDvrOrd;
            BIVideoDvr newCameraMultistreamDvr = this.newVideoCamera.getDvr();
            if (newCameraMultistreamDvr instanceof BComponent) {
                newCameraMultistreamDvrOrd = ((BComponent)newCameraMultistreamDvr).getSlotPathOrd();
                if (!newCameraMultistreamDvrOrd.toString().startsWith("station:|")) {
                    newCameraMultistreamDvrOrd = BOrd.make((String)("station:|" + newCameraMultistreamDvrOrd.toString()));
                }
            } else {
                throw new IllegalStateException("Expected new DVR to be a BComponent: " + newCameraMultistreamDvr);
            }
            BVideoMultistreamPaneForView existingMultistreamPaneToReuseForCamera = null;
            Enumeration<BVideoMultistreamPaneForView> multistreamPanes = multistreamPanesToBindings.keys();
            while (multistreamPanes.hasMoreElements() && existingMultistreamPaneToReuseForCamera == null) {
                BVideoMultistreamPaneForView multistreamPane = multistreamPanes.nextElement();
                BVideoMultistreamBinding multistreamBinding = multistreamPanesToBindings.get((Object)multistreamPane);
                BOrd multistreamDvrOrd = multistreamBinding.getOrd();
                if (BOrd.NULL.equals((Object)multistreamDvrOrd)) continue;
                if (!multistreamDvrOrd.toString().startsWith("station:|")) {
                    multistreamDvrOrd = BOrd.make((String)("station:|" + multistreamDvrOrd.toString()));
                }
                if (!multistreamDvrOrd.equals((Object)newCameraMultistreamDvrOrd)) continue;
                existingMultistreamPaneToReuseForCamera = multistreamPane;
            }
            return existingMultistreamPaneToReuseForCamera;
        }

        public void changeCameraFromNonMultistreamToNonMultistream() {
            if (this.oldVideoStreamBinding.isRunning() && !(this.oldVideoStreamBinding.getParent() instanceof BNullWidget)) {
                this.stopBinding(this.oldVideoStreamBinding);
                this.videoPlayer.remove((BComplex)this.oldVideoStreamBinding);
                this.videoPlayer.resetImage();
                new BNullWidget().add("pawnBinding", (BValue)this.oldVideoStreamBinding);
            }
            BVideoStreamBinding newVideoStreamBinding = new BVideoStreamBinding();
            newVideoStreamBinding.setOrd(this.newVideoCameraStationOrd);
            this.videoPlayer.setMultistreamPaneForView(null);
            this.videoPlayer.add("cameraBinding", (BValue)newVideoStreamBinding);
            OrdTarget bindingTarget = this.newVideoCameraStationOrd.resolve(this.objectMountedInStation);
            newVideoStreamBinding.fw(303, bindingTarget, null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.prepareForRun();
            Object object = this.multistreamViewer.switcherSynchronizer;
            synchronized (object) {
                if (this.isOldCameraMultistream()) {
                    if (this.isNewCameraMultistream()) {
                        this.changeCameraFromMultistreamToMultistream();
                    } else {
                        this.changeCameraFromMultistreamToNonMultistream();
                    }
                } else if (this.isNewCameraMultistream()) {
                    this.changeCameraFromNonMultistreamToMultistream();
                } else {
                    this.changeCameraFromNonMultistreamToNonMultistream();
                }
                this.multistreamViewer.updateCameraOrd(BVideoMultistreamCameraDropPane.this.multistreamViewerId, this.newVideoCameraStationOrd);
            }
            boolean extraCameraInfoRetrieved = false;
            if (this.newVideoCamera != null && this.videoPlayer != null) {
                while (!extraCameraInfoRetrieved && this.videoPlayer.isRunning()) {
                    try {
                        this.multistreamViewer.configureVideoPlayerFromVideoSource(this.videoPlayer, (BIVideoSource)this.newVideoCamera);
                        extraCameraInfoRetrieved = true;
                    }
                    catch (UnresolvedException ue) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    catch (CannotSaveException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

