/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidget;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;
import com.tridium.videoDriver.ui.camera.BVideoPtzBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzCameraWidgetBinding;
import com.tridium.videoDriver.ui.camera.BVideoZoomSlider;
import com.tridium.videoDriver.ui.camera.GotoPresetCommand;
import com.tridium.videoDriver.ui.camera.StorePresetCommand;
import com.tridium.videoDriver.ui.holdDownButton.BHoldDownButton;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BVideoPtzDialogPane
extends BEdgePane {
    public static final Action videoPlaybackChanged = BVideoPtzDialogPane.newAction((int)0, null);
    public static final Topic adjustIris = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Topic adjustFocus = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Topic adjustZoom = BVideoPtzDialogPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoPtzDialogPane.class);
    public BVideoPlayer videoPlayer;
    public final BIVideoCamera videoCamera;
    public BVideoPanTiltJoystick joystick;
    public BVideoZoomSlider zoomSlider;
    public final BPane bottomPane;
    public BVideoStreamBinding videoStreamBinding;
    public final BSize preferedSize;
    public static final Lexicon LEX = Lexicon.make(BVideoPtzDialogPane.class);
    static boolean hasOperatorInvoke = false;
    static boolean hasAdminInvoke = false;
    static boolean isMoveOperatorFlag = false;
    static boolean isZoomOperatorFlag = false;
    static boolean isIrisOperatorFlag = false;
    static boolean isFocusOperatorFlag = false;
    static boolean isMovePresetOperatorFlag = false;
    static boolean isStorePresetOperatorFlag = false;

    public void videoPlaybackChanged() {
        this.invoke(videoPlaybackChanged, null, null);
    }

    public void fireAdjustIris(BVideoIrisEnum event) {
        this.fire(adjustIris, (BValue)event, null);
    }

    public void fireAdjustFocus(BVideoFocusEnum event) {
        this.fire(adjustFocus, (BValue)event, null);
    }

    public void fireAdjustZoom(BVideoZoomEnum event) {
        this.fire(adjustZoom, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoPtzDialogPane() {
        this((BIVideoCamera)null, (BWidget)null, (BRelTime)null, (BRelTime)null);
    }

    public BVideoPtzDialogPane(BIVideoCamera videoCamera, BWidget container) {
        this(videoCamera, container, BRelTime.makeSeconds((int)1), BRelTime.makeSeconds((int)1));
    }

    public BVideoPtzDialogPane(BIVideoCamera videoCamera, BWidget container, BRelTime moveInterval, BRelTime zoomInterval) {
        this(videoCamera, container, BSize.make((double)0.0, (double)0.0), BBorder.inset, moveInterval, Theme.scrollBar().getControlBackground(), zoomInterval, 25, new BPlaybackParams(BVideoPtzDialogPane.getBackgroundColor(videoCamera), BVideoPtzDialogPane.getAspectRatio(videoCamera), BVideoPtzDialogPane.getResolution(videoCamera), BVideoPtzDialogPane.getFrameRate(videoCamera), BVideoPtzDialogPane.getCompression(videoCamera)), BVideoPtzDialogPane.getFoxStreamPreferred(videoCamera));
    }

    private static BColor getBackgroundColor(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return (BColor)((BIVideoSource)videoCamera).getPreferredBackgroundColor();
        }
        return BColor.black;
    }

    private static BVideoAspectRatioEnum getAspectRatio(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)videoCamera).getPreferredAspectRatio();
        }
        return BVideoAspectRatioEnum.standard_def;
    }

    private static BVideoResolutionEnum getResolution(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)videoCamera).getPreferredResolution();
        }
        return BVideoResolutionEnum.high;
    }

    private static BVideoFrameRateEnum getFrameRate(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)videoCamera).getPreferredFrameRate();
        }
        return BVideoFrameRateEnum.low;
    }

    private static BVideoCompressionEnum getCompression(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)videoCamera).getPreferredCompression();
        }
        return BVideoCompressionEnum.medium;
    }

    private static boolean getTimestampPreferred(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            return ((BIVideoSource)videoCamera).isTimestampPreferred();
        }
        return false;
    }

    private static BFoxVideoStreamEnum getFoxStreamPreferred(BIVideoCamera videoCamera) {
        if (videoCamera instanceof BIVideoSource) {
            if (((BIVideoSource)videoCamera).isFoxVideoStreamPreferred()) {
                return BFoxVideoStreamEnum.yes;
            }
            return BFoxVideoStreamEnum.no;
        }
        return BFoxVideoStreamEnum.no;
    }

    public BVideoPtzDialogPane(BIVideoCamera videoCamera, BWidget parent, BSize size, BPlaybackParams playbackParams) {
        this.videoCamera = videoCamera;
        this.bottomPane = null;
        this.preferedSize = size;
        BFoxVideoStreamEnum streamFox = BVideoPtzDialogPane.getFoxStreamPreferred(videoCamera);
        this.makeVideoPlayer(parent, 50, playbackParams, streamFox);
        this.setCenter((BWidget)new BBorderPane((BWidget)this.videoPlayer, BBorder.inset, BInsets.NULL));
        this.startVideoPlayerBinding();
    }

    public BVideoPtzDialogPane(BIVideoCamera videoCamera, BWidget parentWidget, BSize totalSize, BBorder videoPaneBorder, BRelTime panTiltKeepDownInterval, BBrush zoomBackground, BRelTime zoomKeepDownInterval, int videoPaneThrottleRefreshRate, BPlaybackParams playBackParams, BFoxVideoStreamEnum streamFox) {
        this.videoCamera = videoCamera;
        this.preferedSize = totalSize;
        BUserService svc = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)((BComponent)videoCamera));
        svc.lease();
        Context context = null;
        try {
            BISession session = BOrd.toSession((BObject)((BComponent)videoCamera));
            if (session != null) {
                context = session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String strLoggedUserName = ((BString)context.getFacet("username")).getString();
        BUser loggedUser = (BUser)svc.get(strLoggedUserName);
        loggedUser.lease();
        BPermissions userPermissions = loggedUser.getPermissions(context);
        hasOperatorInvoke = userPermissions.hasOperatorInvoke();
        hasAdminInvoke = userPermissions.hasAdminInvoke();
        BComponent cameraComp = (BComponent)videoCamera;
        isMoveOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("move")) & 0x100) != 0;
        isZoomOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("zoom")) & 0x100) != 0;
        isIrisOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("irisControl")) & 0x100) != 0;
        isFocusOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("focusControl")) & 0x100) != 0;
        isMovePresetOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("moveToPreset")) & 0x100) != 0;
        isStorePresetOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("storePreset")) & 0x100) != 0;
        this.makePanTiltJoystick(parentWidget, videoPaneBorder, panTiltKeepDownInterval);
        this.makeZoomSlider(parentWidget, videoPaneBorder, zoomBackground, zoomKeepDownInterval);
        this.makeVideoPlayer(parentWidget, videoPaneThrottleRefreshRate, playBackParams, streamFox);
        BPane videoAndPanTiltPane = this.overlayPanTiltJoystickOnVideoPlayer();
        this.setCenter((BWidget)videoAndPanTiltPane);
        if (this.isZoomAvailable()) {
            this.setRight(this.zoomSlider);
        }
        BPane buttonPane = BVideoPtzDialogPane.makeIrisFocusButtonPane((BWidget)this, null, videoCamera, adjustIris, adjustFocus, true);
        BPane presetsPane = BVideoPtzDialogPane.makePresetsPane((BWidget)this, videoCamera, true);
        BGridPane bottomPane = new BGridPane(2);
        bottomPane.setColumnGap(5.0);
        bottomPane.setRowGap(5.0);
        if (buttonPane != null) {
            bottomPane.add("buttonPane", (BValue)buttonPane);
        }
        if (presetsPane != null) {
            bottomPane.add("presetsPane", (BValue)presetsPane);
        }
        this.bottomPane = new BBorderPane((BWidget)bottomPane, BInsets.make((double)1.0));
        this.setBottom((BWidget)this.bottomPane);
        this.setTop((BWidget)new BBorderPane((BWidget)this.makeTitlePane(), BInsets.make((double)3.0)));
        this.startVideoPlayerBinding();
        this.linkTo((BComponent)this.videoPlayer, (Slot)BVideoPlayer.reloadVideo, (Slot)videoPlaybackChanged);
        this.videoPlaybackChanged();
    }

    public BVideoPtzDialogPane(BVideoCameraWidget videoCameraWidget, BIVideoCamera videoCamera) {
        this(videoCamera, videoCameraWidget, videoCameraWidget.getPtzDialogSize(), videoCameraWidget.getPtzBorder(), videoCameraWidget.getPanTiltKeepDownInterval(), videoCameraWidget.getZoomBackground(), videoCameraWidget.getZoomKeepDownInterval(), videoCameraWidget.getRefreshRate(), new BPlaybackParams(videoCameraWidget.getResolution(), videoCameraWidget.getFrameRate(), videoCameraWidget.getStreamFacets()), videoCameraWidget.getVideoStreamFox());
    }

    protected boolean isPanTiltAvailable() {
        return this.videoCamera instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)this.videoCamera).isPanTiltEnabled() && (hasAdminInvoke || isMoveOperatorFlag && hasOperatorInvoke);
    }

    protected void makePanTiltJoystick(BWidget parentWidget, BBorder videoPaneBorder, BRelTime panTiltKeepDownInterval) {
        if (this.isPanTiltAvailable()) {
            this.joystick = new BVideoPanTiltJoystick();
            this.joystick.setBackground(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setBorder(videoPaneBorder);
            this.joystick.setBallPercent(0.1);
            this.joystick.setFillBallDragging(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setFillBallNormal(BBrush.makeSolid((BColor)BColor.transparent));
            this.joystick.setKeepDownInterval(panTiltKeepDownInterval);
            if (parentWidget != null) {
                this.joystick.add("cameraBinding", (BValue)new BVideoPtzCameraWidgetBinding(parentWidget));
            }
        } else {
            this.joystick = null;
        }
    }

    protected boolean isZoomAvailable() {
        return this.videoCamera instanceof BIVideoZoomControl && ((BIVideoZoomControl)this.videoCamera).isZoomEnabled() && (hasAdminInvoke || isZoomOperatorFlag && hasOperatorInvoke);
    }

    protected void makeZoomSlider(BWidget parentWidget, BBorder videoPaneBorder, BBrush zoomBackground, BRelTime zoomKeepDownInterval) {
        if (this.isZoomAvailable()) {
            this.zoomSlider = new BVideoZoomSlider();
            this.zoomSlider.setBackground(zoomBackground);
            this.zoomSlider.setBorder(videoPaneBorder);
            this.zoomSlider.setKeepDownInterval(zoomKeepDownInterval);
            if (parentWidget != null) {
                this.zoomSlider.add("cameraBinding", (BValue)new BVideoPtzCameraWidgetBinding(parentWidget));
            }
        } else {
            this.zoomSlider = null;
        }
    }

    protected boolean isVideoAvailable() {
        return this.videoCamera instanceof BIVideoSource;
    }

    protected void makeVideoPlayer(BWidget parentWidget, int videoPaneThrottleRefreshRate, BPlaybackParams playBackParams, BFoxVideoStreamEnum streamFox) {
        if (this.isVideoAvailable()) {
            this.videoPlayer = new BVideoPlayer();
            this.videoPlayer.setThrottleRefreshRate(videoPaneThrottleRefreshRate);
            this.videoPlayer.setBackgroundColor(playBackParams.getBackgroundColor());
            this.videoPlayer.setAspectRatio(playBackParams.getAspectRatio());
            this.videoPlayer.setResolution(playBackParams.getResolution());
            this.videoPlayer.setFrameRate(playBackParams.getFrameRate());
            this.videoPlayer.setCompression(playBackParams.getCompression());
            this.videoPlayer.setStreamFacets(playBackParams.getVideoFacets());
            this.videoPlayer.setVideoStreamFox(streamFox);
            this.videoPlayer.setShowTimeIndex(BVideoPtzDialogPane.getTimestampPreferred(this.videoCamera));
            BOrd videoCameraStationOrd = null;
            if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
                BComponent videoCameraComponent = (BComponent)this.videoCamera;
                videoCameraStationOrd = BOrd.make((String)("station:|" + videoCameraComponent.getSlotPathOrd()));
            }
            if (this.isPanTiltAvailable()) {
                this.configurePanTiltBinding(parentWidget, videoCameraStationOrd);
            }
            if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(this.videoCamera)) {
                this.configureIrisFocusBinding(parentWidget, videoCameraStationOrd);
            }
        } else {
            this.videoPlayer = null;
        }
    }

    protected void startVideoPlayerBinding() {
        BOrd videoCameraStationOrd = null;
        if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
            BComponent videoCameraComponent = (BComponent)this.videoCamera;
            videoCameraStationOrd = BOrd.make((String)("station:|" + videoCameraComponent.getSlotPathOrd()));
        }
        if (this.videoCamera != null && this.videoCamera instanceof BIVideoSource && videoCameraStationOrd != null) {
            BVideoStreamBinding videoStreamBinding = new BVideoStreamBinding();
            videoStreamBinding.setOrd(videoCameraStationOrd);
            this.videoPlayer.add("cameraBinding", (BValue)videoStreamBinding);
        }
    }

    protected void configureIrisFocusBinding(BWidget parentWidget, BOrd videoCameraStationOrd) {
        BVideoPtzBinding ptzBinding = new BVideoPtzBinding();
        ptzBinding.setOrd(videoCameraStationOrd);
        this.add("irisFocusBinding", (BValue)ptzBinding);
        BVideoPtzCameraWidgetBinding b = new BVideoPtzCameraWidgetBinding(parentWidget);
        this.add("parentBinding", (BValue)b);
    }

    protected void configurePanTiltBinding(BWidget parentWidget, BOrd videoCameraStationOrd) {
        if (parentWidget != null) {
            boolean parentWidgetHasVideoPtzBinding = false;
            BBinding[] bindings = parentWidget.getBindings();
            for (int i = 0; i < bindings.length; ++i) {
                if (!(bindings[i] instanceof BVideoPtzBinding)) continue;
                parentWidgetHasVideoPtzBinding = true;
                break;
            }
            if (!parentWidgetHasVideoPtzBinding) {
                BVideoPtzBinding videoPtzBinding = new BVideoPtzBinding();
                videoPtzBinding.setOrd(videoCameraStationOrd);
                parentWidget.add("videoPtzBinding?", (BValue)videoPtzBinding);
                videoPtzBinding.start();
                OrdTarget bindingTarget = videoCameraStationOrd.resolve((BObject)((BComponent)this.videoCamera));
                videoPtzBinding.fw(303, bindingTarget, null, null, null);
            }
        }
    }

    protected BPane overlayPanTiltJoystickOnVideoPlayer() {
        BVideoLayerPane vlp = new BVideoLayerPane();
        vlp.add("videoPlayer", (BValue)this.videoPlayer);
        if (this.joystick != null) {
            vlp.add("joystick", (BValue)this.joystick);
        }
        BBorderPane borderPane = new BBorderPane((BWidget)vlp, BBorder.inset);
        borderPane.setPadding(BInsets.make((double)0.0));
        return borderPane;
    }

    public void computePreferredSize() {
        double w = this.preferedSize.width();
        double h = this.preferedSize.height();
        if (w < 50.0 || h < 50.0) {
            super.computePreferredSize();
        } else {
            this.setPreferredSize(this.preferedSize.width(), this.preferedSize.height());
        }
    }

    protected BGridPane makeTitlePane() {
        BGridPane titlePane = new BGridPane(2);
        titlePane.setStretchColumn(1);
        titlePane.setColumnGap(20.0);
        BVideoCameraWidget cameraWidget = new BVideoCameraWidget();
        cameraWidget.setEnabled(false);
        titlePane.add("graphic", (BValue)cameraWidget);
        titlePane.add("title", (BValue)new BLabel(this.videoCamera.getCameraDescription()));
        return titlePane;
    }

    public static boolean isIrisAvailable(BIVideoCamera videoCamera) {
        return videoCamera instanceof BIVideoIrisControl && ((BIVideoIrisControl)videoCamera).isIrisEnabled() && (hasAdminInvoke || isIrisOperatorFlag && hasOperatorInvoke);
    }

    public static boolean isFocusAvailable(BIVideoCamera videoCamera) {
        return videoCamera instanceof BIVideoIrisControl && ((BIVideoFocusControl)videoCamera).isFocusEnabled() && (hasAdminInvoke || isFocusOperatorFlag && hasOperatorInvoke);
    }

    public static boolean isIrisFocusOrBothAvailable(BIVideoCamera videoCamera) {
        return BVideoPtzDialogPane.isIrisAvailable(videoCamera) || BVideoPtzDialogPane.isFocusAvailable(videoCamera);
    }

    public static BPane makeIrisFocusButtonPane(BWidget owner, BWidget center, BIVideoCamera videoCamera, Topic adjustIrisTopic, Topic adjustFocusTopic, boolean fullsize) {
        BEdgePane buttonPane = new BEdgePane();
        if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(videoCamera)) {
            BPane irisPane = null;
            if (BVideoPtzDialogPane.isIrisAvailable(videoCamera)) {
                irisPane = BVideoPtzDialogPane.makeCameraControlPane(owner, " " + LEX.getText("Iris") + " ", adjustIrisTopic, (BValue)BVideoIrisEnum.brightenFast, (BValue)BVideoIrisEnum.none, (BValue)BVideoIrisEnum.dimFast, (BValue)BVideoIrisEnum.none, fullsize);
            }
            BPane focusPane = null;
            if (BVideoPtzDialogPane.isFocusAvailable(videoCamera)) {
                focusPane = BVideoPtzDialogPane.makeCameraControlPane(owner, " " + LEX.getText("Focus") + " ", adjustFocusTopic, (BValue)BVideoFocusEnum.focusInFast, (BValue)BVideoFocusEnum.none, (BValue)BVideoFocusEnum.focusOutFast, (BValue)BVideoFocusEnum.none, fullsize);
            }
            if (BVideoPtzDialogPane.isIrisAvailable(videoCamera)) {
                buttonPane.setLeft((BWidget)new BBorderPane(irisPane, BInsets.make((double)0.0)));
            } else {
                buttonPane.setLeft((BWidget)new BBorderPane());
            }
            if (BVideoPtzDialogPane.isFocusAvailable(videoCamera)) {
                buttonPane.setRight((BWidget)new BBorderPane(focusPane, BInsets.make((double)0.0)));
            } else {
                buttonPane.setRight((BWidget)new BBorderPane());
            }
        } else if (center == null) {
            return null;
        }
        if (center != null) {
            buttonPane.setCenter(center);
        }
        return buttonPane;
    }

    protected static BPane makeCameraControlPane(BWidget owner, String name, Topic eitherButtonPressTopic, BValue plusButtonDownValue, BValue plusButtonReleaseValue, BValue minusButtonDownValue, BValue minusButtonReleaseValue, boolean fullsize) {
        BGridPane buttonPane = new BGridPane(fullsize ? 1 : 2);
        BHoldDownButton plusButton = new BHoldDownButton(owner, eitherButtonPressTopic, plusButtonDownValue, plusButtonReleaseValue, BImage.make((BIcon)BIcon.std((String)"moveUp.png")));
        BHoldDownButton minusButton = new BHoldDownButton(owner, eitherButtonPressTopic, minusButtonDownValue, minusButtonReleaseValue, BImage.make((BIcon)BIcon.std((String)"moveDown.png")));
        plusButton.setButtonStyle(BButtonStyle.toolBar);
        minusButton.setButtonStyle(BButtonStyle.toolBar);
        buttonPane.add("plusButton", (BValue)plusButton);
        buttonPane.add("minusButton", (BValue)minusButton);
        if (fullsize) {
            return new BBorderPane((BWidget)buttonPane, name);
        }
        return new BBorderPane((BWidget)new BGridPane(2, new BWidget[]{new BLabel(name + ':'), buttonPane}), BBorder.inset, BInsets.make((double)BVideoPlayback.TOP_TOOL_PADDING));
    }

    public static BPane makePresetsPane(BWidget owner, BIVideoCamera videoCamera, boolean fullSize) {
        Action moveToPresetAction;
        boolean cameraSupportsStorePreset;
        BGridPane presetsPane = new BGridPane(fullSize ? 1 : 2);
        presetsPane.setColumnAlign(BHalign.fill);
        presetsPane.setHalign(BHalign.center);
        boolean cameraSupportsMoveToPreset = videoCamera instanceof BIVideoMoveToPresetControl && ((BIVideoMoveToPresetControl)videoCamera).isMoveToPresetEnabled();
        boolean bl = cameraSupportsStorePreset = videoCamera instanceof BIVideoStorePresetControl && ((BIVideoStorePresetControl)videoCamera).isStorePresetEnabled();
        if (cameraSupportsMoveToPreset && cameraSupportsStorePreset && (hasAdminInvoke || isMovePresetOperatorFlag && hasOperatorInvoke) && (hasAdminInvoke || isStorePresetOperatorFlag && hasOperatorInvoke)) {
            moveToPresetAction = ((BIVideoMoveToPresetControl)videoCamera).getMoveToPresetAction();
            BValue moveToPresetValue = ((BComponent)videoCamera).getActionParameterDefault(moveToPresetAction);
            Action storePresetAction = ((BIVideoStorePresetControl)videoCamera).getStorePresetAction();
            BValue storePresetValue = ((BComponent)videoCamera).getActionParameterDefault(storePresetAction);
            BWbFieldEditor presetEditor = BWbFieldEditor.makeFor((BObject)moveToPresetValue);
            presetEditor.loadValue((BObject)moveToPresetValue);
            if (storePresetValue.getType() == moveToPresetValue.getType()) {
                presetsPane.add("editor", (BValue)presetEditor);
                BGridPane presetButtonPane = new BGridPane(2);
                presetButtonPane.setUniformColumnWidth(true);
                presetButtonPane.setColumnAlign(BHalign.fill);
                presetButtonPane.setHalign(BHalign.center);
                BButton go = new BButton((Command)new GotoPresetCommand(owner, presetEditor, videoCamera));
                presetButtonPane.add("go", (BValue)go);
                BButton store = new BButton((Command)new StorePresetCommand(owner, presetEditor, videoCamera));
                presetButtonPane.add("store", (BValue)store);
                if (!fullSize) {
                    go.setButtonStyle(BButtonStyle.toolBar);
                    store.setButtonStyle(BButtonStyle.toolBar);
                }
                presetsPane.add("presetButtonPane", (BValue)presetButtonPane);
            } else {
                BWbFieldEditor storePresetEditor = BWbFieldEditor.makeFor((BObject)storePresetValue);
                storePresetEditor.loadValue((BObject)storePresetValue);
                BGridPane goStorePane = new BGridPane(fullSize ? 2 : 6);
                goStorePane.add("editor", (BValue)presetEditor);
                BButton go = new BButton((Command)new GotoPresetCommand(owner, presetEditor, videoCamera));
                goStorePane.add("go", (BValue)go);
                if (!fullSize) {
                    BBorderPane extraSpaceBetweenGoAndStore = new BBorderPane();
                    extraSpaceBetweenGoAndStore.setPadding(BInsets.make((double)10.0, (double)10.0, (double)30.0, (double)30.0));
                    goStorePane.add(null, (BValue)extraSpaceBetweenGoAndStore);
                }
                goStorePane.add("storeEditor", (BValue)storePresetEditor);
                BButton store = new BButton((Command)new StorePresetCommand(owner, storePresetEditor, videoCamera));
                goStorePane.add("store", (BValue)store);
                if (!fullSize) {
                    go.setButtonStyle(BButtonStyle.toolBar);
                    store.setButtonStyle(BButtonStyle.toolBar);
                }
                presetsPane.add("goStorePane", (BValue)goStorePane);
            }
        } else if (cameraSupportsMoveToPreset && (hasAdminInvoke || isMovePresetOperatorFlag && hasOperatorInvoke)) {
            moveToPresetAction = ((BIVideoMoveToPresetControl)videoCamera).getMoveToPresetAction();
            BValue moveToPresetValue = ((BComponent)videoCamera).getActionParameterDefault(moveToPresetAction);
            BWbFieldEditor presetEditor = BWbFieldEditor.makeFor((BObject)moveToPresetValue);
            presetEditor.loadValue((BObject)moveToPresetValue);
            BGridPane goPane = new BGridPane(fullSize ? 1 : 2);
            goPane.setColumnAlign(BHalign.fill);
            goPane.add("editor", (BValue)presetEditor);
            BButton go = new BButton((Command)new GotoPresetCommand(owner, presetEditor, videoCamera));
            goPane.add("go", (BValue)go);
            if (!fullSize) {
                go.setButtonStyle(BButtonStyle.toolBar);
            }
            presetsPane.add("goPane", (BValue)goPane);
        } else if (cameraSupportsStorePreset && (hasAdminInvoke || isStorePresetOperatorFlag && hasOperatorInvoke)) {
            Action storePresetAction = ((BIVideoStorePresetControl)videoCamera).getStorePresetAction();
            BValue storePresetValue = ((BComponent)videoCamera).getActionParameterDefault(storePresetAction);
            BWbFieldEditor presetEditor = BWbFieldEditor.makeFor((BObject)storePresetValue);
            presetEditor.loadValue((BObject)storePresetValue);
            BGridPane storePane = new BGridPane(fullSize ? 1 : 2);
            storePane.setColumnAlign(BHalign.fill);
            storePane.add("editor", (BValue)presetEditor);
            BButton store = new BButton((Command)new StorePresetCommand(owner, presetEditor, videoCamera));
            storePane.add("store", (BValue)store);
            if (!fullSize) {
                store.setButtonStyle(BButtonStyle.toolBar);
            }
            presetsPane.add("storePane", (BValue)storePane);
        } else {
            return null;
        }
        if (fullSize) {
            BBorderPane p = new BBorderPane((BWidget)presetsPane, " " + LEX.getText("Presets") + " ");
            return p;
        }
        return new BBorderPane((BWidget)new BGridPane(2, new BWidget[]{new BLabel(" " + LEX.getText("Presets") + " :"), presetsPane}), BBorder.inset, BInsets.make((double)BVideoPlayback.TOP_TOOL_PADDING));
    }

    public void doVideoPlaybackChanged() {
        if (this.videoPlayer.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.live) {
            if (this.joystick != null) {
                this.joystick.setVisible(true);
            }
            if (this.zoomSlider != null) {
                this.zoomSlider.setVisible(true);
            }
            this.bottomPane.setVisible(true);
        } else {
            if (this.joystick != null) {
                this.joystick.setVisible(false);
            }
            if (this.zoomSlider != null) {
                this.zoomSlider.setVisible(false);
            }
            this.bottomPane.setVisible(false);
        }
        this.relayout();
        this.repaint();
    }
}

