/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public class BVideoPanTiltJoystick
extends BWidget {
    public static final PalladiumWidgetTheme PWT = new PalladiumWidgetTheme();
    public static final BBrush DEFAULT_BALL_BRUSH_IDLE = BBrush.NULL;
    public static final BBrush DEFAULT_BALL_BRUSH_DRAGGING = BBrush.NULL;
    public static final Property background = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property border = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BBorder.inset, null);
    public static final Property ballPercent = BVideoPanTiltJoystick.newProperty((int)0, (double)0.33, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BDouble.make((double)0.5))));
    public static final Property fillBallNormal = BVideoPanTiltJoystick.newProperty((int)0, (BValue)DEFAULT_BALL_BRUSH_IDLE, null);
    public static final Property fillBallDragging = BVideoPanTiltJoystick.newProperty((int)0, (BValue)DEFAULT_BALL_BRUSH_DRAGGING, null);
    public static final Property keepDownInterval = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Action checkMouseStillPressed = BVideoPanTiltJoystick.newAction((int)0, null);
    public static final Topic move = BVideoPanTiltJoystick.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoPanTiltJoystick.class);
    private static final BIcon icon = BIcon.std((String)"pan.png");
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING_BALL = 1;
    public static final int SPEED_NONE = 0;
    public static final int SPEED_SLOW = 1;
    public static final int SPEED_MEDIUM = 2;
    public static final int SPEED_FAST = 3;
    private static final double slowPercent = 0.65;
    private static final int cap = 102;
    private static final int join = 203;
    private static final BPen solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
    protected int joystickState;
    protected double mouseX = 0.0;
    protected double mouseY = 0.0;
    protected double boxX;
    protected double boxY;
    protected double boxW;
    protected double boxH;
    protected double ballX;
    protected double ballY;
    protected double ballW;
    protected double ballH;
    protected BBrush ballBrush;
    protected int speed = -1;
    protected int direction = -1;
    protected BVideoPanTiltEnum panTiltAction = null;
    protected PolygonGeom upperLeft;
    protected PolygonGeom upper;
    protected PolygonGeom upperRight;
    protected PolygonGeom left;
    protected PolygonGeom right;
    protected PolygonGeom lowerLeft;
    protected PolygonGeom lower;
    protected PolygonGeom lowerRight;
    protected RectGeom deadRegion;
    protected RectGeom slowRegion;
    protected RectGeom mediumRegion;
    protected boolean mouseOverWidget;
    public Clock.Ticket checkMouseStillPressedTicket = null;
    public static Queue movementProcessingQueue = new Queue();
    public static Worker movementProcessingWorker = new Worker((Worker.ITodo)movementProcessingQueue);

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder v) {
        this.set(border, (BValue)v, null);
    }

    public double getBallPercent() {
        return this.getDouble(ballPercent);
    }

    public void setBallPercent(double v) {
        this.setDouble(ballPercent, v, null);
    }

    public BBrush getFillBallNormal() {
        return (BBrush)this.get(fillBallNormal);
    }

    public void setFillBallNormal(BBrush v) {
        this.set(fillBallNormal, (BValue)v, null);
    }

    public BBrush getFillBallDragging() {
        return (BBrush)this.get(fillBallDragging);
    }

    public void setFillBallDragging(BBrush v) {
        this.set(fillBallDragging, (BValue)v, null);
    }

    public BRelTime getKeepDownInterval() {
        return (BRelTime)this.get(keepDownInterval);
    }

    public void setKeepDownInterval(BRelTime v) {
        this.set(keepDownInterval, (BValue)v, null);
    }

    public void checkMouseStillPressed() {
        this.invoke(checkMouseStillPressed, null, null);
    }

    public void fireMove(BVideoPanTiltEnum event) {
        this.fire(move, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoPanTiltJoystick() {
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)100.0, (double)100.0));
    }

    public void doCheckMouseStillPressed() {
        movementProcessingQueue.enqueue((Object)new Runnable(){

            @Override
            public void run() {
                BVideoPanTiltJoystick.this.asyncCheckMouseStillPressed();
            }
        });
    }

    public synchronized void asyncCheckMouseStillPressed() {
        this.fireMove(this.panTiltAction);
        if (this.joystickState >= 1) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 100.0);
    }

    public void doLayout(BWidget[] kids) {
        this.boxX = 1.0;
        this.boxY = 1.0;
        this.boxW = this.getWidth() - 2.0;
        this.boxH = this.getHeight() - 2.0;
        this.computeRegionCoordinates();
    }

    public void paint(Graphics g) {
        g.useAntiAliasing(true);
        try {
            g.push();
            g.setBrush(this.getBackground());
            g.fillRect(this.boxX, this.boxY, this.boxW, this.boxH);
        }
        finally {
            g.pop();
        }
        this.getBorder().paint(g, this.boxX, this.boxY, this.boxW, this.boxH);
        this.computeBallCoordinates();
        if (this.joystickState >= 1) {
            this.paintCurrentRegion(g);
            if (this.speed >= 1) {
                g.setPen(solidPen);
                g.setBrush(this.computeSpeedBrush());
                g.strokeRect(this.boxX, this.boxY, this.boxW, this.boxH);
            }
        }
        this.paintBall(g);
        g.useAntiAliasing(false);
    }

    protected void paintBall(Graphics g) {
        EllipseGeom ball = new EllipseGeom(this.ballX, this.ballY, this.ballW, this.ballH);
        g.setPen(BPen.make((double)1.0));
        g.setBrush(this.ballBrush);
        g.fill((IGeom)ball);
    }

    protected void computeBallCoordinates() {
        double ballPercent = this.getBallPercent();
        if (this.joystickState >= 1) {
            double smallerSide;
            this.ballW = this.boxW * (ballPercent / 1.2);
            this.ballH = this.boxH * (ballPercent / 1.2);
            this.ballW = smallerSide = this.ballW > this.ballH ? this.ballH : this.ballW;
            this.ballH = smallerSide;
            this.ballX = this.mouseX - this.ballW / 2.0;
            this.ballY = this.mouseY - this.ballH / 2.0;
            this.joystickState = 1;
            if (this.ballX < this.boxX) {
                this.ballX = this.boxX;
            }
            if (this.ballX > this.boxW - this.ballW) {
                this.ballX = this.boxW - this.ballW;
            }
            if (this.ballY < this.boxY) {
                this.ballY = this.boxY;
            }
            if (this.ballY > this.boxH - this.ballH) {
                this.ballY = this.boxH - this.ballH;
            }
            this.ballBrush = this.getFillBallDragging();
        } else {
            double smallerSide;
            this.ballW = this.boxW * ballPercent;
            this.ballH = this.boxH * ballPercent;
            this.ballW = smallerSide = this.ballW > this.ballH ? this.ballH : this.ballW;
            this.ballH = smallerSide;
            this.ballX = this.boxX + this.boxW / 2.0 - this.ballW / 2.0;
            this.ballY = this.boxY + this.boxH / 2.0 - this.ballH / 2.0;
            this.ballBrush = this.getFillBallNormal();
        }
    }

    protected BBrush computeSpeedBrush() {
        BBrush speedBrush = null;
        speedBrush = this.speed == 1 ? BBrush.makeSolid((BColor)BColor.make((int)0x333399FF, (boolean)true)) : (this.speed == 2 ? BBrush.makeSolid((BColor)BColor.make((int)-2009884161, (boolean)true)) : BBrush.makeSolid((BColor)BColor.make((int)-298608129, (boolean)true)));
        return speedBrush;
    }

    protected void fillCurrentRegion(Graphics g) {
        switch (this.direction) {
            case 1: {
                g.fill((IGeom)this.lowerLeft);
                break;
            }
            case 2: {
                g.fill((IGeom)this.lower);
                break;
            }
            case 3: {
                g.fill((IGeom)this.lowerRight);
                break;
            }
            case 4: {
                g.fill((IGeom)this.left);
                break;
            }
            case 6: {
                g.fill((IGeom)this.right);
                break;
            }
            case 7: {
                g.fill((IGeom)this.upperLeft);
                break;
            }
            case 8: {
                g.fill((IGeom)this.upper);
                break;
            }
            case 9: {
                g.fill((IGeom)this.upperRight);
            }
        }
    }

    protected void paintCurrentRegion(Graphics g) {
        if (this.speed >= 1 && this.speed <= 3) {
            g.setBrush(this.computeSpeedBrush());
            if (this.direction > 0) {
                this.fillCurrentRegion(g);
            }
        }
    }

    protected void computeRegionCoordinates() {
        this.computeUpperLeftRegion();
        this.computeUpperRegion();
        this.computeUpperRightRegion();
        this.computeLeftRegion();
        this.computeRightRegion();
        this.computeLowerLeftRegion();
        this.computeLowerRegion();
        this.computeLowerRightRegion();
        this.computeDeadRegion();
        this.computeSlowRegion();
        this.computeMediumRegion();
    }

    protected void computeUpperLeftRegion() {
        double[] xCoords = new double[]{this.boxX, this.boxW * 0.25, this.boxW * 0.4, this.boxX};
        double[] yCoords = new double[]{this.boxY, this.boxY, this.boxH * 0.4, this.boxH * 0.25};
        this.upperLeft = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeUpperRegion() {
        double[] xCoords = new double[]{this.boxW * 0.25, this.boxW * 0.75, this.boxW * 0.6, this.boxW / 2.0, this.boxW * 0.4};
        double[] yCoords = new double[]{this.boxY, this.boxY, this.boxH * 0.4, this.boxH / 2.0, this.boxH * 0.4};
        this.upper = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeUpperRightRegion() {
        double[] xCoords = new double[]{this.boxW, this.boxW, this.boxW * 0.6, this.boxW * 0.75};
        double[] yCoords = new double[]{this.boxY, this.boxH * 0.25, this.boxH * 0.4, this.boxY};
        this.upperRight = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeLeftRegion() {
        double[] xCoords = new double[]{this.boxX, this.boxW * 0.4, this.boxW / 2.0, this.boxW * 0.4, this.boxX};
        double[] yCoords = new double[]{this.boxH * 0.25, this.boxH * 0.4, this.boxH / 2.0, this.boxH * 0.6, this.boxH * 0.75};
        this.left = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeRightRegion() {
        double[] xCoords = new double[]{this.boxW, this.boxW * 0.6, this.boxW / 2.0, this.boxW * 0.6, this.boxW};
        double[] yCoords = new double[]{this.boxH * 0.25, this.boxH * 0.4, this.boxH / 2.0, this.boxH * 0.6, this.boxH * 0.75};
        this.right = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeLowerLeftRegion() {
        double[] xCoords = new double[]{this.boxX, this.boxW * 0.25, this.boxW * 0.4, this.boxX};
        double[] yCoords = new double[]{this.boxH, this.boxH, this.boxH * 0.6, this.boxH * 0.75};
        this.lowerLeft = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeLowerRegion() {
        double[] xCoords = new double[]{this.boxW * 0.25, this.boxW * 0.75, this.boxW * 0.6, this.boxW / 2.0, this.boxW * 0.4};
        double[] yCoords = new double[]{this.boxH, this.boxH, this.boxH * 0.6, this.boxH / 2.0, this.boxH * 0.6};
        this.lower = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeLowerRightRegion() {
        double[] xCoords = new double[]{this.boxW, this.boxW, this.boxW * 0.6, this.boxW * 0.75};
        double[] yCoords = new double[]{this.boxH, this.boxH * 0.75, this.boxH * 0.6, this.boxH};
        this.lowerRight = new PolygonGeom(xCoords, yCoords, xCoords.length);
    }

    protected void computeDeadRegion() {
        double ballPercent = this.getBallPercent();
        double deadW = this.boxW * ballPercent;
        double deadH = this.boxH * ballPercent;
        double deadX = this.boxW / 2.0 - deadW / 2.0;
        double deadY = this.boxH / 2.0 - deadH / 2.0;
        this.deadRegion = new RectGeom(deadX, deadY, deadW, deadH);
    }

    protected void computeSlowRegion() {
        double slowW = this.boxW * 0.65;
        double slowH = this.boxH * 0.65;
        double slowX = this.boxW / 2.0 - slowW / 2.0;
        double slowY = this.boxH / 2.0 - slowH / 2.0;
        this.slowRegion = new RectGeom(slowX, slowY, slowW, slowH);
    }

    protected void computeMediumRegion() {
        this.mediumRegion = new RectGeom(this.boxX, this.boxY, this.boxW, this.boxH);
    }

    public synchronized void mouseReleased(BMouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        this.handleMouseReleased();
        this.repaint();
    }

    protected void handleMouseReleased() {
        this.joystickState = 0;
        this.speed = 0;
        this.direction = -1;
        this.panTiltAction = BVideoPanTiltEnum.none;
        if (this.checkMouseStillPressedTicket != null) {
            this.checkMouseStillPressedTicket.cancel();
            this.fireMove(this.panTiltAction);
        }
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            this.setMouseCursor(MouseCursor.grabHand);
        }
        this.mouseOverWidget = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOverWidget = false;
        this.repaint();
    }

    public void mouseDragged(BMouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        int priorJoystickState = this.joystickState;
        BVideoPanTiltEnum priorPanTiltAction = this.panTiltAction;
        this.joystickState = 1;
        this.speed = this.computeSpeed();
        this.direction = this.computeDirection();
        this.panTiltAction = this.computePanTiltAction();
        if (priorJoystickState < 1 || priorPanTiltAction != this.panTiltAction) {
            if (this.checkMouseStillPressedTicket != null) {
                this.checkMouseStillPressedTicket.cancel();
            }
            this.fireMove(this.panTiltAction);
        }
        if (this.checkMouseStillPressedTicket == null || this.checkMouseStillPressedTicket.isExpired()) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
        this.repaint();
    }

    protected int computeSpeed() {
        this.computeBallCoordinates();
        if (this.deadRegion.contains(this.mouseX, this.mouseY)) {
            return 0;
        }
        if (this.slowRegion.contains(this.mouseX, this.mouseY)) {
            return 1;
        }
        if (this.mediumRegion.contains(this.mouseX, this.mouseY)) {
            return 2;
        }
        return 3;
    }

    protected int computeDirection() {
        double ballMidX = this.ballX + this.ballW / 2.0;
        double ballMidY = this.ballY + this.ballH / 2.0;
        if (this.upperLeft.contains(ballMidX, ballMidY)) {
            return 7;
        }
        if (this.upper.contains(ballMidX, ballMidY)) {
            return 8;
        }
        if (this.upperRight.contains(ballMidX, ballMidY)) {
            return 9;
        }
        if (this.left.contains(ballMidX, ballMidY)) {
            return 4;
        }
        if (this.right.contains(ballMidX, ballMidY)) {
            return 6;
        }
        if (this.lowerLeft.contains(ballMidX, ballMidY)) {
            return 1;
        }
        if (this.lower.contains(ballMidX, ballMidY)) {
            return 2;
        }
        if (this.lowerRight.contains(ballMidX, ballMidY)) {
            return 3;
        }
        return -1;
    }

    protected BVideoPanTiltEnum computePanTiltActionSlow() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftSlow;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpSlow;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpSlow;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpSlow;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightSlow;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownSlow;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownSlow;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownSlow;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltActionMedium() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftMedium;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpMedium;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpMedium;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpMedium;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightMedium;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownMedium;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownMedium;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownMedium;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_MEDIUM (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltActionFast() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftFast;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpFast;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpFast;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpFast;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightFast;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownFast;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownFast;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownFast;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_FAST (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltAction() {
        if (this.joystickState >= 1) {
            switch (this.speed) {
                case 0: {
                    return BVideoPanTiltEnum.none;
                }
                case 1: {
                    return this.computePanTiltActionSlow();
                }
                case 2: {
                    return this.computePanTiltActionMedium();
                }
                case 3: {
                    return this.computePanTiltActionFast();
                }
            }
            throw new IllegalStateException("Unrecognized speed index (" + this.speed + ").");
        }
        return BVideoPanTiltEnum.none;
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        movementProcessingWorker.start("BVideoPanTiltJoystick:worker");
    }
}

