/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.palladium.PalladiumButtonTheme;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.ui.camera.BVideoPtzCtrlPanel;
import com.tridium.videoDriver.ui.holdDownButton.BHoldDownButton;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;

public class BVideoPanTiltArrowButton
extends BHoldDownButton {
    public static final Property numArrows = BVideoPanTiltArrowButton.newProperty((int)0, (int)1, null);
    public static final Property direction = BVideoPanTiltArrowButton.newProperty((int)0, (int)6, null);
    public static final Type TYPE = Sys.loadType(BVideoPanTiltArrowButton.class);
    protected static Point noOffset = new Point(0.0, 0.0);
    protected static Point pressedOffset = new Point(1.0, 1.0);
    protected DiagonalButtonScheme dbs = new DiagonalButtonScheme();
    private static final double PERCENTAGE_EMPTY_PER_ARROW = 0.25;
    private static final double HALF_PERCENTAGE_EMPTY_PER_ARROW = 0.125;
    private boolean mousePressed = false;

    public int getNumArrows() {
        return this.getInt(numArrows);
    }

    public void setNumArrows(int v) {
        this.setInt(numArrows, v, null);
    }

    public int getDirection() {
        return this.getInt(direction);
    }

    public void setDirection(int v) {
        this.setInt(direction, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BVideoPanTiltArrowButton() {
    }

    public BVideoPanTiltArrowButton(BVideoPtzCtrlPanel mgr, BVideoPanTiltEnum mousePressedEvt, BVideoPanTiltEnum mouseReleasedEvt, int numArrows, int direction) {
        super((BWidget)mgr, BVideoPtzCtrlPanel.move, (BValue)mousePressedEvt, (BValue)mouseReleasedEvt);
        this.setNumArrows(numArrows);
        this.setDirection(direction);
    }

    protected Point computeMidpoint(Point p1, Point p2) {
        double x1 = p1.x();
        double y1 = p1.y();
        double x2 = p2.x();
        double y2 = p2.y();
        return new Point((x1 + x2) / 2.0, (y1 + y2) / 2.0);
    }

    protected double computeSlope(Point p1, Point p2) {
        return (p2.y - p1.y) / (p2.x - p1.x);
    }

    protected double computeB(Point p1, Point p2) {
        double slope = this.computeSlope(p1, p2);
        return this.computeB(slope, p1);
    }

    protected double computeB(double slope, Point p) {
        return -1.0 * slope * p.x + p.y;
    }

    protected double computeDistance(Point p1, Point p2) {
        double xd = p2.x() - p1.x();
        double yd = p2.y() - p1.y();
        double xdSq = xd * xd;
        double ydSq = yd * yd;
        return Math.sqrt(xdSq + ydSq);
    }

    protected void drawArrowLine(Graphics g, Point arrowPoint1TooFar, Point arrowPoint2TooFar) {
        Point arrowPoint1 = new Point();
        Point arrowPoint2 = new Point();
        arrowPoint1.x = this.computeStartArrowX(arrowPoint1TooFar, arrowPoint2TooFar);
        arrowPoint2.x = this.computeEndArrowX(arrowPoint1TooFar, arrowPoint2TooFar);
        double slope = this.computeSlope(arrowPoint1TooFar, arrowPoint2TooFar);
        double B = this.computeB(slope, arrowPoint1TooFar);
        arrowPoint1.y = slope * arrowPoint1.x + B;
        arrowPoint2.y = slope * arrowPoint2.x + B;
        g.strokeLine(arrowPoint1.x, arrowPoint1.y, arrowPoint2.x, arrowPoint2.y);
    }

    protected void drawArrowHashes(Graphics g, Line bisectDiamond, Line parallelLine1, Line parallelLine2) {
        int numArrows = this.getNumArrows();
        boolean rightToLeft = this.isRightToLeft();
        for (int i = 0; i < numArrows; ++i) {
            Line bisectingDivisionI = bisectDiamond.getLineDivision(i, numArrows);
            Line bisectingPaddedDivI = bisectingDivisionI.getPaddedLine();
            Point arrowLineMidpoint = bisectingPaddedDivI.computeMidpoint();
            Line pointyHalfOfArrowLine = rightToLeft ? new Line(bisectingPaddedDivI.p1, arrowLineMidpoint) : new Line(bisectingPaddedDivI.p2, arrowLineMidpoint);
            Point arrowLineQuarterPoint = pointyHalfOfArrowLine.computeMidpoint();
            Point arrowHead = rightToLeft ? bisectingPaddedDivI.p1 : bisectingPaddedDivI.p2;
            Point arrowTail = rightToLeft ? bisectingPaddedDivI.p2 : bisectingPaddedDivI.p1;
            Point qPtToPar1 = new Point();
            Point qPtToPar2 = new Point();
            if (this.isDiagonalArrow()) {
                double M1 = parallelLine1.computeSlope();
                double B1 = parallelLine1.computeB();
                double M2 = M1;
                double B2 = parallelLine2.computeB();
                double M3 = -1.0 / M1;
                double B3 = this.computeB(M3, arrowTail);
                qPtToPar1.x = (B3 - B1) / (M1 - M3);
                qPtToPar1.y = M1 * qPtToPar1.x + B1;
                qPtToPar2.x = (B3 - B2) / (M2 - M3);
                qPtToPar2.y = M2 * qPtToPar2.x + B2;
            } else if (this.isHorizontalArrow()) {
                qPtToPar1.x = arrowLineQuarterPoint.x;
                qPtToPar1.y = parallelLine1.p1.y;
                qPtToPar2.x = arrowLineQuarterPoint.x;
                qPtToPar2.y = parallelLine2.p1.y;
            } else if (this.isVerticalArrow()) {
                qPtToPar1.x = parallelLine1.p1.x;
                qPtToPar1.y = arrowLineQuarterPoint.y;
                qPtToPar2.x = parallelLine2.p1.x;
                qPtToPar2.y = arrowLineQuarterPoint.y;
            } else {
                throw new IllegalStateException("Unrecognized arrow orientation");
            }
            Line hashLine1 = new Line(arrowHead, this.computeMidpoint(arrowTail, qPtToPar1));
            Line hashLine2 = new Line(arrowHead, this.computeMidpoint(arrowTail, qPtToPar2));
            hashLine1.draw(g);
            hashLine2.draw(g);
        }
    }

    protected void drawArrowHashes(Graphics g, Point leftOfDiamond, Point topOfDiamond, Point bottomOfDiamond, Point rightOfDiamond) {
        Line parallelLine2;
        Line parallelLine1;
        Line bisectingArrowLine;
        int arrowDirection = this.getDirection();
        switch (arrowDirection) {
            case 7: {
                bisectingArrowLine = new Line(this.computeMidpoint(bottomOfDiamond, rightOfDiamond), this.computeMidpoint(leftOfDiamond, topOfDiamond));
                parallelLine1 = new Line(bottomOfDiamond, leftOfDiamond);
                parallelLine2 = new Line(rightOfDiamond, topOfDiamond);
                break;
            }
            case 3: {
                bisectingArrowLine = new Line(this.computeMidpoint(leftOfDiamond, topOfDiamond), this.computeMidpoint(bottomOfDiamond, rightOfDiamond));
                parallelLine1 = new Line(leftOfDiamond, bottomOfDiamond);
                parallelLine2 = new Line(topOfDiamond, rightOfDiamond);
                break;
            }
            case 1: {
                bisectingArrowLine = new Line(this.computeMidpoint(bottomOfDiamond, leftOfDiamond), this.computeMidpoint(rightOfDiamond, topOfDiamond));
                parallelLine1 = new Line(topOfDiamond, leftOfDiamond);
                parallelLine2 = new Line(rightOfDiamond, bottomOfDiamond);
                break;
            }
            case 9: {
                bisectingArrowLine = new Line(this.computeMidpoint(leftOfDiamond, bottomOfDiamond), this.computeMidpoint(topOfDiamond, rightOfDiamond));
                parallelLine1 = new Line(leftOfDiamond, topOfDiamond);
                parallelLine2 = new Line(bottomOfDiamond, rightOfDiamond);
                break;
            }
            case 8: {
                bisectingArrowLine = new Line(bottomOfDiamond, topOfDiamond);
                parallelLine1 = new Line(new Point(bottomOfDiamond.x * 0.2, bottomOfDiamond.y), new Point(topOfDiamond.x * 0.2, topOfDiamond.y));
                parallelLine2 = new Line(new Point(bottomOfDiamond.x * 1.8, bottomOfDiamond.y), new Point(topOfDiamond.x * 1.8, topOfDiamond.y));
                break;
            }
            case 2: {
                bisectingArrowLine = new Line(topOfDiamond, bottomOfDiamond);
                parallelLine1 = new Line(new Point(topOfDiamond.x * 0.2, topOfDiamond.y), new Point(bottomOfDiamond.x * 0.2, bottomOfDiamond.y));
                parallelLine2 = new Line(new Point(topOfDiamond.x * 1.8, topOfDiamond.y), new Point(bottomOfDiamond.x * 1.8, bottomOfDiamond.y));
                break;
            }
            case 6: {
                bisectingArrowLine = new Line(leftOfDiamond, rightOfDiamond);
                parallelLine1 = new Line(new Point(leftOfDiamond.x, leftOfDiamond.y * 0.2), new Point(rightOfDiamond.x, rightOfDiamond.y * 0.2));
                parallelLine2 = new Line(new Point(leftOfDiamond.x, leftOfDiamond.y * 1.8), new Point(rightOfDiamond.x, rightOfDiamond.y * 1.8));
                bisectingArrowLine = bisectingArrowLine.getPaddedLine();
                parallelLine1 = parallelLine1.getPaddedLine();
                parallelLine2 = parallelLine2.getPaddedLine();
                break;
            }
            case 4: {
                bisectingArrowLine = new Line(rightOfDiamond, leftOfDiamond);
                parallelLine1 = new Line(new Point(rightOfDiamond.x, rightOfDiamond.y * 0.2), new Point(leftOfDiamond.x, leftOfDiamond.y * 0.2));
                parallelLine2 = new Line(new Point(rightOfDiamond.x, rightOfDiamond.y * 1.8), new Point(leftOfDiamond.x, leftOfDiamond.y * 1.8));
                bisectingArrowLine = bisectingArrowLine.getPaddedLine();
                parallelLine1 = parallelLine1.getPaddedLine();
                parallelLine2 = parallelLine2.getPaddedLine();
                break;
            }
            default: {
                throw new IllegalArgumentException("Direction must be 1,2,3,4,6,7,8,9; not " + arrowDirection);
            }
        }
        this.drawArrowHashes(g, bisectingArrowLine.getPaddedLine(), parallelLine1.getPaddedLine(), parallelLine2.getPaddedLine());
    }

    protected boolean isRightToLeft() {
        int direction = this.getDirection();
        switch (direction) {
            case 1: 
            case 4: 
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected boolean isDiagonalArrow() {
        int direction = this.getDirection();
        switch (direction) {
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    protected boolean isHorizontalArrow() {
        int direction = this.getDirection();
        switch (direction) {
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected boolean isVerticalArrow() {
        int direction = this.getDirection();
        switch (direction) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected void drawArrowLines(Graphics g, Line drawArrowsAlongThisLine, int numArrows) {
        for (int i = 0; i < numArrows; ++i) {
            drawArrowsAlongThisLine.getLineDivision(i, numArrows).getPaddedLine().draw(g);
        }
    }

    protected void drawArrows(Graphics g) {
        BBrush foregroundBrush = this.dbs.getTextBrush(this.getEnabled());
        g.setBrush(foregroundBrush);
        g.setPen(BPen.make((double)1.0));
        double w = this.getWidth();
        double h = this.getHeight();
        if (w > h) {
            w = h;
        }
        if (h > w) {
            h = w;
        }
        double halfW = w / 2.0;
        double halfH = h / 2.0;
        Point leftOfDiamond = new Point(0.0, halfH);
        Point topOfDiamond = new Point(halfW, 0.0);
        Point rightOfDiamond = new Point(w - 1.0, halfH);
        Point bottomOfDiamond = new Point(halfW, h - 1.0);
        this.drawArrowHashes(g, leftOfDiamond, topOfDiamond, bottomOfDiamond, rightOfDiamond);
    }

    public double computeStartArrowX(Point arrowPointTooFar1, Point arrowPointTooFar2) {
        double mx1 = arrowPointTooFar1.x();
        double mx2 = arrowPointTooFar2.x();
        return mx1 + 0.125 * (mx2 - mx1);
    }

    public double computeStartArrowY(Point arrowPointTooFar1, Point arrowPointTooFar2) {
        double my1 = arrowPointTooFar1.y();
        double my2 = arrowPointTooFar2.y();
        return my1 + 0.125 * (my2 - my1);
    }

    public double computeEndArrowX(Point arrowPointTooFar1, Point arrowPointTooFar2) {
        double mx1 = arrowPointTooFar1.x();
        double mx2 = arrowPointTooFar2.x();
        return mx2 - 0.125 * (mx2 - mx1);
    }

    public double computeEndArrowY(Point arrowPointTooFar1, Point arrowPointTooFar2) {
        double my1 = arrowPointTooFar1.y();
        double my2 = arrowPointTooFar2.y();
        return my2 - 0.125 * (my2 - my1);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.useAntiAliasing(true);
        this.drawArrows(g);
    }

    protected void paintDiamondBackground(Graphics g) {
        g.useAntiAliasing(true);
        BVideoPanTiltArrowButton b = this;
        boolean enabled = b.getEnabled();
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean menuPressed = b.isMenuPressed();
        boolean hasMenu = b.getMenuController() != null;
        boolean distinct = !hasMenu ? false : b.getMenuController().isMenuDistinct();
        boolean selected = false;
        g.setPen(BPen.make((double)1.0));
        double w = b.getWidth();
        double h = b.getHeight();
        if (w > h) {
            w = h;
        } else if (h > w) {
            h = w;
        }
        double mw = this.getMenuWidth();
        if (hasMenu) {
            w -= this.getMenuWidth();
        }
        boolean drawOutline = true;
        boolean drawShading = true;
        if (!hasMenu) {
            distinct = true;
        }
        if (!(b.getButtonStyle() != BButtonStyle.toolBar || mouseOver && enabled || menuPressed)) {
            drawOutline = false;
            if (!selected) {
                drawShading = false;
            }
        }
        double halfW = w / 2.0;
        double halfH = h / 2.0;
        g.setBrush(this.dbs.getBackground((BAbstractButton)b, pressed, selected));
        g.fill((IGeom)new PolygonGeom(new double[]{1.0, halfW, w - 2.0, halfW}, new double[]{halfH, 1.0, halfH, h - 2.0}, 4));
        if (drawOutline) {
            if (enabled) {
                g.setBrush(this.dbs.getControlForeground());
            } else {
                g.setBrush(this.dbs.getControlShadow());
            }
            g.stroke((IGeom)new PolygonGeom(new double[]{0.0, halfW, w - 1.0, halfW}, new double[]{halfH, 0.0, halfH, h - 1.0}, 4));
        }
        if (drawShading) {
            if (menuPressed && !distinct || !menuPressed && pressed && mouseOver || selected) {
                g.setBrush(this.dbs.getControlShadow());
            } else {
                g.setBrush(this.dbs.getControlHighlight());
            }
            g.strokeLine(2.0, halfH, halfW, 2.0);
            g.strokeLine(halfW, 2.0, w - 3.0, halfH);
            if (enabled || selected) {
                g.setBrush(this.dbs.getControlShadow());
            } else {
                g.setBrush(this.dbs.getControlAuxiliary());
            }
            g.strokeLine(2.0, halfH, halfW, h - 3.0);
            g.strokeLine(halfW, h - 3.0, w - 3.0, halfH);
            if (hasMenu && distinct && (b.getButtonStyle() != BButtonStyle.toolBar || pressed || mouseOver)) {
                g.strokeLine(w + mw - 2.0, 1.0, w + mw - 2.0, h - 2.0);
                g.strokeLine(w, h - 2.0, w + mw - 2.0, h - 2.0);
            }
        }
        if (b.hasFocus() && b.getButtonStyle() != BButtonStyle.toolBar) {
            this.dbs.paintFocus(g, new RectGeom(3.0, 3.0, w - 7.0, h - 7.0));
        }
        this.dbs.paintDefaultBorder(g, (BAbstractButton)b, pressed);
        g.useAntiAliasing(false);
    }

    public void paintBackground(Graphics g) {
        if (this.isDiagonalArrow()) {
            this.paintDiamondBackground(g);
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        if (this.isDiagonalArrow()) {
            if (this.isMouseInButton(event)) {
                this.mousePressed = true;
                super.mousePressed(event);
            }
        } else {
            this.mousePressed = true;
            super.mousePressed(event);
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        try {
            if (this.mousePressed) {
                super.mouseReleased(event);
            }
        }
        finally {
            this.mousePressed = false;
        }
    }

    protected boolean isMouseInButton(BMouseEvent event) {
        if (this.isDiagonalArrow()) {
            double h;
            double evtX = event.getX();
            double evtY = event.getY();
            double w = this.getWidth();
            if (w > (h = this.getHeight())) {
                w = h;
            } else if (h > w) {
                h = w;
            }
            double halfW = w / 2.0;
            double halfH = h / 2.0;
            PolygonGeom area = new PolygonGeom(new double[]{1.0, halfW, w - 2.0, halfW}, new double[]{halfH, 1.0, halfH, h - 2.0}, 4);
            return area.contains(evtX, evtY);
        }
        throw new IllegalStateException("Should only compute 'isMouseInButton' for diamond button mode.");
    }

    class Line {
        Point p1;
        Point p2;

        Line(Point p1, Point p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        double computeSlope() {
            return BVideoPanTiltArrowButton.this.computeSlope(this.p1, this.p2);
        }

        double computeB() {
            return BVideoPanTiltArrowButton.this.computeB(this.p1, this.p2);
        }

        Point computeMidpoint() {
            return BVideoPanTiltArrowButton.this.computeMidpoint(this.p1, this.p2);
        }

        double dx() {
            return Math.abs(this.p1.x - this.p2.x);
        }

        double dy() {
            return Math.abs(this.p1.y - this.p2.y);
        }

        void draw(Graphics g) {
            g.strokeLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
        }

        Line getPaddedLine() {
            double slope = this.computeSlope();
            double B = this.computeB();
            Point padded1 = new Point();
            Point padded2 = new Point();
            double dx = this.dx();
            if (dx < 1.0E-4 && this.dx() > -1.0E-4) {
                padded1.x = this.p1.x;
                padded1.y = BVideoPanTiltArrowButton.this.computeStartArrowY(this.p1, this.p2);
                padded2.x = this.p2.x;
                padded2.y = BVideoPanTiltArrowButton.this.computeEndArrowY(this.p1, this.p2);
                return new Line(padded1, padded2);
            }
            padded1.x = BVideoPanTiltArrowButton.this.computeStartArrowX(this.p1, this.p2);
            padded1.y = slope * padded1.x + B;
            padded2.x = BVideoPanTiltArrowButton.this.computeEndArrowX(this.p1, this.p2);
            padded2.y = slope * padded2.x + B;
            return new Line(padded1, padded2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Line getLineDivision(int i, int numArrows) {
            double iAsDouble = i;
            double numArrowsAsDouble = numArrows;
            double dx = this.dx();
            double B = this.computeB();
            double slope = this.computeSlope();
            Point divLineP1 = new Point();
            Point divLineP2 = new Point();
            if (dx < 1.0E-4 && dx > -1.0E-4) {
                if (!(this.p1.y < this.p2.y)) return new Line(this.p2, this.p1).getLineDivision(i, numArrows);
                double dy = this.dy();
                divLineP1.x = this.p1.x;
                divLineP1.y = this.p1.y + iAsDouble / numArrowsAsDouble * dy;
                divLineP2.x = this.p2.x;
                divLineP2.y = this.p1.y + (iAsDouble + 1.0) / numArrowsAsDouble * dy;
                return new Line(divLineP1, divLineP2);
            } else {
                if (!(this.p1.x < this.p2.x)) return new Line(this.p2, this.p1).getLineDivision(i, numArrows);
                divLineP1.x = this.p1.x + iAsDouble / numArrowsAsDouble * dx;
                divLineP1.y = slope * divLineP1.x + B;
                divLineP2.x = this.p1.x + (iAsDouble + 1.0) / numArrowsAsDouble * dx;
                divLineP2.y = slope * divLineP2.x + B;
            }
            return new Line(divLineP1, divLineP2);
        }
    }

    class DiagonalButtonScheme
    extends PalladiumButtonTheme {
        DiagonalButtonScheme() {
        }

        public BBrush getBackground(BAbstractButton b, boolean isDepressed, boolean isSelected) {
            return super.getBackground(b, isDepressed, isSelected);
        }

        public void paintDefaultBorder(Graphics arg0, BAbstractButton arg1, boolean arg2) {
            super.paintDefaultBorder(arg0, arg1, arg2);
        }

        public void paintFocus(Graphics g, PolygonGeom bounds) {
            g.setBrush(focusBrush);
            double[] x = bounds.x();
            double[] y = bounds.y();
            if (x.length > 1) {
                for (int i = 0; i < x.length - 1; ++i) {
                    PaintUtil.drawDashedLine((Graphics)g, (double)x[i], (double)y[i], (double)x[i + 1], (double)y[i + 1]);
                }
            }
        }
    }
}

