/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.alarm.BVideoAlarmExtParameters;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.alarm.BVideoCameraChooserFE;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BVideoAlarmExtParametersFE
extends BWbFieldEditor {
    public static final Action cameraChosen = BVideoAlarmExtParametersFE.newAction((int)0, null);
    public static final Action gotoPresetBooleanChanged = BVideoAlarmExtParametersFE.newAction((int)0, null);
    public static final Action startRecordingChanged = BVideoAlarmExtParametersFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoAlarmExtParametersFE.class);
    public static final String PRESET_PROP_NAME = "preset";
    public static final String PRESET_LBL_PROP_NAME = "presetLbl";
    protected BWbShell shell = null;
    protected BVideoAlarmExtParameters alarmExtParams;
    protected BVideoCameraChooserFE alarmRecorderChooser;
    protected AlarmExtParamsSubscriber alarmExtParamsSubscriber;
    protected BBooleanFE startRecordingFE;
    protected BBooleanFE sendAlarmToDisplayFE;
    protected BLabel startRecordingLbl;
    protected BBooleanFE gotoPresetFE;
    protected BLabel gotoPresetLbl;
    protected BLabel sendAlarmToDisplayLbl;
    protected BWbFieldEditor choosePresetFE;
    protected BLabel choosePresetLbl;
    protected Property choosePresetProp;
    public static final Lexicon LEX = UiLexicon.make(BVideoAlarmExtParametersFE.class);

    public void cameraChosen() {
        this.invoke(cameraChosen, null, null);
    }

    public void gotoPresetBooleanChanged() {
        this.invoke(gotoPresetBooleanChanged, null, null);
    }

    public void startRecordingChanged() {
        this.invoke(startRecordingChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoAlarmExtParametersFE() {
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.add("cameraOrdLbl", (BValue)new BLabel(LEX.getText("CameraOrd")));
        this.alarmRecorderChooser = new BVideoCameraChooserFE();
        contentGrid.add("cameraOrd", (BValue)this.alarmRecorderChooser);
        this.linkTo((BComponent)this.alarmRecorderChooser, (Slot)BVideoCameraChooserFE.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.alarmRecorderChooser, (Slot)BVideoCameraChooserFE.setModified, (Slot)cameraChosen);
        this.linkTo((BComponent)this.alarmRecorderChooser, (Slot)BVideoCameraChooserFE.actionPerformed, (Slot)actionPerformed);
        this.startRecordingLbl = new BLabel(LEX.getText("StartRecording"));
        contentGrid.add("startRecordingLbl", (BValue)this.startRecordingLbl);
        this.startRecordingFE = new BBooleanFE();
        contentGrid.add("startRecording", (BValue)this.startRecordingFE);
        this.startRecordingFE.loadValue((BObject)BBoolean.FALSE);
        this.linkTo((BComponent)this.startRecordingFE, (Slot)BBooleanFE.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.startRecordingFE, (Slot)BBooleanFE.setModified, (Slot)startRecordingChanged);
        this.gotoPresetLbl = new BLabel(LEX.getText("GoToPreset"));
        contentGrid.add("gotoPresetLbl", (BValue)this.gotoPresetLbl);
        this.gotoPresetFE = new BBooleanFE();
        contentGrid.add("gotoPreset", (BValue)this.gotoPresetFE);
        this.gotoPresetFE.loadValue((BObject)BBoolean.FALSE);
        this.gotoPresetFE.setVisible(false);
        this.gotoPresetLbl.setVisible(false);
        this.linkTo((BComponent)this.gotoPresetFE, (Slot)BBooleanFE.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.gotoPresetFE, (Slot)BBooleanFE.setModified, (Slot)gotoPresetBooleanChanged);
        this.sendAlarmToDisplayLbl = new BLabel(LEX.getText("SendAlarmToDisplay"));
        contentGrid.add("sendAlarmToDisplayLbl", (BValue)this.sendAlarmToDisplayLbl);
        this.sendAlarmToDisplayFE = new BBooleanFE();
        contentGrid.add("sendAlarmToDisplay", (BValue)this.sendAlarmToDisplayFE);
        this.linkTo((BComponent)this.sendAlarmToDisplayFE, (Slot)BBooleanFE.setModified, (Slot)setModified);
        this.choosePresetLbl = new BLabel(LEX.getText("CameraPreset"));
        contentGrid.add(PRESET_LBL_PROP_NAME, (BValue)this.choosePresetLbl);
        this.choosePresetFE = new BStringFE();
        this.choosePresetProp = contentGrid.add(PRESET_PROP_NAME, (BValue)this.choosePresetFE);
        this.choosePresetFE.setVisible(false);
        this.choosePresetLbl.setVisible(false);
        contentGrid.add("fluff1", (BValue)new BLabel(""));
        contentGrid.add("fluff2", (BValue)new BLabel(""));
        this.setContent((BWidget)contentGrid);
    }

    protected void updateUi(BOrd videoCameraOrd, boolean startRecording, boolean gotoPreset, BValue cameraPreset) {
        this.checkReadOnly();
        if (videoCameraOrd != null) {
            BComponent base = null;
            try {
                base = (BComponent)this.shell.getActiveOrdTarget().get();
            }
            catch (Exception e) {
                base = null;
            }
            if (base != null) {
                BObject videoCamera = null;
                try {
                    videoCamera = videoCameraOrd.get((BObject)base);
                }
                catch (Exception e) {
                    videoCamera = null;
                }
                if (videoCamera != null) {
                    ((BComponent)videoCamera).lease();
                    boolean isRecorder = videoCamera instanceof BIVideoAlarmRecorder;
                    if (startRecording || !isRecorder) {
                        this.startRecordingFE.loadValue((BObject)BBoolean.make((boolean)startRecording));
                        this.startRecordingFE.setVisible(isRecorder);
                        this.startRecordingLbl.setVisible(isRecorder);
                        if (videoCamera instanceof BIVideoMoveToPresetControl) {
                            this.gotoPresetFE.loadValue((BObject)BBoolean.make((boolean)gotoPreset));
                            this.gotoPresetFE.setVisible(true);
                            this.gotoPresetLbl.setVisible(true);
                            if (gotoPreset) {
                                Action moveToPresetAction = ((BIVideoMoveToPresetControl)videoCamera).getMoveToPresetAction();
                                BValue moveToPresetDefaultValue = ((BComponent)videoCamera).getActionParameterDefault(moveToPresetAction);
                                this.choosePresetFE = BWbFieldEditor.makeFor((BObject)moveToPresetDefaultValue);
                                if (cameraPreset != null && moveToPresetDefaultValue.getType() == cameraPreset.getType()) {
                                    this.choosePresetFE.loadValue((BObject)cameraPreset, this.getCurrentContext());
                                } else {
                                    this.choosePresetFE.loadValue((BObject)moveToPresetDefaultValue, this.getCurrentContext());
                                }
                                this.choosePresetFE.setVisible(true);
                                this.choosePresetLbl.setVisible(true);
                                BGridPane contentGrid = (BGridPane)this.getContent();
                                contentGrid.remove(this.choosePresetProp);
                                contentGrid.remove("fluff1");
                                contentGrid.remove("fluff2");
                                this.choosePresetProp = contentGrid.add(PRESET_PROP_NAME, (BValue)this.choosePresetFE);
                                this.linkTo((BComponent)this.choosePresetFE, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
                                contentGrid.add("fluff1", (BValue)new BLabel(""));
                                contentGrid.add("fluff2", (BValue)new BLabel(""));
                            } else {
                                this.choosePresetFE.setVisible(false);
                                this.choosePresetLbl.setVisible(false);
                            }
                        } else {
                            this.hidePresetFields();
                        }
                    }
                    if (videoCamera instanceof BIVideoCamera) {
                        BIVideoCamera cam = (BIVideoCamera)videoCamera;
                        BIVideoDvr dvr = cam.getDvr();
                        if (dvr == null) {
                            this.hideSendAlarmToDisplayField();
                        } else {
                            BIVideoDisplayDeviceExt displayExt = dvr.getDisplayExt();
                            boolean hasDisplays = displayExt.getAllDisplays().length != 0;
                            this.sendAlarmToDisplayLbl.setVisible(hasDisplays);
                            this.sendAlarmToDisplayFE.setVisible(hasDisplays);
                        }
                    }
                } else {
                    this.hidePresetFields();
                    this.hideSendAlarmToDisplayField();
                }
            } else {
                Thread.dumpStack();
                this.hidePresetFields();
                this.hideSendAlarmToDisplayField();
            }
        } else {
            this.hidePresetFields();
            this.hideSendAlarmToDisplayField();
        }
    }

    protected void hidePresetFields() {
        this.gotoPresetFE.setVisible(false);
        this.gotoPresetLbl.setVisible(false);
        this.choosePresetFE.setVisible(false);
        this.choosePresetLbl.setVisible(false);
    }

    protected void hideSendAlarmToDisplayField() {
        this.sendAlarmToDisplayFE.setVisible(false);
        this.sendAlarmToDisplayLbl.setVisible(false);
    }

    public void doStartRecordingChanged() {
        this.doGotoPresetBooleanChanged();
    }

    public void doCameraChosen() {
        BValue cameraPreset;
        BOrd alarmRecorderOrd;
        BBoolean startRecording = BBoolean.FALSE;
        BBoolean gotoPreset = BBoolean.FALSE;
        try {
            alarmRecorderOrd = (BOrd)this.alarmRecorderChooser.saveValue(this.getCurrentContext());
        }
        catch (Exception e) {
            alarmRecorderOrd = null;
        }
        try {
            startRecording = (BBoolean)this.startRecordingFE.saveValue();
        }
        catch (Exception e) {
            startRecording = BBoolean.FALSE;
        }
        try {
            gotoPreset = (BBoolean)this.gotoPresetFE.saveValue();
        }
        catch (Exception e) {
            gotoPreset = BBoolean.FALSE;
        }
        if (gotoPreset == null) {
            gotoPreset = BBoolean.FALSE;
        }
        try {
            cameraPreset = (BValue)this.choosePresetFE.saveValue();
        }
        catch (Exception e) {
            cameraPreset = null;
        }
        this.updateUi(alarmRecorderOrd, startRecording.getBoolean(), gotoPreset.getBoolean(), cameraPreset);
    }

    public void doGotoPresetBooleanChanged() {
        BValue cameraPreset;
        BBoolean gotoPreset;
        BBoolean startRecording;
        BOrd alarmRecorderOrd;
        try {
            alarmRecorderOrd = (BOrd)this.alarmRecorderChooser.saveValue(this.getCurrentContext());
        }
        catch (Exception e) {
            alarmRecorderOrd = null;
        }
        try {
            startRecording = (BBoolean)this.startRecordingFE.saveValue();
        }
        catch (Exception e) {
            startRecording = BBoolean.FALSE;
        }
        try {
            gotoPreset = (BBoolean)this.gotoPresetFE.saveValue();
        }
        catch (Exception e) {
            gotoPreset = BBoolean.FALSE;
        }
        try {
            cameraPreset = (BValue)this.choosePresetFE.saveValue();
        }
        catch (Exception e) {
            cameraPreset = null;
        }
        this.updateUi(alarmRecorderOrd, startRecording.getBoolean(), gotoPreset.getBoolean(), cameraPreset);
    }

    public void started() {
        this.shell = this.getWbShell();
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.doLoadValue(val, this.getCurrentContext());
        }
    }

    protected void subscribeToComponent(BVideoAlarmExtParameters newVideoAlarmParameters) {
        if (this.alarmExtParams == null || this.alarmExtParams != newVideoAlarmParameters) {
            if (this.alarmExtParamsSubscriber != null) {
                this.alarmExtParamsSubscriber.unsubscribeAll();
            }
            this.alarmExtParamsSubscriber = new AlarmExtParamsSubscriber();
            this.alarmExtParamsSubscriber.subscribe(new BComponent[]{newVideoAlarmParameters, (BComponent)newVideoAlarmParameters.getParent()}, 0, null);
            this.alarmExtParams = newVideoAlarmParameters;
        }
    }

    protected void doLoadValue(BObject value, Context context) {
        BVideoAlarmExtParameters videoAlarmParameters = (BVideoAlarmExtParameters)value;
        this.subscribeToComponent(videoAlarmParameters);
        this.alarmRecorderChooser.loadValue((BObject)videoAlarmParameters.getVideoCamera(), this.getCurrentContext());
        this.startRecordingFE.loadValue((BObject)BBoolean.make((boolean)videoAlarmParameters.getStartRecording().getValue()), this.getCurrentContext());
        this.sendAlarmToDisplayFE.loadValue((BObject)BBoolean.make((boolean)videoAlarmParameters.getSendAlarmToDisplay()), this.getCurrentContext());
        if (this.shell != null) {
            this.updateUi(videoAlarmParameters.getVideoCamera(), videoAlarmParameters.getStartRecording().getValue(), videoAlarmParameters.getGotoPreset(), videoAlarmParameters.getCameraPreset());
        }
    }

    public void checkReadOnly() {
        if (this.alarmExtParams != null && Flags.isReadonly((BComplex)this.alarmExtParams.getParent(), (Slot)this.alarmExtParams.getPropertyInParent())) {
            this.setReadonly(true);
        } else {
            this.setReadonly(false);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        if (this.alarmExtParamsSubscriber != null) {
            this.alarmExtParamsSubscriber.unsubscribeAll();
        }
        BVideoAlarmExtParameters saveVideoAlarmExtParams = (BVideoAlarmExtParameters)value;
        saveVideoAlarmExtParams.getStartRecording().setValue(((BBoolean)this.startRecordingFE.saveValue(cx)).getBoolean());
        saveVideoAlarmExtParams.setVideoCamera((BOrd)this.alarmRecorderChooser.saveValue(cx));
        saveVideoAlarmExtParams.setGotoPreset(((BBoolean)this.gotoPresetFE.saveValue(cx)).getBoolean());
        if (saveVideoAlarmExtParams.getGotoPreset()) {
            try {
                saveVideoAlarmExtParams.setCameraPreset((BValue)this.choosePresetFE.saveValue(cx));
            }
            catch (Exception e) {
                saveVideoAlarmExtParams.setGotoPreset(false);
            }
        }
        if (this.sendAlarmToDisplayFE.isVisible()) {
            saveVideoAlarmExtParams.setSendAlarmToDisplay(((BBoolean)this.sendAlarmToDisplayFE.saveValue(cx)).getBoolean());
        } else {
            saveVideoAlarmExtParams.setSendAlarmToDisplay(false);
        }
        return saveVideoAlarmExtParams;
    }

    protected void doSetReadonly(boolean readonly) {
        this.alarmRecorderChooser.setReadonly(readonly);
        if (this.startRecordingFE != null) {
            this.startRecordingFE.setReadonly(readonly);
        }
        if (this.gotoPresetFE != null) {
            this.gotoPresetFE.setReadonly(readonly);
        }
        if (this.choosePresetFE != null) {
            this.choosePresetFE.setReadonly(readonly);
        }
    }

    public class AlarmExtParamsSubscriber
    extends Subscriber {
        public void event(BComponentEvent event) {
            if (event.getSourceComponent() instanceof BVideoAlarmExtParameters) {
                BVideoAlarmExtParameters videoAlarmParameters = (BVideoAlarmExtParameters)event.getSourceComponent();
                if (BVideoAlarmExtParametersFE.this.shell != null) {
                    BVideoAlarmExtParametersFE.this.updateUi(videoAlarmParameters.getVideoCamera(), videoAlarmParameters.getStartRecording().getValue(), videoAlarmParameters.getGotoPreset(), videoAlarmParameters.getCameraPreset());
                }
            } else if (event.getSourceComponent() == BVideoAlarmExtParametersFE.this.alarmExtParams.getParent() && event.getId() == 6) {
                BVideoAlarmExtParametersFE.this.checkReadOnly();
            }
        }
    }
}

