/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nd;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BStationRole
extends BFrozenEnum {
    public static final int PEER = 0;
    public static final int SUBORDINATE = 1;
    public static final int SUPERVISOR = 2;
    public static final BStationRole peer = new BStationRole(0);
    public static final BStationRole subordinate = new BStationRole(1);
    public static final BStationRole supervisor = new BStationRole(2);
    public static final Type TYPE = Sys.loadType(BStationRole.class);
    public static final BStationRole DEFAULT = peer;

    public Type getType() {
        return TYPE;
    }

    public static BStationRole make(int ordinal) {
        return (BStationRole)peer.getRange().get(ordinal, false);
    }

    public static BStationRole make(String tag) {
        return (BStationRole)peer.getRange().get(tag);
    }

    private BStationRole(int ordinal) {
        super(ordinal);
    }

    public static boolean isValidRoleChange(BStationRole from, BStationRole to) {
        switch (from.getOrdinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return !to.equals((Object)supervisor);
            }
            case 2: {
                return !to.equals((Object)subordinate);
            }
        }
        throw new IllegalStateException("Unexpected from role ordinal: " + from.getOrdinal());
    }

    public BStationRole getOppositeRole() {
        switch (this.getOrdinal()) {
            case 0: {
                return peer;
            }
            case 1: {
                return supervisor;
            }
            case 2: {
                return subordinate;
            }
        }
        throw new IllegalStateException("Invalid ordinal for role: " + this.getOrdinal());
    }

    public boolean isPeer() {
        return this.getOrdinal() == 0;
    }

    public boolean isSubordinate() {
        return this.getOrdinal() == 1;
    }

    public boolean isSupervisor() {
        return this.getOrdinal() == 2;
    }
}

