/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.fox.sys.BSysChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.point.INiagaraProxyExt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.status.BStatus;
import javax.baja.sys.BDate;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.util.Version;

public class DefaultNiagaraVirtualStationAdapter
implements INiagaraVirtualStationAdapter {
    private final BNiagaraStation station;
    private static final Logger log = Logger.getLogger("fox.niagaraVirtual");
    private static final String SCHEDULE_INTEREST_POST_FIX = " - scheduleSnapshot";
    private static final BOrd SCHEDULE_RPC_ORD = BOrd.make((String)"type:schedule:ScheduleRpc");
    private static final BOrd NIAGARA_VIRTUAL_ORD = BOrd.make((String)"type:niagaraVirtual:NiagaraVirtualComponent");
    private static final String HISTORY_INTEREST_POST_FIX = " - history";
    private static final Version FIND_DESCENDANT_HISTORY_VERSION = new Version("4.7");

    public DefaultNiagaraVirtualStationAdapter(BNiagaraStation station) {
        this.station = station;
    }

    public String getStationName() {
        return this.station.getStationName();
    }

    public BStatus getStationStatus() {
        return this.station.getStatus();
    }

    public boolean isVirtualsEnabled() {
        return this.station.getVirtualsEnabled();
    }

    public BNiagaraVirtualPolicies getNiagaraVirtualPolicies() {
        return this.station.getNiagaraNetwork().getVirtualPolicies();
    }

    public Object getStateLock() {
        return this.station.getPoints().stateLock;
    }

    public void registerProxyExt(INiagaraProxyExt proxyExt) {
        this.station.getPoints().registerProxyExt(proxyExt);
    }

    public void unregisterProxyExt(INiagaraProxyExt proxyExt) {
        BNiagaraPointDeviceExt points = this.station.getPoints();
        if (points == null) {
            return;
        }
        points.unregisterProxyExt(proxyExt);
        if (points.clientWorker != null) {
            points.clientWorker.stopped(proxyExt);
        }
    }

    public Logger getLog() {
        return log;
    }

    public Version getStationVersion(Version defaultVersion) {
        Version v = defaultVersion;
        if (this.station.getVersion().length() > 0) {
            v = new Version(this.station.getVersion());
        }
        return v;
    }

    public Map<String, String> fetchRemoteTags(List<String> requestedTags, INiagaraProxyExt ext, Context cx) {
        return BNiagaraProxyExt.doFetchRemoteTags(requestedTags, ext, this.station, cx);
    }

    public BAbstractSchedule getScheduleSnapshot(BOrd scheduleOrd, Context cx) {
        try {
            Optional scheduleOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "getSnapshot", new Object[]{scheduleOrd.toString()}));
            if (!scheduleOpt.isPresent()) {
                throw new IllegalStateException("Cannot get snapshot");
            }
            return (BAbstractSchedule)ValueDocDecoder.unmarshal((String)((String)scheduleOpt.get()), (Context)cx);
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot get schedule snapshot", err);
        }
    }

    public BAbstractSchedule saveScheduleSnapshot(BOrd scheduleOrd, BAbstractSchedule newSchedule, Context cx) {
        try {
            Optional scheduleOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "save", new Object[]{scheduleOrd.toString(), DefaultNiagaraVirtualStationAdapter.marshal((BValue)newSchedule, cx)}));
            if (!scheduleOpt.isPresent()) {
                throw new IllegalStateException("Cannot save snapshot");
            }
            return (BAbstractSchedule)ValueDocDecoder.unmarshal((String)((String)scheduleOpt.get()), (Context)cx);
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot save schedule snapshot", err);
        }
    }

    public List<BDate> getHighlightedDates(BOrd scheduleOrd, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        try {
            Optional datesOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "getHighlightedDates", new Object[]{scheduleOrd.toString(), DefaultNiagaraVirtualStationAdapter.marshal((BValue)sched, cx), DefaultNiagaraVirtualStationAdapter.marshal((BValue)start, cx), DefaultNiagaraVirtualStationAdapter.marshal((BValue)end, cx)}));
            return ((List)datesOpt.orElseThrow(IllegalStateException::new)).stream().map(dateStr -> {
                try {
                    return (BDate)BDate.DEFAULT.decodeFromString(dateStr);
                }
                catch (IOException err) {
                    throw new RuntimeException(err);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot get highlighted dates", err);
        }
    }

    public List<Map<String, String>> getSummary(BOrd scheduleOrd, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        try {
            Optional summaryOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "getSummary", new Object[]{scheduleOrd.toString(), DefaultNiagaraVirtualStationAdapter.marshal((BValue)sched, cx), DefaultNiagaraVirtualStationAdapter.marshal((BValue)start, cx), DefaultNiagaraVirtualStationAdapter.marshal((BValue)end, cx), DefaultNiagaraVirtualStationAdapter.marshal((BValue)cx.getFacets(), cx)}));
            return (List)summaryOpt.orElseThrow(IllegalStateException::new);
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot get summary", err);
        }
    }

    public List<BOrd> findCalendarSchedules(BOrd scheduleOrd, Context cx) {
        try {
            Optional calendarsOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "findCalendarSchedules", new Object[]{scheduleOrd.toString()}));
            return ((List)calendarsOpt.orElseThrow(IllegalStateException::new)).stream().map(BOrd::make).collect(Collectors.toList());
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot find calendar schedules", err);
        }
    }

    public Map<String, Object> getScheduleOptions(BOrd scheduleOrd, Context cx) {
        try {
            Optional optionsOpt = this.doScheduleRpc(scheduleOrd, sys -> sys.niagaraRpc(SCHEDULE_RPC_ORD, "getScheduleOptions", new Object[]{scheduleOrd.toString()}));
            return (Map)optionsOpt.orElseThrow(IllegalStateException::new);
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot get schedule options", err);
        }
    }

    private static RuntimeException asRuntimeException(String msg, Exception err) throws RuntimeException {
        log.log(Level.WARNING, msg, err);
        if (err instanceof RuntimeException) {
            return (RuntimeException)err;
        }
        return new RuntimeException(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> doScheduleRpc(BOrd scheduleOrd, ScheduleRpcInvocation<T> scheduleRpcInvocation) throws Exception {
        if (!this.station.isRunning() || this.station.isDisabled() || this.station.isFatalFault()) {
            throw new NotRunningException();
        }
        String interest = scheduleOrd + SCHEDULE_INTEREST_POST_FIX;
        try {
            this.station.engageNoRetry(interest);
            BSysChannel sys = (BSysChannel)this.station.getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
            Optional<T> optional = scheduleRpcInvocation.invoke(sys);
            return optional;
        }
        finally {
            this.station.disengage(interest);
        }
    }

    private static String marshal(BValue value, Context cx) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ValueDocEncoder encoder = new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)new ValueDocEncoder.BogEncoderPlugin((OutputStream)out, cx), cx);){
            encoder.setEncodeTransients(true);
            encoder.encode(value);
        }
        return new String(out.toByteArray());
    }

    public List<String> findDescendantHistories(BNiagaraVirtualComponent virtualComp, int limit, Context cx) {
        if (!this.station.isRunning() || this.station.isDisabled() || this.station.isFatalFault()) {
            throw new NotRunningException();
        }
        String ord = virtualComp.getNiagaraVirtualCompInfo().getSlotOrd().toString();
        String interest = ord + HISTORY_INTEREST_POST_FIX;
        try {
            this.station.engageNoRetry(interest);
            if (this.getStationVersion(FIND_DESCENDANT_HISTORY_VERSION).compareTo(FIND_DESCENDANT_HISTORY_VERSION) >= 0) {
                BSysChannel sys = (BSysChannel)this.station.getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
                Optional historyList = sys.niagaraRpc(NIAGARA_VIRTUAL_ORD, "findDescendantHistories", new Object[]{ord, limit});
                List list = (List)historyList.orElseThrow(IllegalStateException::new);
                return list;
            }
            List<String> sys = Collections.emptyList();
            return sys;
        }
        catch (Exception err) {
            throw DefaultNiagaraVirtualStationAdapter.asRuntimeException("Cannot find descendant histories", err);
        }
        finally {
            this.station.disengage(interest);
        }
    }

    public static interface ScheduleRpcInvocation<R> {
        public Optional<R> invoke(BSysChannel var1) throws Exception;
    }
}

