/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BServerConnections;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BProviderState;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BNetworkExt;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;

public abstract class BSysDefProvider
extends BNetworkExt {
    public static final Property state = BSysDefProvider.newProperty((int)3, (BValue)BProviderState.stopped, null);
    public static final Property faultCause = BSysDefProvider.newProperty((int)3, (String)"", null);
    public static final Action startup = BSysDefProvider.newAction((int)16, null);
    public static final Action shutdown = BSysDefProvider.newAction((int)16, (BValue)BBoolean.FALSE, null);
    public static final Action purge = BSysDefProvider.newAction((int)16, null);
    public static final Topic providerEvent = BSysDefProvider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BSysDefProvider.class);
    private final ReentrantReadWriteLock purgeLock = new ReentrantReadWriteLock();
    private static final BIcon ICON = BIcon.std((String)"cloud.png");
    protected static final Logger log = Logger.getLogger("niagara.sysdef");
    private final Object sessionLock = new Object();
    private boolean allowSessions = false;
    private final HashSet<ProviderSession> sessions = new HashSet();
    private Clock.Ticket ticket = null;
    private final Invocation purgeInvoke = new Invocation((BComponent)this, purge, null, null);

    public BProviderState getState() {
        return (BProviderState)this.get(state);
    }

    public void setState(BProviderState v) {
        this.set(state, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public void startup() {
        this.invoke(startup, null, null);
    }

    public void shutdown(BBoolean immediate) {
        this.invoke(shutdown, (BValue)immediate, null);
    }

    public void purge() {
        this.invoke(purge, null, null);
    }

    public void fireProviderEvent(BProviderEvent event) {
        this.fire(providerEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public boolean isCompatible(Version version) {
        return !version.isNull();
    }

    private void cancelTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    public final ProviderSession createSession(String sessionName, Context cx) {
        BasicContext bc = new BasicContext(cx, BFacets.make((String)"sessionName_", (String)sessionName));
        return this.createSession((Context)bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProviderSession createSession(Context cx) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            this.lease(1);
            if (!this.getState().isRunning()) {
                throw new SysDefException("Provider is not running.");
            }
            return new FoxProviderSession(this.getNiagaraNetwork(), this, cx);
        }
        ProviderSession session = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.allowSessions) {
                throw new SysDefException("Provider is not running.");
            }
            session = this.makeSession(cx);
            this.sessions.add(session);
        }
        return session;
    }

    protected abstract ProviderSession makeSession(Context var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sessionClosed(ProviderSession session) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            return;
        }
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            Object object = this.sessionLock;
            synchronized (object) {
                this.sessions.remove(session);
                if (!this.allowSessions && this.getState().isStopping() && this.sessions.size() == 0) {
                    this.setState(BProviderState.stopped);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartup() {
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            if (!this.getState().isStopped()) {
                StringBuffer err = new StringBuffer().append("Cannot startup the provider: ");
                switch (this.getState().getOrdinal()) {
                    case 0: 
                    case 3: {
                        return;
                    }
                    case 1: {
                        err.append("It is in the process of shutting down.");
                        break;
                    }
                    case 4: {
                        err.append("An unrecoverable error has occured.");
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getState().toString());
                    }
                }
                throw new SysDefException(err.toString());
            }
            this.setState(BProviderState.starting);
            Object object = this.sessionLock;
            synchronized (object) {
                this.allowSessions = true;
            }
            this.getNiagaraNetwork().getLocalStation().getPersistTask().execute();
            this.setState(BProviderState.running);
            this.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doShutdown(BBoolean immediate) {
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            if (!this.getState().isRunning()) {
                StringBuffer err = new StringBuffer().append("Cannot shutdown the provider: ");
                switch (this.getState().getOrdinal()) {
                    case 2: 
                    case 4: {
                        return;
                    }
                    case 1: {
                        if (immediate.getBoolean()) break;
                        return;
                    }
                    case 3: {
                        err.append("It is in the process of starting.");
                        throw new SysDefException(err.toString());
                    }
                    default: {
                        throw new IllegalStateException(this.getState().toString());
                    }
                }
            }
            this.setState(BProviderState.stopping);
            this.cancelTicket();
            Object object = this.sessionLock;
            synchronized (object) {
                this.allowSessions = false;
                if (this.sessions.size() == 0) {
                    this.setState(BProviderState.stopped);
                } else if (immediate.getBoolean()) {
                    SysDefSession[] openSessions = this.sessions.toArray(new SysDefSession[this.sessions.size()]);
                    for (int i = 0; i < openSessions.length; ++i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Forcing close of session: " + ((ProviderSession)openSessions[i]).getSessionName());
                        }
                        openSessions[i].close();
                    }
                    BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
                    BServerConnections conns = foxService.getServerConnections();
                    BFoxServerConnection[] fsessions = (BFoxServerConnection[])conns.getChildren(BFoxServerConnection.class);
                    for (int i = 0; i < fsessions.length; ++i) {
                        try {
                            fsessions[i].getChannels().get("sysdef", BSysDefChannel.TYPE).sessionClosed(null);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.setState(BProviderState.stopped);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPurge() {
        ProviderSession fw = null;
        try {
            this.cancelTicket();
            fw = this.createSession("Purge", null);
            BProviderStation root = (BProviderStation)fw.getLocalStation();
            if (root == null) {
                log.fine("Nothing to purge, the local host is not in the provider yet.");
                return;
            }
            HashSet<String> unreachable = new HashSet<String>();
            this.loadStationNames(unreachable);
            this.purgeLock.writeLock().lock();
            try {
                unreachable.remove(root.getStationName());
                String[] rootSups = fw.getRoleRefs(root, BStationRole.supervisor);
                for (int i = 0; i < rootSups.length; ++i) {
                    unreachable.remove(rootSups[i]);
                }
                this.findReachable(root, unreachable, fw);
                for (String toDelete : unreachable) {
                    log.fine("Purging orphan: " + toDelete);
                    fw.delete(toDelete);
                }
            }
            finally {
                this.purgeLock.writeLock().unlock();
            }
            if (unreachable.size() != 0) {
                BDevice[] devices = this.getNiagaraNetwork().getDevices();
                for (int i = 0; i < devices.length; ++i) {
                    BNiagaraStation station = (BNiagaraStation)devices[i];
                    if (!station.getSysDef().getRole().isSupervisor()) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Forcing supervisor " + devices[i].getName() + " to purge.");
                    }
                    station.getSysDef().getSyncTask().setSignalPurge(true);
                }
            }
        }
        catch (Exception x) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Purge failed: " + x.getMessage());
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
        }
    }

    protected abstract void loadStationNames(HashSet<String> var1);

    private void findReachable(BINiagaraStation current, HashSet<String> unreachable, ProviderSession fw) {
        if (current == null) {
            return;
        }
        String[] subordinates = fw.getRoleRefs(current, BStationRole.subordinate);
        for (int i = 0; i < subordinates.length; ++i) {
            unreachable.remove(subordinates[i]);
            this.findReachable(fw.getStation(subordinates[i]), unreachable, fw);
        }
    }

    final void blockPurge() {
        this.purgeLock.readLock().lock();
    }

    final void unblockPurge() {
        this.purgeLock.readLock().unlock();
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.shutdown(BBoolean.TRUE);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == purge || action == startup || action == shutdown) {
            try {
                BNiagaraNetwork nn = (BNiagaraNetwork)this.getNetwork();
                Invocation i = new Invocation((BComponent)this, action, argument, cx);
                try {
                    nn.getWorkers().process(i);
                    return null;
                }
                catch (NotRunningException notRunningException) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.post(action, argument, cx);
    }

    public BIcon getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        BAbsTime now = BAbsTime.now();
        out.startTable(true);
        out.trTitle((Object)"Open Sessions", 3);
        out.w((Object)"<tr>");
        out.thTitle((Object)"Session Name");
        out.thTitle((Object)"Creation Time");
        out.thTitle((Object)"Time Open");
        out.w((Object)"</tr>");
        Object object = this.sessionLock;
        synchronized (object) {
            ProviderSession[] as = this.sessions.toArray(new ProviderSession[this.sessions.size()]);
            for (int i = 0; i < as.length; ++i) {
                ProviderSession session = as[i];
                BAbsTime creation = session.getCreation();
                out.w((Object)"<tr>");
                out.td((Object)session.getSessionName());
                out.td((Object)creation);
                out.td((Object)creation.delta(now));
                out.w((Object)"</tr>");
            }
        }
        out.endTable();
        super.spy(out);
    }
}

