/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSyncTask;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

public class BSysDefChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BSysDefChannel.class);
    private final IntHashMap sessionReg = new IntHashMap();
    private int nextId = 0;
    public static final String CHANNEL = "sysdef";
    private static final Logger slog = Logger.getLogger("niagara.sysdef");
    private static final String SERVICES = "services";
    private static final String CLOSE_SESSION = "close";
    private static final String CHANGE_ROLE = "role";
    private static final String GET1 = "gs";
    private static final String SYNC_TO_SUB = "toSub";
    private static final String PERSIST = "persist";
    private static final String SYNC_TO_SUP = "toSup";
    private static final String GET_ROLES = "getRoles";
    public StringBuffer lastSync;

    public Type getType() {
        return TYPE;
    }

    public BSysDefChannel() {
        super(CHANNEL);
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        String command = req.command;
        if (command.equals(SERVICES)) {
            return this.getServiceTypes(req);
        }
        if (command.equals(CHANGE_ROLE)) {
            return this.changeRole(req);
        }
        if (command.equals(CLOSE_SESSION)) {
            return this.closeSession(req);
        }
        if (command.equals(GET1)) {
            return this.getStation(req);
        }
        if (command.equals(SYNC_TO_SUB)) {
            return this.syncToSubordinate(req);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        String command = circuit.command;
        if (command.equals(GET_ROLES)) {
            this.getStations(circuit);
            return;
        }
        if (command.equals(SYNC_TO_SUP)) {
            this.syncToSupervisor(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    protected void checkStatus(FoxMessage resp) throws Exception {
        String rc = resp.getString("status");
        if (!rc.equals("ok")) {
            if (rc.equals("error")) {
                throw new SysDefException(resp.getString("msg"));
            }
            slog.warning(resp.getString("msg"));
        }
    }

    protected BProviderStation decodeStation(FoxMessage msg) throws Exception {
        return (BProviderStation)DecoderFactory.decode((FoxMessage)msg, (String)"station", null);
    }

    protected void handleServerException(ProviderSession session, FoxMessage resp, Throwable t) {
        if (session != null && resp.getBoolean("wasCreated", false)) {
            int sessionId;
            try {
                sessionId = resp.getInt("sessionId");
            }
            catch (Exception x) {
                throw new IllegalStateException("should have had sessionId.");
            }
            if (slog.isLoggable(Level.FINE)) {
                this.trace("Closing piggy-backed session: " + sessionId);
            }
            this.closeSession(session, sessionId);
        }
        resp.add("status", "error");
        resp.add("msg", "[" + Sys.getStation().getStationName() + "]: " + t.getMessage());
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    protected BNiagaraStation getNiagaraStation() {
        return this.getConnection().getConnectionTarget(BNiagaraStation.class).orElse(null);
    }

    protected BNiagaraSysDefDeviceExt getSysDefExt() {
        BNiagaraStation s = this.getNiagaraStation();
        return s == null ? null : s.getSysDef();
    }

    private String sn(String sessionName) {
        return new StringBuffer().append(this.getNiagaraStation().getStationName()).append(':').append(sessionName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(Throwable cause) throws Exception {
        SysDefSession[] sessions = null;
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            sessions = (SysDefSession[])this.sessionReg.toArray((Object[])new SysDefSession[this.sessionReg.size()]);
            this.sessionReg.clear();
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (i == 0) {
                slog.log(Level.WARNING, "SysDefChannel for session " + this.getServerConnection().getName() + " is closing with " + sessions.length + " open SysDef sessions. Closing them.", cause);
            }
            try {
                sessions[i].close();
                continue;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        super.sessionClosed(cause);
    }

    private void setSession(FoxProviderSession session, FoxMessage req) {
        req.add("sessionId", session.getSessionId());
        req.add("sessionName", session.getSessionName());
    }

    private void setSession(FoxProviderSession session, FoxCircuit circuit) throws Exception {
        FoxMessage req = new FoxMessage("session");
        this.setSession(session, req);
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        this.assignSessionId(session, resp);
    }

    private ProviderSession getSession(FoxMessage req, FoxMessage resp, boolean create) throws Exception {
        int sessionId = req.getInt("sessionId");
        String sessionName = req.getString("sessionName");
        if (sessionId == -1) {
            if (create) {
                BNiagaraNetwork network = this.getNiagaraNetwork();
                ProviderSession session = network.getSysDefProvider().createSession("fox_" + sessionName, this.getServerConnection().getSessionContext());
                sessionId = this.registerSession(session);
                resp.add("sessionId", sessionId);
                resp.add("wasCreated", true);
                return session;
            }
            throw new SysDefException("Invalid fox session id. (" + sessionId + ")");
        }
        ProviderSession session = this.getSession(sessionId);
        return session;
    }

    private ProviderSession getSession(FoxCircuit circuit, boolean create) throws Exception {
        FoxMessage req = circuit.readMessage();
        FoxMessage resp = new FoxMessage();
        ProviderSession session = null;
        try {
            session = this.getSession(req, resp, create);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        catch (Exception x) {
            this.handleServerException(session, resp, x);
            throw x;
        }
        return session;
    }

    private void assignSessionId(FoxProviderSession session, FoxMessage resp) throws Exception {
        int INIT = -1;
        int sessionId = resp.getInt("sessionId", -1);
        if (sessionId == -1) {
            if (session.getSessionId() == -1) {
                throw new SysDefException("Missing session id.");
            }
        } else {
            session.setOpen(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerSession(ProviderSession session) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            int id = this.nextId;
            this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            while (this.sessionReg.get(id) != null) {
                id = this.nextId;
                this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            }
            this.sessionReg.put(id, (Object)session);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            this.sessionReg.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderSession getSession(int sessionId) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            return (ProviderSession)this.sessionReg.get(sessionId);
        }
    }

    public void closeSession(FoxProviderSession session) throws Exception {
        FoxRequest req = this.makeRequest(CLOSE_SESSION);
        this.setSession(session, (FoxMessage)req);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        session.setClosed();
    }

    private FoxResponse closeSession(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try {
            int sessionId = req.getInt("sessionId");
            ProviderSession session = this.getSession((FoxMessage)req, (FoxMessage)resp, false);
            if (session != null) {
                this.closeSession(session, sessionId);
                resp.add("status", "ok");
            } else {
                resp.add("status", "warn");
                resp.add("msg", "Session " + sessionId + " was already closed on remote station " + Sys.getStation().getStationName());
            }
        }
        catch (SysDefException sde) {
            this.handleServerException(null, (FoxMessage)resp, (Throwable)((Object)sde));
        }
        return resp;
    }

    private void closeSession(ProviderSession session, int sessionId) {
        session.close();
        this.unregisterSession(sessionId);
    }

    public BProviderStation getStation(FoxProviderSession session, String stationName) throws Exception {
        FoxRequest req = this.makeRequest(GET1);
        this.setSession(session, (FoxMessage)req);
        req.add("stationName", stationName);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.assignSessionId(session, (FoxMessage)resp);
        BProviderStation pStation = this.decodeStation((FoxMessage)resp);
        pStation.network = session.network;
        return pStation;
    }

    private FoxResponse getStation(FoxRequest req) {
        FoxResponse resp = new FoxResponse(req);
        ProviderSession session = null;
        try {
            session = this.getSession((FoxMessage)req, (FoxMessage)resp, true);
            String stationName = req.getString("stationName");
            BProviderStation station = (BProviderStation)session.getStation(stationName);
            BogCodec.add((FoxMessage)resp, (String)"station", (BValue)station, null);
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(session, (FoxMessage)resp, x);
        }
        return resp;
    }

    public Array<BTypeSpec> getServiceTypes(FoxProviderSession session, BINiagaraStation station) throws Exception {
        FoxRequest req = this.makeRequest(SERVICES);
        this.setSession(session, (FoxMessage)req);
        req.add("stationName", station.getStationName());
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.assignSessionId(session, (FoxMessage)resp);
        String[] specs = resp.listStrings("spec");
        Array result = new Array(BTypeSpec.class);
        for (int i = 0; i < specs.length; ++i) {
            result.add((Object)BTypeSpec.make((String)specs[i]));
        }
        return result;
    }

    private FoxResponse getServiceTypes(FoxRequest req) {
        FoxResponse resp = new FoxResponse(req);
        ProviderSession session = null;
        try {
            session = this.getSession((FoxMessage)req, (FoxMessage)resp, true);
            String stationName = req.getString("stationName");
            BProviderStation station = new BProviderStation(stationName);
            Array<BTypeSpec> services = session.getServices(station);
            for (int i = 0; i < services.size(); ++i) {
                resp.add("spec", ((BTypeSpec)services.get(i)).toString());
            }
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(session, (FoxMessage)resp, x);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraStation[] getStations(FoxProviderSession session, BINiagaraStation station, BStationRole role) throws Exception {
        try (FoxCircuit circuit = this.openCircuit(GET_ROLES);){
            this.setSession(session, circuit);
            FoxMessage req = new FoxMessage("req");
            req.add("stationName", station.getStationName());
            req.add(CHANGE_ROLE, role.getOrdinal());
            circuit.writeMessage(req);
            circuit.flush();
            Array stations = new Array(BINiagaraStation.class);
            FoxMessage current = circuit.readMessage();
            this.checkStatus(current);
            while (!current.getBoolean("EOF", false)) {
                BProviderStation pStation = this.decodeStation(current);
                stations.add((Object)pStation);
                pStation.network = session.network;
                current = circuit.readMessage();
            }
            if (stations.size() != current.getInt("size")) {
                throw new IllegalStateException("Actual size: " + stations.size() + " <> Expected size: " + current.getInt("size"));
            }
            BINiagaraStation[] bINiagaraStationArray = (BINiagaraStation[])stations.trim();
            return bINiagaraStationArray;
        }
    }

    private void getStations(FoxCircuit circuit) {
        FoxMessage msg = null;
        FoxMessage resp = new FoxMessage();
        ProviderSession session = null;
        try {
            session = this.getSession(circuit, true);
            msg = circuit.readMessage();
            BProviderStation station = new BProviderStation(msg.getString("stationName"));
            int role = msg.getInt(CHANGE_ROLE);
            BINiagaraStation[] stations = null;
            switch (role) {
                case 1: {
                    stations = session.getSubordinates(station);
                    break;
                }
                case 2: {
                    stations = session.getSupervisors(station);
                    break;
                }
                default: {
                    throw new IllegalStateException("PEER role not supported.");
                }
            }
            for (int i = 0; i < stations.length; ++i) {
                resp = new FoxMessage();
                resp.add("status", "ok");
                BogCodec.add((FoxMessage)resp, (String)"station", (BValue)((BProviderStation)stations[i]), null);
                circuit.writeMessage(resp);
            }
            resp = new FoxMessage();
            resp.add("status", "ok");
            resp.add("size", stations.length);
            resp.add("EOF", true);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        catch (IOException station) {
        }
        catch (Exception x) {
            this.handleServerException(null, resp, x);
            try {
                circuit.writeMessage(resp);
                circuit.flush();
            }
            catch (Exception ix) {
                ix.printStackTrace();
            }
        }
    }

    private FoxRequest makePersistRequest(BProviderStation station, boolean commit) throws Exception {
        FoxRequest req = this.makeRequest(PERSIST);
        req.add(CHANGE_ROLE, this.getSysDefExt().getRole().getOppositeRole().getOrdinal());
        req.add("commit", commit);
        BogCodec.add((FoxMessage)req, (String)"station", (BValue)station, null);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse persist(FoxMessage req, ProviderSession session) throws Exception {
        FoxResponse resp = new FoxResponse();
        boolean closeSession = false;
        if (session == null) {
            session = this.getNiagaraNetwork().getSysDefProvider().createSession(this.sn(PERSIST), null);
            closeSession = true;
        }
        try {
            BStationRole expectedRole = BStationRole.make(req.getInt(CHANGE_ROLE));
            boolean commit = req.getBoolean("commit");
            BProviderStation station = this.decodeStation(req);
            BResolveBits outOfDate = this.persist(station, expectedRole, commit, session);
            if (slog.isLoggable(Level.FINE) && commit) {
                slog.fine("Updated " + (Object)((Object)outOfDate) + " for station " + station.getStationName());
            }
            resp.add("bits", outOfDate.getBitmask());
            resp.add("status", "ok");
        }
        catch (SysDefException sde) {
            resp = new FoxResponse();
            resp.add("status", "error");
            resp.add("msg", sde.getMessage());
        }
        finally {
            if (closeSession && session != null) {
                session.close();
            }
        }
        return resp;
    }

    private BResolveBits persist(BProviderStation station, BStationRole role, boolean commit, ProviderSession session) throws Exception {
        BNiagaraStation ns = this.getNiagaraStation();
        BNiagaraNetwork net = this.getNiagaraNetwork();
        BResolveBits outOfDate = null;
        if (ns != null && ns.getStationName().equals(station.getStationName())) {
            this.verifyRole(role);
            net.getLocalStation().addRef(station.getStationName(), this.getSysDefExt().getRole());
            outOfDate = session.persist(station, commit);
            if (commit && this.getSysDefExt().getRole().isSubordinate() && !outOfDate.equals((Object)BResolveBits.NONE)) {
                net.getLocalStation().networkChanged();
            }
        } else {
            outOfDate = session.persist(station, commit);
        }
        return outOfDate;
    }

    private void verifyRole(BStationRole remoteExpectedRole) throws SysDefException {
        BStationRole remoteCurrentRole = this.getSysDefExt().getRole();
        if (!remoteExpectedRole.equals((Object)remoteCurrentRole)) {
            throw new SysDefException("Expected role for station " + this.getNiagaraStation().getStationName() + " to be " + (Object)((Object)remoteExpectedRole) + ", but current role is: " + (Object)((Object)remoteCurrentRole));
        }
    }

    public void changeRole(BStationRole role) throws Exception {
        FoxRequest req = this.makeRequest(CHANGE_ROLE);
        req.add(CHANGE_ROLE, role.getOppositeRole().getOrdinal());
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
        this.commitRole(role, true);
    }

    private FoxResponse changeRole(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try {
            BStationRole toRole = BStationRole.make(req.getInt(CHANGE_ROLE));
            BNiagaraSysDefDeviceExt ext = this.getSysDefExt();
            BStationRole prevRole = ext.getRole();
            if (!toRole.equals((Object)prevRole) || !toRole.equals((Object)BStationRole.peer)) {
                this.checkRoleChange();
            }
            this.commitRole(toRole, false);
            resp.add("status", "ok");
        }
        catch (Exception x) {
            this.handleServerException(null, (FoxMessage)resp, x);
        }
        return resp;
    }

    private void checkRoleChange() throws SysDefException {
        if (!this.getSysDefExt().isOperational()) {
            throw new SysDefException("SysDef extension not in a valid state to change roles: " + this.getSysDefExt().getStatus());
        }
        if (!this.getSysDefExt().getRoleManager().isRoleSynced()) {
            throw new SysDefException("Simultaneous role change detected; cannot change role.");
        }
    }

    private void commitRole(BStationRole role, boolean isClient) {
        BNiagaraSysDefDeviceExt ext = this.getSysDefExt();
        BStationRole prevRole = ext.getRole();
        this.getNiagaraNetwork().getLocalStation().removeRef(this.getNiagaraStation().getStationName(), prevRole);
        ext.getRoleManager().setActualRole(role);
        ext.getRoleManager().setDesiredRole(role);
        if (isClient) {
            ext.getSyncTask().setRequestReciprocatedSync(true);
        }
    }

    public void syncToSubordinate(BSyncTask syncTask) throws Exception {
        BProviderStation me = new BProviderStation();
        me.copyFrom((BComplex)this.getNiagaraNetwork().getLocalStation());
        me.setSubordinates(BNameList.make((String)this.getNiagaraStation().getName()));
        me.setSupervisors(BNameList.DEFAULT);
        FoxRequest req = this.makeRequest(SYNC_TO_SUB);
        req.add("reciprocateSync", syncTask.getRequestReciprocatedSync());
        req.add("persistReq", (FoxMessage)this.makePersistRequest(me, true));
        FoxResponse resp = this.sendSync(req);
        this.checkStatus((FoxMessage)resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse syncToSubordinate(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        boolean reciprocateSync = false;
        try {
            reciprocateSync = req.getBoolean("reciprocateSync");
            FoxMessage persist = req.getMessage("persistReq");
            resp = this.persist(persist, null);
        }
        catch (Exception x) {
            this.handleServerException(null, (FoxMessage)resp, x);
        }
        finally {
            if (reciprocateSync) {
                if (slog.isLoggable(Level.FINE)) {
                    slog.fine("Reciprocating Sync to station [" + this.getNiagaraStation().getStationName() + "]");
                }
                this.getSysDefExt().getSyncTask().execute();
            }
        }
        return resp;
    }

    public void syncToSupervisor(BSyncTask syncTask) throws Exception {
        this.lastSync = new StringBuffer();
        BNiagaraNetwork net = this.getNiagaraNetwork();
        ProviderSession session = null;
        FoxCircuit sync = this.openCircuit(SYNC_TO_SUP);
        try {
            FoxMessage recip = new FoxMessage();
            recip.add("reciprocateSync", syncTask.getRequestReciprocatedSync());
            recip.add("purge", syncTask.getSignalPurge());
            sync.writeMessage(recip);
            session = net.getSysDefProvider().createSession(this.sn("syncToSupervisor_client"), null);
            this.syncToSupervisor(session.doGetStation(net.getLocalStation().getStationName()), sync, session, this.lastSync);
            FoxMessage EOF = new FoxMessage();
            EOF.add("EOF", true);
            sync.writeMessage(EOF);
            sync.flush();
            FoxMessage msg = sync.readMessage();
            this.checkStatus(msg);
        }
        catch (Exception x) {
            this.lastSync.append("ERROR");
            throw x;
        }
        finally {
            if (slog.isLoggable(Level.FINE)) {
                slog.fine("Sync'd Subtree to " + this.getNiagaraStation().getStationName() + ":\n" + this.lastSync.toString());
            }
            sync.close();
            if (session != null) {
                session.close();
            }
        }
    }

    private void syncToSupervisor(BProviderStation current, FoxCircuit sync, ProviderSession session, StringBuffer lastSync) throws Exception {
        if (current == null) {
            return;
        }
        lastSync.append('(').append(current.getStationName());
        if (!current.getResolved().equals((Object)BResolveBits.ALL)) {
            current = session.read(current.getStationName());
        }
        FoxMessage resp = null;
        FoxRequest msg = this.makePersistRequest(current, false);
        sync.writeMessage((FoxMessage)msg);
        sync.flush();
        resp = sync.readMessage();
        this.checkStatus(resp);
        if (resp.getBoolean("networkStale")) {
            lastSync.append("+ ");
            String[] subs = current.getStationRefs(BStationRole.subordinate);
            for (int i = 0; i < subs.length; ++i) {
                this.syncToSupervisor(session.read(subs[i]), sync, session, lastSync);
            }
        } else if (resp.getBoolean("stationStale")) {
            lastSync.append("[s]");
        }
        lastSync.append(')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToSupervisor(FoxCircuit circuit) throws Exception {
        ProviderSession session = null;
        boolean reciprocateSync = false;
        boolean purge = false;
        try {
            session = this.getNiagaraNetwork().getSysDefProvider().createSession(this.sn("syncToSupervisor_server"), null);
            FoxMessage msg = circuit.readMessage();
            reciprocateSync = msg.getBoolean("reciprocateSync");
            purge = msg.getBoolean("purge");
            Array persistCache = new Array(BProviderStation.class);
            msg = circuit.readMessage();
            while (!msg.getBoolean("EOF", false)) {
                FoxResponse resp = null;
                try {
                    resp = this.persist(msg, session);
                    this.checkStatus((FoxMessage)resp);
                    BResolveBits outOfDate = BResolveBits.make(resp.getInt("bits"));
                    resp.add("stationStale", outOfDate.isBits(BResolveBits.STATION));
                    resp.add("networkStale", outOfDate.getBit(4));
                    if (!outOfDate.equals((Object)BResolveBits.NONE)) {
                        BProviderStation s = this.decodeStation(msg);
                        if (slog.isLoggable(Level.FINE)) {
                            slog.fine("Caching " + s.getStationName());
                        }
                        persistCache.push((Object)s);
                    }
                    circuit.writeMessage((FoxMessage)resp);
                    circuit.flush();
                    msg = circuit.readMessage();
                }
                catch (SysDefException sde) {
                    circuit.writeMessage((FoxMessage)resp);
                    circuit.flush();
                    if (session != null) {
                        session.close();
                    }
                    return;
                }
            }
            this.getNiagaraNetwork().getSysDefProvider().blockPurge();
            try {
                FoxMessage result = new FoxMessage();
                BProviderStation current = null;
                try {
                    if (slog.isLoggable(Level.FINE)) {
                        slog.fine("Obtained subTreeLock for station: " + this.getNiagaraStation().getStationName());
                    }
                    while (!persistCache.isEmpty()) {
                        current = (BProviderStation)persistCache.pop();
                        BResolveBits outOfDate = this.persist(current, BStationRole.subordinate, true, session);
                        if (!slog.isLoggable(Level.FINE)) continue;
                        slog.fine("Sync'd: " + (Object)((Object)outOfDate) + " for station " + current.getStationName());
                    }
                    result.add("status", "ok");
                    circuit.writeMessage(result);
                    circuit.flush();
                }
                catch (SysDefException x) {
                    result = new FoxMessage();
                    result.add("status", "error");
                    result.add("msg", "Failed while commiting station " + current.getStationName() + ": " + x.getMessage());
                    circuit.writeMessage(result);
                    circuit.flush();
                }
                finally {
                    if (slog.isLoggable(Level.FINE)) {
                        slog.fine("Released subTreeLock for station: " + this.getNiagaraStation().getStationName());
                    }
                }
            }
            finally {
                this.getNiagaraNetwork().getSysDefProvider().unblockPurge();
            }
            if (reciprocateSync) {
                if (slog.isLoggable(Level.FINE)) {
                    slog.fine("Reciprocating Sync to station [" + this.getNiagaraStation().getStationName() + "]");
                }
                this.getSysDefExt().getSyncTask().execute();
            }
            if (purge) {
                if (slog.isLoggable(Level.FINE)) {
                    slog.fine(this.getNiagaraStation().getStationName() + " forced a purge.");
                }
                this.getNiagaraNetwork().getSysDefProvider().purge();
            }
        }
        catch (Exception x) {
            FoxMessage resp = new FoxMessage();
            this.handleServerException(null, resp, x);
            circuit.writeMessage(resp);
            circuit.flush();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

